divert(-1)

# adit_tree.m4	(C) K. J. Turner (kjt@cs.stir.ac.uk)	10/10/07
#
# This "m4" macro file generates Clinical Guidance Tree specifications in
# ADIT tree format.

# All internal macros start with "adit_". Visible macros are as follows:
#
#  chance	probabilistic, non-deterministic choice
#  comment	comment transcribed to the output
#  decision	deterministic choice
#  question	request for user input
#  terminal	leaf node
#  tree		entire tree
#  value	value (text or expression)

# The following macros may be defined on the command line:
#
#  adit_debug	Error level reporting: 0 all, 1 notes (default), 2 errors,
#		3 panics
#
#  adit_indent	The indentation per level is normally 2 spaces, but can be
#		overridden from the command line (e.g. "-D adit_indent=1").
#
#  adit_prefix	As a macro name must not appear in ordinary text, it is
#		desirable to prefix the visible macros with a distinguishing
#		string. Normally this is "adit_", but can be overridden on the
#		command line (e.g. "-D adit_prefix=ADIT_", or
#		"-D adit_prefix=" to use no prefix).

# A number of characters require special consideration:
#
#  //		Use this for comments that should be removed during macro
#		translation. This allows use of hash, which is the usual M4
#		comment symbol.
#
#  ( )		Parentheses are used to delimit macro parameters. As a result,
#		they must be balanced in ordinary text.
#
#  ,		Comma is used to separate macro parameters. As a result, it must
#		not appear unprotected in ordinary text. A comma can be
#		protected by appearing within balanced parentheses or within
#		[[ ]].
#
#  $		Dollar is used for macro parameters. As a result, it must not
#		appear followed by digits. It is suggested that $ be used if
#		this is the case.
#
#  ` '		Single quotes are normally used to quote macro parameters. They
#		are changed to [[ ]] to avoid interference with ordinary text.
#		Since a single quote may appear in the text, it should not be
#		used by any ADIT macros. Instead, it is suggested that
#		McChangeQuote with and  be used for quotes.
#
#  [[ ]]	Double brackets are used to quote macro parameters. As a result,
#		they must not appear in ordinary text.
#
#  ~		During macro translation, a comma is temporarily represented by
#		a tilde. As a result, it must not appear in ordinary text. If
#		required, use &#126; as the HTML equivalent.
#
#  "		Double quote is used to delimit attribute values. As a result,
#		it must not appear in ordinary text. It is suggested that a
#		single quote be used instead (as this is a valid HTML
#		alternative). If required, use &quot; as the HTML equivalent.
#
#  		During macro translation, logical not is used temporarily as a
#		separator. As a result, it must not appear in ordinary text. If
#		required, use &not; as the HTML equivalent.
#
#  		Since it is not possible in M4 to match any character including
#		a newline, this is expressed as "not ". As a result, this
#		must not appear in ordinary text.

# ============================== Definition Macros =============================

# ---------------------------------- changecom ---------------------------------
# allow use of hash by changing to // ... newline for comments
# ------------------------------------------------------------------------------

changecom(//)

// -------------------------------- changequote --------------------------------
// allow use of single quotes by changing to [[ ... ]] instead for quoting
// -----------------------------------------------------------------------------

changequote([[,]])

// -------------------------------- adit_debug ---------------------------------
// returns 1/0 for diagnostic output or not: 0 all, 1 notes (default), 2 errors,
// 3 panics; may be overriden from the command line ("-D adit_debug=2")
// -----------------------------------------------------------------------------

define(adit_debug,
 [[1]])

//-------------------------------- adit_indent ---------------------------------
// returns the number of spaces per indent (e.g. "2"); may be overriden from the
// command line ("-D adit_indent=4")
// -----------------------------------------------------------------------------

ifdef([[adit_indent]],
  ,
  [[define([[adit_indent]],
    [[2]])]])

// ------------------------------- adit_prefix ---------------------------------
// returns the prefix for "external" ADIT macros (default "adit_");
// may be overriden from the command line ("-D adit_prefix=ADIT_")
// -----------------------------------------------------------------------------

ifdef([[adit_prefix]],,
  [[define([[adit_prefix]],
    [[adit_]])]])

// ============================= Working Variables =============================

//------------------------------ adit_attribute -------------------------------
// returns the current attribute
// -----------------------------------------------------------------------------

define(adit_attribute,
 [[]])

//------------------------------ adit_identifier -------------------------------
// returns the identifier of the current node
// -----------------------------------------------------------------------------

define(adit_identifier,
 [[]])

//----------------------------- adit_indent_initial ----------------------------
// returns the initial indentation offset
// -----------------------------------------------------------------------------

define(adit_indent_initial,
  [[0]])

//------------------------------- adit_level -----------------------------------
// returns the current indentation level (0 = top level)
// -----------------------------------------------------------------------------

define(adit_level,
  [[0]])

//-------------------------- adit_parent_identifier ----------------------------
// returns the identifier of the parent node
// -----------------------------------------------------------------------------

define(adit_parent_identifier,
 [[]])

//----------------------------- adit_parent_type -------------------------------
// returns the parent type
// -----------------------------------------------------------------------------

define(adit_parent_type,
 [[]])

//----------------------------- adit_parent_type -------------------------------
// returns the default payoff for terminal nodes
// -----------------------------------------------------------------------------

define(adit_payoff,
 [[100]])

//-------------------------------- adit_result ---------------------------------
// returns the current field evaluation result
// -----------------------------------------------------------------------------

define(adit_result,
 [[]])

//---------------------------- adit_specification ------------------------------
// returns the specification of the entire tree
// -----------------------------------------------------------------------------

define(adit_specification,
 [[]])

//-------------------------------- adit_type -----------------------------------
// returns the type of the current node (initially at tree level)
// -----------------------------------------------------------------------------

define(adit_type,
 [[Tree]])

//------------------------------- adit_version ---------------------------------
// returns the default ADIT viewer version
// -----------------------------------------------------------------------------

define(adit_version,
 [[2.4]])

// ============================== General Macros ===============================

// --------------------- adit_diagnostic(string1,...) --------------------------
// report the diagnostic message "string1", etc.
// -----------------------------------------------------------------------------

define(adit_diagnostic,
  [[ifelse(
      eval(adit_debug <= 0),1,
	[[errprint([[]]
adit_convert [error]: line __line__ node 'adit_identifier' - $@
)]])]])

// ------------------------ adit_error(string1,...) ----------------------------
// reports the error message "string1", etc.
// -----------------------------------------------------------------------------

define(adit_error,
  [[ifelse(
      eval(adit_debug <= 2),1,
	[[errprint([[]]
adit_convert [error]: line __line__ node 'adit_identifier' - $@
)]])]])

// ---------------------------- adit_indent_current ----------------------------
// returns indentation for "adit_level"
// -----------------------------------------------------------------------------

// ----------------------------- adit_indent_less ------------------------------
// decrements the current indenting level
// -----------------------------------------------------------------------------

// ----------------------------- adit_indent_more ------------------------------
// increments the current indenting level
// -----------------------------------------------------------------------------

// -------------------------- adit_indent_of(lev) ------------------------------
// returns indentation for the given level "lev"
// -----------------------------------------------------------------------------

define(adit_indent_of,
  [[adit_spaces(eval(adit_indent_initial + $1 * adit_indent))]])

// --------------------------- adit_indent_set(bool) ---------------------------
// enables indentation (initialises macro "adit_level" to 0, defines macros
// "adit_indent_current", "adit_indent_less", "adit_indent_more") or disables
// indentation (undefines macros "adit_indent_current", "adit_indent_less",
// "adit_indent_more") according to whether "bool" is 1 or 0
// -----------------------------------------------------------------------------

define(adit_indent_set,
  [[ifelse($1,1,
    [[define([[adit_level]],
      0)define([[adit_indent_current]],
	[[adit_indent_of(adit_level)]])define([[adit_indent_less]],
	  [[define([[adit_level]],
	    eval(adit_level-1))]])define([[adit_indent_more]],
	      [[define([[adit_level]],
		eval(adit_level+1))]])]],
    [[undefine([[adit_indent_current]])undefine([[adit_indent_less]])undefine(
      [[adit_indent_more]])]])]])

// ----------------------------- adit_lower(text) ------------------------------
// returns "text" initially lower-case
// -----------------------------------------------------------------------------

define(adit_lower,
  [[translit(substr($1,0,1),A-Z,a-z)[[]]substr($1,1)]])

// ---------------------------- adit_lowers(text) ------------------------------
// returns "text" all in lower-case
// -----------------------------------------------------------------------------

define(adit_lowers,
  [[translit($1,A-Z,a-z)]])

// ----------------------- adit_note(string1,...) ---------------------------
// reports the note message "string1", etc.
// -----------------------------------------------------------------------------

define(adit_note,
  [[ifelse(
      eval(adit_debug <= 1),1,
	[[errprint([[]]
adit_convert [warning]: line __line__ node 'adit_identifier' - $@
)]])]])

// ----------------------- adit_panic(string1,...) -----------------------------
// report the panic message "string1", etc.
// -----------------------------------------------------------------------------

define(adit_panic,
  [[ifelse(
      eval(adit_debug <= 3),1,
	[[errprint([[]]
adit_convert [panic]: line __line__ node 'adit_identifier' - $@
)]])]])

// --------------------------- adit_spaces(number) -----------------------------
// returns the number of spaces "number"
// -----------------------------------------------------------------------------

define(adit_spaces,
  [[ifelse(eval($1 < 0),1,[[adit_error(negative space not allowed)]],
    $1,0,,
    [[ adit_spaces(decr($1))]])]])

// ------------------------ adit_trim_spaces(text) -----------------------------
// returns the "text" without trailing spaces
// -----------------------------------------------------------------------------

define(adit_trim_spaces,
  [[patsubst($1,[[\s+$]])]])

// ----------------------------- adit_upper(text) ------------------------------
// returns "text" initially upper-case
// -----------------------------------------------------------------------------

define(adit_upper,
  [[translit(substr($1,0,1),a-z,A-Z)[[]]substr($1,1)]])

// ---------------------------- adit_uppers(text) ------------------------------
// returns "text" all in upper-case
// -----------------------------------------------------------------------------

define(adit_uppers,
  [[translit($1,a-z,A-Z)]])

// =========================== Internal Tree Macros ============================

// ------------------------- adit_allows_macros(field) -------------------------
// returns 1/0 if the field allows macros or not
// -----------------------------------------------------------------------------

define(adit_allows_macros,
  [[ifelse(
      $1,conjunction,
	1,
      $1,display,
	1,
      $1,error,
	1,
      $1,macros,
	1,
      $1,perform,
	1,
      $1,query,
	1,
      $1,reason,
	1,
	0)]])

// ---------------------- adit_attributes(attributes) --------------------------
// returns node fields for all the space-separated "attributes" defined in the
// format 'field="value"' or 'field' (the latter being short for a value defined
// as '<Id>_Field', i.e. a macro);
// -----------------------------------------------------------------------------

define(adit_attributes,
  [[ifelse(
  $1,,
    ,
    [[define([[adit_attribute]],
      regexp($1,
	^\(\w+\)\s*=\s*"\([^"]*\)"\s*\([^]*\),
	[[
adit_indent_currentadit_field(\1)adit_field_value(\1,
  [[\2]])adit_attributes(\3)]]))ifelse(
	  adit_attribute,,
	    [[define([[adit_attribute]],
	      regexp($1,
		^\(\w+\)\s*\([^]*\),
		[[\1="adit_identifier[[]]_[[]]adit_upper(\1)" \2]]))ifelse(
		  adit_attribute,,
		    [[adit_error(malformed attribute at '$1')]],
		    [[adit_attributes(adit_attribute)]])]],
	    adit_attribute)]])]])

// ------------------- adit_check_field(type,field,label) ----------------------
// returns the "label" corresponding to the "field" provided this matches the
// node "type" ("Question", "Tree", "-" meaning anything else); otherwise an
// error is reported
// -----------------------------------------------------------------------------

define(adit_check_field,
  [[ifelse(
      $1,Question,
	[[ifelse(
	  adit_type,Question,
	    $3,
	    [[adit_error(field '$2' is only for questions)]])]],
      $1,Tree,
	[[ifelse(
	  adit_type,Tree,
	    $3,
	    [[adit_error(field '$2' is only for trees)]])]],
	[[ifelse(
	  adit_type,Tree,
	    [[adit_error(field '$2' is not for trees)]],
	    $3)]])]])

// ---------------------------- adit_field(field) ------------------------------
// returns the tree field name corresponding to the given attribute name
// -----------------------------------------------------------------------------

define(adit_field,
  [[ifelse(
    $1,variables,
      [[adit_check_field(Tree,$1,)]],
    [[ifelse(
      $1,composed,
	[[adit_check_field(Tree,$1,ComposedHeadings)]],
      $1,conjunction,
	[[ifelse(
	    adit_type,Tree,
	      ComposedNodeJoiningText,
	      JoiningText)]],
      $1,conjunction,
	[[adit_check_field(Tree,$1,JoiningText)]],
      $1,dictionary,
	[[adit_check_field(Tree,$1,DictionaryFile)]],
      $1,display,
	[[ifelse(adit_type,Tree,IntroText,UserText)]],
      $1,error,
	[[adit_check_field(Question,$1,ValidationRuleText)]],
      $1,format,
	[[adit_check_field(Question,$1,InputType)]],
      $1,label,
	[[adit_check_field(-,$1,LongLabel)]],
      $1,macros,
	[[adit_check_field(Tree,$1,GlobalMacros)]],
      $1,neutral,
	[[adit_check_field(Tree,$1,NeutralPoint)]],
      $1,payoff,
	[[adit_check_field(-,$1,Payoff)]],
      $1,probability,
	[[adit_check_field(-,$1,Prob)]],
      $1,perform,
	[[adit_check_field(-,$1,InstructionText)]],
      $1,print,
	[[adit_check_field(-,$1,PrintIf)]],
      $1,query,
	[[adit_check_field(Question,$1,QuestionText)]],
      $1,reason,
	[[adit_check_field(-,$1,DocumentingText)]],
      $1,scale,
	[[adit_check_field(-,$1,ScaleIf)]],
      $1,valid,
	[[adit_check_field(Question,$1,ValidationRule)]],
      $1,variable,
	[[ifelse(
	    adit_type,Question,
	      BoundVariable,
	    adit_type,Tree,
	      TreeVariable,
	      [[adit_error(field 'variable' is only for questions)]])]],
      $1,version,
	[[adit_check_field(Tree,$1,RequiresVersion)]],
      $1,visible,
	[[adit_check_field(-,$1,ExistsIf)]],
	[[adit_error(field '$1' is unknown)]]): ]])]])

// ------------------------- adit_has_macros(value) ----------------------------
// returns 1/0 if the field has macros or not
// -----------------------------------------------------------------------------

define(adit_has_macros,
  [[ifelse(
     regexp($1,\<Mc\w+),-1,
       0,
       1)]])

// ------------------ adit_node(type,id,label,attributes) ----------------------
// returns tree node attributes for node "type", identifier "id", short label
// "label" and "attributes" ("display" is assumed if not explicitly given,
// a default "payoff" is assumed if not explicitly given)
// -----------------------------------------------------------------------------

define(adit_node,
  [[define([[adit_type]],
      $1)define([[adit_parent_type]],
	$1)define([[adit_identifier]],
	  $2)define([[adit_parent_identifier]],
	    $2)define([[adit_label]],
		ifelse(
		  regexp($3,&),-1,
		    [[adit_trim_spaces($3)]],
		    [[[patsubst(adit_trim_spaces($3),
		      \s*&\s*,][)]]]))define([[adit_result]],
			ifelse(
			  regexp($4,\<display\(\s+\|="\|$\)),-1,
			    display $4,
			    $4))ifelse(
			      adit_type,Terminal,
				[[ifelse(
				  regexp($4,\<payoff\(\s+\|="\|$\)),-1,
				  [[define([[adit_result]],
				    payoff="adit_payoff" adit_result)]])]])
adit_indent_currentID: adit_identifier
adit_indent_currentType: adit_type
adit_indent_currentParentID: [[adit_parent_identifier]]
adit_indent_currentShortLabel: adit_labeladit_attributes([[adit_result]])
]])

// ---------------------- adit_field_value(field,value) ------------------------
// returns the value "value", reporting an error if it contains a "Mc" macro
// call for anything except a text field
// -----------------------------------------------------------------------------

define(adit_field_value,
  [[ifelse(
      adit_allows_macros($1),0,
	[[ifelse(
	  adit_has_macros($2),1,
	    [[adit_error(field '$1' may not use macros)]])]])ifelse(
		$1,variables,
		  [[adit_variables($2)]],
		  [[$2]])]])

// ---------------------- adit_variables(declarations) -------------------------
// returns tree variable declarations for the given "declarations"
// -----------------------------------------------------------------------------

define(adit_variables,
  [[patsubst(
      $1,
      \(\w+\)\s*\(=\s*\([^;]+\)\)?;?\s*,
      [[adit_field(variable)\1[[]]ifelse(\3,,,[[ = \3]])
]])]])

// ============================ Visible Tree Macros ============================

// --------------- adit_chance(id,label,attributes,node1,..) -------------------
// returns a chance node with identifier "id", short label "label", "attributes"
// and nodes "node1", etc. as deterministic (user-decided) alternatives
// -----------------------------------------------------------------------------

define(adit_prefix[[]]chance,
  [[ifelse(eval($# < 4),1,
    [[adit_error(too few parameters for [[[[chance]]]])]],
    [[adit_node(Chance,$1,$2,$3)adit_indent_moreadit_chance_aux(
      shift(shift(shift($@))))adit_indent_less]])]])

define(adit_chance_aux,
  [[ifelse(
    $#,0,
      ,
    $#,1,
      [[adit_indent_current$1]],
    [[adit_indent_current$1[[]]adit_chance_aux(shift($@))]])]])

// --------------------------- adit_comment(text) ------------------------------
// returns a tree comment
// -----------------------------------------------------------------------------

define(adit_prefix[[]]comment,
  [[*/ patsubst(
    [[$1]],
    [
],[[
*/ ]])]])

// -------------- adit_decision(id,label,attributes,node1,..) ------------------
// returns a decision node with identifier "id", short label "label",
// "attributes" and nodes "node1", etc. as deterministic (user-decided)
// alternatives
// -----------------------------------------------------------------------------

define(adit_prefix[[]]decision,
  [[ifelse(eval($# < 4),1,
    [[adit_error(too few parameters for [[[[decision]]]])]],
    [[adit_node(Decision,$1,$2,$3)adit_indent_moreadit_decision_aux(
      shift(shift(shift($@))))adit_indent_less]])]])

define(adit_decision_aux,
  [[ifelse(
    $#,0,
      ,
    $#,1,
      [[adit_indent_current$1]],
    [[adit_indent_current$1[[]]adit_decision_aux(shift($@))]])]])

// -------------- adit_question(id,label,attributes,node1,..) ------------------
// returns a question node with identifier "id", short label "label",
// "attributes" and optional nodes "node1", etc. subordinate to the question
// -----------------------------------------------------------------------------

define(adit_prefix[[]]question,
  [[ifelse(eval($# < 3),1,
    [[adit_error(too few parameters for [[[[question]]]])]],
    [[adit_node(Question,$1,$2,$3)adit_indent_moreadit_question_aux(
      shift(shift(shift($@))))adit_indent_less]])]])

define(adit_question_aux,
  [[ifelse(
    $#,0,
      ,
    $#,1,
      [[adit_indent_current$1]],
    [[adit_indent_current$1[[]]adit_question_aux(shift($@))]])]])

// ------------------ adit_terminal(id,label,attributes) -----------------------
// returns a terminal node with identifier id", short label "label" and
// "attributes"
// -----------------------------------------------------------------------------

define(adit_prefix[[]]terminal,
  [[ifelse(eval($# < 2),1,
    [[adit_error(too few parameters for [[[[terminal]]]])]],
    [[adit_node(Terminal,$1,$2,$3)]])]])

// ------------------ adit_tree(id,label,attributes,node) ----------------------
// returns a tree node with name "label", "attributes" and node "node"
// -----------------------------------------------------------------------------

define(adit_prefix[[]]tree,
  [[adit_indent_set(0)define([[adit_type]],
    Tree)define([[adit_identifier]],
      $1)define([[adit_label]],
	$2)define([[adit_result]],
	  ifelse(
	    regexp($3,\<display\(\s+\|="\|$\)),-1,
	      display $3,
	      $3))define([[adit_result]],
		ifelse(
		  regexp(adit_result,\<version\(\s+\|="\|$\)),-1,
		    version="adit_version" adit_result,
		    adit_result))define([[adit_parent_identifier]],
		      )ifelse(
			$#,4,
			  [[define([[adit_specification]],
			      [[TreeName: $1adit_attributes([[adit_result]])
$4]])adit_indent_set(1)translit(adit_specification,
  [[~]],[[,]])]],
			  [[adit_error(
			      incorrect parameter count for [[[[tree]]]])]])]])

// ------------------------ adit_value(name,value) -----------------------------
// defines a value attribute macro with "name" and "value", replacing commas
// by "~"
// -----------------------------------------------------------------------------

define(adit_prefix[[]]value,
  [[define([[$1]],translit([[$2]],[[,]],[[~]]))]])

// ================================== Trailer ==================================

divert

