// test_lotos.m4	K. J. Turner	27/09/07

// input to "m4 test.m4"

// ********************** checks of "adit_chance" ***********************

// ---------------------------------- 1 ---------------------------------------

define([[adit_processes]])
1 {adit_chance(C1, Stay at home, reason)}
{adit_processes}

// ---------------------------------- 2 ---------------------------------------

define([[adit_processes]])
{adit_chance(C2, Stay at home, reason,
  adit_terminal(T2, Have a nap, payoff="payNap" probability="probNap"
   visible="a == b"))}
{adit_processes}

// ---------------------------------- 3 ---------------------------------------

define([[adit_processes]])
{adit_chance(C3, Stay at home, reason,
   adit_terminal(T3, Have a nap, payoff="payNap" probability="probNap"))}
{adit_processes}

// ---------------------------------- 4 ---------------------------------------

define([[adit_processes]])
{adit_chance(C4, Stay at home, reason,
  adit_terminal(T4A, Have a nap, payoff="payNap" probability="probNap"),
  adit_terminal(T4B, Do something, payoff="payDo" probability="probDo"),
  adit_terminal(T4C, A person from Porlock calls, visible="true or false"
    payoff="payPorlock" probability="probPorlock"))}
{adit_processes}

// ---------------------------------- 5 ---------------------------------------

define([[adit_processes]])
{adit_chance(C5, Stay at home, reason,
  adit_terminal(T5A, Have a nap, payoff="payNap" probability="probNap"),
  adit_terminal(T5B, Do something, payoff="payDo" probability="probDo"
    visible="false"),
  adit_terminal(T5C, A person from Porlock calls, visible="w < z"
    payoff="payPorlock" probability="probPorlock"))}
{adit_processes}

// ---------------------------------- 6 ---------------------------------------

define([[adit_processes]])
{adit_chance(C6, Stay at home, reason,
  adit_terminal(T6A, Have a nap, payoff="payNap" visible="x"),
  adit_terminal(T6B, Do something, payoff="payDo" probability="probDo"),
  adit_terminal(T6C, A person from Porlock calls, visible="w < z"
    payoff="payPorlock" probability="probPorlock"))}
{adit_processes}

// ---------------------------------- 7 ---------------------------------------

define([[adit_processes]])
{adit_chance(C7, Stay at home, reason,
  adit_question(Old, Old lag, query variable="elderly"
   format="Combo(red,green,blue,black)" reason valid="9 > x"))}
{adit_processes}

// ---------------------------------- 8 ---------------------------------------

define([[adit_processes]])
{adit_chance(C8, Stay at home, reason,
  adit_question(New, New new, query variable="modern"
   format="Combo(red,green,blue,black)" reason valid="a >= b"),
  adit_terminal(T8, Have a nap, payoff="payNap"
   probability="probNap"))}
{adit_processes}

// ---------------------------------- 9 ---------------------------------------

define([[adit_processes]])
{adit_chance(C9, Stay at home, reason,
  adit_question(Forward, Forwards, query variable="mod1"
   format="Combo(red,green,blue,black)" reason valid="a >= b"),
  adit_question(Past, Past tense, query variable="history"
   format="Edit" reason valid="c != b"),
  adit_terminal(T9, Have a nap, payoff="payNap"
   probability="probNap"))}
{adit_processes}

// ---------------------------------- 10 ---------------------------------------

define([[adit_processes]])
{adit_chance(C10, Stay at home, reason,
  adit_question(Future, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b"),
  adit_question(Bygone, Hygones, query variable="history"
   format="Edit" reason valid="c != b"),
  adit_terminal(T10A, Have a nap, payoff="payNap"
   probability="probNap"),
  adit_terminal(T10B, Have a nap, payoff="payNap"
   probability="probNap"))}
{adit_processes}

// ---------------------------------- 11---------------------------------------

define([[adit_processes]])
{adit_chance(C11, Stay at home, reason,
  adit_question(Future2, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b" visible="a or b"),
  adit_question(Bygone2, Hygones, query variable="history"
   format="Edit" reason valid="c != b"),
  adit_terminal(T11A, Have a nap, payoff="payNap" probability="probNap"),
  adit_terminal(T11B, Have a nap, payoff="payNap"
   probability="probNap" visible="not(x)"))}
{adit_processes}

// ---------------------------------- 12---------------------------------------

define([[adit_processes]])
{adit_chance(C12, Stay at home, reason,
  adit_question(Future3, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b" visible="false"),
  adit_question(Bygone3, Hygones, query variable="history"
   format="Edit" reason valid="c != b"),
  adit_terminal(T12A, Have a nap, payoff="payNap"
   probability="probNap"),
  adit_terminal(T12B, Have a nap, payoff="payNap"
   probability="probNap"))}
{adit_processes}

// ---------------------------------- 13 ---------------------------------------

define([[adit_processes]])
{adit_chance(C13, Stay at home, reason,
  adit_terminal(T13, Have a nap, payoff="payNap"
   probability="probNap"),
  adit_question(Future66, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b" visible="2+5"))}
{adit_processes}

// ---------------------------------- 14 ---------------------------------------

define([[adit_processes]])
{adit_chance(C14, Stay at home, reason,
  adit_terminal(T14A, Have & Nap, payoff="payNap" probability="probNap"),
  adit_question(Future66, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b" visible="2+5"),
  adit_terminal(T14B, Have & Nap, payoff="payNap" probability="probNap"))}
{adit_processes}

// ********************** checks of "adit_decision" ***********************

// ---------------------------------- 1 ---------------------------------------

define([[adit_processes]])
1 {adit_decision(D1, Stay at home, reason)}
{adit_processes}

// ---------------------------------- 2 ---------------------------------------

define([[adit_processes]])
{adit_decision(D2, Stay at home, reason,
  adit_terminal(T2, Have a nap, payoff="payNap" probability="probNap"
   visible="a == b"))}
{adit_processes}

// ---------------------------------- 3 ---------------------------------------

define([[adit_processes]])
{adit_decision(D3, Stay at home, reason,
  adit_terminal(T3, Have a nap, payoff="payNap" probability="probNap"))}
{adit_processes}

// ---------------------------------- 4 ---------------------------------------

define([[adit_processes]])
{adit_decision(D48, Stay at home, reason,
  adit_terminal(T4A, Have a nap, payoff="payNap" probability="probNap"),
  adit_terminal(T4B, Do something, payoff="payDo" probability="probDo"),
  adit_terminal(T4C, A person from Porlock calls, visible="true or false"
    payoff="payPorlock" probability="probPorlock"))}
{adit_processes}

// ---------------------------------- 5 ---------------------------------------

define([[adit_processes]])
{adit_decision(D5, Stay at home, reason,
  adit_terminal(T5A, Have a nap, payoff="payNap" probability="probNap"),
  adit_terminal(T5B, Do something, payoff="payDo" probability="probDo"
    visible="false"),
  adit_terminal(T5C, A person from Porlock calls, visible="w < z"
    payoff="payPorlock" probability="probPorlock"))}
{adit_processes}

// ---------------------------------- 6 ---------------------------------------

define([[adit_processes]])
{adit_decision(D6, Stay at home, reason,
  adit_terminal(T6A, Have a nap, payoff="payNap" visible="x"),
  adit_terminal(T6B, Do something, payoff="payDo" probability="probDo"),
  adit_terminal(T6C, A person from Porlock calls, visible="w < z"
    payoff="payPorlock" probability="probPorlock"))}
{adit_processes}

// ---------------------------------- 7 ---------------------------------------

define([[adit_processes]])
{adit_decision(D7, Stay at home, reason,
  adit_question(Old, Old lag, query variable="elderly"
   format="Combo(red,green,blue,black)" reason valid="9 > x"))}
{adit_processes}

// ---------------------------------- 8 ---------------------------------------

define([[adit_processes]])
{adit_decision(D8, Stay at home, reason,
  adit_question(New, New new, query variable="modern"
   format="Combo(red,green,blue,black)" reason valid="a >= b"),
  adit_terminal(T8, Have a nap, payoff="payNap"
   probability="probNap"))}
{adit_processes}

// ---------------------------------- 9 ---------------------------------------

define([[adit_processes]])
{adit_decision(D9, Stay at home, reason,
  adit_question(Forward, Forwards, query variable="mod1"
   format="Combo(red,green,blue,black)" reason valid="a >= b"),
  adit_question(Past, Past tense, query variable="history"
   format="Edit" reason valid="c != b"),
  adit_terminal(T9, Have a nap, payoff="payNap"
   probability="probNap"))}
{adit_processes}

// ---------------------------------- 10 ---------------------------------------

define([[adit_processes]])
{adit_decision(D10, Stay at home, reason,
  adit_question(Future, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b"),
  adit_question(Bygone, Hygones, query variable="history"
   format="Edit" reason valid="c != b"),
  adit_terminal(T10A, Have a nap, payoff="payNap"
   probability="probNap"),
  adit_terminal(T10B, Have a nap, payoff="payNap"
   probability="probNap"))}
{adit_processes}

// ---------------------------------- 11---------------------------------------

define([[adit_processes]])
{adit_decision(D11, Stay at home, reason,
  adit_question(Future11, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b" visible="a or b"),
  adit_question(Bygone11, Hygones, query variable="history"
   format="Edit" reason valid="c != b"),
  adit_terminal(T11A, Have a nap, payoff="payNap" probability="probNap"),
  adit_terminal(T11B, Have a nap, payoff="payNap"
   probability="probNap" visible="not(x)"))}
{adit_processes}

// ---------------------------------- 12---------------------------------------

define([[adit_processes]])
{adit_decision(D12, Stay at home, reason,
  adit_question(Future12, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b" visible="false"),
  adit_question(Bygone12, Hygones, query variable="history"
   format="Edit" reason valid="c != b"),
  adit_terminal(T12A, Have a nap, payoff="payNap"
   probability="probNap"),
  adit_terminal(T12B, Have a nap, payoff="payNap"
   probability="probNap"))}
{adit_processes}

// ---------------------------------- 13 ---------------------------------------

define([[adit_processes]])
{adit_decision(D13, Stay at home, reason,
  adit_terminal(T13, Have a nap, payoff="payNap"
   probability="probNap"),
  adit_question(Future13, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b" visible="2+5"))}
{adit_processes}

// ---------------------------------- 14 ---------------------------------------

define([[adit_processes]])
{adit_decision(D14, Stay at home, reason,
  adit_terminal(T14A, Have & Nap, payoff="payNap" probability="probNap"),
  adit_question(Future14, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b" visible="2+5"),
  adit_terminal(T14B, Have & Nap, payoff="payNap" probability="probNap"))}
{adit_processes}

// ---------------------------------- 14 ---------------------------------------

define([[adit_processes]])
{adit_decision(D14, Stay at home, reason,
  adit_terminal(T14A, Have & Nap, payoff="payNap" probability="probNap"),
  adit_question(Future66, Futurology, query variable="mod2"
   format="Combo(red,green,blue,black)" reason valid="a >= b" visible="2+5"),
  adit_terminal(T14B, Have & Nap, payoff="payNap" probability="probNap"))}
{adit_processes}

// ********************* checks of adit_question ***********************

// ---------------------------------- 1 ---------------------------------------

define([[adit_processes]])
adit_value([[Old_Valid]],x > 0)
{adit_question(Old, Old lag, query variable="elderly"
  format="Combo(red,green,blue,black)" reason valid)}
{adit_processes}

// ---------------------------------- 2 ---------------------------------------

define([[adit_processes]])
{adit_question(New, New broom, query variable="modern"
  format="Radio(No,Yes)" reason,
   adit_terminal(T4, Have a nap, payoff="payNap" probability="probNap"))}
{adit_processes}

// ---------------------------------- 3 ---------------------------------------

define([[adit_processes]])
define([[adit_questions]])
adit_value([[Hello_Valid]],x > 0)
{adit_question(Hello, Hello there, query variable="greeting"
  format="Edit" reason valid,
   adit_terminal(T3A, Have a nap, payoff="payNap" probability="probNap"),
   adit_terminal(T3B, Do something, payoff="payDo" probability="probDo"))}
{adit_processes}

// ---------------------------------- 4 ---------------------------------------

define([[adit_processes]])
define([[adit_questions]])
adit_value([[Next_Valid]],x > 0)
{adit_question(Next, Hello there, query variable="greeting"
  format="Edit" reason valid,
   adit_terminal(T4, Have a nap, payoff="payNap" probability="probNap"),
   adit_question(Q11, Have a nap, variable="dozy" format="WeightScale"))}
{adit_processes}

// ---------------------------------- 5 ---------------------------------------

define([[adit_processes]])
adit_value([[Q5_Visible]],x > 0)
{adit_question(Bye, Bye bye, query variable="sayonara"
  format="HeightScale" reason,
   adit_question(Q5, Have a nap, variable="sleepy" format="WeightScale"
    visible),
   adit_terminal(T5, Do something, payoff="payDo" probability="probDo"))}
{adit_processes}

// ---------------------------------- 6 ---------------------------------------

define([[adit_processes]])
adit_value([[Q6_Visible]],adit_translate_exit(,0))
{adit_question(Go, Go home, query variable="back|forth"
  format="BloodPressure" reason,
   adit_question(Q6, Have a nap, variable="dozy" format="WeightScale"
    visible),
   adit_terminal(T6, Do something, payoff="payDo" probability="probDo"))}
{adit_processes}

// ---------------------------------- 7 ---------------------------------------

define([[adit_processes]])
adit_value([[Q7A_Visible]],adit_translate_exit(,0))
adit_value([[Q7B_Visible]],x + 2 != 4)
{adit_question(Try7, Try it, query variable="attempt"
  format="HeightScale" reason,
   adit_question(Q7A, Have a nap, variable="snooze" format="WeightScale"
    visible),
   adit_question(Q7B, Go to sleep, variable="somno|lence" format="BloodPressure"
    visible),
   adit_terminal(T7, Do something, payoff="payDo" probability="probDo"))}
{adit_processes}

// ---------------------------------- 8 ---------------------------------------

define([[adit_processes]])
define([[Good_Valid]],adit_translate_exit(,0))
adit_value([[Q8A_Visible]],4 < w)
adit_value([[Q8B_Visible]],x + 2 != 4)
{adit_question(Good, Good morrow, query variable="fine"
  format="HeightScale" reason valid,
   adit_question(Q8A, Have a nap, variable="dream" format="WeightScale"
    visible),
   adit_question(Q8B, Go to sleep, variable="somnolence" format="Edit"
    visible),
   adit_terminal(T8, Do something, payoff="payDo" probability="probDo"))}
{adit_processes}

// ---------------------------------- 9 ---------------------------------------

define([[adit_processes]])
adit_value([[Q9_Valid]],true)
adit_value([[Q9_Visible]],true)
{adit_question(Thing, Bye bye, query variable="sayonara"
  format="HeightScale" reason,
   adit_question(Q9, Have a nap, variable="sleepy" format="WeightScale"
    valid visible),
   adit_terminal(T9, Do something, payoff="payDo" probability="probDo"))}
{adit_processes}

// ---------------------------------- 10 ---------------------------------------

define([[adit_processes]])
{adit_question(Try10, Try it, query variable="attempt"
  format="HeightScale" reason,
   adit_terminal(T10A, And & Also, payoff="payDo" probability="probDo"),
   adit_question(Q10, Sleep Doze, variable="somno|lence" format="BloodPressure"
    visible="b < c"),
   adit_terminal(T10B, Do & something, payoff="payDo" probability="probDo"))}
{adit_processes}

// ********************** checks of "adit_terminal" ***********************

// ---------------------------------- 1 ---------------------------------------

define([[adit_processes]])
{adit_terminal(Bored, Become bored, payoff="payBored"
  probability="probBored" valid="p + q" visible="r > s")}
{adit_processes}

// ---------------------------------- 2 ---------------------------------------

define([[adit_processes]])
{adit_terminal(Porlock, A person from Porlock calls, visible
  payoff="payPorlock" valid probability="probPorlock")}
{adit_processes}

// ---------------------------------- 3 ---------------------------------------

define([[adit_processes]])
adit_value(Porlock_Valid,
  if x < 0 then y else z fi)
adit_value(Porlock_Visible,
  (a * b) < c fi)
{adit_terminal(Porlock, A person from Porlock calls, visible
  payoff="payPorlock" valid probability="probPorlock")}
{adit_processes}

// ---------------------------------- 4 ---------------------------------------

define([[adit_processes]])
adit_value(Porlock_Valid,
  if x < 0 then y else z fi)
adit_value(Porlock_Visible,
  (a * b) < c fi)
{adit_terminal(Porlock, A person from Porlock calls, visible="x + y"
  payoff="payPorlock" valid="b <= a" probability="probPorlock")}
{adit_processes}

// ---------------------------------- 5 ---------------------------------------

define([[adit_processes]])
{adit_terminal(Bored, Boring & Ennui, payoff="payBored"
  probability="probBored" valid="p + q" visible="r > s")}
{adit_processes}

// ---------------------------------- 6 ---------------------------------------

define([[adit_processes]])
adit_value(Testing_Valid,
  probWWSame = 0.195)
adit_value(Testing_Visible,
  true)
{adit_terminal(Testing, A person from Porlock calls, visible
  payoff="payPorlock" valid probability="probPorlock")}
{adit_processes}

// ********************** checks of "adit_value" ***********************

define([[adit_processes]])

// ---------------------------------- 1 ---------------------------------------

adit_value([[Test1_Valid]],)

// ---------------------------------- 2 ---------------------------------------

define([[adit_processes]])
adit_value([[Test2_Valid]],x=3)
{adit_processes}

// ---------------------------------- 3 ---------------------------------------

define([[adit_processes]])
adit_value([[Test3_Valid]],y * 4)
{adit_processes}

// ---------------------------------- 4 ---------------------------------------

define([[adit_processes]])
adit_value([[Test4_Valid]],b = if z <= 5 then x = 3 else x = 0 fi)
{adit_processes}

// ---------------------------------- 5 ---------------------------------------

define([[adit_processes]])
adit_value([[Test5_Valid]],if a != 0 then a = 2 else b = 6 fi)
{adit_processes}

// ---------------------------------- 6 ---------------------------------------

define([[adit_processes]])
adit_value([[Test6_Valid]], [[
  if age > 3 then payDay=3; y = true or z else x= false and w; payZ = 4 fi]])
{adit_processes}

// ---------------------------------- 7 ---------------------------------------

define([[adit_processes]])
adit_value([[Test7_Valid]], [[
  if history
    then
      if ageCategory == 1
	then else
      fi
  fi]])
{adit_processes}

// ---------------------------------- 8 ---------------------------------------

define([[adit_processes]])
adit_value([[Test8_Valid]], [[
  if history
    then
      if ageCategory == 1
	then ; else x = y;
      fi;
  fi]])
{adit_processes}

// ---------------------------------- 9 ---------------------------------------

define([[adit_processes]])
adit_value([[Test9_Valid]], [[
  if history
    then
      if ageCategory == 1
	then
	  if x < 5
	    then else
	  fi
	else
	  if x == 4 then else fi
      fi
  fi]])
{adit_processes}

// ---------------------------------- 10 ---------------------------------------

define([[adit_processes]])
adit_value([[Test10_Valid]], [[
  if history
    then
      if ageCategory == 1
	then
	  if x < 5
	    then payA = A else probB = B;
	  fi
	else
	  if x == 4 then x=5 else payC = payA fi
      fi
  fi]])
{adit_processes}

// ---------------------------------- 11 ---------------------------------------

define([[adit_processes]])
adit_value([[Test11_Valid]], [[
  if age > 3 then payDay=3; else payZ = 4; fi; true]])
{adit_processes}

// ---------------------------------- 12 ---------------------------------------

define([[adit_processes]])
adit_value([[Test12_Valid]], [[
  x = y*35; (y / 2) + 1; x > 5]])
{adit_processes}

// ---------------------------------- 13 ---------------------------------------

define([[adit_processes]])
adit_value([[Test13_Valid]], [[
  x = 3 + probY; y = payZ / 2]])
{adit_processes}

// ---------------------------------- 14 ---------------------------------------

define([[adit_processes]])
adit_value([[Test_Valid_Valid]], [[
  x = 3 + w; y = Z / 2]])
{adit_processes}

// ---------------------------------- 15 ---------------------------------------

define([[adit_processes]])
adit_value([[Test_Valid__Valid_Visible_Probability]], [[
  x = 3 + w; y = Z / 2]])
{adit_processes}

// ---------------------------------- 16 ---------------------------------------

define([[adit_processes]])
adit_value([[Test_Valid_Visible]], [[
  x = 3 + w; y = Z / 2]])
{adit_processes}

// ---------------------------------- 21 ---------------------------------------

adit_value(T1_Valid, [[
  if history
    then
      if ageCategory == 1
	then probVaccinatedFlu = 0.0899
	else probVaccinatedFlu = 0.098
      fi;
    else
      if ageCategory == 1
	then probVaccinatedFlu = 0.0964
	else probVaccinatedFlu = 0.042
      fi;
  fi;
  fluprob + flupayoff]])

// ---------------------------------- 22 ---------------------------------------

adit_value(Treatment_Valid, [[
  totalStrokeLifestyleReduction =
    weightLossStrokeRiskReduction + exerciseStrokeRiskReduction +
    saltStrokeRiskReduction;
  totalCHDLifestyleReduction =
   weightLossCHDRiskReduction + exerciseCHDRiskReduction +
    saltCHDRiskReduction;
  revisedCHDRisk = chdDbpRisk - totalCHDLifestyleReduction;
  revisedStrokeRisk = strokeDbpRisk - totalStrokeLifestyleReduction;

  // KJT 28/11/06: computed variables for later use in ExistsIf
  drugCHD = revisedCHDRisk - (revisedCHDRisk * drugCHDRiskReduction);
  drugStroke =
    revisedStrokeRisk - (revisedStrokeRisk * drugStrokeRiskReduction);
  drugNoEvents = 1 - (drugCHD + drugStroke);
  true]])

// ---------------------------------- 23 ---------------------------------------

adit_value(StayHome_Valid, [[
  if tuesday
    then
      probNap = 0.2;
      probBored = 0.35;
      probPorlock = 0.4
    else
      probNap = 0.4;
      probBored = 0.55;
      probPorlock = 0
  fi;
  true]])

// ---------------------------------- 24 ---------------------------------------

adit_value(WW2_Valid, [[symptomScore < 8]])

// ---------------------------------- 25 ---------------------------------------

adit_value(WW3_Valid, [[
  probWWSame = 0.195;
  probWWWorse = 0.06;
  probWWSameWorse = probWWSame +
    probWWWorse]])

// ---------------------------------- 26 ---------------------------------------

adit_value(WW5_Valid,
  [[probWWIncontinence = 0.018]])

// ---------------------------------- 27 ---------------------------------------

adit_value(WW7_Valid, [[
  if symptomScore < 8
    then probWWMedication = 0.267
    else probWWMedication = 0.227
  fi;
  if symptomScore < 8
    then probWWSurgery = 0.1
    else probWWSurgery = 0.308
  fi;
  true]])

// ---------------------------------- 28 ---------------------------------------

adit_value(Q2_Valid, [[
    if history then
      if ageCategory == 1 then
	probUnvaccinatedFluBad = 0.3
      fi
    fi]])

// ---------------------------------- 29 ---------------------------------------

adit_value(Q2_Valid, [[
    if history then
      if ageCategory == 1 then
	probUnvaccinatedFluBad = 0.3
      else
	if ageCategory == 2 then
	  probUnvaccinatedFluBad = 0.35
	fi
      fi
    fi]])

// ---------------------------------- 30 ---------------------------------------

adit_value(Q2_Valid, [[
    if history then
      if ageCategory == 1 then
	probUnvaccinatedFluVeryBad = 0.4;
	probUnvaccinatedFluBad = 0.3
      else
	if ageCategory == 2 then
	  probUnvaccinatedFluVeryBad = 0.5;
	  probUnvaccinatedFluBad = 0.35
	else
	  probUnvaccinatedFluVeryBad = 0.6;
	  probUnvaccinatedFluBad = 0.39
	fi;
      fi;
    else
      if ageCategory == 1 then
	probUnvaccinatedFluVeryBad = 0.1;
	probUnvaccinatedFluBad = 0.2
      else
	if ageCategory == 2 then
	  probUnvaccinatedFluVeryBad = 0.2;
	  probUnvaccinatedFluBad = 0.25
	else
	  probUnvaccinatedFluVeryBad = 0.3;
	  probUnvaccinatedFluBad = 0.3
	fi;
      fi;
    fi;
    true]])

// ---------------------------------- 31 ---------------------------------------

adit_value(AgeQ_Valid, [[ageAnswered = 1; true]])

// ---------------------------------- 32 ---------------------------------------

adit_value(SmokingQ_Valid, [[
  smokingAnswered = 1;
  if smokingCategory == 3
    then probSmoker = 1
    else probSmoker = 0
  fi;
  true]])

// ---------------------------------- 33 ---------------------------------------

adit_value(D6_Valid, [[
  probDiureticsBPRHDSideEffects = drugCHD * probDiureticsSideEffects;
  probDiureticsBPNRHDSideEffects = revisedCHDRisk * probDiureticsSideEffects;
  true]])

// ---------------------------------- 34 ---------------------------------------

adit_value(Q2_Valid, [[
    if history then
      if ageCategory == 1 then
	probUnvaccinatedFluVeryBad = 0.4;
	probUnvaccinatedFluBad = 0.3;
      else
	if ageCategory == 2 then
	  probUnvaccinatedFluVeryBad = 0.5;
	  probUnvaccinatedFluBad = 0.35;
	else
	  probUnvaccinatedFluVeryBad = 0.6;
	  probUnvaccinatedFluBad = 0.39;
	fi;
      fi;
    else
      if ageCategory == 1 then
	probUnvaccinatedFluVeryBad = 0.1;
	probUnvaccinatedFluBad = 0.2;
      else
	if ageCategory == 2 then
	  probUnvaccinatedFluVeryBad = 0.2;
	  probUnvaccinatedFluBad = 0.25;
	else
	  probUnvaccinatedFluVeryBad = 0.3;
	  probUnvaccinatedFluBad = 0.3;
	fi;
      fi;
    fi;
    true]])

// ---------------------------------- 35 ---------------------------------------

adit_value(BPQ_Valid, [[
  bpAnswered = 1;
  ((sbp > 99) and (sbp < 221)) or ((dbp > 49) and (dbp < 121))]])

{adit_processes}

// ********************* checks of "adit_set_attributes" ***********************

define([[adit_identifier]],Thing)

0 adit_set_attributes(check visible payoff)
dumpdef([[adit_check_Thing]])
dumpdef([[adit_visible_Thing]])

1 adit_set_attributes(payoff="payoffNap" visible="x>5")
dumpdef([[adit_visible_Thing]])

2 adit_set_attributes(payoff="payNap" visible)
dumpdef([[adit_visible_Thing]])

3 adit_set_attributes(visible="x>5" payoff check="y + 2 != 5")
dumpdef([[adit_check_Thing]])
dumpdef([[adit_visible_Thing]])

// ***************** checks of "adit_translate_assignment" *********************

adit_translate_begin

1 {adit_translate_assignment()}

2 {adit_translate_assignment(x=3)}

3 {adit_translate_assignment(y * 4)}

3 {adit_translate_assignment(b = if z <= 5 then x = 3 else x = 0 fi)}

4 {adit_translate_assignment(if a != 0 then a = 2 else b = 6 fi)}

7 {adit_translate_sequence(adit_translate_if(if a != 0 then a = 2 else b = 6 fi))}

adit_translate_end

// ******************* checks of "adit_translate_format" *********************

1 {adit_translate_format(BloodPressure)}

1 {adit_translate_format(Combo(a,b,c))}

2 {adit_translate_format(Edit)}

3 {adit_translate_format(HeightScale)}

4 {adit_translate_format(Radio(Yes,No))}

5 {adit_translate_format(WeightScale)}

6 {adit_translate_format(Nonsense(3))}

7 {adit_translate_format(Combo(a))}

8 {adit_translate_format(Radio(YesNo))}

// ******************** checks of "adit_translate_names" ***********************

adit_add_name(Bored)
adit_add_name(Porlock)

1 {adit_translate_names}

// ******************* checks of "adit_translate_number" ***********************

1 {adit_translate_number(4)}

2 {adit_translate_number(+5)}

3 {adit_translate_number(-3)}

4 {adit_translate_number(431)}

5 {adit_translate_number(4)}

6 {adit_translate_number(6.)}

7 {adit_translate_number(31.29)}

8 {adit_translate_number(.1)}

// ******************* checks of "adit_translate_sequence" *********************

1 {adit_translate_sequence(x=3)}

2 {adit_translate_sequence(x=3;y=4)}

3 {adit_translate_sequence(x = 2;payw=22)}

4 {adit_translate_sequence(x=3;payw=33;)}

5 {adit_translate_sequence(payx=4;w=44)}

6 {adit_translate_sequence(payx=5;w=55;)}

7 {adit_translate_sequence(x=3;payw=5;z=4;)}

8 {adit_translate_sequence(probx=3;w=5;payz=4;)}

9 {adit_translate_sequence(probx * 3;w+4;payz / 4;)}

// ****************** checks of "adit_translate_statement" *********************

1 {adit_translate_statement( ; x=3)}

2 {adit_translate_statement(x=3 ; )}

3 {adit_translate_statement( ; x=3 ; )}

4 {adit_translate_statement( ; ; x=3 ; )}

// ******************* checks of "adit_translate_string" ***********************

1 {adit_translate_string()}

2 {adit_translate_string(a)}

3 {adit_translate_string(ab)}

4 {adit_translate_string(abc)}

// ******************* checks of "adit_translate_value" *********************

1 {adit_translate_value(log(y) + exp(z)^w) == true)}

2 {adit_translate_value((4 != y2z) and (true or false))}

3 {adit_translate_value(4.20 + +5 - .2 - ((-1 * -18.06) / .41))}

4 {adit_translate_value(x67 + 4.2 - 1 + false)}

// ****************** checks of "adit_translate_variables" *********************

define([[adit_names]])define([[adit_variables]])
adit_value(Walk_Variables,
  tuesday
  probPorlock 0
  payWalk 80
  day
)
1 {adit_variables}
adit_translate_names

define([[adit_names]])define([[adit_variables]])
adit_value(Hypertension_Variables, [[
  // personal profile
  height 0
  weight 0
  exercise 1			// yes/no
  bmi
  saltOK 1
  highSalt 0
  smokingCategory 1		// 1=non-smoker, 2=ex-smoker 3=smoker
  smoker 0
  cigarettes 0			// number of cigarettes smoked
  yearsSmoked 0			// number of years for ex-smoker
  whenGaveUp

  // payoff constants
  payNoEvents 100
  payHeartDisease 10
  payStroke 5
  payDiureticSideEffects 40
  payBetaBlockerSideEffects 40
  payAlphaBlockerSideEffects 40
  payCASideEffects 40
  payACEISideEffects 40
  payACEIISideEffects 40

  // lifestyle risk reductions per mm/Hg DBP reduction
  lifestyleCHDRiskReduction 0.029
  lifestyleStrokeRiskReduction 0.069

   // no drugs
  probNoDrugsNoEvents
  probNoDrugsStroke
  probNoDrugsHD
]])
2 {adit_variables}
adit_translate_names

// ********************** checks of "adit_translate" ***********************

1 {adit_translate(x =5 == y; z = 4)}

2 {adit_translate(adit_if(age > 3,,))}

3 {adit_translate(adit_if(age > 3,x = 5,yChoice = 3))}

4 {adit_translate(adit_if(age > 3,,yChoice = 3))}

5 {adit_translate(adit_if(age > 3,x = 5,))}

6 {adit_translate(adit_if(x == 4,,z=2))}

7 {adit_translate(adit_if(history,
  adit_if(ageCategory == 1,
    adit_if(x < 5,,),
    adit_if(x == 4,x=5,)),))}

// ******************* checks of "adit_visibility" *********************

adit_value([[One_Visible]],x = 3 + w; y = Z / 2)
adit_value([[Two_Visible]],0)
adit_value([[Three_Visible]],1)

1 {adit_visibility(One)}

2 {adit_visibility(Two)}

3 {adit_visibility(Three)}

4 {adit_visibility(Four)}

/adit_tree(Walk, Walk, version="1.90" dictionary="walk.dic" neutral="70" macros
 variables,
  adit_terminal(Bored, Become bored, payoff="payBored"
   probability="probBored" check visible))

adit_chance(C9, Thingy, reason,
  adit_decision(D7, Stay at home, reason,
    adit_terminal(T1, Have a nap, payoff="payNap" probability="probNap"),
    adit_terminal(T2, Do something, payoff="payDo" probability="probDo"),
    adit_terminal(T3, A person from Porlock calls, visible
      payoff="payPorlock" probability="probPorlock")),
    adit_chance(C8, Stay at home, reason,
	adit_terminal(T4, Have a nap, payoff="payNap" probability="probNap"),
	adit_terminal(T5, Do something, payoff="payDo" probability="probDo"),
	adit_terminal(T6, A person from Porlock calls, visible
	payoff="payPorlock" probability="probPorlock")))

