// test_lotos.res	K. J. Turner	27/09/07

// ************** Output from running TOPO/LOLA on "bph" ****************

e 20:

    Analysed states       = 2816
    Generated transitions = 4432
    Duplicated states     = 245
    Deadlocks             = 0

e 30:

    Analysed states       = 25000
    Generated transitions = 39828
    Duplicated states     = 2166
    Deadlocks             = 0

e 40:  (dies)

e 40 -i: (dies after around 300MB used)

// ************** Output from running TOPO/LOLA on "diet" ***************

e 60:

    Analysed states       = 190
    Generated transitions = 298
    Duplicated states     = 87
    Deadlocks             = 0

// ************** Output from running TOPO/LOLA on "flu_complex" ***************

e 60: (need > 60)

    Analysed states       = 20617
    Generated transitions = 34145
    Duplicated states     = 9522
    Deadlocks             = 0

// ************** Output from running TOPO/LOLA on "flu_simple" ****************

e 70: (need > 70)

    Analysed states       = 65249
    Generated transitions = 109197
    Duplicated states     = 29089
    Deadlocks             = 0

// ************** Output from running TOPO/LOLA on "hypertension" **************

e 60: (need > 60, but 70 kills LOLA)

    Analysed states       = 3124
    Generated transitions = 4283
    Duplicated states     = 446
    Deadlocks             = 0

// ************** Output from running TOPO/LOLA on "menorrhagia" **************

e 50: (need > 60, but 60 kills LOLA)

    Analysed states       = 119321
    Generated transitions = 203941
    Duplicated states     = 27709
    Deadlocks             = 0

// ************** Output from running TOPO/LOLA on "sunday" ***************

e 15:

    Analysed states       = 26
    Generated transitions = 45
    Duplicated states     = 13
    Deadlocks             = 0

// *************** Output from running TOPO/LOLA for "walk" ******************

e 100:

    Analysed states       = 1468
    Generated transitions = 2447
    Duplicated states     = 855
    Deadlocks             = 0

----------------------------------------------------------------------------

With the following error in process Porlock:

  user !Porlock [get(tuesday,state) eq 4];

----------------------------------------------------------------------------

[1] t 15 ok -s -i: Stops 2 (print shows "i (* porlock *)" but also other "i"s)

[2] t 15 ok test -s -i -y: Stops 2 (print shows "i (* porlock *)" but also other "i"s - essentially same result as [1])

[3] t 15 ok test -s -i -y -b5: Stops 1 (print shows "i (* porlock *)" but also other "i"s)

----------------------------------------------------------------------------

[4] e 15: Deadlocks 1
    t 15 ok -s: Stops 5 (print shows "i (* porlock *)" only - essentially same result as [1])

  user  ! r ~ (o ~ (o ~ (t ~ <>)));
  (  user  ! s ~ (t ~ (a ~ (y ~ (h ~ (o ~ (m ~ (e ~ <>)))))));
     user  ! query;
     user  ! number(+,1 ~ <>,<>);
     user  ! s ~ (t ~ (a ~ (y ~ <>)));
     i; (* porlock *)
     stop
   []
     user  ! back;
     user  ! r ~ (o ~ (o ~ (t ~ <>)));
     (  user  ! s ~ (t ~ (a ~ (y ~ (h ~ (o ~ (m ~ (e ~ <>)))))));
	user  ! query;
	user  ! number(+,1 ~ <>,<>);
	user  ! s ~ (t ~ (a ~ (y ~ <>)));
	i; (* porlock *)
	stop
      []
	user  ! back;
	user  ! r ~ (o ~ (o ~ (t ~ <>)));
	(  user  ! s ~ (t ~ (a ~ (y ~ (h ~ (o ~ (m ~ (e ~ <>)))))));
	   user  ! query;
	   user  ! number(+,1 ~ <>,<>);
	   user  ! s ~ (t ~ (a ~ (y ~ <>)));
	   i; (* porlock *)
	   stop
	 []
	   user  ! back;
	   user  ! r ~ (o ~ (o ~ (t ~ <>)));
	   (  user  ! s ~ (t ~ (a ~ (y ~ (h ~ (o ~ (m ~ (e ~ <>)))))));
	      user  ! query;
	      user  ! number(+,1 ~ <>,<>);
	      user  ! s ~ (t ~ (a ~ (y ~ <>)));
	      i; (* porlock *)
	      stop
	    []
	      user  ! back;
	      user  ! r ~ (o ~ (o ~ (t ~ <>)));
	      user  ! s ~ (t ~ (a ~ (y ~ (h ~ (o ~ (m ~ (e ~ <>)))))));
	      user  ! query;
	      user  ! number(+,1 ~ <>,<>);
	      user  ! s ~ (t ~ (a ~ (y ~ <>)));
	      i; (* porlock *)
	      stop
	   )
	)
     )
  )

// *************** Output from running "m4 test.m4 | cat -s" ******************

// ********************** checks of "adit_chance" ***********************

// ---------------------------------- 1 ---------------------------------------

1 {}
{}

// ---------------------------------- 2 ---------------------------------------

{Process C2 [user] (map:Map) : Exit(map) := (* Chance C2 *)
  user !C2; (* enter node *)
  (
    T2Visible (map) (* check T2 visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    [visible(T2,map)] -> (* T2 visible? *)
      (
	Hide t2 In (* hide internal choice gate *)
	  t2; (* system choice *)
	  T2 [user] (map) (* to T2 *)
      )adit_back
  )
EndProc (* end C2 *)

}
{Process T2Visible (map:Map) : Exit(map) := (* Visible T2 *)
  Exit(set(get(a,map) == get(b,map),map)) (* exit with last result set to "a == b" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T2,map)) (* set Visible for T2 *)
EndProc (* end T2Visible *)

Process T2 [user] (map:Map) : Exit(map) := (* Terminal T2 *)
  user !T2; (* enter T2 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C2 [user] (map) (* to parent *)
  )
EndProc (* end T2 *)

}

// ---------------------------------- 3 ---------------------------------------

{Process C3 [user] (map:Map) : Exit(map) := (* Chance C3 *)
  user !C3; (* enter node *)
  (
    (
      Hide t3 In (* hide internal choice gate *)
	t3; (* system choice *)
	T3 [user] (map) (* to T3 *)
    )adit_back
  )
EndProc (* end C3 *)

}
{Process T3 [user] (map:Map) : Exit(map) := (* Terminal T3 *)
  user !T3; (* enter T3 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C3 [user] (map) (* to parent *)
  )
EndProc (* end T3 *)

}

// ---------------------------------- 4 ---------------------------------------

{Process C4 [user] (map:Map) : Exit(map) := (* Chance C4 *)
  user !C4; (* enter node *)
  (
    T4CVisible (map) (* check T4C visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    (
      Hide t4a In (* hide internal choice gate *)
	t4a; (* system choice *)
	T4A [user] (map) (* to T4A *)
    )
  [] (* or *)
    (
      Hide t4b In (* hide internal choice gate *)
	t4b; (* system choice *)
	T4B [user] (map) (* to T4B *)
    )
  [] (* or *)
    [visible(T4C,map)] -> (* T4C visible? *)
      (
	Hide t4c In (* hide internal choice gate *)
	  t4c; (* system choice *)
	  T4C [user] (map) (* to T4C *)
      )adit_back
  )
EndProc (* end C4 *)

}
{Process T4CVisible (map:Map) : Exit(map) := (* Visible T4C *)
  Exit(set(1 Of Number or 0 Of Number,map)) (* exit with last result set to "true or false" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T4C,map)) (* set Visible for T4C *)
EndProc (* end T4CVisible *)

Process T4A [user] (map:Map) : Exit(map) := (* Terminal T4A *)
  user !T4A; (* enter T4A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C4 [user] (map) (* to parent *)
  )
EndProc (* end T4A *)

Process T4B [user] (map:Map) : Exit(map) := (* Terminal T4B *)
  user !T4B; (* enter T4B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C4 [user] (map) (* to parent *)
  )
EndProc (* end T4B *)

Process T4C [user] (map:Map) : Exit(map) := (* Terminal T4C *)
  user !T4C; (* enter T4C *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C4 [user] (map) (* to parent *)
  )
EndProc (* end T4C *)

}

// ---------------------------------- 5 ---------------------------------------

{Process C5 [user] (map:Map) : Exit(map) := (* Chance C5 *)
  user !C5; (* enter node *)
  (
    T5CVisible (map) (* check T5C visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    (
      Hide t5a In (* hide internal choice gate *)
	t5a; (* system choice *)
	T5A [user] (map) (* to T5A *)
    )
  [] (* or *)
    [visible(T5C,map)] -> (* T5C visible? *)
      (
	Hide t5c In (* hide internal choice gate *)
	  t5c; (* system choice *)
	  T5C [user] (map) (* to T5C *)
      )adit_back
  )
EndProc (* end C5 *)

}
{Process T5BVisible (map:Map) : Exit(map) := (* Visible T5B *)
  Exit(set(0 Of Number,map)) (* exit with last result set to "false" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T5B,map)) (* set Visible for T5B *)
EndProc (* end T5BVisible *)

Process T5CVisible (map:Map) : Exit(map) := (* Visible T5C *)
  Exit(set(get(w,map) < get(z,map),map)) (* exit with last result set to "w < z" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T5C,map)) (* set Visible for T5C *)
EndProc (* end T5CVisible *)

Process T5A [user] (map:Map) : Exit(map) := (* Terminal T5A *)
  user !T5A; (* enter T5A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C5 [user] (map) (* to parent *)
  )
EndProc (* end T5A *)

Process T5B [user] (map:Map) : Exit(map) := (* Terminal T5B *)
  user !T5B; (* enter T5B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C5 [user] (map) (* to parent *)
  )
EndProc (* end T5B *)

Process T5C [user] (map:Map) : Exit(map) := (* Terminal T5C *)
  user !T5C; (* enter T5C *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C5 [user] (map) (* to parent *)
  )
EndProc (* end T5C *)

}

// ---------------------------------- 6 ---------------------------------------

{Process C6 [user] (map:Map) : Exit(map) := (* Chance C6 *)
  user !C6; (* enter node *)
  (
    T6AVisible (map) (* check T6A visibility *)
  >> Accept map:Map In (* get new map *)
    T6CVisible (map) (* check T6C visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    [visible(T6A,map)] -> (* T6A visible? *)
      (
	Hide t6a In (* hide internal choice gate *)
	  t6a; (* system choice *)
	  T6A [user] (map) (* to T6A *)
      )
  [] (* or *)
    (
      Hide t6b In (* hide internal choice gate *)
	t6b; (* system choice *)
	T6B [user] (map) (* to T6B *)
    )
  [] (* or *)
    [visible(T6C,map)] -> (* T6C visible? *)
      (
	Hide t6c In (* hide internal choice gate *)
	  t6c; (* system choice *)
	  T6C [user] (map) (* to T6C *)
      )adit_back
  )
EndProc (* end C6 *)

}
{Process T6AVisible (map:Map) : Exit(map) := (* Visible T6A *)
  Exit(set(get(x,map),map)) (* exit with last result set to "x" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T6A,map)) (* set Visible for T6A *)
EndProc (* end T6AVisible *)

Process T6CVisible (map:Map) : Exit(map) := (* Visible T6C *)
  Exit(set(get(w,map) < get(z,map),map)) (* exit with last result set to "w < z" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T6C,map)) (* set Visible for T6C *)
EndProc (* end T6CVisible *)

Process T6A [user] (map:Map) : Exit(map) := (* Terminal T6A *)
  user !T6A; (* enter T6A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C6 [user] (map) (* to parent *)
  )
EndProc (* end T6A *)

Process T6B [user] (map:Map) : Exit(map) := (* Terminal T6B *)
  user !T6B; (* enter T6B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C6 [user] (map) (* to parent *)
  )
EndProc (* end T6B *)

Process T6C [user] (map:Map) : Exit(map) := (* Terminal T6C *)
  user !T6C; (* enter T6C *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C6 [user] (map) (* to parent *)
  )
EndProc (* end T6C *)

}

// ---------------------------------- 7 ---------------------------------------

{Process C7 [user] (map:Map) : Exit(map) := (* Chance C7 *)
  user !C7; (* enter node *)
  (
    (
      Hide old In (* hide internal choice gate *)
	old; (* system choice *)
	Old [user] (map) (* to Old *)
    )adit_back
  )
EndProc (* end C7 *)

}
{Process OldValid (map:Map) : Exit(map) := (* Valid Old *)
  Exit(set(number(+,t(9),<>) > get(x,map),map)) (* exit with last result set to "9 > x" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Old,map)) (* set Valid for Old *)
EndProc (* end OldValid *)

Process Old [user] (map:Map) : Exit(map) := (* Question Old *)
  OldAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C7 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit(map) (* continue after question *)
  )

Where (* local definitions *)

  Process OldAux [user] (map:Map) : Exit(Map) := (* Auxiliary Old *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Old; (* enter node *)
	(
	  [satisfied(Old,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      OldAux [user] (unsatisfy(Old,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Old,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for elderly *)
		  Exit(set(elderly,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for elderly *)
		  Exit(set(elderly,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for elderly *)
		  Exit(set(elderly,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for elderly *)
		  Exit(set(elderly,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		OldValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Old,map)] -> (* valid answer? *)
		    Exit(satisfy(Old,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Old,map))] -> (* invalid answer? *)
		    OldAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of OldAux *)

EndProc (* end Old *)

}

// ---------------------------------- 8 ---------------------------------------

{Process C8 [user] (map:Map) : Exit(map) := (* Chance C8 *)
  user !C8; (* enter node *)
  (
    (
      Hide new In (* hide internal choice gate *)
	new; (* system choice *)
	New [user] (map) (* to New *)
    )
  [] (* or *)
    (
      Hide t8 In (* hide internal choice gate *)
	t8; (* system choice *)
	T8 [user] (map) (* to T8 *)
    )adit_back
  )
EndProc (* end C8 *)

}
{Process NewValid (map:Map) : Exit(map) := (* Valid New *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(New,map)) (* set Valid for New *)
EndProc (* end NewValid *)

Process New [user] (map:Map) : Exit(map) := (* Question New *)
  NewAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C8 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process NewAux [user] (map:Map) : Exit(Map) := (* Auxiliary New *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !New; (* enter node *)
	(
	  [satisfied(New,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      NewAux [user] (unsatisfy(New,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(New,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for modern *)
		  Exit(set(modern,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for modern *)
		  Exit(set(modern,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for modern *)
		  Exit(set(modern,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for modern *)
		  Exit(set(modern,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		NewValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(New,map)] -> (* valid answer? *)
		    Exit(satisfy(New,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(New,map))] -> (* invalid answer? *)
		    NewAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of NewAux *)

EndProc (* end New *)

Process T8 [user] (map:Map) : Exit(map) := (* Terminal T8 *)
  user !T8; (* enter T8 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C8 [user] (map) (* to parent *)
  )
EndProc (* end T8 *)

}

// ---------------------------------- 9 ---------------------------------------

{Process C9 [user] (map:Map) : Exit(map) := (* Chance C9 *)
  user !C9; (* enter node *)
  (
    (
      Hide forward In (* hide internal choice gate *)
	forward; (* system choice *)
	Forward [user] (map) (* to Forward *)
    )
  [] (* or *)
    (
      Hide past In (* hide internal choice gate *)
	past; (* system choice *)
	Past [user] (map) (* to Past *)
    )
  [] (* or *)
    (
      Hide t9 In (* hide internal choice gate *)
	t9; (* system choice *)
	T9 [user] (map) (* to T9 *)
    )adit_back
  )
EndProc (* end C9 *)

}
{Process ForwardValid (map:Map) : Exit(map) := (* Valid Forward *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Forward,map)) (* set Valid for Forward *)
EndProc (* end ForwardValid *)

Process PastValid (map:Map) : Exit(map) := (* Valid Past *)
  Exit(set(get(c,map) /= get(b,map),map)) (* exit with last result set to "c != b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Past,map)) (* set Valid for Past *)
EndProc (* end PastValid *)

Process Forward [user] (map:Map) : Exit(map) := (* Question Forward *)
  ForwardAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C9 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process ForwardAux [user] (map:Map) : Exit(Map) := (* Auxiliary Forward *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Forward; (* enter node *)
	(
	  [satisfied(Forward,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      ForwardAux [user] (unsatisfy(Forward,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Forward,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod1 *)
		  Exit(set(mod1,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod1 *)
		  Exit(set(mod1,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod1 *)
		  Exit(set(mod1,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod1 *)
		  Exit(set(mod1,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		ForwardValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Forward,map)] -> (* valid answer? *)
		    Exit(satisfy(Forward,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Forward,map))] -> (* invalid answer? *)
		    ForwardAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of ForwardAux *)

EndProc (* end Forward *)

Process Past [user] (map:Map) : Exit(map) := (* Question Past *)
  PastAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C9 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process PastAux [user] (map:Map) : Exit(Map) := (* Auxiliary Past *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Past; (* enter node *)
	(
	  [satisfied(Past,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      PastAux [user] (unsatisfy(Past,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Past,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for history *)
		Exit(set(history,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		PastValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Past,map)] -> (* valid answer? *)
		    Exit(satisfy(Past,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Past,map))] -> (* invalid answer? *)
		    PastAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of PastAux *)

EndProc (* end Past *)

Process T9 [user] (map:Map) : Exit(map) := (* Terminal T9 *)
  user !T9; (* enter T9 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C9 [user] (map) (* to parent *)
  )
EndProc (* end T9 *)

}

// ---------------------------------- 10 ---------------------------------------

{Process C10 [user] (map:Map) : Exit(map) := (* Chance C10 *)
  user !C10; (* enter node *)
  (
    (
      Hide future In (* hide internal choice gate *)
	future; (* system choice *)
	Future [user] (map) (* to Future *)
    )
  [] (* or *)
    (
      Hide bygone In (* hide internal choice gate *)
	bygone; (* system choice *)
	Bygone [user] (map) (* to Bygone *)
    )
  [] (* or *)
    (
      Hide t10a In (* hide internal choice gate *)
	t10a; (* system choice *)
	T10A [user] (map) (* to T10A *)
    )
  [] (* or *)
    (
      Hide t10b In (* hide internal choice gate *)
	t10b; (* system choice *)
	T10B [user] (map) (* to T10B *)
    )adit_back
  )
EndProc (* end C10 *)

}
{Process FutureValid (map:Map) : Exit(map) := (* Valid Future *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Future,map)) (* set Valid for Future *)
EndProc (* end FutureValid *)

Process BygoneValid (map:Map) : Exit(map) := (* Valid Bygone *)
  Exit(set(get(c,map) /= get(b,map),map)) (* exit with last result set to "c != b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Bygone,map)) (* set Valid for Bygone *)
EndProc (* end BygoneValid *)

Process Future [user] (map:Map) : Exit(map) := (* Question Future *)
  FutureAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C10 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process FutureAux [user] (map:Map) : Exit(Map) := (* Auxiliary Future *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future; (* enter node *)
	(
	  [satisfied(Future,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      FutureAux [user] (unsatisfy(Future,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		FutureValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future,map)] -> (* valid answer? *)
		    Exit(satisfy(Future,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future,map))] -> (* invalid answer? *)
		    FutureAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of FutureAux *)

EndProc (* end Future *)

Process Bygone [user] (map:Map) : Exit(map) := (* Question Bygone *)
  BygoneAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C10 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process BygoneAux [user] (map:Map) : Exit(Map) := (* Auxiliary Bygone *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Bygone; (* enter node *)
	(
	  [satisfied(Bygone,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      BygoneAux [user] (unsatisfy(Bygone,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Bygone,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for history *)
		Exit(set(history,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		BygoneValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Bygone,map)] -> (* valid answer? *)
		    Exit(satisfy(Bygone,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Bygone,map))] -> (* invalid answer? *)
		    BygoneAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of BygoneAux *)

EndProc (* end Bygone *)

Process T10A [user] (map:Map) : Exit(map) := (* Terminal T10A *)
  user !T10A; (* enter T10A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C10 [user] (map) (* to parent *)
  )
EndProc (* end T10A *)

Process T10B [user] (map:Map) : Exit(map) := (* Terminal T10B *)
  user !T10B; (* enter T10B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C10 [user] (map) (* to parent *)
  )
EndProc (* end T10B *)

}

// ---------------------------------- 11---------------------------------------

{Process C11 [user] (map:Map) : Exit(map) := (* Chance C11 *)
  user !C11; (* enter node *)
  (
    Future2Visible (map) (* check Future2 visibility *)
  >> Accept map:Map In (* get new map *)
    T11BVisible (map) (* check T11B visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    [visible(Future2,map)] -> (* Future2 visible? *)
      (
	Hide future2 In (* hide internal choice gate *)
	  future2; (* system choice *)
	  Future2 [user] (map) (* to Future2 *)
      )
  [] (* or *)
    (
      Hide bygone2 In (* hide internal choice gate *)
	bygone2; (* system choice *)
	Bygone2 [user] (map) (* to Bygone2 *)
    )
  [] (* or *)
    (
      Hide t11a In (* hide internal choice gate *)
	t11a; (* system choice *)
	T11A [user] (map) (* to T11A *)
    )
  [] (* or *)
    [visible(T11B,map)] -> (* T11B visible? *)
      (
	Hide t11b In (* hide internal choice gate *)
	  t11b; (* system choice *)
	  T11B [user] (map) (* to T11B *)
      )adit_back
  )
EndProc (* end C11 *)

}
{Process Future2Valid (map:Map) : Exit(map) := (* Valid Future2 *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Future2,map)) (* set Valid for Future2 *)
EndProc (* end Future2Valid *)

Process Future2Visible (map:Map) : Exit(map) := (* Visible Future2 *)
  Exit(set(get(a,map) or get(b,map),map)) (* exit with last result set to "a or b" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Future2,map)) (* set Visible for Future2 *)
EndProc (* end Future2Visible *)

Process Bygone2Valid (map:Map) : Exit(map) := (* Valid Bygone2 *)
  Exit(set(get(c,map) /= get(b,map),map)) (* exit with last result set to "c != b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Bygone2,map)) (* set Valid for Bygone2 *)
EndProc (* end Bygone2Valid *)

Process T11BVisible (map:Map) : Exit(map) := (* Visible T11B *)
  Exit(set(not(get(x,map)),map)) (* exit with last result set to "not(x)" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T11B,map)) (* set Visible for T11B *)
EndProc (* end T11BVisible *)

Process Future2 [user] (map:Map) : Exit(map) := (* Question Future2 *)
  Future2Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C11 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Future2Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Future2 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future2; (* enter node *)
	(
	  [satisfied(Future2,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Future2Aux [user] (unsatisfy(Future2,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future2,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		Future2Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future2,map)] -> (* valid answer? *)
		    Exit(satisfy(Future2,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future2,map))] -> (* invalid answer? *)
		    Future2Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Future2Aux *)

EndProc (* end Future2 *)

Process Bygone2 [user] (map:Map) : Exit(map) := (* Question Bygone2 *)
  Bygone2Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C11 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Bygone2Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Bygone2 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Bygone2; (* enter node *)
	(
	  [satisfied(Bygone2,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Bygone2Aux [user] (unsatisfy(Bygone2,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Bygone2,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for history *)
		Exit(set(history,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Bygone2Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Bygone2,map)] -> (* valid answer? *)
		    Exit(satisfy(Bygone2,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Bygone2,map))] -> (* invalid answer? *)
		    Bygone2Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Bygone2Aux *)

EndProc (* end Bygone2 *)

Process T11A [user] (map:Map) : Exit(map) := (* Terminal T11A *)
  user !T11A; (* enter T11A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C11 [user] (map) (* to parent *)
  )
EndProc (* end T11A *)

Process T11B [user] (map:Map) : Exit(map) := (* Terminal T11B *)
  user !T11B; (* enter T11B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C11 [user] (map) (* to parent *)
  )
EndProc (* end T11B *)

}

// ---------------------------------- 12---------------------------------------

{Process C12 [user] (map:Map) : Exit(map) := (* Chance C12 *)
  user !C12; (* enter node *)
  (
    (
      Hide bygone3 In (* hide internal choice gate *)
	bygone3; (* system choice *)
	Bygone3 [user] (map) (* to Bygone3 *)
    )
  [] (* or *)
    (
      Hide t12a In (* hide internal choice gate *)
	t12a; (* system choice *)
	T12A [user] (map) (* to T12A *)
    )
  [] (* or *)
    (
      Hide t12b In (* hide internal choice gate *)
	t12b; (* system choice *)
	T12B [user] (map) (* to T12B *)
    )adit_back
  )
EndProc (* end C12 *)

}
{Process Future3Valid (map:Map) : Exit(map) := (* Valid Future3 *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Future3,map)) (* set Valid for Future3 *)
EndProc (* end Future3Valid *)

Process Future3Visible (map:Map) : Exit(map) := (* Visible Future3 *)
  Exit(set(0 Of Number,map)) (* exit with last result set to "false" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Future3,map)) (* set Visible for Future3 *)
EndProc (* end Future3Visible *)

Process Bygone3Valid (map:Map) : Exit(map) := (* Valid Bygone3 *)
  Exit(set(get(c,map) /= get(b,map),map)) (* exit with last result set to "c != b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Bygone3,map)) (* set Valid for Bygone3 *)
EndProc (* end Bygone3Valid *)

Process Future3 [user] (map:Map) : Exit(map) := (* Question Future3 *)
  Future3Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C12 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Future3Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Future3 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future3; (* enter node *)
	(
	  [satisfied(Future3,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Future3Aux [user] (unsatisfy(Future3,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future3,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		Future3Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future3,map)] -> (* valid answer? *)
		    Exit(satisfy(Future3,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future3,map))] -> (* invalid answer? *)
		    Future3Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Future3Aux *)

EndProc (* end Future3 *)

Process Bygone3 [user] (map:Map) : Exit(map) := (* Question Bygone3 *)
  Bygone3Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C12 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Bygone3Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Bygone3 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Bygone3; (* enter node *)
	(
	  [satisfied(Bygone3,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Bygone3Aux [user] (unsatisfy(Bygone3,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Bygone3,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for history *)
		Exit(set(history,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Bygone3Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Bygone3,map)] -> (* valid answer? *)
		    Exit(satisfy(Bygone3,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Bygone3,map))] -> (* invalid answer? *)
		    Bygone3Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Bygone3Aux *)

EndProc (* end Bygone3 *)

Process T12A [user] (map:Map) : Exit(map) := (* Terminal T12A *)
  user !T12A; (* enter T12A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C12 [user] (map) (* to parent *)
  )
EndProc (* end T12A *)

Process T12B [user] (map:Map) : Exit(map) := (* Terminal T12B *)
  user !T12B; (* enter T12B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C12 [user] (map) (* to parent *)
  )
EndProc (* end T12B *)

}

// ---------------------------------- 13 ---------------------------------------

{Process C13 [user] (map:Map) : Exit(map) := (* Chance C13 *)
  user !C13; (* enter node *)
  (
    Future66Visible (map) (* check Future66 visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    (
      Hide t13 In (* hide internal choice gate *)
	t13; (* system choice *)
	T13 [user] (map) (* to T13 *)
    )
  [] (* or *)
    [visible(Future66,map)] -> (* Future66 visible? *)
      (
	Hide future66 In (* hide internal choice gate *)
	  future66; (* system choice *)
	  Future66 [user] (map) (* to Future66 *)
      )adit_back
  )
EndProc (* end C13 *)

}
{Process Future66Valid (map:Map) : Exit(map) := (* Valid Future66 *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Future66,map)) (* set Valid for Future66 *)
EndProc (* end Future66Valid *)

Process Future66Visible (map:Map) : Exit(map) := (* Visible Future66 *)
  Exit(set(number(+,t(2),<>)number(+,t(5),<>),map)) (* exit with last result set to "2+5" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Future66,map)) (* set Visible for Future66 *)
EndProc (* end Future66Visible *)

Process T13 [user] (map:Map) : Exit(map) := (* Terminal T13 *)
  user !T13; (* enter T13 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    C13 [user] (map) (* to parent *)
  )
EndProc (* end T13 *)

Process Future66 [user] (map:Map) : Exit(map) := (* Question Future66 *)
  Future66Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C13 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Future66Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Future66 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future66; (* enter node *)
	(
	  [satisfied(Future66,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Future66Aux [user] (unsatisfy(Future66,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future66,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		Future66Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future66,map)] -> (* valid answer? *)
		    Exit(satisfy(Future66,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future66,map))] -> (* invalid answer? *)
		    Future66Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Future66Aux *)

EndProc (* end Future66 *)

}

// ---------------------------------- 14 ---------------------------------------

{Process C14 [user] (map:Map) : Exit(map) := (* Chance C14 *)
  user !C14; (* enter node *)
  (
    Future66Visible (map) (* check Future66 visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    [visible(Future66,map)] -> (* Future66 visible? *)
      (
	Hide future66 In (* hide internal choice gate *)
	  future66; (* system choice *)
	  Future66 [user] (map) (* to Future66 *)
      )adit_back
  )
EndProc (* end C14 *)

}
{Process Future66 [user] (map:Map) : Exit(map) := (* Question Future66 *)
  Future66Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      C14 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Future66Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Future66 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future66; (* enter node *)
	(
	  [satisfied(Future66,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Future66Aux [user] (unsatisfy(Future66,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future66,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		Future66Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future66,map)] -> (* valid answer? *)
		    Exit(satisfy(Future66,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future66,map))] -> (* invalid answer? *)
		    Future66Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Future66Aux *)

EndProc (* end Future66 *)

}

// ********************** checks of "adit_decision" ***********************

// ---------------------------------- 1 ---------------------------------------

1 {}
{}

// ---------------------------------- 2 ---------------------------------------

{Process D2 [user] (map:Map) : Exit(map) := (* Decision D2 *)
  user !D2; (* enter node *)
  (
    T2Visible (map) (* check T2 visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    [visible(T2,map)] -> (* T2 visible? *)
      (
	T2 [user] (map) (* to T2 *)
      )adit_back
  )
EndProc (* end D2 *)

}
{Process T2Visible (map:Map) : Exit(map) := (* Visible T2 *)
  Exit(set(get(a,map) == get(b,map),map)) (* exit with last result set to "a == b" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T2,map)) (* set Visible for T2 *)
EndProc (* end T2Visible *)

Process T2 [user] (map:Map) : Exit(map) := (* Terminal T2 *)
  user !T2; (* enter T2 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D2 [user] (map) (* to parent *)
  )
EndProc (* end T2 *)

}

// ---------------------------------- 3 ---------------------------------------

{Process D3 [user] (map:Map) : Exit(map) := (* Decision D3 *)
  user !D3; (* enter node *)
  (
    T3 [user] (map) (* to T3 *)adit_back
  )
EndProc (* end D3 *)

}
{Process T3 [user] (map:Map) : Exit(map) := (* Terminal T3 *)
  user !T3; (* enter T3 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D3 [user] (map) (* to parent *)
  )
EndProc (* end T3 *)

}

// ---------------------------------- 4 ---------------------------------------

{Process D48 [user] (map:Map) : Exit(map) := (* Decision D48 *)
  user !D48; (* enter node *)
  (
    T4CVisible (map) (* check T4C visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    T4A [user] (map) (* to T4A *)
  [] (* or *)
    T4B [user] (map) (* to T4B *)
  [] (* or *)
    [visible(T4C,map)] -> (* T4C visible? *)
      (
	T4C [user] (map) (* to T4C *)
      )adit_back
  )
EndProc (* end D48 *)

}
{Process T4CVisible (map:Map) : Exit(map) := (* Visible T4C *)
  Exit(set(1 Of Number or 0 Of Number,map)) (* exit with last result set to "true or false" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T4C,map)) (* set Visible for T4C *)
EndProc (* end T4CVisible *)

Process T4A [user] (map:Map) : Exit(map) := (* Terminal T4A *)
  user !T4A; (* enter T4A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D48 [user] (map) (* to parent *)
  )
EndProc (* end T4A *)

Process T4B [user] (map:Map) : Exit(map) := (* Terminal T4B *)
  user !T4B; (* enter T4B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D48 [user] (map) (* to parent *)
  )
EndProc (* end T4B *)

Process T4C [user] (map:Map) : Exit(map) := (* Terminal T4C *)
  user !T4C; (* enter T4C *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D48 [user] (map) (* to parent *)
  )
EndProc (* end T4C *)

}

// ---------------------------------- 5 ---------------------------------------

{Process D5 [user] (map:Map) : Exit(map) := (* Decision D5 *)
  user !D5; (* enter node *)
  (
    T5CVisible (map) (* check T5C visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    T5A [user] (map) (* to T5A *)
  [] (* or *)
    [visible(T5C,map)] -> (* T5C visible? *)
      (
	T5C [user] (map) (* to T5C *)
      )adit_back
  )
EndProc (* end D5 *)

}
{Process T5BVisible (map:Map) : Exit(map) := (* Visible T5B *)
  Exit(set(0 Of Number,map)) (* exit with last result set to "false" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T5B,map)) (* set Visible for T5B *)
EndProc (* end T5BVisible *)

Process T5CVisible (map:Map) : Exit(map) := (* Visible T5C *)
  Exit(set(get(w,map) < get(z,map),map)) (* exit with last result set to "w < z" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T5C,map)) (* set Visible for T5C *)
EndProc (* end T5CVisible *)

Process T5A [user] (map:Map) : Exit(map) := (* Terminal T5A *)
  user !T5A; (* enter T5A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D5 [user] (map) (* to parent *)
  )
EndProc (* end T5A *)

Process T5B [user] (map:Map) : Exit(map) := (* Terminal T5B *)
  user !T5B; (* enter T5B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D5 [user] (map) (* to parent *)
  )
EndProc (* end T5B *)

Process T5C [user] (map:Map) : Exit(map) := (* Terminal T5C *)
  user !T5C; (* enter T5C *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D5 [user] (map) (* to parent *)
  )
EndProc (* end T5C *)

}

// ---------------------------------- 6 ---------------------------------------

{Process D6 [user] (map:Map) : Exit(map) := (* Decision D6 *)
  user !D6; (* enter node *)
  (
    T6AVisible (map) (* check T6A visibility *)
  >> Accept map:Map In (* get new map *)
    T6CVisible (map) (* check T6C visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    [visible(T6A,map)] -> (* T6A visible? *)
      (
	T6A [user] (map) (* to T6A *)
      )
  [] (* or *)
    T6B [user] (map) (* to T6B *)
  [] (* or *)
    [visible(T6C,map)] -> (* T6C visible? *)
      (
	T6C [user] (map) (* to T6C *)
      )adit_back
  )
EndProc (* end D6 *)

}
{Process T6AVisible (map:Map) : Exit(map) := (* Visible T6A *)
  Exit(set(get(x,map),map)) (* exit with last result set to "x" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T6A,map)) (* set Visible for T6A *)
EndProc (* end T6AVisible *)

Process T6CVisible (map:Map) : Exit(map) := (* Visible T6C *)
  Exit(set(get(w,map) < get(z,map),map)) (* exit with last result set to "w < z" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T6C,map)) (* set Visible for T6C *)
EndProc (* end T6CVisible *)

Process T6A [user] (map:Map) : Exit(map) := (* Terminal T6A *)
  user !T6A; (* enter T6A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D6 [user] (map) (* to parent *)
  )
EndProc (* end T6A *)

Process T6B [user] (map:Map) : Exit(map) := (* Terminal T6B *)
  user !T6B; (* enter T6B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D6 [user] (map) (* to parent *)
  )
EndProc (* end T6B *)

Process T6C [user] (map:Map) : Exit(map) := (* Terminal T6C *)
  user !T6C; (* enter T6C *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D6 [user] (map) (* to parent *)
  )
EndProc (* end T6C *)

}


// ---------------------------------- 7 ---------------------------------------

{Process D7 [user] (map:Map) : Exit(map) := (* Decision D7 *)
  user !D7; (* enter node *)
  (
    Old [user] (map) (* to Old *)adit_back
  )
EndProc (* end D7 *)

}
{Process OldValid (map:Map) : Exit(map) := (* Valid Old *)
  Exit(set(number(+,t(9),<>) > get(x,map),map)) (* exit with last result set to "9 > x" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Old,map)) (* set Valid for Old *)
EndProc (* end OldValid *)

Process Old [user] (map:Map) : Exit(map) := (* Question Old *)
  OldAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D7 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process OldAux [user] (map:Map) : Exit(Map) := (* Auxiliary Old *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Old; (* enter node *)
	(
	  [satisfied(Old,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      OldAux [user] (unsatisfy(Old,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Old,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for elderly *)
		  Exit(set(elderly,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for elderly *)
		  Exit(set(elderly,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for elderly *)
		  Exit(set(elderly,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for elderly *)
		  Exit(set(elderly,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		OldValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Old,map)] -> (* valid answer? *)
		    Exit(satisfy(Old,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Old,map))] -> (* invalid answer? *)
		    OldAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of OldAux *)

EndProc (* end Old *)

}

// ---------------------------------- 8 ---------------------------------------

{Process D8 [user] (map:Map) : Exit(map) := (* Decision D8 *)
  user !D8; (* enter node *)
  (
    New [user] (map) (* to New *)
  [] (* or *)
    T8 [user] (map) (* to T8 *)adit_back
  )
EndProc (* end D8 *)

}
{Process NewValid (map:Map) : Exit(map) := (* Valid New *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(New,map)) (* set Valid for New *)
EndProc (* end NewValid *)

Process New [user] (map:Map) : Exit(map) := (* Question New *)
  NewAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D8 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process NewAux [user] (map:Map) : Exit(Map) := (* Auxiliary New *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !New; (* enter node *)
	(
	  [satisfied(New,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      NewAux [user] (unsatisfy(New,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(New,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for modern *)
		  Exit(set(modern,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for modern *)
		  Exit(set(modern,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for modern *)
		  Exit(set(modern,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for modern *)
		  Exit(set(modern,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		NewValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(New,map)] -> (* valid answer? *)
		    Exit(satisfy(New,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(New,map))] -> (* invalid answer? *)
		    NewAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of NewAux *)

EndProc (* end New *)

Process T8 [user] (map:Map) : Exit(map) := (* Terminal T8 *)
  user !T8; (* enter T8 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D8 [user] (map) (* to parent *)
  )
EndProc (* end T8 *)

}

// ---------------------------------- 9 ---------------------------------------

{Process D9 [user] (map:Map) : Exit(map) := (* Decision D9 *)
  user !D9; (* enter node *)
  (
    Forward [user] (map) (* to Forward *)
  [] (* or *)
    Past [user] (map) (* to Past *)
  [] (* or *)
    T9 [user] (map) (* to T9 *)adit_back
  )
EndProc (* end D9 *)

}
{Process ForwardValid (map:Map) : Exit(map) := (* Valid Forward *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Forward,map)) (* set Valid for Forward *)
EndProc (* end ForwardValid *)

Process PastValid (map:Map) : Exit(map) := (* Valid Past *)
  Exit(set(get(c,map) /= get(b,map),map)) (* exit with last result set to "c != b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Past,map)) (* set Valid for Past *)
EndProc (* end PastValid *)

Process Forward [user] (map:Map) : Exit(map) := (* Question Forward *)
  ForwardAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D9 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process ForwardAux [user] (map:Map) : Exit(Map) := (* Auxiliary Forward *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Forward; (* enter node *)
	(
	  [satisfied(Forward,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      ForwardAux [user] (unsatisfy(Forward,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Forward,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod1 *)
		  Exit(set(mod1,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod1 *)
		  Exit(set(mod1,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod1 *)
		  Exit(set(mod1,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod1 *)
		  Exit(set(mod1,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		ForwardValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Forward,map)] -> (* valid answer? *)
		    Exit(satisfy(Forward,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Forward,map))] -> (* invalid answer? *)
		    ForwardAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of ForwardAux *)

EndProc (* end Forward *)

Process Past [user] (map:Map) : Exit(map) := (* Question Past *)
  PastAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D9 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process PastAux [user] (map:Map) : Exit(Map) := (* Auxiliary Past *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Past; (* enter node *)
	(
	  [satisfied(Past,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      PastAux [user] (unsatisfy(Past,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Past,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for history *)
		Exit(set(history,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		PastValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Past,map)] -> (* valid answer? *)
		    Exit(satisfy(Past,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Past,map))] -> (* invalid answer? *)
		    PastAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of PastAux *)

EndProc (* end Past *)

Process T9 [user] (map:Map) : Exit(map) := (* Terminal T9 *)
  user !T9; (* enter T9 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D9 [user] (map) (* to parent *)
  )
EndProc (* end T9 *)

}

// ---------------------------------- 10 ---------------------------------------

{Process D10 [user] (map:Map) : Exit(map) := (* Decision D10 *)
  user !D10; (* enter node *)
  (
    Future [user] (map) (* to Future *)
  [] (* or *)
    Bygone [user] (map) (* to Bygone *)
  [] (* or *)
    T10A [user] (map) (* to T10A *)
  [] (* or *)
    T10B [user] (map) (* to T10B *)adit_back
  )
EndProc (* end D10 *)

}
{Process FutureValid (map:Map) : Exit(map) := (* Valid Future *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Future,map)) (* set Valid for Future *)
EndProc (* end FutureValid *)

Process BygoneValid (map:Map) : Exit(map) := (* Valid Bygone *)
  Exit(set(get(c,map) /= get(b,map),map)) (* exit with last result set to "c != b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Bygone,map)) (* set Valid for Bygone *)
EndProc (* end BygoneValid *)

Process Future [user] (map:Map) : Exit(map) := (* Question Future *)
  FutureAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D10 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process FutureAux [user] (map:Map) : Exit(Map) := (* Auxiliary Future *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future; (* enter node *)
	(
	  [satisfied(Future,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      FutureAux [user] (unsatisfy(Future,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		FutureValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future,map)] -> (* valid answer? *)
		    Exit(satisfy(Future,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future,map))] -> (* invalid answer? *)
		    FutureAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of FutureAux *)

EndProc (* end Future *)

Process Bygone [user] (map:Map) : Exit(map) := (* Question Bygone *)
  BygoneAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D10 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process BygoneAux [user] (map:Map) : Exit(Map) := (* Auxiliary Bygone *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Bygone; (* enter node *)
	(
	  [satisfied(Bygone,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      BygoneAux [user] (unsatisfy(Bygone,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Bygone,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for history *)
		Exit(set(history,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		BygoneValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Bygone,map)] -> (* valid answer? *)
		    Exit(satisfy(Bygone,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Bygone,map))] -> (* invalid answer? *)
		    BygoneAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of BygoneAux *)

EndProc (* end Bygone *)

Process T10A [user] (map:Map) : Exit(map) := (* Terminal T10A *)
  user !T10A; (* enter T10A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D10 [user] (map) (* to parent *)
  )
EndProc (* end T10A *)

Process T10B [user] (map:Map) : Exit(map) := (* Terminal T10B *)
  user !T10B; (* enter T10B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D10 [user] (map) (* to parent *)
  )
EndProc (* end T10B *)

}

// ---------------------------------- 11---------------------------------------

{Process D11 [user] (map:Map) : Exit(map) := (* Decision D11 *)
  user !D11; (* enter node *)
  (
    Future11Visible (map) (* check Future11 visibility *)
  >> Accept map:Map In (* get new map *)
    T11BVisible (map) (* check T11B visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    [visible(Future11,map)] -> (* Future11 visible? *)
      (
	Future11 [user] (map) (* to Future11 *)
      )
  [] (* or *)
    Bygone11 [user] (map) (* to Bygone11 *)
  [] (* or *)
    T11A [user] (map) (* to T11A *)
  [] (* or *)
    [visible(T11B,map)] -> (* T11B visible? *)
      (
	T11B [user] (map) (* to T11B *)
      )adit_back
  )
EndProc (* end D11 *)

}
{Process Future11Valid (map:Map) : Exit(map) := (* Valid Future11 *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Future11,map)) (* set Valid for Future11 *)
EndProc (* end Future11Valid *)

Process Future11Visible (map:Map) : Exit(map) := (* Visible Future11 *)
  Exit(set(get(a,map) or get(b,map),map)) (* exit with last result set to "a or b" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Future11,map)) (* set Visible for Future11 *)
EndProc (* end Future11Visible *)

Process Bygone11Valid (map:Map) : Exit(map) := (* Valid Bygone11 *)
  Exit(set(get(c,map) /= get(b,map),map)) (* exit with last result set to "c != b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Bygone11,map)) (* set Valid for Bygone11 *)
EndProc (* end Bygone11Valid *)

Process T11BVisible (map:Map) : Exit(map) := (* Visible T11B *)
  Exit(set(not(get(x,map)),map)) (* exit with last result set to "not(x)" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(T11B,map)) (* set Visible for T11B *)
EndProc (* end T11BVisible *)

Process Future11 [user] (map:Map) : Exit(map) := (* Question Future11 *)
  Future11Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D11 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Future11Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Future11 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future11; (* enter node *)
	(
	  [satisfied(Future11,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Future11Aux [user] (unsatisfy(Future11,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future11,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		Future11Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future11,map)] -> (* valid answer? *)
		    Exit(satisfy(Future11,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future11,map))] -> (* invalid answer? *)
		    Future11Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Future11Aux *)

EndProc (* end Future11 *)

Process Bygone11 [user] (map:Map) : Exit(map) := (* Question Bygone11 *)
  Bygone11Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D11 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Bygone11Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Bygone11 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Bygone11; (* enter node *)
	(
	  [satisfied(Bygone11,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Bygone11Aux [user] (unsatisfy(Bygone11,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Bygone11,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for history *)
		Exit(set(history,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Bygone11Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Bygone11,map)] -> (* valid answer? *)
		    Exit(satisfy(Bygone11,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Bygone11,map))] -> (* invalid answer? *)
		    Bygone11Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Bygone11Aux *)

EndProc (* end Bygone11 *)

Process T11A [user] (map:Map) : Exit(map) := (* Terminal T11A *)
  user !T11A; (* enter T11A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D11 [user] (map) (* to parent *)
  )
EndProc (* end T11A *)

Process T11B [user] (map:Map) : Exit(map) := (* Terminal T11B *)
  user !T11B; (* enter T11B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D11 [user] (map) (* to parent *)
  )
EndProc (* end T11B *)

}

// ---------------------------------- 12---------------------------------------

{Process D12 [user] (map:Map) : Exit(map) := (* Decision D12 *)
  user !D12; (* enter node *)
  (
    Bygone12 [user] (map) (* to Bygone12 *)
  [] (* or *)
    T12A [user] (map) (* to T12A *)
  [] (* or *)
    T12B [user] (map) (* to T12B *)adit_back
  )
EndProc (* end D12 *)

}
{Process Future12Valid (map:Map) : Exit(map) := (* Valid Future12 *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Future12,map)) (* set Valid for Future12 *)
EndProc (* end Future12Valid *)

Process Future12Visible (map:Map) : Exit(map) := (* Visible Future12 *)
  Exit(set(0 Of Number,map)) (* exit with last result set to "false" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Future12,map)) (* set Visible for Future12 *)
EndProc (* end Future12Visible *)

Process Bygone12Valid (map:Map) : Exit(map) := (* Valid Bygone12 *)
  Exit(set(get(c,map) /= get(b,map),map)) (* exit with last result set to "c != b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Bygone12,map)) (* set Valid for Bygone12 *)
EndProc (* end Bygone12Valid *)

Process Future12 [user] (map:Map) : Exit(map) := (* Question Future12 *)
  Future12Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D12 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Future12Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Future12 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future12; (* enter node *)
	(
	  [satisfied(Future12,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Future12Aux [user] (unsatisfy(Future12,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future12,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		Future12Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future12,map)] -> (* valid answer? *)
		    Exit(satisfy(Future12,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future12,map))] -> (* invalid answer? *)
		    Future12Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Future12Aux *)

EndProc (* end Future12 *)

Process Bygone12 [user] (map:Map) : Exit(map) := (* Question Bygone12 *)
  Bygone12Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D12 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Bygone12Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Bygone12 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Bygone12; (* enter node *)
	(
	  [satisfied(Bygone12,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Bygone12Aux [user] (unsatisfy(Bygone12,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Bygone12,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for history *)
		Exit(set(history,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Bygone12Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Bygone12,map)] -> (* valid answer? *)
		    Exit(satisfy(Bygone12,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Bygone12,map))] -> (* invalid answer? *)
		    Bygone12Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Bygone12Aux *)

EndProc (* end Bygone12 *)

Process T12A [user] (map:Map) : Exit(map) := (* Terminal T12A *)
  user !T12A; (* enter T12A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D12 [user] (map) (* to parent *)
  )
EndProc (* end T12A *)

Process T12B [user] (map:Map) : Exit(map) := (* Terminal T12B *)
  user !T12B; (* enter T12B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D12 [user] (map) (* to parent *)
  )
EndProc (* end T12B *)

}

// ---------------------------------- 13 ---------------------------------------

{Process D13 [user] (map:Map) : Exit(map) := (* Decision D13 *)
  user !D13; (* enter node *)
  (
    Future13Visible (map) (* check Future13 visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    T13 [user] (map) (* to T13 *)
  [] (* or *)
    [visible(Future13,map)] -> (* Future13 visible? *)
      (
	Future13 [user] (map) (* to Future13 *)
      )adit_back
  )
EndProc (* end D13 *)

}
{Process Future13Valid (map:Map) : Exit(map) := (* Valid Future13 *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Future13,map)) (* set Valid for Future13 *)
EndProc (* end Future13Valid *)

Process Future13Visible (map:Map) : Exit(map) := (* Visible Future13 *)
  Exit(set(number(+,t(2),<>)number(+,t(5),<>),map)) (* exit with last result set to "2+5" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Future13,map)) (* set Visible for Future13 *)
EndProc (* end Future13Visible *)

Process T13 [user] (map:Map) : Exit(map) := (* Terminal T13 *)
  user !T13; (* enter T13 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    D13 [user] (map) (* to parent *)
  )
EndProc (* end T13 *)

Process Future13 [user] (map:Map) : Exit(map) := (* Question Future13 *)
  Future13Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D13 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Future13Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Future13 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future13; (* enter node *)
	(
	  [satisfied(Future13,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Future13Aux [user] (unsatisfy(Future13,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future13,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		Future13Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future13,map)] -> (* valid answer? *)
		    Exit(satisfy(Future13,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future13,map))] -> (* invalid answer? *)
		    Future13Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Future13Aux *)

EndProc (* end Future13 *)

}

// ---------------------------------- 14 ---------------------------------------

{Process D14 [user] (map:Map) : Exit(map) := (* Decision D14 *)
  user !D14; (* enter node *)
  (
    Future14Visible (map) (* check Future14 visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    [visible(Future14,map)] -> (* Future14 visible? *)
      (
	Future14 [user] (map) (* to Future14 *)
      )adit_back
  )
EndProc (* end D14 *)

}
{Process Future14Valid (map:Map) : Exit(map) := (* Valid Future14 *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Future14,map)) (* set Valid for Future14 *)
EndProc (* end Future14Valid *)

Process Future14Visible (map:Map) : Exit(map) := (* Visible Future14 *)
  Exit(set(number(+,t(2),<>)number(+,t(5),<>),map)) (* exit with last result set to "2+5" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Future14,map)) (* set Visible for Future14 *)
EndProc (* end Future14Visible *)

Process Future14 [user] (map:Map) : Exit(map) := (* Question Future14 *)
  Future14Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D14 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Future14Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Future14 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future14; (* enter node *)
	(
	  [satisfied(Future14,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Future14Aux [user] (unsatisfy(Future14,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future14,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		Future14Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future14,map)] -> (* valid answer? *)
		    Exit(satisfy(Future14,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future14,map))] -> (* invalid answer? *)
		    Future14Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Future14Aux *)

EndProc (* end Future14 *)

}

// ---------------------------------- 14 ---------------------------------------

{Process D14 [user] (map:Map) : Exit(map) := (* Decision D14 *)
  user !D14; (* enter node *)
  (
    Future66Visible (map) (* check Future66 visibility *)
  )
>> Accept map:Map In (* get new map *)
  (
    [visible(Future66,map)] -> (* Future66 visible? *)
      (
	Future66 [user] (map) (* to Future66 *)
      )adit_back
  )
EndProc (* end D14 *)

}
{Process Future66Valid (map:Map) : Exit(map) := (* Valid Future66 *)
  Exit(set(get(a,map) >= get(b,map),map)) (* exit with last result set to "a >= b" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Future66,map)) (* set Valid for Future66 *)
EndProc (* end Future66Valid *)

Process Future66Visible (map:Map) : Exit(map) := (* Visible Future66 *)
  Exit(set(number(+,t(2),<>)number(+,t(5),<>),map)) (* exit with last result set to "2+5" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Future66,map)) (* set Visible for Future66 *)
EndProc (* end Future66Visible *)

Process Future66 [user] (map:Map) : Exit(map) := (* Question Future66 *)
  Future66Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      D14 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Future66Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Future66 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Future66; (* enter node *)
	(
	  [satisfied(Future66,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Future66Aux [user] (unsatisfy(Future66,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Future66,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for mod2 *)
		  Exit(set(mod2,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for mod2 *)
		  Exit(set(mod2,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for mod2 *)
		  Exit(set(mod2,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for mod2 *)
		  Exit(set(mod2,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		Future66Valid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Future66,map)] -> (* valid answer? *)
		    Exit(satisfy(Future66,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Future66,map))] -> (* invalid answer? *)
		    Future66Aux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Future66Aux *)

EndProc (* end Future66 *)

}

// ********************* checks of adit_question ***********************

// ---------------------------------- 1 ---------------------------------------

{Process Old [user] (map:Map) : Exit(map) := (* Question Old *)
  OldAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      adit_parent_identifier [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process OldAux [user] (map:Map) : Exit(Map) := (* Auxiliary Old *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Old; (* enter node *)
	(
	  [satisfied(Old,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      OldAux [user] (unsatisfy(Old,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Old,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !1 Of Number; (* get 1 for elderly *)
		  Exit(set(elderly,1,map)) (* exit with answer *)
		[] (* or *)
		  user !2 Of Number; (* get 2 for elderly *)
		  Exit(set(elderly,2,map)) (* exit with answer *)
		[] (* or *)
		  user !3 Of Number; (* get 3 for elderly *)
		  Exit(set(elderly,3,map)) (* exit with answer *)
		[] (* or *)
		  user !4 Of Number; (* get 4 for elderly *)
		  Exit(set(elderly,4,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		OldValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Old,map)] -> (* valid answer? *)
		    Exit(satisfy(Old,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Old,map))] -> (* invalid answer? *)
		    OldAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of OldAux *)

EndProc (* end Old *)

}
{Process OldValid (map:Map) : Exit(map) := (* Valid Old *)
  Exit(set(get(x,map) > 0,map)) (* exit with last result set to "x > 0" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Old,map)) (* set Valid for Old *)
EndProc (* end OldValid *)

}

// ---------------------------------- 2 ---------------------------------------

{Process New [user] (map:Map) : Exit(map) := (* Question New *)
  NewAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      adit_parent_identifier [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      (
	Let map:Map = unskip(map) In (* stop skipping questions *)
	  (
	    T4 [user] (map) (* to T4 *)
	  )
      )
  )

Where (* local definitions *)

  Process NewAux [user] (map:Map) : Exit(Map) := (* Auxiliary New *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !New; (* enter node *)
	(
	  [satisfied(New,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      NewAux [user] (unsatisfy(New,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(New,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		(
		  user !0 Of Number; (* get 0 for modern *)
		  Exit(set(modern,0,map)) (* exit with answer *)
		[] (* or *)
		  user !1 Of Number; (* get 1 for modern *)
		  Exit(set(modern,1,map)) (* exit with answer *)
		)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(New,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of NewAux *)

EndProc (* end New *)

}
{Process T4 [user] (map:Map) : Exit(map) := (* Terminal T4 *)
  user !T4; (* enter T4 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    New [user] (map) (* to parent *)
  )
EndProc (* end T4 *)

}

// ---------------------------------- 3 ---------------------------------------

{Process Hello [user] (map:Map) : Exit(map) := (* Question Hello *)
  HelloAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      adit_parent_identifier [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      (
	Let map:Map = unskip(map) In (* stop skipping questions *)
	  (
	    T3A [user] (map) (* to T3A *)
	  >> Accept map:Map In (* get new map *)
	    T3B [user] (map) (* to T3B *)
	  )
      )
  )

Where (* local definitions *)

  Process HelloAux [user] (map:Map) : Exit(Map) := (* Auxiliary Hello *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Hello; (* enter node *)
	(
	  [satisfied(Hello,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      HelloAux [user] (unsatisfy(Hello,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Hello,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for greeting *)
		Exit(set(greeting,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		HelloValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Hello,map)] -> (* valid answer? *)
		    Exit(satisfy(Hello,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Hello,map))] -> (* invalid answer? *)
		    HelloAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of HelloAux *)

EndProc (* end Hello *)

}
{Process HelloValid (map:Map) : Exit(map) := (* Valid Hello *)
  Exit(set(get(x,map) > 0,map)) (* exit with last result set to "x > 0" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Hello,map)) (* set Valid for Hello *)
EndProc (* end HelloValid *)

Process T3A [user] (map:Map) : Exit(map) := (* Terminal T3A *)
  user !T3A; (* enter T3A *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    Hello [user] (map) (* to parent *)
  )
EndProc (* end T3A *)

Process T3B [user] (map:Map) : Exit(map) := (* Terminal T3B *)
  user !T3B; (* enter T3B *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    Hello [user] (map) (* to parent *)
  )
EndProc (* end T3B *)

}

// ---------------------------------- 4 ---------------------------------------

{Process Next [user] (map:Map) : Exit(map) := (* Question Next *)
  NextAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      adit_parent_identifier [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      (
	Let map:Map = unskip(map) In (* stop skipping questions *)
	  (
	    T4 [user] (map) (* to T4 *)
	  >> Accept map:Map In (* get new map *)
	    Q11 [user] (map) (* to Q11 *)
	  )
      )
  )

Where (* local definitions *)

  Process NextAux [user] (map:Map) : Exit(Map) := (* Auxiliary Next *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Next; (* enter node *)
	(
	  [satisfied(Next,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      NextAux [user] (unsatisfy(Next,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Next,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for greeting *)
		Exit(set(greeting,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		NextValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Next,map)] -> (* valid answer? *)
		    Exit(satisfy(Next,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Next,map))] -> (* invalid answer? *)
		    NextAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of NextAux *)

EndProc (* end Next *)

}
{Process NextValid (map:Map) : Exit(map) := (* Valid Next *)
  Exit(set(get(x,map) > 0,map)) (* exit with last result set to "x > 0" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Next,map)) (* set Valid for Next *)
EndProc (* end NextValid *)

Process T4 [user] (map:Map) : Exit(map) := (* Terminal T4 *)
  user !T4; (* enter T4 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    Next [user] (map) (* to parent *)
  )
EndProc (* end T4 *)

Process Q11 [user] (map:Map) : Exit(map) := (* Question Q11 *)
  Q11Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      Next [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit(map) (* continue after question *)
  )

Where (* local definitions *)

  Process Q11Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Q11 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Q11; (* enter node *)
	(
	  [satisfied(Q11,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Q11Aux [user] (unsatisfy(Q11,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Q11,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?weight:Number (* get weight for dozy *)
		  [(number(+,t(4)~0,<>) le weight) and
		   (weight le number(+,t(1)~4~5,<>))];
		Exit(set(dozy,weight,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Q11,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Q11Aux *)

EndProc (* end Q11 *)

}

// ---------------------------------- 5 ---------------------------------------

{Process Bye [user] (map:Map) : Exit(map) := (* Question Bye *)
  (
    Q5Visible (map) (* check Q5 visibility *)
  )
>> Accept map:Map In (* get new map *)
  ByeAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      adit_parent_identifier [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      (
	Let map:Map = unskip(map) In (* stop skipping questions *)
	  (
	    (
	      [visible(Q5,map)] -> (* Q5 visible? *)
		Q5 [user] (map) (* to Q5 *)
	    [] (* or *)
	      [not(visible(Q5,map))] -> (* Q5 invisible? *)
		Exit(map) (* exit with current map *)
	    )
	  >> Accept map:Map In (* get new map *)
	    T5 [user] (map) (* to T5 *)
	  )
      )
  )

Where (* local definitions *)

  Process ByeAux [user] (map:Map) : Exit(Map) := (* Auxiliary Bye *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Bye; (* enter node *)
	(
	  [satisfied(Bye,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      ByeAux [user] (unsatisfy(Bye,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Bye,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?height:Number (* get height for sayonara *)
		  [(number(+,t(1),t(5)) le height) and
		   (height le number(+,t(2),<>))];
		Exit(set(sayonara,height,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Bye,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of ByeAux *)

EndProc (* end Bye *)

}
{Process Q5Visible (map:Map) : Exit(map) := (* Visible Q5 *)
  Exit(set(get(x,map) > 0,map)) (* exit with last result set to "x > 0" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Q5,map)) (* set Visible for Q5 *)
EndProc (* end Q5Visible *)

Process Q5 [user] (map:Map) : Exit(map) := (* Question Q5 *)
  Q5Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      Bye [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Q5Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Q5 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Q5; (* enter node *)
	(
	  [satisfied(Q5,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Q5Aux [user] (unsatisfy(Q5,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Q5,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?weight:Number (* get weight for sleepy *)
		  [(number(+,t(4)~0,<>) le weight) and
		   (weight le number(+,t(1)~4~5,<>))];
		Exit(set(sleepy,weight,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Q5,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Q5Aux *)

EndProc (* end Q5 *)

Process T5 [user] (map:Map) : Exit(map) := (* Terminal T5 *)
  user !T5; (* enter T5 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    Bye [user] (map) (* to parent *)
  )
EndProc (* end T5 *)

}

// ---------------------------------- 6 ---------------------------------------

{Process Go [user] (map:Map) : Exit(map) := (* Question Go *)
  (
    Q6Visible (map) (* check Q6 visibility *)
  )
>> Accept map:Map In (* get new map *)
  GoAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      adit_parent_identifier [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      (
	Let map:Map = unskip(map) In (* stop skipping questions *)
	  (
	    (
	      [visible(Q6,map)] -> (* Q6 visible? *)
		Q6 [user] (map) (* to Q6 *)
	    [] (* or *)
	      [not(visible(Q6,map))] -> (* Q6 invisible? *)
		Exit(map) (* exit with current map *)
	    )
	  >> Accept map:Map In (* get new map *)
	    T6 [user] (map) (* to T6 *)
	  )
      )
  )

Where (* local definitions *)

  Process GoAux [user] (map:Map) : Exit(Map) := (* Auxiliary Go *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Go; (* enter node *)
	(
	  [satisfied(Go,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      GoAux [user] (unsatisfy(Go,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Go,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?systolic:Number; (* get systolic pressure for back *)
		user ?diastolic:Number; (* get diastolic pressure for forth *)
		Exit(set(back,systolic,set(forth,diastolic,map))) (* exit with answers *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Go,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of GoAux *)

EndProc (* end Go *)

}
{Process Q6Visible (map:Map) : Exit(map) := (* Visible Q6 *)
  Exit(set(get(  ,map)get(Exit,map)(get(set,map)(0,get(map,map))) (* get(exit,map) get(with,map) get(last,map) get(result,map) get(set,map) get(to,map) "0" *),map)) (* exit with last result set to "  Exit(set(0,map)) (* exit with last result set to "0" *)" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Q6,map)) (* set Visible for Q6 *)
EndProc (* end Q6Visible *)

Process Q6 [user] (map:Map) : Exit(map) := (* Question Q6 *)
  Q6Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      Go [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Q6Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Q6 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Q6; (* enter node *)
	(
	  [satisfied(Q6,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Q6Aux [user] (unsatisfy(Q6,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Q6,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?weight:Number (* get weight for dozy *)
		  [(number(+,t(4)~0,<>) le weight) and
		   (weight le number(+,t(1)~4~5,<>))];
		Exit(set(dozy,weight,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Q6,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Q6Aux *)

EndProc (* end Q6 *)

Process T6 [user] (map:Map) : Exit(map) := (* Terminal T6 *)
  user !T6; (* enter T6 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    Go [user] (map) (* to parent *)
  )
EndProc (* end T6 *)

}

// ---------------------------------- 7 ---------------------------------------

{Process Try7 [user] (map:Map) : Exit(map) := (* Question Try7 *)
  (
    Q7AVisible (map) (* check Q7A visibility *)
  >> Accept map:Map In (* get new map *)
    Q7BVisible (map) (* check Q7B visibility *)
  )
>> Accept map:Map In (* get new map *)
  Try7Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      adit_parent_identifier [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      (
	Let map:Map = unskip(map) In (* stop skipping questions *)
	  (
	    (
	      [visible(Q7A,map)] -> (* Q7A visible? *)
		Q7A [user] (map) (* to Q7A *)
	    [] (* or *)
	      [not(visible(Q7A,map))] -> (* Q7A invisible? *)
		Exit(map) (* exit with current map *)
	    )
	  >> Accept map:Map In (* get new map *)
	    (
	      [visible(Q7B,map)] -> (* Q7B visible? *)
		Q7B [user] (map) (* to Q7B *)
	    [] (* or *)
	      [not(visible(Q7B,map))] -> (* Q7B invisible? *)
		Exit(map) (* exit with current map *)
	    )
	  >> Accept map:Map In (* get new map *)
	    T7 [user] (map) (* to T7 *)
	  )
      )
  )

Where (* local definitions *)

  Process Try7Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Try7 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Try7; (* enter node *)
	(
	  [satisfied(Try7,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Try7Aux [user] (unsatisfy(Try7,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Try7,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?height:Number (* get height for attempt *)
		  [(number(+,t(1),t(5)) le height) and
		   (height le number(+,t(2),<>))];
		Exit(set(attempt,height,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Try7,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Try7Aux *)

EndProc (* end Try7 *)

}
{Process Q7AVisible (map:Map) : Exit(map) := (* Visible Q7A *)
  Exit(set(get(  ,map)get(Exit,map)(get(set,map)(0,get(map,map))) (* get(exit,map) get(with,map) get(last,map) get(result,map) get(set,map) get(to,map) "0" *),map)) (* exit with last result set to "  Exit(set(0,map)) (* exit with last result set to "0" *)" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Q7A,map)) (* set Visible for Q7A *)
EndProc (* end Q7AVisible *)

Process Q7BVisible (map:Map) : Exit(map) := (* Visible Q7B *)
  Exit(set(get(x,map) + number(+,t(2),<>) /= number(+,t(4),<>),map)) (* exit with last result set to "x + 2 != 4" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Q7B,map)) (* set Visible for Q7B *)
EndProc (* end Q7BVisible *)

Process Q7A [user] (map:Map) : Exit(map) := (* Question Q7A *)
  Q7AAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      Try7 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Q7AAux [user] (map:Map) : Exit(Map) := (* Auxiliary Q7A *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Q7A; (* enter node *)
	(
	  [satisfied(Q7A,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Q7AAux [user] (unsatisfy(Q7A,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Q7A,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?weight:Number (* get weight for snooze *)
		  [(number(+,t(4)~0,<>) le weight) and
		   (weight le number(+,t(1)~4~5,<>))];
		Exit(set(snooze,weight,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Q7A,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Q7AAux *)

EndProc (* end Q7A *)

Process Q7B [user] (map:Map) : Exit(map) := (* Question Q7B *)
  Q7BAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      Try7 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Q7BAux [user] (map:Map) : Exit(Map) := (* Auxiliary Q7B *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Q7B; (* enter node *)
	(
	  [satisfied(Q7B,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Q7BAux [user] (unsatisfy(Q7B,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Q7B,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?systolic:Number; (* get systolic pressure for somno *)
		user ?diastolic:Number; (* get diastolic pressure for lence *)
		Exit(set(somno,systolic,set(lence,diastolic,map))) (* exit with answers *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Q7B,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Q7BAux *)

EndProc (* end Q7B *)

Process T7 [user] (map:Map) : Exit(map) := (* Terminal T7 *)
  user !T7; (* enter T7 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    Try7 [user] (map) (* to parent *)
  )
EndProc (* end T7 *)

}

// ---------------------------------- 8 ---------------------------------------

{Process Good [user] (map:Map) : Exit(map) := (* Question Good *)
  (
    Q8AVisible (map) (* check Q8A visibility *)
  >> Accept map:Map In (* get new map *)
    Q8BVisible (map) (* check Q8B visibility *)
  )
>> Accept map:Map In (* get new map *)
  GoodAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      adit_parent_identifier [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      (
	Let map:Map = unskip(map) In (* stop skipping questions *)
	  (
	    (
	      [visible(Q8A,map)] -> (* Q8A visible? *)
		Q8A [user] (map) (* to Q8A *)
	    [] (* or *)
	      [not(visible(Q8A,map))] -> (* Q8A invisible? *)
		Exit(map) (* exit with current map *)
	    )
	  >> Accept map:Map In (* get new map *)
	    (
	      [visible(Q8B,map)] -> (* Q8B visible? *)
		Q8B [user] (map) (* to Q8B *)
	    [] (* or *)
	      [not(visible(Q8B,map))] -> (* Q8B invisible? *)
		Exit(map) (* exit with current map *)
	    )
	  >> Accept map:Map In (* get new map *)
	    T8 [user] (map) (* to T8 *)
	  )
      )
  )

Where (* local definitions *)

  Process GoodAux [user] (map:Map) : Exit(Map) := (* Auxiliary Good *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Good; (* enter node *)
	(
	  [satisfied(Good,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      GoodAux [user] (unsatisfy(Good,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Good,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?height:Number (* get height for fine *)
		  [(number(+,t(1),t(5)) le height) and
		   (height le number(+,t(2),<>))];
		Exit(set(fine,height,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		GoodValid (map)
	      >> Accept map:Map In (* get new map *)
		(
		  [valid(Good,map)] -> (* valid answer? *)
		    Exit(satisfy(Good,map)) (* exit with question satisfied *)
		[] (* or *)
		  [not(valid(Good,map))] -> (* invalid answer? *)
		    GoodAux [user] (map) (* repeat question *)
		)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of GoodAux *)

EndProc (* end Good *)

}
{Process Q8AVisible (map:Map) : Exit(map) := (* Visible Q8A *)
  Exit(set(number(+,t(4),<>) < get(w,map),map)) (* exit with last result set to "4 < w" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Q8A,map)) (* set Visible for Q8A *)
EndProc (* end Q8AVisible *)

Process Q8BVisible (map:Map) : Exit(map) := (* Visible Q8B *)
  Exit(set(get(x,map) + number(+,t(2),<>) /= number(+,t(4),<>),map)) (* exit with last result set to "x + 2 != 4" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Q8B,map)) (* set Visible for Q8B *)
EndProc (* end Q8BVisible *)

Process Q8A [user] (map:Map) : Exit(map) := (* Question Q8A *)
  Q8AAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      Good [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Q8AAux [user] (map:Map) : Exit(Map) := (* Auxiliary Q8A *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Q8A; (* enter node *)
	(
	  [satisfied(Q8A,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Q8AAux [user] (unsatisfy(Q8A,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Q8A,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?weight:Number (* get weight for dream *)
		  [(number(+,t(4)~0,<>) le weight) and
		   (weight le number(+,t(1)~4~5,<>))];
		Exit(set(dream,weight,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Q8A,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Q8AAux *)

EndProc (* end Q8A *)

Process Q8B [user] (map:Map) : Exit(map) := (* Question Q8B *)
  Q8BAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      Good [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Q8BAux [user] (map:Map) : Exit(Map) := (* Auxiliary Q8B *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Q8B; (* enter node *)
	(
	  [satisfied(Q8B,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Q8BAux [user] (unsatisfy(Q8B,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Q8B,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?number:Number; (* get number for somnolence *)
		Exit(set(somnolence,number,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Q8B,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Q8BAux *)

EndProc (* end Q8B *)

Process T8 [user] (map:Map) : Exit(map) := (* Terminal T8 *)
  user !T8; (* enter T8 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    Good [user] (map) (* to parent *)
  )
EndProc (* end T8 *)

}

// ---------------------------------- 9 ---------------------------------------

{Process Thing [user] (map:Map) : Exit(map) := (* Question Thing *)
  ThingAux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      adit_parent_identifier [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      (
	Let map:Map = unskip(map) In (* stop skipping questions *)
	  (
	    Q9 [user] (map) (* to Q9 *)
	  >> Accept map:Map In (* get new map *)
	    T9 [user] (map) (* to T9 *)
	  )
      )
  )

Where (* local definitions *)

  Process ThingAux [user] (map:Map) : Exit(Map) := (* Auxiliary Thing *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Thing; (* enter node *)
	(
	  [satisfied(Thing,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      ThingAux [user] (unsatisfy(Thing,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Thing,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?height:Number (* get height for sayonara *)
		  [(number(+,t(1),t(5)) le height) and
		   (height le number(+,t(2),<>))];
		Exit(set(sayonara,height,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Thing,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of ThingAux *)

EndProc (* end Thing *)

}
{Process Q9 [user] (map:Map) : Exit(map) := (* Question Q9 *)
  Q9Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      Thing [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Q9Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Q9 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Q9; (* enter node *)
	(
	  [satisfied(Q9,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Q9Aux [user] (unsatisfy(Q9,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Q9,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?weight:Number (* get weight for sleepy *)
		  [(number(+,t(4)~0,<>) le weight) and
		   (weight le number(+,t(1)~4~5,<>))];
		Exit(set(sleepy,weight,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Q9,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Q9Aux *)

EndProc (* end Q9 *)

Process T9 [user] (map:Map) : Exit(map) := (* Terminal T9 *)
  user !T9; (* enter T9 *)
  (
    Exit({}) (* exit leaf node *)
  [] (* or *)
    user !Back; (* go back *)
    Thing [user] (map) (* to parent *)
  )
EndProc (* end T9 *)

}

// ---------------------------------- 10 ---------------------------------------

{Process Try10 [user] (map:Map) : Exit(map) := (* Question Try10 *)
  (
    Q10Visible (map) (* check Q10 visibility *)
  )
>> Accept map:Map In (* get new map *)
  Try10Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      adit_parent_identifier [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      (
	Let map:Map = unskip(map) In (* stop skipping questions *)
	  (
	    (
	      [visible(Q10,map)] -> (* Q10 visible? *)
		Q10 [user] (map) (* to Q10 *)
	    [] (* or *)
	      [not(visible(Q10,map))] -> (* Q10 invisible? *)
		Exit(map) (* exit with current map *)
	    )

	  )
      )
  )

Where (* local definitions *)

  Process Try10Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Try10 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Try10; (* enter node *)
	(
	  [satisfied(Try10,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Try10Aux [user] (unsatisfy(Try10,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Try10,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?height:Number (* get height for attempt *)
		  [(number(+,t(1),t(5)) le height) and
		   (height le number(+,t(2),<>))];
		Exit(set(attempt,height,map)) (* exit with answer *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Try10,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Try10Aux *)

EndProc (* end Try10 *)

}
{Process Q10Visible (map:Map) : Exit(map) := (* Visible Q10 *)
  Exit(set(get(b,map) < get(c,map),map)) (* exit with last result set to "b < c" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Q10,map)) (* set Visible for Q10 *)
EndProc (* end Q10Visible *)

Process Q10 [user] (map:Map) : Exit(map) := (* Question Q10 *)
  Q10Aux [user] (map) (* ask question *)
>> Accept map:Map In (* get new map *)
  (
    [backing(map)] -> (* going back? *)
      Try10 [user] (unback(map)) (* to parent, not going back *)
  [] (* or *)
    [not(backing(map))] -> (* not going back? *)
      Exit({}) (* exit leaf node *)
  )

Where (* local definitions *)

  Process Q10Aux [user] (map:Map) : Exit(Map) := (* Auxiliary Q10 *)
    [skipping(map)] -> (* skipping all questions? *)
      Exit(map) (* exit question *)
  []
    [not(skipping(map))] -> (* not skipping all questions? *)
      (
	user !Q10; (* enter node *)
	(
	  [satisfied(Q10,map)] -> (* question satisfied? *)
	    user !Preserve; (* ask to preserve current answer *)
	    (
	      user !Keep; (* keep current answer *)
	      Exit(map) (* exit question *)
	    []
	      user !Change; (* change current answer *)
	      Q10Aux [user] (unsatisfy(Q10,map)) (* ask question again *)
	    )
	[]
	  [not(satisfied(Q10,map))] -> (* question unsatisfied? *)
	    user !Query; (* prompt for answer *)
	    (
	      user !Skip; (* skip question *)
	      Exit(map) (* exit question with no answer *)
	    []
	      user !SkipAll; (* skip all questions *)
	      Exit(skip(map)) (* exit question, skipping all others *)
	    []
	      (
		user ?systolic:Number; (* get systolic pressure for somno *)
		user ?diastolic:Number; (* get diastolic pressure for lence *)
		Exit(set(somno,systolic,set(lence,diastolic,map))) (* exit with answers *)
	      >> Accept map:Map In (* get new map *)
		Exit(satisfy(Q10,map)) (* exit with question satisfied *)
	      )
	    )
	)
      [] (* or *)
	user !Back; (* go back *)
	Exit(back(map)) (* exit question, going back *)
      )
  EndProc (* end of Q10Aux *)

EndProc (* end Q10 *)

}

// ********************** checks of "adit_terminal" ***********************

// ---------------------------------- 1 ---------------------------------------

{Process Bored1 [user] (map:Map) : Exit(map) := (* Terminal Bored1 *)
  user !Bored1; (* enter Bored1 *)
  (
    Exit({}) (* exit leaf node *)adit_back
  )
EndProc (* end Bored1 *)

}
{Process Bored1Valid (map:Map) : Exit(map) := (* Valid Bored1 *)
  Exit(set(get(p,map) + get(q,map),map)) (* exit with last result set to "p + q" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Bored1,map)) (* set Valid for Bored1 *)
EndProc (* end Bored1Valid *)

Process Bored1Visible (map:Map) : Exit(map) := (* Visible Bored1 *)
  Exit(set(get(r,map) > get(s,map),map)) (* exit with last result set to "r > s" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Bored1,map)) (* set Visible for Bored1 *)
EndProc (* end Bored1Visible *)

}

// ---------------------------------- 2 ---------------------------------------

{Process Porlock2 [user] (map:Map) : Exit(map) := (* Terminal Porlock2 *)
  user !Porlock2; (* enter Porlock2 *)
  (
    Exit({}) (* exit leaf node *)adit_back
  )
EndProc (* end Porlock2 *)

}
{}

// ---------------------------------- 3 ---------------------------------------

{Process Porlock3 [user] (map:Map) : Exit(map) := (* Terminal Porlock3 *)
  user !Porlock3; (* enter Porlock3 *)
  (
    Exit({}) (* exit leaf node *)adit_back
  )
EndProc (* end Porlock3 *)

}
{Process Porlock3Valid (map:Map) : Exit(map) := (* Valid Porlock3 *)
  (
    [(get(x,map) < 0) eq 1] ->
      Exit(set(get(y,map),map)) (* exit with last result set to "y" *)
  []
    [(get(x,map) < 0) eq 0] ->
      Exit(set(get(z,map),map)) (* exit with last result set to "z" *)
  )
>> Accept map:Map In (* get new map *)
  Exit(setValid(Porlock3,map)) (* set Valid for Porlock3 *)
EndProc (* end Porlock3Valid *)

Process Porlock3Visible (map:Map) : Exit(map) := (* Visible Porlock3 *)
  Exit(set((get(a,map) * get(b,map)) < get(c,map) },map)) (* exit with last result set to "(a * b) < c }" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Porlock3,map)) (* set Visible for Porlock3 *)
EndProc (* end Porlock3Visible *)

}

// ---------------------------------- 4 ---------------------------------------

{Process Porlock4 [user] (map:Map) : Exit(map) := (* Terminal Porlock4 *)
  user !Porlock4; (* enter Porlock4 *)
  (
    Exit({}) (* exit leaf node *)adit_back
  )
EndProc (* end Porlock4 *)

}
{Process Porlock4Valid (map:Map) : Exit(map) := (* Valid Porlock4 *)
  (
    [(get(x,map) < 0) eq 1] ->
      Exit(set(get(y,map),map)) (* exit with last result set to "y" *)
  []
    [(get(x,map) < 0) eq 0] ->
      Exit(set(get(z,map),map)) (* exit with last result set to "z" *)
  )
>> Accept map:Map In (* get new map *)
  Exit(setValid(Porlock4,map)) (* set Valid for Porlock4 *)
EndProc (* end Porlock4Valid *)

Process Porlock4Visible (map:Map) : Exit(map) := (* Visible Porlock4 *)
  Exit(set((get(a,map) * get(b,map)) < get(c,map) },map)) (* exit with last result set to "(a * b) < c }" *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Porlock4,map)) (* set Visible for Porlock4 *)
EndProc (* end Porlock4Visible *)

}

// ---------------------------------- 5 ---------------------------------------

{}
{}

// ---------------------------------- 6 ---------------------------------------

{Process Testing [user] (map:Map) : Exit(map) := (* Terminal Testing *)
  user !Testing; (* enter Testing *)
  (
    Exit({}) (* exit leaf node *)adit_back
  )
EndProc (* end Testing *)

}
{}

// ********************** checks of "adit_value" ***********************

// ---------------------------------- 1 ---------------------------------------

// ---------------------------------- 2 ---------------------------------------

{Process Test2Valid (map:Map) : Exit(map) := (* Valid Test2 *)
  Exit(set(x,number(+,t(3),<>),map)) (* exit with x set to 3 *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Test2,map)) (* set Valid for Test2 *)
EndProc (* end Test2Valid *)

}

// ---------------------------------- 3 ---------------------------------------

{Process Test3Valid (map:Map) : Exit(map) := (* Valid Test3 *)
  Exit(set(get(y,map) * number(+,t(4),<>),map)) (* exit with last result set to "y * 4" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Test3,map)) (* set Valid for Test3 *)
EndProc (* end Test3Valid *)

}

// ---------------------------------- 4 ---------------------------------------

{Process Test4Valid (map:Map) : Exit(map) := (* Valid Test4 *)
  (
    [(get(z,map) <= number(+,t(5),<>)) eq 1] ->
      Exit(set(x,number(+,t(3),<>),map)) (* exit with x set to 3 *)
  []
    [(get(z,map) <= number(+,t(5),<>)) eq 0] ->
      Exit(set(x,0,map)) (* exit with x set to 0 *)
  )
>> Accept map:Map In (* get new map *)
  Exit(set(b,map)) (* exit with b set to last result *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Test4,map)) (* set Valid for Test4 *)
EndProc (* end Test4Valid *)

}

// ---------------------------------- 5 ---------------------------------------

{Process Test5Valid (map:Map) : Exit(map) := (* Valid Test5 *)
  (
    [(get(a,map) /= 0) eq 1] ->
      Exit(set(a,number(+,t(2),<>),map)) (* exit with a set to 2 *)
  []
    [(get(a,map) /= 0) eq 0] ->
      Exit(set(b,number(+,t(6),<>),map)) (* exit with b set to 6 *)
  )
>> Accept map:Map In (* get new map *)
  Exit(setValid(Test5,map)) (* set Valid for Test5 *)
EndProc (* end Test5Valid *)

}

// ---------------------------------- 6 ---------------------------------------

{Process Test6Valid (map:Map) : Exit(map) := (* Valid Test6 *)
  (
    [(get(age,map) > number(+,t(3),<>)) eq 1] ->
      Exit(set(y,1 Of Number or get(z,map),map)) (* exit with y set to true or z *)
  []
    [(get(age,map) > number(+,t(3),<>)) eq 0] ->
      Exit(set(x,0 Of Number and get(w,map),map)) (* exit with x set to false and w *)
  )
>> Accept map:Map In (* get new map *)
  Exit(setValid(Test6,map)) (* set Valid for Test6 *)
EndProc (* end Test6Valid *)

}

// ---------------------------------- 7 ---------------------------------------

{}

// ---------------------------------- 8 ---------------------------------------

{Process Test8Valid (map:Map) : Exit(map) := (* Valid Test8 *)
  (
    [(get(history,map)) eq 1] ->
      (
	[(get(ageCategory,map) == 1) eq 1] ->
	  Exit(set(undefined,map)) (* exit with last result set to "undefined" *)
      []
	[(get(ageCategory,map) == 1) eq 0] ->
	  Exit(set(x,get(y,map),map)) (* exit with x set to y *)
      )
  []
    [(get(history,map)) eq 0] ->
      Exit(set(undefined,map)) (* exit with last result set to "undefined" *)
  )
>> Accept map:Map In (* get new map *)
  Exit(setValid(Test8,map)) (* set Valid for Test8 *)
EndProc (* end Test8Valid *)

}

// ---------------------------------- 9 ---------------------------------------

{}

// ---------------------------------- 10 ---------------------------------------

{Process Test10Valid (map:Map) : Exit(map) := (* Valid Test10 *)
  (
    [(get(history,map)) eq 1] ->
      (
	[(get(ageCategory,map) == 1) eq 1] ->
	  Exit(set(undefined,map)) (* exit with last result set to "undefined" *)
      []
	[(get(ageCategory,map) == 1) eq 0] ->
	  (
	    [(get(x,map) == number(+,t(4),<>)) eq 1] ->
	      Exit(set(x,number(+,t(5),<>),map)) (* exit with x set to 5 *)
	  []
	    [(get(x,map) == number(+,t(4),<>)) eq 0] ->
	      Exit(set(undefined,map)) (* exit with last result set to "undefined" *)
	  )
      )
  []
    [(get(history,map)) eq 0] ->
      Exit(set(undefined,map)) (* exit with last result set to "undefined" *)
  )
>> Accept map:Map In (* get new map *)
  Exit(setValid(Test10,map)) (* set Valid for Test10 *)
EndProc (* end Test10Valid *)

}

// ---------------------------------- 11 ---------------------------------------

{}

// ---------------------------------- 12 ---------------------------------------

{Process Test12Valid (map:Map) : Exit(map) := (* Valid Test12 *)
  Exit(set(x,get(y,map)*number(+,t(3)~5,<>),map)) (* exit with x set to y*35 *)
>> Accept map:Map In (* get new map *)
  Exit(set((get(y,map) / number(+,t(2),<>)) + 1,map)) (* exit with last result set to "(y / 2) + 1" *)
>> Accept map:Map In (* get new map *)
  Exit(set(get(x,map) > number(+,t(5),<>),map)) (* exit with last result set to "x > 5" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Test12,map)) (* set Valid for Test12 *)
EndProc (* end Test12Valid *)

}

// ---------------------------------- 13 ---------------------------------------

{Process Test13Valid (map:Map) : Exit(map) := (* Valid Test13 *)
  Exit(set(x,number(+,t(3),<>) + get(probY,map),map)) (* exit with x set to 3 + probY *)
>> Accept map:Map In (* get new map *)
  Exit(set(y,get(payZ,map) / number(+,t(2),<>),map)) (* exit with y set to payZ / 2 *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Test13,map)) (* set Valid for Test13 *)
EndProc (* end Test13Valid *)

}

// ---------------------------------- 14 ---------------------------------------

{Process Test_ValidValid (map:Map) : Exit(map) := (* Valid Test_Valid *)
  Exit(set(x,number(+,t(3),<>) + get(w,map),map)) (* exit with x set to 3 + w *)
>> Accept map:Map In (* get new map *)
  Exit(set(y,get(Z,map) / number(+,t(2),<>),map)) (* exit with y set to Z / 2 *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Test_Valid,map)) (* set Valid for Test_Valid *)
EndProc (* end Test_ValidValid *)

}

// ---------------------------------- 15 ---------------------------------------

{}

// ---------------------------------- 16 ---------------------------------------

{Process Test_ValidVisible (map:Map) : Exit(map) := (* Visible Test_Valid *)
  Exit(set(x,number(+,t(3),<>) + get(w,map),map)) (* exit with x set to 3 + w *)
>> Accept map:Map In (* get new map *)
  Exit(set(y,get(Z,map) / number(+,t(2),<>),map)) (* exit with y set to Z / 2 *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Test_Valid,map)) (* set Visible for Test_Valid *)
EndProc (* end Test_ValidVisible *)

}

// ---------------------------------- 21 ---------------------------------------

// ---------------------------------- 22 ---------------------------------------

// ---------------------------------- 23 ---------------------------------------

// ---------------------------------- 24 ---------------------------------------

// ---------------------------------- 25 ---------------------------------------

// ---------------------------------- 26 ---------------------------------------

// ---------------------------------- 27 ---------------------------------------

// ---------------------------------- 28 ---------------------------------------

// ---------------------------------- 29 ---------------------------------------

// ---------------------------------- 30 ---------------------------------------

// ---------------------------------- 31 ---------------------------------------

// ---------------------------------- 32 ---------------------------------------

// ---------------------------------- 33 ---------------------------------------

// ---------------------------------- 34 ---------------------------------------

// ---------------------------------- 35 ---------------------------------------

{Process Test_ValidVisible (map:Map) : Exit(map) := (* Visible Test_Valid *)
  Exit(set(x,number(+,t(3),<>) + get(w,map),map)) (* exit with x set to 3 + w *)
>> Accept map:Map In (* get new map *)
  Exit(set(y,get(Z,map) / number(+,t(2),<>),map)) (* exit with y set to Z / 2 *)
>> Accept map:Map In (* get new map *)
  Exit(setVisible(Test_Valid,map)) (* set Visible for Test_Valid *)
EndProc (* end Test_ValidVisible *)

Process T1Valid (map:Map) : Exit(map) := (* Valid T1 *)
  Exit(set(get(fluprob,map) + get(flupayoff,map),map)) (* exit with last result set to "fluprob + flupayoff" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(T1,map)) (* set Valid for T1 *)
EndProc (* end T1Valid *)

Process TreatmentValid (map:Map) : Exit(map) := (* Valid Treatment *)
  Exit(set(totalStrokeLifestyleReduction,get(weightLossStrokeRiskReduction,map) + get(exerciseStrokeRiskReduction,map) +
    get(saltStrokeRiskReduction,map),map)) (* exit with totalStrokeLifestyleReduction set to weightLossStrokeRiskReduction + exerciseStrokeRiskReduction +
    saltStrokeRiskReduction *)
>> Accept map:Map In (* get new map *)
  Exit(set(totalCHDLifestyleReduction,get(weightLossCHDRiskReduction,map) + get(exerciseCHDRiskReduction,map) +
    get(saltCHDRiskReduction,map),map)) (* exit with totalCHDLifestyleReduction set to weightLossCHDRiskReduction + exerciseCHDRiskReduction +
    saltCHDRiskReduction *)
>> Accept map:Map In (* get new map *)
  Exit(set(revisedCHDRisk,get(chdDbpRisk,map) - get(totalCHDLifestyleReduction,map),map)) (* exit with revisedCHDRisk set to chdDbpRisk - totalCHDLifestyleReduction *)
>> Accept map:Map In (* get new map *)
  Exit(set(revisedStrokeRisk,get(strokeDbpRisk,map) - get(totalStrokeLifestyleReduction,map),map)) (* exit with revisedStrokeRisk set to strokeDbpRisk - totalStrokeLifestyleReduction *)
>> Accept map:Map In (* get new map *)
  Exit(set(drugCHD,get(revisedCHDRisk,map) - (get(revisedCHDRisk,map) * get(drugCHDRiskReduction,map)),map)) (* exit with drugCHD set to revisedCHDRisk - (revisedCHDRisk * drugCHDRiskReduction) *)
>> Accept map:Map In (* get new map *)
  Exit(set(drugStroke,get(revisedStrokeRisk,map) - (get(revisedStrokeRisk,map) * get(drugStrokeRiskReduction,map)),map)) (* exit with drugStroke set to revisedStrokeRisk - (revisedStrokeRisk * drugStrokeRiskReduction) *)
>> Accept map:Map In (* get new map *)
  Exit(set(drugNoEvents,1 - (get(drugCHD,map) + get(drugStroke,map)),map)) (* exit with drugNoEvents set to 1 - (drugCHD + drugStroke) *)
>> Accept map:Map In (* get new map *)
  Exit(set(1 Of Number,map)) (* exit with last result set to "true" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(Treatment,map)) (* set Valid for Treatment *)
EndProc (* end TreatmentValid *)

Process WW2Valid (map:Map) : Exit(map) := (* Valid WW2 *)
  Exit(set(get(symptomScore,map) < number(+,t(8),<>),map)) (* exit with last result set to "symptomScore < 8" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(WW2,map)) (* set Valid for WW2 *)
EndProc (* end WW2Valid *)

Process AgeQValid (map:Map) : Exit(map) := (* Valid AgeQ *)
  Exit(set(ageAnswered,1,map)) (* exit with ageAnswered set to 1 *)
>> Accept map:Map In (* get new map *)
  Exit(set(1 Of Number,map)) (* exit with last result set to "true" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(AgeQ,map)) (* set Valid for AgeQ *)
EndProc (* end AgeQValid *)

Process SmokingQValid (map:Map) : Exit(map) := (* Valid SmokingQ *)
  Exit(set(smokingAnswered,1,map)) (* exit with smokingAnswered set to 1 *)
>> Accept map:Map In (* get new map *)
  Exit(set(1 Of Number,map)) (* exit with last result set to "true" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(SmokingQ,map)) (* set Valid for SmokingQ *)
EndProc (* end SmokingQValid *)

Process BPQValid (map:Map) : Exit(map) := (* Valid BPQ *)
  Exit(set(bpAnswered,1,map)) (* exit with bpAnswered set to 1 *)
>> Accept map:Map In (* get new map *)
  Exit(set(((get(sbp,map) > number(+,t(9)~9,<>)) and (get(sbp,map) < number(+,t(2)~2~1,<>))) or ((get(dbp,map) > number(+,t(4)~9,<>)) and (get(dbp,map) < number(+,t(1)~2~1,<>))),map)) (* exit with last result set to "((sbp > 99) and (sbp < 221)) or ((dbp > 49) and (dbp < 121))" *)
>> Accept map:Map In (* get new map *)
  Exit(setValid(BPQ,map)) (* set Valid for BPQ *)
EndProc (* end BPQValid *)

}

// ********************** checks of "cgt_set_attributes" ***********************

// ****************** checks of "cgt_translate_assignment" *********************

// ******************* checks of "cgt_translate_format" *********************

// ********************* checks of "cgt_translate_names" ***********************

// ******************** checks of "cgt_translate_number" ***********************

// ******************* checks of "cgt_translate_statement" *********************

// ******************** checks of "cgt_translate_string" ***********************

// ******************* checks of "cgt_translate_value" *********************

// ******************* checks of "cgt_translate_variables" *********************

// ********************** checks of "cgt_translate" ***********************

// ******************* checks of "cgt_visibility" *********************

