################################### Header ###################################

# "anise.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	14/08/98

# This "m4" macro file contains templates for generating Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.
#
# Respect the following naming conventions:
#
#   o User-declared macros must not clash with ANISE ones. Avoiding purely
#     lower-case names will guarantee this. Temporary ANISE macros are
#     prefixed with "an_".
#
#   o No service primitive name may be a prefix of another (e.g. "ServPrim",
#     "ServPrim1").
#
#   o Service primitive names must not clash with user-declared or ANISE
#     macros (e.g. service primitive and user macro both called "OffHookReq").
# 
# Set "an_trace" to 1 (see definition below) to trace actions

# Copyright 1998 K. J. Turner, University of Stirling

############################## Included Macros ##############################

include(anise_comb_gen.m4)
include(anise_comb_tel.m4)
include(anise_feat.m4)
include(anise_prim_int.m4)
include(anise_prim_par.m4)
include(anise_prof.m4)
include(anise_prim_queue.m4)
include(anise_prim_type.m4)

############################### General Macros ###############################

# "add_num_par(num)" adds number "num" to those currently in use for a
# process, as stored in global "an_num_pars"

define(add_num_par,
  `define(`an_ind_np',index(an_num_pars,$1))ifelse(an_ind_np,-1,
    `define(`an_num_pars',an_num_pars| $1)')')

# "add_num_pars(beh)" adds numbers in "beh" to global "an_num_pars" that are
# additional to the default values of "n1, n2"

define(add_num_pars,
  `define(`an_ind_np1',
    index(`$1',`n3,'))define(`an_ind_np2',
      index(`$1',`n3)'))define(`an_ind_np3',
	`index(an_num_pars,`n3')')ifelse(eval(((an_ind_np1>0)||
	  (an_ind_np2>0))&&(an_ind_np3<0)),1,
	    `define(`an_num_pars',an_num_pars| n3)')')

# "add_proc_attrs(proc,func)" adds process attributes to global
# "an_proc_attrs"

define(add_proc_attrs,
  `define(`an_proc_attrs',[$1|$2]`'an_proc_attrs)')

# "an_exit_func" returns the functionality of an exiting process according
# to the numbers in "an_num_pars"

define(an_exit_func,
  `ifelse(index(an_num_pars,n3),-1,
    `exit (Num, Num, Result)',
      `exit (Num, Num, Num, Result)')')

# "an_ctl_gate" returns the ANISE control gate

define(an_ctl_gate,
  `ctl')

# "an_header" accumulates comments to be printed in the file header

define(an_header,
  `')

# "an_lab1"/"an_lab2" produce the labels to distinguish the parameters of
# two constructor operations. The labels must be alphabetic.

define(an_lab1,
  `A')

define(an_lab2,
  `B')

# "an_num_pars" gives the numbers in use by a process: "n1, n2" by default

define(an_num_pars,
  `n1| n2')

# "an_proc_attrs" contains the current list of process attributes as a list
# containing "<process noexit/exit >"

define(an_proc_attrs,
  `')

# "an_<proc>" gives the next number to be used for a process according to
# its name

# "an_trace" defines if declarations should be traced (1) or not (0)

define(an_trace,
  `0')

# "any_res" returns any results according to the numbers in "an_num_pars"

define(any_res,
  `ifelse(index(an_num_pars,n3),-1,
    `exit (any Num, any Num, any Result)',
      `exit (any Num, any Num, any Num, any Result)')')

# "cap_of(string)" produces the same string with its initial letter
# capitalised

define(cap_of,
  `ifelse($1,,,`upper_of(substr($1,0,1))`'substr($1,1)')')

# "cond_of(beh)" extracts the first condition in brackets ([...]) else
# "false"; "[]" for choice must not come first

define(cond_of,
  `define(`an_ind_co1',
    `index($1,`[')')define(`an_ind_co2',
      `index($1,`]')')ifelse(eval(
	(an_ind_co1<0)||(an_ind_co2<0)||((an_ind_co2-an_ind_co1)<2)),1,
	  false,
	  `substr($1,incr(an_ind_co1),eval(an_ind_co2-an_ind_co1-1))')')

# "declare(name,beh)" defines the macro "name" as "beh". User numbers may be
# given as parameters when the macro is called in order to define the gates
# and parameters of "beh" (if any). No user number parameters is equivalent
# to user numbers "12". One user number parameter is repeated (e.g. 2 is
# equivalent to 22). Two user number parameters are used literally. Any
# further numbers in the call of "beh" are left unaltered. User 0 means no
# number at the normal gate. User S means a surrogate (number 3, operating at
# the control gate). Any other number is used literally at the normal gate.
# 
# Consider "declare(Seize,`OffHookFeat [tel, tel] (n1, n2)')". The call
# "Seize" produces "OffHookFeat [tel, tel] (n1, n2)". The call "Seize(2)"
# produces "OffHookFeat [tel, tel] (n2, n2)". The call "Seize(S0)" produces
# "OffHookFeat [ctl, tel] (n3, NoNum of Num)"
# 
# Plain macros like "declare(MaxCalls,100)" expand as normal.

define(declare,
  `ifdef(`$1',
    `rep_err(`$1' is already declared)',
      `ifelse(valid_name($1),1,`ifelse(an_trace,1,
        `errprint(Declaring $1
)')define($1,
  gate_num_set(`$2'))',`rep_err(Invalid name $1)')')')

# "decr(number)" produces the number less one - uncomment this if your
# version of m4 does not have a decrement macro

# define(decr,
#   `eval($1-1)')

# "exit_of(func)" returns a null string if the functionality is empty,
# noexit if the functionality is noexit, else exit

define(exit_of,
  `ifelse($1,,,
    $1,noexit,noexit,
      exit)')

# "extrn_of(string)" produces the external equivalent of the
# internal form of function calls

define(extrn_of,`translit($1,[|],`(,)')')

# "feat_of(string)" produces the feature group in a process instantiation
# such as "OffHook" in "OffHookFeat3 [tel, ctl] (n3, n2)" by extracting
# the name before "Feat" (or its process name if not present)

define(feat_of,
  `define(`an_ind_fo',
    index(`$1',Feat))ifelse(an_ind_fo,-1,
      `proc_of(`$1')',
        `substr(`$1',0,1)`'substr(`$1',1,eval(an_ind_fo-1))')')

# "file_delete(file)" deletes file "file"

define(file_delete,`syscmd(rm $1)')

# "file_save(file,text)" saves the definition of a process "text" in file
# "file"

define(file_save,
  `syscmd(cat >> $1 <<"EOF"
$2
EOF)')

# "func_of(beh)" returns the functionality of "beh" if it is a process,
# noexit for "stop", exit for "exit ...", else a null string

define(func_of,
  `define(`an_ind_fo',
    `index(an_proc_attrs,[proc_of($1)|)')ifelse(an_ind_fo,-1,
      ifelse(
        `$1',stop,noexit,
        substr(`$1',0,4),exit,an_exit_func),
	  `ifelse(get_word(substr(an_proc_attrs,an_ind_fo),1),noexit,
	    noexit,`an_exit_func')')')

# "func_last_of(func1,func2,func3,func4)" returns the rightmost defined
# functionality (4/3/2/1 in order of preference) or "exit" by default

define(func_last_of,
  `ifelse($4,,
    `ifelse($3,,
      `ifelse($2,,
        `ifelse($1,,
	  an_exit_func,
	  $1)',
	$2)',
      $3)',
    $4)')

# "func_max_of(func1,func2,func3,func4)" returns "exit" with appropriate
# numbers and result if one functionality is exit, otherwise the functionality
# of "func1"

define(func_max_of,
  `ifelse($4,an_exit_func,an_exit_func,
    `ifelse($3,an_exit_func,an_exit_func,
      `ifelse($2,an_exit_func,an_exit_func,$1)')')')

# "gate_num_set(beh)" produces a macro definition to instantiate "beh", which
# is either plain text or a process call with comma and space separators as
# required, such as "Proc [tel`,' ctl] (n2, n1, n5)". For the latter case, the
# macro definition may subsequently be called with user numbers (e.g. 21).
# When the macro is called, no user numbers results in the original "beh".
# One user number is treated as a pair the same. Two user numbers are used to
# set the gates (in the S case) and the number parameters.
# 
# User 0 means no number at the normal gate, user S means a surrogate (number
# 3, operating at the control gate), other numbers are used literally at the
# normal gate. For example, with parameters:
# 
#   none:	Proc [tel`,' ctl] (n2, n1, n5).
#   "13":	Proc [g2`,' g1] (n1, n3, n5).
#   "S0":	Proc [ctl`,' g1] (n3, NoNum of Num, n5)

define(gate_num_set,
  ``define(`an_proc_gn',)regexp($1,
    `^\(\w+\) \[\(\w+\)\W+\(\w+\)\] (\(\w+\)\W+\(\w+\)\W+\(.+\))$',
    `define(`an_proc_gn',\1)define(`an_gate_gn1',
      \2)define(`an_gate_gn2',\3)define(`an_num_gn1',
        \4)define(`an_num_gn2',\5)define(`an_num_gn3',
	  `, \6')')ifelse(an_proc_gn,,`regexp($1,
	    `^\(\w+\) \[\(\w+\)\W+\(\w+\)\] (\(\w+\)\W+\(\w+\))$',
	    `define(`an_proc_gn',\1)define(`an_gate_gn1',
	      \2)define(`an_gate_gn2',\3)define(`an_num_gn1',
		\4)define(`an_num_gn2',\5)define(`an_num_gn3',
                  )')')ifelse(an_proc_gn,,`$1',
		    define(`an_dir_gn',
		      ifelse(
		        $''``1,,12,
			substr($'`1,1,1),,$''``1$''``1,
			$''``1))`define(`an_dir_gn1',
			  substr(an_dir_gn,0,1))define(`an_dir_gn2',
			    substr(an_dir_gn,1,1))ifelse(
			      an_dir_gn1,S,
			        `ifelse(an_gate_gn1,an_ctl_gate,
				  `rep_err(Surrogate user not allowed for combinator call)',
				    `define(`an_gate_gn1',
			              an_ctl_gate)define(`an_num_gn1',n3)')',
			      an_dir_gn1,0,
			        `define(`an_num_gn1',NoNum of Num)',
				`define(`an_num_gn1',
				  n`'an_dir_gn1)')ifelse(
				    an_dir_gn2,S,
				      `ifelse(an_gate_gn2,an_ctl_gate,
					`rep_err(Surrogate user not allowed for combinator call)',
					`define(`an_gate_gn2',
					  an_ctl_gate)define(`an_num_gn2',
					    n3)')',
				    an_dir_gn2,0,
				      `define(`an_num_gn2',NoNum of Num)',
				      `define(`an_num_gn2',
				        n`'an_dir_gn2)')an_proc_gn [an_gate_gn1``,'' an_gate_gn2] (an_num_gn1, an_num_gn2`'an_num_gn3)')'')

# "gate_num_swap(beh)" produces a behaviour corresponding to "beh" but
# with gates and numbers swapped; it is assumed that these are in a list with
# comma and space separators (e.g. "Proc [g1`,' g2] (n1, n2)")

define(gate_num_swap,
  `define(`an_num_gn',`$1')define(`an_ind_gn1',
    `index(an_num_gn,`[')')define(`an_ind_gn2',
      `index(an_num_gn,`,')')define(`an_ind_gn3',
	`index(an_num_gn,`]')')ifelse(eval(
	  (an_ind_gn1<0)||(an_ind_gn2<0)||(an_ind_gn3<0)),1,
	    an_num_gn,
	    `substr(an_num_gn,0,an_ind_gn1)[substr(an_num_gn,
	      eval(an_ind_gn2+2),
	        eval(an_ind_gn3-an_ind_gn2-2))``,' 'substr(an_num_gn,
		  eval(an_ind_gn1+1),
		    eval(an_ind_gn2-an_ind_gn1-1))]define(`an_num_gn',
		      substr(an_num_gn,
		        eval(an_ind_gn3+1)))define(`an_ind_gn1',
			  `index(an_num_gn,`(')')define(`an_ind_gn2',
			    `index(an_num_gn,`,')')define(`an_ind_gn3',
			      `index(an_num_gn,`)')')ifelse(eval(
				(an_ind_gn1<0)||(an_ind_gn2<0)||
				  (an_ind_gn3<0)),1,an_num_gn,
				`substr(an_num_gn,0,
				  an_ind_gn1)`('substr(an_num_gn,
				    eval(an_ind_gn2+2),
				      eval(
				        an_ind_gn3-an_ind_gn2-2))`, 'substr(
					  an_num_gn,eval(an_ind_gn1+1),
					   eval(
					    an_ind_gn2-an_ind_gn1-1))`)'')')')

# "gate_qual(num,beh)" produces a behaviour corresponding to "beh" but with
# number "num" appended to the gate name

define(gate_qual,
  `define(`an_ind',
    index($2,gate))ifelse(an_ind,-1,$2,
      `define(`an_ind',eval(an_ind+len(gate)))substr($2,0,an_ind)()$1substr($2,an_ind)')')

# "gate_set(gates,beh)" produces a behaviour corresponding to "beh" but
# with gates set according to parameters "c" (control) and "n" (normal)

define(gate_set,
  `define(`an_gate_gs1',
    substr($1,0,1))ifelse(
      an_gate_gs1,c,`define(`an_gate_gs1',an_ctl_gate)',
      an_gate_gs1,n,`define(`an_gate_gs1',an_nrm_gate)',
      `rep_err(Unknown first gate type an_gate_gs1)')define(`an_gate_gs2',
        substr($1,1,1))ifelse(
	  an_gate_gs2,c,`define(`an_gate_gs2',an_ctl_gate)',
	  an_gate_gs2,n,`define(`an_gate_gs2',an_nrm_gate)',
	  `rep_err(Unknown second gate type an_gate_gs2)')define(`an_ind_gs1',
	    `index(`$2',`[')')define(`an_ind_gs2',
	      `index(`$2',`]')')ifelse(eval((an_ind_gs1<0)||(an_ind_gs2<0)),1,
	        $2,
		`substr(`$2',0,
		  an_ind_gs1)[an_gate_gs1`,' an_gate_gs2]substr(`$2',
		    eval(an_ind_gs2+1))')')

# "get_word(string,num)" gets the word ending in "|" or "]" from "string"
# with number "num" (0 is first word), returning a null string if there is no
# such word

define(get_word,
  `define(`an_ind_gw',`min(index($1,`|'),index($1,`]'))')ifelse(an_ind_gw,-1,,
    `ifelse(eval($2<0),1,,
      `ifelse(eval($2=0),1,
	`substr($1,0,an_ind_gw)',
	  `ifelse(substr($1,an_ind_gw,1),],,
	    `get_word(substr($1,incr(an_ind_gw)),eval($2-1))')')')')')

# "group_name(group)" returns the group surrounded by underscores (in case
# the group name is already a macro)

define(group_name,
  `ifelse($1,exit,$1,`_`'$1`'_')')

# "group_of(string)" produces the group in a process or procedure
# instantiation such as "Conn" in "ConnReq(alpha,beta)" or
# "ConnReq[gamma,delta]" by removing the last three characters of the name
# and adding "Group"

define(group_of,
  `define(`an_name',
    `proc_of($1)')substr(an_name,0,eval(len(an_name)-3))')

# "header(string)" adds the given string to the header information

define(header,
  `define(`an_header',an_header
  $1)')

# "intrn_of(string)" produces the same string with function calls
# changed into internal form, i.e. "f(a,b)" translated to
# "f[a|b]". This is because "(", "," and ")" are special to m4.
# Newlines, blanks and tabs are also removed.

define(intrn_of,`translit(translit(`$1',`(,)',[|]),`
' 	)')

# "lab_args(string,label)" labels each argument in the string by
# appending the given label

define(lab_args,
  `undefine(`an_list')define(`an_lab_arg',
    `define(`par',
      $'1`)ifdef(`an_list',
        `define(`an_list',an_list|par`'$2)',
          `define(`an_list',par`'$2)')')map_args($1,
            `an_lab_arg')an_list')

# "line_max" defines the target line length

define(line_max,
  `55')

# "ltrs_of(string)" produces the same string with digits deleted

define(ltrs_of,
  `translit($1,0123456789)'))

# "lower_of(string)" produces the same string with upper case letters changed
# to lower case

define(lower_of,
  `translit(
    $1,ABCDEFGHIJKLMNOPQRSTUVWXYZ,abcdefghijklmnopqrstuvwxyz)'))

# "map_args(string,macro)" calls the macro for each parameter in
# the string. The macro is called with the function parameter list
# as its only parameter.

define(map_args,
  `define(`an_arg_ind',
    index($1,|))ifelse(
      $1,,,
	an_arg_ind,-1,`$2($1)',
	  `$2(substr($1,0,an_arg_ind))'``''`map_args(
	    substr($1,incr(an_arg_ind)),`$2')')')

# "map_funs(string,macro)" calls the macro for each function call
# in the string. This macro is called with the function name as
# its first parameter, and the function parameter list as its
# second parameter.

define(map_funs,
  `define(`an_fun_ind1',
    index($1,[))define(
      `an_fun_ind2',index($1,]))ifelse(
	an_fun_ind1,-1,,
	  an_fun_ind2,-1,,
	     `$2(
	       substr($1,0,an_fun_ind1),substr($1,incr(an_fun_ind1),
		   eval(an_fun_ind2-an_fun_ind1-1)))'``''`map_funs(
		     substr($1,incr(an_fun_ind2)),`$2')')')

# "min(n1,n2)" produces the lesser non-negative value

define(min,
  `ifelse(eval($1<0),1,$2,
    `ifelse(eval($2<0),1,$1,
      eval($1<$2),1,$1,$2)')')

# "next_no(proc)" produces a name/number for the process using the global
# "an_<proc>" to store the last number

define(next_no,
  `ifdef(`an_$1',
    `define(`an_$1',incr(an_$1))$1`'an_$1',
    `define(`an_$1',0)$1')')

# "num_pair(dir)" produces a number pair for direction "dir" ("12" or "21",
# default "12")

define(num_pair,
 `ifelse($1,,`n1, n2',
   $1,12,`n1, n2',
     `n2, n1')')

# "num_set(beh)" set the current number parameters "an_num_pars" corresponding
# to behaviour "beh" (e.g. "Proc [g1`,' g2] (n2, n1)" sets "n2| n1")

define(num_set,
  `define(`an_ind_ns1',
    `index(`$1',`(')')define(`an_ind_ns2',
      `index(`$1',`)')')ifelse(eval((an_ind_ns1>=0)&&(an_ind_ns2>=0)),1,
	`define(`an_nums',
	  `translit(substr(`$1',eval(an_ind_ns1),
	    eval(an_ind_ns2-an_ind_ns1+1)),`,',`|')')define(`an_num_pars',
	      `substr(an_nums,1,eval(an_ind_ns2-an_ind_ns1-1))')')')

# "num_swap(beh)" produces a behaviour corresponding to "beh" but
# with numbers swapped; it is assumed that these are in a list with
# comma and space separators (e.g. "Proc [g1`,' g2] (n1, n2)")

define(num_swap,
  `define(`an_num_ns',
    `$1')define(`an_ind_ns1',
      `index(an_num_ns,`,')')define(`an_ind_ns2',
	`index(an_num_ns,`(')')define(`an_ind_ns3',
	  `index(substr(an_num_ns,an_ind_ns2),`,')')ifelse(an_ind_ns3,-1,,
	    `define(`an_ind_ns3',
	      eval(an_ind_ns2+an_ind_ns3))')define(`an_ind_ns4',
		`index(an_num_ns,`)')')ifelse(eval(
		  (an_ind_ns1<0)||(an_ind_ns2<0)||(an_ind_ns3<0)||
		    (an_ind_ns4<0)),1,an_num_ns,
		  `substr(an_num_ns,0,
		    an_ind_ns1)``,''substr(an_num_ns,
		      incr(an_ind_ns1),
		        eval(an_ind_ns2-an_ind_ns1-1))`('substr(an_num_ns,
			  eval(an_ind_ns3+2),
			    eval(
			      an_ind_ns4-an_ind_ns3-2))`, 'substr(
				an_num_ns,eval(an_ind_ns2+1),
				  eval(
				  an_ind_ns3-an_ind_ns2-1))`)'')')

# "pars_of(string)" produces the parameters in a process or procedure
# instantiation such as "(alpha,beta)" in "Conn(alpha,beta)" or
# "[gamma,delta]" in "Conn[gamma,delta]"

define(pars_of,
  `define(`an_ind',
    index($1,`('))ifelse(an_ind,-1,`define(`an_ind',
      index($1,`['))ifelse(an_ind,-1,,substr($1,an_ind))',substr($1,an_ind))')

# "proc_call(beh)" instantiates process "beh", but re-orders its
# numbers if they differ from the expected ones in "an_num_pars". If a list
# of number does not exist in "beh", this is presumed to be a macro that will
# later be defined. Evaluation of the call is therefore deferred till later.

define(proc_call,
  `define(`an_pars_pc',
    proc_pars_of(translit(`$1',`,',`|')))define(`an_ind_pc',
      `index(an_pars_pc,`| res')')ifelse(an_ind_pc,-1,,
        `define(`an_pars_pc',substr(an_pars_pc,0,an_ind_pc))')ifelse(
          index(an_pars_pc,|),-1,
	    ``proc_call_defer'(an_num_pars,$1)',
          an_pars_pc,an_num_pars,
            ``$1'',
	    `(`$1'
    >> accept proc_pars_of(`$1') : Num`,' res : Result in
      exit (extrn_of(an_num_pars), res))')')

# "proc_call_defer(nums,beh)" instantiates process "beh", but re-orders its
# numbers if they differ from the expected ones in "nums"

define(proc_call_defer,
  `define(`an_pars_pc',
    proc_pars_of(translit(`$2',`,',`|')))ifelse(
      an_pars_pc,$1,
        `$2',
        `($2
    >> accept proc_pars_of(`$2') : Num`,' res : Result in
      exit (extrn_of($1), res))')')

# "proc_of(string)" produces the name in a process instantiation such as
# "ConnReq" in "ConnReq", "ConnReq(alpha,beta)" or "ConnReq[gamma,delta]" or
# "ConnReq [gamma,delta] (alpha,beta)"

define(proc_of,
  `define(`an_ind1',
    index(`$1',` '))define(`an_ind2',
      index(`$1',`['))define(`an_ind3',
        index(`$1',`('))define(`an_ind4',
	  `min(min(an_ind1,an_ind2),an_ind3)')ifelse(an_ind4,-1,`$1',
	    `substr(`$1',0,an_ind4)')')

# "proc_pars_of(string)" produces the parameters in a process
# instantiation such as "n3, n2" in "ConnReq [g1, g2] (n3, n2)"; as a special
# case, if any parameter has "NoNum" then the default parameters are "n1, n2"

define(proc_pars_of,
  `define(`an_ind1',
    index(`$1',`('))ifelse(an_ind1,-1,,
      `define(`an_ind1',
        incr(an_ind1))define(`an_ind2',index(`$1',`)'))ifelse(an_ind2,-1,,
          `ifelse(index(`$1',NoNum),-1,
	    `substr(`$1',an_ind1,eval(an_ind2-an_ind1))',
	      `n1, n2')')')')

# "rep_err(string)" report the error message "string"

define(rep_err,
  `errprint(`anise: Error on Line '__line__` - $1
')')

# "role_of(string)" produces the role (req/ind/res/con) in a process or
# procedure instantiation such as "Req" in "ConnReq(alpha,beta)" or
# "ConnReq[gamma,delta]" by extracting the last three characters of the name

define(role_of,
  `define(`an_name',`proc_of($1)')substr(an_name,eval(len(an_name)-3))')

# "uniq_func(function,parameters)" appends the function and parameters to
# "an_list", unless the function is already present in the list

define(uniq_func,
  `ifdef(`an_list',
    `ifelse(index(an_list,$1),-1,
      `define(`an_list',an_list`'$1[$2])')',`define(`an_list',$1[$2])')')

# "uniq_func_par(function,parameters)" appends the function and parameters to
# "an_list", unless the function and parameters are already present in the list

define(uniq_func_par,
  `ifdef(`an_list',
    `ifelse(index(an_list,$1[$2]),-1,
      `define(`an_list',an_list`'$1[$2])')',`define(`an_list',$1[$2])')')

# "uniq_funcs(string)" removes duplicate function calls in the string

define(uniq_funcs,
  `undefine(`an_list')map_funs($1,`uniq_func')an_list')

# "uniq_funcs_pars(string)" removes duplicate function calls in the string
# with identical parameters

define(uniq_funcs_pars,
  `undefine(`an_list')map_funs($1,`uniq_func_par')an_list')

# "upper_of(string)" produces the same string with lower case letters changed
# to upper case

define(upper_of,
  `translit(
    $1,abcdefghijklmnopqrstuvwxyz,ABCDEFGHIJKLMNOPQRSTUVWXYZ)'))

############################ Specification Macros ###########################

# "global(gate,beh)" produces all accumulated process and type
# definitions for gate "gate", profiles "prof" and behaviour "beh"

define(global,
  `ifelse(an_trace,1,
    `errprint(Declaring Specification
)')prof_check`'define(`an_proc_res',
    func_of($2))define(`an_serv_name',
      cap_of($1)`'Service)define(an_nrm_gate,
        `lower_of($1)')ifelse(an_nrm_gate,an_ctl_gate,
          `rep_err(Gate name "an_ctl_gate" is reserved)')define(an_gates,
            `an_nrm_gate`,' an_ctl_gate')
(*****************************************************************************

  Specification of cap_of($1) Service
  Generated by ANISE on syscmd(date)an_header

*****************************************************************************)

specification an_serv_name [an_nrm_gate] : an_proc_res
all_types(an_prims)
behaviour
  hide an_ctl_gate in
    $2

where

sinclude(an_feat_file)sinclude(an_comb_file)endspec (* an_serv_name *)
file_delete(an_feat_file)file_delete(an_comb_file)')

# "valid_name(name)" checks if "name" is valid (1 for alphanumeric plus
# underscore) or invalid (0)

define(valid_name,
  `ifelse(index($1,` '),-1,1,0)')

########################### Trailer ##############################

# allow use of hash in numbers

changecom(%,)

divert
