################################### Header ###################################

# "anise_comb_gen.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	12/08/98

# This "m4" macro file contains templates for generating Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.

# This particular file contains macros for general feature combinators.

# Copyright 1998 K. J. Turner, University of Stirling

######################### General Combination Macros #########################

# "an_comb_file" gives the temporary filename used for combination processes

define(an_comb_file,
  maketemp(/tmp/combXXXXXX))

# "an_comb_pars" returns the current parameters for a combinator process
# as the numbers in use ("an_num_pars")

define(an_comb_pars,
  `extrn_of(an_num_pars) : Num')

############################ Combination Processes ###########################

# "alternates(beh)" produces a process definition and process instantiation
# for behaviour "beh" alternating in each direction

define(alternates,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_func1',
      `func_of(`$1')')ifelse(an_func1,,
	`rep_err(Cannot alternate with unknown result for an_feat1)',
	  an_func1,noexit,
	    `rep_err(Cannot alternate with non-exit result for an_feat1)',
	      `define(`an_proc_name1',
		next_no(Alternates))add_num_pars(
		  `$1')define(`an_proc_res',
		    noexit)add_proc_attrs(an_proc_name1,
		      noexit)file_save(an_comb_file,
`  '(* group_name(`an_feat1') will alternate in each direction *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    `$1'
  ``>> accept proc_pars_of(`$1') : Num, res : Result in''
    gate_num_swap(`$1')
  ``>> accept proc_pars_of(gate_num_swap(`$1')) : Num, res : Result in''
    comb_call(an_proc_name1)
  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')')

# "collides(feat)" produces a process definition and process instantiation
# for feature "feat" (which cannot be a combination) that may collide with
# itself; the following requires "feat" to be unconfirmed, but should
# take account of different patterns

define(collides,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_prop',
      `prop_of(`$1')')define(`an_patt',
	`patt_of(`$1')')define(`an_group1',
	`group1_of(`$1')')define(`an_group2',
	  `group2_of(`$1')')ifelse(an_prop,single,
	    `ifelse(
	      an_patt,local_confirmed,`$1',
	      an_patt,provider_initiated,`$1',
	      an_patt,user_initiated,`$1',
	      an_patt,user_provider_confirmed,
                `rep_err(Sorry`,' an_patt collision not yet implemented)',
	      `define(`an_proc_name1',
		next_no(Collides))define(`an_proc_name2',
		  an_proc_name1`'an_lab1)define(`an_proc_name3',
		    an_proc_name1`'an_lab2)add_num_pars(
		      `$1')define(`an_proc_res',
			an_exit_func)add_proc_attrs(an_proc_name1,
			  exit)file_save(an_comb_file,
`  '(* group_name(`an_feat1') requests at both ends mutually cancel *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    (
      (
        proc_call(`$1')
      [>
        exit (extrn_of(an_num_pars), NoRes)
      )
    |||
      (
        proc_call(gate_num_swap(`$1'))
      [>
        exit (extrn_of(an_num_pars), NoRes)
      )
    )
  |[an_nrm_gate]|
    an_proc_name2 [an_gates]

    where

    process an_proc_name2 [an_gates] : an_proc_res :=
      an_nrm_gate ? id : Id ? prim : Prim;
      an_nrm_gate ? id : Id ? prim : Prim;ifelse(an_patt,unconfirmed,`
      any_res',`
      (
	[IsReq (prim)] ->ifelse(an_patt,asymmetric_confirmed,`
	  any_res',an_patt,unconfirmed,`
	  any_res',`
	  any_res
        ``>> accept proc_pars_of($1) : Num, res : Result in''
	  ifelse(an_group2,,`
	  (
	     an_nrm_gate ? id : Id ? prim : Prim
	      [IsInd (prim) and IsId (id, n1)]
	    exit
	  |||
	    an_nrm_gate ? id : Id ? prim : Prim
	      [IsInd (prim) and IsId (id, n2)]
	    exit
	  )
	>>
	  any_res
	  ',`
	  (
	    an_nrm_gate ? id : Id ? prim : Prim
	      [IsCon (prim) and IsId (id, n1)]
	    exit
	  |||
	    an_nrm_gate ? id : Id ? prim : Prim
	      [IsCon (prim) and IsId (id, n2)]
	    exit
	  )
	>>
	  any_res
	  ')')
      []
	[not (IsReq (prim))] ->
	  an_proc_name3 [an_gates]
      )')
    endproc (* an_proc_name2 *)ifelse(an_patt,unconfirmed,,`

    process an_proc_name3 [an_gates] : an_proc_res :=ifelse(an_group2,-,`
      an_nrm_gate ? id : Id ? prim : Prim
        [not (IsReq (prim))];ifelse(
	  an_patt,asymmetric_confirmed,`
      any_res',`
      (
        [IsCon (prim)] ->
	  any_res
      []
        [not (IsCon (prim))] ->
	  an_proc_name3 [an_gates]
      )')',`
      an_nrm_gate ? id : Id ? prim : Prim;ifelse(
        an_patt,asymmetric_confirmed,`
      any_res',`
      (
        [IsInd (prim)] ->
	  any_res)
      []
        [not (IsInd (prim))] ->
	  an_proc_name3 [an_gates]
      )')')
    endproc (* an_proc_name3 *)')

  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')',
  `rep_err(Sorry`,' an_prop property collision not yet implemented)')')

# "comb_call(comb)" instantiates combinator process "comb"

define(comb_call,
  `$1 [an_nrm_gate``,'' an_ctl_gate] (extrn_of(an_num_pars))')

# "comb_inst(comb)" instantiates combinator process "comb" and re-initialises
# the list of numbers in use

define(comb_inst,
  `comb_call($1)`'define(`an_num_pars',`n1| n2')')

# "disables(beh1,beh2)" produces a process definition and process
# instantiation for behaviour "beh1" to disable behaviour "beh2"

define(disables,
  `define(`an_feat1',`feat_of(`$1')')define(`an_feat2',
    `feat_of(`$2')')define(`an_proc_name1',
      next_no(Disables))add_num_pars(
        `$1')add_num_pars(`$2')define(`an_proc_res',
	  `func_max_of(func_of(`$1'),
	    func_of(`$2'))')add_proc_attrs(an_proc_name1,
	    `exit_of(an_proc_res)')file_save(an_comb_file,
`  '(* group_name(`an_feat1') may disable group_name(`an_feat2') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    proc_call(`$2')
  [>
    proc_call(`$1')
  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')

# "duplicates(beh)" produces a process definition and process instantiation
# for behaviour "beh" interleaved in each direction

define(duplicates,
  `define(`an_feat1',
    feat_of(`$1'))define(`an_func1',
      func_of(`$1'))define(`an_proc_name1',
        next_no(Duplicates))add_num_pars(
	  `$1')define(`an_proc_res',
	    `an_func1')add_proc_attrs(an_proc_name1,
	      `exit_of(an_proc_res)')file_save(an_comb_file,
`  '(* group_name(`an_feat1') will occur in each direction *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    `$1'
  |||ifelse(exit_of(an_proc_res),exit,`
    (
       `gate_num_swap(`$1')'
    ``>> accept n2, n1 : Num, res : Result in''
      exit (an_comb_pars, res)
    )',`
    `gate_num_swap(`$1')'')
  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')

# "enables(beh1,beh2,beh3,beh4,beh5)" produces a process definition and
# process instantiation for behaviour "beh1" to enable behaviour "beh2", ...

define(enables,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_func1',
      `func_of(`$1')')add_num_pars(`$1')add_num_pars(`$2')add_num_pars(
	`$3')add_num_pars(`$4')add_num_pars(`$5')define(`an_proc_res',
	  `func_last_of(func_of(`$2'),func_of(`$3'),
	    func_of(`$4'),func_of(`$5'))')ifelse(an_func1,,
	      `rep_err(Cannot enable with unknown result for an_feat1)',
		an_func1,noexit,
		  `rep_err(Cannot enable with non-exit result for an_feat1)',
		    `define(`an_feat2',
		      `feat_of(`$2')')define(`an_feat3',
			`feat_of(`$3')')define(`an_feat4',
			  `feat_of(`$4')')define(`an_feat5',
			    `feat_of(`$5')')define(`an_proc_name1',
			      next_no(Enables))add_proc_attrs(
				an_proc_name1,
				`exit_of(an_proc_res)')file_save(an_comb_file,
`  '(* group_name(`an_feat1') may enable group_name(`an_feat2')`'ifelse(`$3',,,
  `, group_name(`an_feat3')`'ifelse(`$4',,,
    `, group_name(`an_feat4')`'ifelse(`$5',,,
      `, group_name(`an_feat5')')')') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    `$1'
  ``>> accept proc_pars_of($1) : Num, res : Result in''
    ifelse(`$3',,``proc_call(`$2')'',``$2'
  ``>> accept proc_pars_of($2) : Num, res : Result in''
    ifelse(`$4',,``proc_call(`$3')'',``$3'
  ``>> accept proc_pars_of($3) : Num, res : Result in''
    ifelse(`$5',,``proc_call(`$4')'',``$4'
  ``>> accept proc_pars_of($4) : Num, res : Result in''
    ``proc_call(`$5')''')')')
  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')')

# "enables_after_ack(feat,beh)" produces a process definition and process
# instantiation for acknowledging behaviour "feat" (which cannot be a
# combination) to enable "feat"; the following requires "feat" to be
# user_confirmed behaviour, but should take account of different patterns

define(enables_after_ack,
  `define(`an_proc_name1',
    next_no(EnablesAfterAck))define(`an_proc_name2',
      an_proc_name1`'Aux)define(`an_proc_name3',
	an_proc_name1`'AuxA)define(`an_proc_name4',
	  an_proc_name1`'AuxB)file_save(an_comb_file,
`  '(* acknowledging proc_of(`$1') will enable proc_of(`$2') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : noexit :=
ifelse(is_feat(`$1'),0,
`    stop		(*** "proc_of(`$1')" is not one of the features ***)
  endproc (* an_proc_name1 *)
',
`ifelse(patt_of(`$1'),user_confirmed,
`    hide gate1``,'' gate2 in
      (``''
	gate_qual(1,`$1')
      |||
	gate_qual(2,`$2')
      )
    |[gate1``,'' gate2]|
      an_proc_name2 [gate``,'' gate1``,'' gate2] (an_comb_pars)

  where

    process an_proc_name2 [gate``,'' gate1``,'' gate2] (an_comb_pars) : noexit :=
      gate1 ? id : Id ? prim1 : Prim;
      gate ! id ! prim1;
      (``''
	[IsRes (prim1)] ->
	  (``''
	    [id eq id2] ->
	      an_proc_name3 [gate``,'' gate1``,'' gate2] (an_comb_pars)
	  []
	    [id eq id1] ->
	      an_proc_name3 [gate``,'' gate1``,'' gate2] (an_comb_pars)
	  )
      []
        [not (IsRes (prim1))] ->
	  an_proc_name2 [gate``,'' gate1``,'' gate2] (an_comb_pars)
      )
    endproc (* an_proc_name2 *)

    process an_proc_name3 [gate``,'' gate1``,'' gate2] (an_comb_pars) : exit :=
      gate1 ? id : Id ? prim1 : Prim;
      gate ! id ! prim1;
      (``''
        [IsCon (prim1)] ->
	  an_proc_name4 [gate``,'' gate1``,'' gate2] (an_comb_pars)
      []
        [not (IsCon (prim1))] ->
	an_proc_name3 [gate``,'' gate1``,'' gate2] (an_comb_pars)
      )
    []
      gate2 ! id2 ? prim2 : Prim [IsReq (prim2)];
      gate ! id2 ! prim2;
      an_proc_name3 [gate``,'' gate1``,'' gate2] (an_comb_pars)
    endproc (* an_proc_name3 *)

    process an_proc_name4 [gate``,'' gate1``,'' gate2] (an_comb_pars) : exit :=
      gate1 ? id : Id ? prim1 : Prim;
      gate ! id ! prim1;
      an_proc_name4 [gate``,'' gate1``,'' gate2] (an_comb_pars)
    []
      gate2 ? id : Id ? prim2 : Prim;
      gate ! id ! prim2;
      an_proc_name4 [gate``,'' gate1``,'' gate2] (an_comb_pars)
    endproc (* an_proc_name4 *)

  endproc (* an_proc_name1 *)
',
`    stop		(*** "proc_of(`$1')" is not user_confirmed ***)
  endproc (* an_proc_name1 *)
')'))comb_inst(an_proc_name1)')

# "enables_after_try(beh1,beh2)" produces a process definition and process
# instantiation for trying behaviour "beh1" to enable "beh2"

define(enables_after_try,
  `define(`an_proc_name1',
    next_no(EnablesAfterTry))define(`an_proc_name2',
      an_proc_name1`'Aux)define(`an_proc_name3',
	an_proc_name1`'AuxA)define(`an_proc_name4',
	  an_proc_name1`'AuxB)file_save(an_comb_file,
`  '(* trying proc_of(`$1') will enable proc_of(`$2') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : noexit :=
    hide gate1``,'' gate2 in
      (``''
	gate_qual(1,`$1')
      |||
	gate_qual(2,`$2')
      )
    |[gate1``,'' gate2]|
      an_proc_name2 [gate``,'' gate1``,'' gate2] (an_comb_pars)

  where

    process an_proc_name2 [gate``,'' gate1``,'' gate2] (an_comb_pars) : noexit :=
      gate1 ? id : Id ? prim1 : Prim;
      gate ! id ! prim1;
      (``''
	[IsReq (prim1)] ->
	  (``''
	    [id eq id1] ->
	      an_proc_name3 [gate``,'' gate1``,'' gate2] (an_comb_pars)
	  []
	    [id eq id2] ->
	      an_proc_name3 [gate``,'' gate1``,'' gate2] (proc_pars_of(`gate_num_swap(`$1')'))
	  )
      []
        [not (IsReq (prim1))] ->
	  an_proc_name2 [gate``,'' gate1``,'' gate2] (an_comb_pars)
      )
    endproc (* an_proc_name2 *)

    process an_proc_name3 [gate``,'' gate1``,'' gate2] (an_comb_pars) : exit :=
      gate1 ? id : Id ? prim1 : Prim;
      gate ! id ! prim1;
      (``''
        [IsInd (prim1)] ->
	  an_proc_name4 [gate``,'' gate1``,'' gate2] (an_comb_pars)
      []
        [not (IsInd (prim1))] ->
	  an_proc_name3 [gate``,'' gate1``,'' gate2] (an_comb_pars)
      )
    []
      gate2 ! id1 ? prim2 : Prim [IsReq (prim2)];
      gate ! id1 ! prim2;
      an_proc_name3 [gate``,'' gate1``,'' gate2] (an_comb_pars)
    endproc (* an_proc_name3 *)

    process an_proc_name4 [gate``,'' gate1``,'' gate2] (an_comb_pars) : exit :=
      gate1 ? id : Id ? prim1 : Prim;
      gate ! id ! prim1;
      an_proc_name4 [gate``,'' gate1``,'' gate2] (an_comb_pars)
    []
      gate2 ? id : Id ? prim2 : Prim;
      gate ! id ! prim2;
      an_proc_name4 [gate``,'' gate1``,'' gate2] (an_comb_pars)
    endproc (* an_proc_name4 *)

  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')

# "enables_exit(feat1,feat2)" returns feature "feat1" unless it is "exit", in
# which case, the exit results of feature "feat2" are used instead

define(enables_exit,
  `ifelse(`$1',exit,`exit (proc_pars_of(`$2'), res)',`$1')')

# "enables_on_result(beh1,res2,beh2,...,behN)" produces a process definition
# and process instantiation for behaviour "beh1" to enable behaviour "beh2"
# if its result is "res2", etc. with default behaviour "behN"
# 
# If "beh2" is omitted it defaults to "exit", which may be used for any
# behaviour to exit with the current numbers and result

define(enables_on_result,
  `define(`an_res2',)define(`an_res3',)define(`an_res4',)define(`an_proc2',
    )define(`an_proc3',)define(`an_proc4',)define(`an_proc5',
      )add_num_pars(`$1')ifelse(`$2',,,
       `define(`an_res2',`$2')ifelse(
        `$3',,
          `define(`an_proc2',`enables_exit(exit,`$1')')',
        `$3',exit,
          `define(`an_proc2',`enables_exit(exit,`$1')')',
	`define(`an_proc2',``$3'')add_num_pars(`$3')ifelse(
	  `$5',,
	    `define(`an_proc3',`enables_exit(`$4',`$1')')',
	  `define(`an_res3',`$4')define(`an_proc3',
	    `enables_exit(`$5',`$1')')ifelse(`$7',,
	      `define(`an_proc4',`enables_exit(`$6',`$1')')',
	    `define(`an_res4',`$6')define(`an_proc4',
	      `enables_exit(`$7',`$1')')define(`an_proc5',$8)')')')')define(
		`an_feat1',`feat_of($1)')define(`an_func1',
		  func_of(`$1'))ifelse(
		    an_func1,,
		      `rep_err(
			Cannot enable with unknown result for an_feat1)',
		    an_func1,noexit,
		      `rep_err(Cannot enable with no exit from an_feat1)',
		    `define(`an_feat2',
		      `feat_of(an_proc2)')define(`an_feat3',
			`feat_of(an_proc3)')define(`an_feat4',
			  `feat_of(an_proc4)')define(`an_proc_name1',
			    next_no(EnablesOnResult))define(
			      `an_proc_res',
				`func_max_of(
				  func_of(an_proc2),func_of(an_proc3),
				    func_of(an_proc4),
				      func_of(an_proc5))')add_proc_attrs(
					  an_proc_name1,
					    `exit_of(
					      an_proc_res)')file_save(
						an_comb_file,
`  '(* group_name(`an_feat1') may enable group_name(
        `an_feat2') on an_res2`'ifelse(an_res3,,
	  `ifelse(an_feat3,,,`, else group_name(`an_feat3')')',
	  `, group_name(`an_feat3') on an_res3`'ifelse(an_res4,,
	    `ifelse(an_feat4,,,`, else group_name(`an_feat4')')',
	      `, group_name(`an_feat4') on an_res4`'ifelse(an_proc5,,,
	        `, else group_name(an_proc5)')')')') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    `$1'
  ``>> accept proc_pars_of(`$1') : Num, res : Result in''
    [res eq Result (an_res2)] ->
      ifelse(an_proc3,,`proc_call(an_proc2)',``proc_call(an_proc2)'
  []ifelse(an_res3,,`
    [res ne Result (an_res2)] ->',`
    [res eq Result (an_res3)] ->')
      ifelse(an_proc4,,`proc_call(an_proc3)',``proc_call(an_proc3)'
  []ifelse(an_res4,,`
    [(res ne Result (an_res2)) and (res ne Result (an_res3))] ->',`
    [res eq Result (an_res4)] ->')
      `proc_call(an_proc4)'ifelse(an_proc5,,,`
  []
    [(res ne Result (an_res2)) and (res ne Result (an_res3)) and (res ne Result (an_res4))] ->
      `proc_call(an_proc5)'')')')
  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')')

# "feat_attrs" gives the attributes of features as a list of triples:
# process name, pattern, property

define(feat_attrs,
  `')

# "finishes(beh)" stops if "beh" exits

define(finishes,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_func1',
	`func_of(`$1')')ifelse(an_func1,,
	  `rep_err(Cannot finish with unknown result for an_feat1)',
	    an_func1,noexit,
	      `$1',
		`define(`an_proc_name1',
		  next_no(Finishes))add_num_pars(
		    `$1')define(`an_proc_res',
		      noexit)add_proc_attrs(an_proc_name1,
			noexit)file_save(an_comb_file,
`  '(* group_name(`an_feat1') will not terminate *)

  process an_proc_name1 [an_gates] (an_comb_pars) : noexit :=
    `$1'
  ``>> accept proc_pars_of($1) : Num, res : Result in''
    stop
  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')')

# "instances(num,beh)" produces a process definition and process instantiation
# for "num" (>= 1) instances of behaviour "beh"

define(instances,
  `define(`an_feat1',
    `feat_of(`$2')')define(`an_proc_name1',
      next_no(Instances))add_num_pars(
        `$2')define(`an_proc_res',
	  `func_of(`$2')')add_proc_attrs(an_proc_name1,
	    `exit_of(an_proc_res)')file_save(an_comb_file,
`  '(* group_name(`an_feat1') instantiated `$1' times *)

  process an_proc_name1 [an_gates] : an_proc_res :=
    ``let n1 : Num = NoNum, n2 : Num = NoNum in''
      (instances_aux(`$1',`$2')
      )
  endproc (* an_proc_name1 *)
)an_proc_name1 [an_gates]')

# "instances_aux(num,beh)" produces "num" (>= 1) instances of behaviour "beh"

define(instances_aux,
  `ifelse(
    eval(`$1' < 1),1,`rep_err(`Must be one or more instances of 'an_feat1)',
      `$1',1,`
        `$2'',`
        `$2'
      |||instances_aux(decr(`$1'),`$2')')')

# "interleaves(beh1,beh2,beh3,beh4,beh5)" produces a process instantiation
# and accumulated process definition for behaviour "beh1" to interleave with
# behaviour "beh2", ...

define(interleaves,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_feat2',
      `feat_of(`$2')')define(`an_feat3',
	`feat_of(`$3')')define(`an_feat4',
	  `feat_of(`$4')')define(`an_feat5',
	    `feat_of(`$5')')define(`an_proc_name1',
	      next_no(Interleaves))define(`an_proc_res',
		`func_max_of(func_of(`$1'),func_of(`$2'), func_of(`$3'),
		  func_of(`$4'),func_of(`$5'))')add_proc_attrs(an_proc_name1,
		    `exit_of(an_proc_res)')file_save(
		      an_comb_file,
`  '(* interleaving of group_name(`an_feat1'), group_name(`an_feat2')`'ifelse(`$3',,,
  `, _`'an_feat3`'_`'ifelse(`$4',,,
    `, _`'an_feat4`'_`'ifelse(`$5',,,
      `, _`'an_feat5`'_')')') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    `$1'
  |||
    `$2'`'ifelse(`$3',,,`
  |||
    `$3'`'ifelse(`$4',,,`
  |||
    `$4'`'ifelse(`$5',,,`
  |||
    `$5'')')')
  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')

# "interrupts(beh1,beh2)" produces a process definition and process
# instantiation for behaviour "beh1" to interrupt behaviour "beh2" and then
# repeat

define(interrupts,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_feat2',
      `feat_of(`$2')')define(`an_func1',
	`func_of(`$1')')ifelse(an_func1,,
	  `rep_err(Cannot interrupt with unknown result for an_feat1)',
	    an_func1,noexit,
	      `rep_err(Cannot interrupt with non-exit result for an_feat1)',
		`define(`an_proc_name1',
		  next_no(Interrupts))add_num_pars(
		    `$1')add_num_pars(
		      `$2')define(`an_proc_res',
			`func_of(`$2')')add_proc_attrs(an_proc_name1,
			  `exit_of(an_proc_res)')file_save(an_comb_file,
`  '(* group_name(`an_feat1') may interrupt and restart group_name(`an_feat2') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : exit :=
    `$2'
  [>
    (
      `$1'
  ``>> accept proc_pars_of($1) : Num, res : Result in''
      comb_call(an_proc_name1)
    )
  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')')

# "interrupts_after_ack(beh1,beh2)" produces a process definition and process
# instantiation for behaviour "beh1" to interrupt after an acknowledgement of
# behaviour "beh2" and then allow a repeat

define(interrupts_after_ack,
  `define(`an_proc_name1',
    next_no(InterruptsAfterAck))define(`an_proc_name2',
      an_proc_name1`'Aux)define(`an_proc_name3',
	an_proc_name1`'AuxA)file_save(an_comb_file,
`  '(* proc_of(`$1') may interrupt after an acknowledgement of proc_of(`$2'), then repeat *)

  process an_proc_name1 [an_gates] (an_comb_pars) : noexit :=
    hide gate1 in
      gate_qual(1,`$2')
    |[gate1]|
      an_proc_name2 [gate``,'' gate1] (an_comb_pars)

  where

    process an_proc_name2 [gate``,'' gate1] (an_comb_pars) : noexit :=
      gate1 ? id : Id ? prim1 : Prim;
      gate ! id ! prim1;
      (``''
	[IsRes (prim1)] ->
	  (``''
	    an_proc_name3 [gate``,'' gate1] (an_comb_pars)
	  [>
	    (``''
	      `$1'
	    >>
	      comb_call(an_proc_name1)
	    )
	  )
      []
	[not (IsReq (prim1))] ->
	  an_proc_name2 [gate``,'' gate1] (an_comb_pars)
      )
    endproc (* an_proc_name2 *)

    process an_proc_name3 [gate``,'' gate1] (an_comb_pars) : exit :=
      gate1 ? id : Id ? prim1 : Prim;
      gate ! id ! prim1;
      an_proc_name3 [gate``,'' gate1] (an_comb_pars)
    endproc (* an_proc_name3 *)

  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')

# "interrupts_after_try(beh1,beh2)" produces a process definition and process
# instantiation for behaviour "beh1" to interrupt after a try (request or
# indication) of behaviour "beh2" and then allow a repeat

define(interrupts_after_try,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_feat2',
      `feat_of(`$2')')define(`an_func1',
	  `func_of(`$1')')ifelse(an_func1,,
	    `rep_err(Cannot interrupt with unknown result for an_feat1)',
	      an_func1,noexit,
		`rep_err(Cannot interrupt with non-exit result for an_feat1)',
		  `define(`an_proc_name1',
		    next_no(InterruptsAfterTry))define(`an_proc_name2',
		      an_proc_name1`'an_lab1)define(`an_proc_name3',
			an_proc_name1`'an_lab2)add_num_pars(
			  `$1')add_num_pars(
			    `$2')define(`an_proc_res',
			      `an_func1')add_proc_attrs(an_proc_name1,
				`exit_of(an_proc_res)')file_save(an_comb_file,
`  '(* group_name(`an_feat2') may be restarted by group_name(`an_feat1') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    (
      `$2'
    [>
      (
	an_nrm_gate ? id1 : Id ? prim : Prim
	  [IsGroup (prim, an_feat1`'Group)];
	an_proc_name2 [an_gates] (IdNum (id1, n1), n2)
      )
    )
  |[an_nrm_gate]|
    (
      an_nrm_gate ? id : Id ? prim : Prim
        [not (IsGroup (prim, an_feat1`'Group))];
      an_proc_name3 [an_gates] (IdNum (id), n2)
    )

    where

    process an_proc_name2 [an_gates] (an_comb_pars) : an_proc_res :=
      an_nrm_gate ? id : Id ? prim : Prim
        [IsId (id, n1) or IsId (id, n2)];
      comb_call(an_proc_name2)
    []
      any_res
    endproc (* an_proc_name2 *)

    process an_proc_name3 [an_gates] (an_comb_pars) : an_proc_res :=
      (
        `$1'
      `>> accept n1`,' n2 : Num, res : Result in'
        comb_call(an_proc_name1)
      )
    []
      an_nrm_gate ? id : Id ? prim : Prim
        [not (IsGroup (prim, an_feat1`'Group))];
      comb_call(an_proc_name3)
    []
      any_res')
    endproc (* an_proc_name3 *)

  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')')

# "loops(beh)" produces a process definition and process instantiation for
# behaviour "beh" to repeat indefinitely

define(loops,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_func1',
      `func_of(`$1')')ifelse(an_func1,,
	`rep_err(Cannot loop with unknown result for an_feat1)',
	  an_func1,noexit,
	    `rep_err(Cannot loop with non-exit result for an_feat1)',
	      `define(`an_proc_name1',
		next_no(Loops))add_num_pars(
		  `$1')define(`an_proc_res',
		    noexit)add_proc_attrs(an_proc_name1,
		      noexit)file_save(an_comb_file,
`  '(* group_name(`an_feat1') repeats indefinitely *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    `$1'
  ``>> accept proc_pars_of($1) : Num, res : Result in''
    comb_call(an_proc_name1)
  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')')

# "offers(beh1,beh2,beh3,beh4,beh5)" produces a process instantiation
# and accumulated process definition for behaviour "beh1" or behaviour "beh2",
# ...

define(offers,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_feat2',
      `feat_of(`$2')')define(`an_feat3',
	`feat_of(`$3')')define(`an_feat4',
	  `feat_of(`$4')')define(`an_feat5',
	    `feat_of(`$5')')define(`an_proc_name1',
	      next_no(Offers))add_num_pars(`$1')add_num_pars(
	        `$2')add_num_pars(`$3')add_num_pars(`$4')add_num_pars(
		  `$5')define(`an_proc_res',
		    `func_max_of(func_of(`$1'),func_of(`$2'),
		      func_of(`$3'),func_of(`$4'),
		        func_of(`$5'))')add_proc_attrs(an_proc_name1,
			  `exit_of(an_proc_res)')file_save(an_comb_file,
`  '(* choice of group_name(`an_feat1'), group_name(`an_feat2')`'ifelse(`$3',,,
  `, _`'an_feat3`'_`'ifelse(`$4',,,
    `, _`'an_feat4`'_`'ifelse(`$5',,,
      `, _`'an_feat5`'_')')') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    proc_call(`$1')
  []
    proc_call(`$2')`'ifelse(`$3',,,`
  []
    proc_call(`$3')`'ifelse(`$4',,,`
  []
    proc_call(`$4')`'ifelse(`$5',,,`
  []
    proc_call(`$5')')')')
  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')

# "overtakes(beh1,beh2)" produces a process definition and process
# instantiation for behaviour "beh1" (which must be a feature) to possibly
# overtake behaviour "beh2"

define(overtakes,
  `define(`an_proc_name1',
    next_no(Overtakes))define(`an_proc_name2',
      an_proc_name1`'Aux)file_save(an_comb_file,
`  '(* proc_of(`$1') may possibly overtake proc_of(`$2') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : exit :=
ifelse(is_feat(`$1'),0,
`    stop		(*** "proc_of(`$1')" is not one of the features ***)
  endproc (* an_proc_name2 *)',
  define(`group1',substr(`$1',0,ind))`    '(```'''
      `$1'
    |||
      `$2'
    )
  |[an_nrm_gate]|
    an_proc_name2 [an_gates] (an_comb_pars, <<>>)

  where

    process an_proc_name2 [an_gates]
     (an_comb_pars, primq : PrimQueue) : exit :=
      gate ! id1 ? prim1 : Prim;
      (```'''
        [IsReq (prim1)] ->
	  an_proc_name2 [an_gates] (an_comb_pars, prim1 + primq)
      []
        [not (IsReq (prim1))] ->
	  an_proc_name2 [an_gates] (an_comb_pars, primq)
      )
    []
      gate ! id2 ? prim2 : Prim
       [IsInd (prim2) implies IsAheadQueue (prim2, primq)];
      (```'''
        [IsInd (prim2)] ->
	  an_proc_name2 [an_gates] (an_comb_pars, RemPrev (prim2, primq))
      []
        [not (IsInd (prim2))] ->
	  an_proc_name2 [an_gates] (an_comb_pars, primq)
      )
    endproc (* an_proc_name2 *)

  endproc (* an_proc_name1 *))
)comb_inst(an_proc_name1)')

# "reverses(beh)" produces a process instantiation for behaviour "beh" in
# the opposite direction

define(reverses,
  `gate_num_swap(`$1')')

# "unique_ids(group1,group2,beh)" produces a process definition and process
# instantiation for behaviour "beh" that ensures unique use of ids for
# service primitives "group1" that start associations and service primitives
# "group2" that end them; the following assumes unconfirmed behaviour for
# "group2", but should take account of different patterns

define(unique_ids,
  `define(`an_proc_name1',
    next_no(UniqueIds))file_save(an_comb_file,
`  '(* in proc_of(`$3'), ids are uniquely assigned/released by `$1'/`$2' *)

  process an_proc_name1 [an_gates] (usedids : IdSet) : noexit :=
    g ? id : Id ? prim : Prim
     [(IsGroup (prim, `$1') and (IsReq (prim) or IsInd (prim))) implies
      (id NotIn usedids)];
    (``''
      [IsGroup (prim, `$1')] ->
        an_proc_name1 [an_gates] (Insert (id, usedids))
    []
      [not (IsGroup (prim, `$1') or IsGroup (prim, `$2'))] ->
        an_proc_name1 [an_gates] (usedids)
    []
      [IsGroup (prim, `$2')] ->
        an_proc_name1 [an_gates] (Remove (id, usedids))
    )
  endproc (* an_proc_name1 *)
)`$3'
|[an_nrm_gate]|
  an_proc_name1 [an_gates] ({})')

# "withholds(group,beh)" produces a process definition and process
# instantiation for behaviour "beh" that may temporarily be refused

define(withholds,
  `define(`an_proc_name1',
    next_no(Withholds))file_save(an_comb_file,
`  '(* a `$1' may temporarily not be allowed *)

  process an_proc_name1 [an_gates] : noexit :=
    choice ids : IdSet []	(* choose id set allowing activity *)
      gate ? id : Id ? prim : Prim
       [(IsReq (prim) and IsGroup (prim, `$1')) implies (id IsIn ids)];
      an_proc_name1 [an_gates]
    []
      i;			(* revise id set allowing activity *)
      an_proc_name1 [an_gates]
  endproc (* an_proc_name1 *)
)`$2'
|[an_nrm_gate]|
  an_proc_name1 [an_gates]')
