################################### Header ###################################

# "anise_comb_tel.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	21/08/98

# This "m4" macro file contains templates for generating Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.

# This particular file contains macros for telephony feature combinators.

# Copyright 1998 K. J. Turner, University of Stirling

######################### Context-Dependent Macros #########################

# "an_dials" gives the number translation expression for "dials"

define(an_dials,
  `NumOf (prim)')

# "an_rings" gives the called message check for "rings" using global values
# "an_rings_pref", "an_rings_disp" and "an_rings_screen"

define(an_rings,
  `((CalledTypeOf (CalledMessOf (prim)) eq CallWaitTone) or
            (an_rings_pref and
		an_rings_disp))`'an_rings_screen')

# "an_rings_disp" gives the called message check for caller display

define(an_rings_disp,
  `(CalledNumOf (CalledMessOf (prim)) eq NoNum)')

# "an_rings_pref" gives the called message check for ring preference

define(an_rings_pref,
  `(CalledTypeOf (CalledMessOf (prim)) eq NormRing)')

# "an_rings_screen" gives the calling number check for terminating call
# screening

define(an_rings_screen,
  `')

# "checks_busy_answer" defines the "checks_busy" action when the caller is
# told that the call has been answered (Answer.Ind)

define(checks_busy_answer,
  `an_proc_name2 [an_gates]
	   (IdAssocAdd (id, Calls), NoWaits, Dials, Returns)')

# "checks_busy_assoc" defines the "checks_busy" action to determine the
# associated number (Dial.Req)

define(checks_busy_assoc,
  `IdAssocNum (n2, Calls)')

# "checks_busy_conds" adds the negated conditions that may be defined by
# "checks_busy_return" ("returns_manual") and "checks_busy_wait"
# ("waits_call")

define(checks_busy_conds,
  `define(`an_cnd',
    `cond_of(checks_busy_return)')ifelse(an_cnd,false,,
      ` and
	 not (an_cnd)')define(`an_cnd',
        `cond_of(checks_busy_wait)')ifelse(an_cnd,false,,
          ` and
	 not (an_cnd)')')

# "checks_busy_dial" defines the "checks_busy" parameter that
# selects "Dials/NewDials" if "checks_busy_return" employs the
# "returns_manual" check for selecting digit 5

define(checks_busy_dial,
  `ifelse(index(checks_busy_return,`DigOf (prim) eq 5'),-1,
    Dials,
    NewDials)')

# "checks_busy_endwait" defines the "checks_busy" action to handle hangup
# during call waiting (OnHook.Req or StopRing.Ind)

define(checks_busy_endwait,
  `')

# "checks_busy_engaged" defines the "checks_busy" action when the called
# number is engaged

define(checks_busy_engaged,
  `an_proc_name2 [an_gates] (Calls, NoWaits, checks_busy_dial, Returns)')

# "checks_busy_hangup" defines the "checks_busy" action when a line becomes
# free (OffHook.Req or StopRing.Ind)

define(checks_busy_hangup,
  `an_proc_name2 [an_gates] (IdAssocRem (id, Calls),
	      NoWaits, Dials, Returns)')

# "checks_busy_return" defines the "checks_busy" action to handle manual
# ring-back (Select.Req)

define(checks_busy_return,
  `')

# "checks_busy_ring" defines the "checks_busy" condition on ringing the
# called (StartRing.Ind)

define(checks_busy_ring,
  `')

# "checks_busy_rung" defines the "checks_busy" action after the called has
# been rung (StartRing.Ind)

define(checks_busy_rung,
  `an_proc_name2 [an_gates]
	   (IdAssocAdd (id, Calls), NoWaits, Dials, Returns)')

# "checks_busy_seize" defines the "checks_busy" action when a line is
# seized (OffHook.Req)

define(checks_busy_seize,
  `an_proc_name2 [an_gates]
	   (IdAssocAdd (id, Calls), NoWaits, Dials, Returns)')

# "checks_busy_wait" defines the "checks_busy" action to handle call waiting
# control (Select.Req)

define(checks_busy_wait,
  `')

############################ Combination Processes ###########################

# "checks_busy(beh)" maintains global associations between numbers; its action
# on busy, free and primitives is described by separate macros
# "checks_busy_seize", "checks_busy_free" and "checks_busy_prim"

define(checks_busy,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_func',
      `noexit')define(`an_proc_name1',
        next_no(ChecksBusy))define(`an_proc_name2',
	  an_proc_name1`'an_lab1)define(`an_proc_res',
	    `an_func')add_proc_attrs(an_proc_name1,
	      `exit_of(an_proc_res)')file_save(an_comb_file,
`  '(* monitors line busy/free in group_name(`an_feat1') *)

  process an_proc_name1 [an_gates] : an_proc_res :=
    `$1'
  ||
    an_proc_name2 [an_gates]
     (<> of IdAssocs, <> of IdAssocs, <> of NumAssocs, <> of NumAssocs)

    where

    process an_proc_name2 [an_gates]
     (Calls, NoWaits : IdAssocs, Dials, Returns : NumAssocs) : noexit :=
      an_nrm_gate ? id : Id ? prim : Prim
        [(IsKind (prim, OffHookReqKind) implies IdAssocAvail (id, Calls))`'checks_busy_ring];
      (
        [IsKind (prim, OffHookReqKind)] ->
	  checks_busy_seize
      []
        [IsKind (prim, AnswerIndKind)] ->
	  checks_busy_answer
      []
        [IsKind (prim, StartRingIndKind)] ->
	  checks_busy_rung
      []
        [IsKind (prim, OnHookReqKind) or IsKind (prim, StopRingIndKind)] ->
	  (
	    checks_busy_endwait`'checks_busy_hangup
	  )
      []checks_busy_return`'checks_busy_wait
        [not (IsKind (prim, OffHookReqKind) or
	 IsKind (prim, AnswerIndKind) or
	 IsKind (prim, StartRingIndKind) or
	 IsKind (prim, OnHookReqKind) or
	 IsKind (prim, StopRingIndKind))checks_busy_conds] ->
	  an_proc_name2 [an_gates] (Calls, NoWaits, Dials, Returns)
      )
    []
      `an_ctl_gate ! CtlDial ? n1`,' n2 : Num;'
      (
        let
	 n2`'an_lab1 : Num = checks_busy_assoc,
	 NewDials : NumAssocs = NumAssocLink (n1, n2, Dials) in
	  ctl ! CtlDial ! n1 ! n2`'an_lab1;
	  (
	    [IsHeld (n2`'an_lab1)] ->
	      checks_busy_engaged
	  []
	    [not (IsHeld (n2`'an_lab1))] ->
	      an_proc_name2 [an_gates] (IdAssocLink (NumId (n1),
	        NumId (n2`'an_lab1), Calls), NoWaits, checks_busy_dial, Returns)
	  )
      )
    endproc (* an_proc_name2 *)

  endproc (* an_proc_name1 *)
)an_proc_name1 [an_gates]')

# "dials(beh)" produces a process definition and process instantiation
# that fixes the second number according to the state of the number called in
# behaviour "beh"

define(dials,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_prop',
      prop_of(`$1'))define(`an_patt',
	patt_of(`$1'))ifelse(an_prop,single,
	  `ifelse(
	    an_patt,provider_initiated,`$1',
	    an_patt,remote_confirmed,`$1',
	    an_patt,user_initiated,`$1',
	      `define(`an_proc_name1',
		next_no(Dials))define(`an_proc_name2',
		  an_proc_name1`'an_lab1)add_num_pars(
		    `$1')define(`an_proc_res',
		      an_exit_func)add_proc_attrs(an_proc_name1,
			exit)file_save(an_comb_file,
`  '(* called number in group_name(`an_feat1') fixes called party *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    (
      `$1'
    ``>> accept proc_pars_of(`$1') : Num, res : Result in''
      exit (n1, any Num, res)
    )
  |[an_nrm_gate]|
    an_proc_name2 [an_gates] (proc_pars_of(`$1'))

    where

    process an_proc_name2 [an_gates] (an_comb_pars) : an_proc_res :=
      an_nrm_gate ? id1 : Id ? prim : Prim
        [IsCon (prim) implies IsCallingMess (n2, CallingMessOf (prim))];
      (
	[IsReq (prim)] ->
	  an_ctl_gate ! CtlDial ! n1 ! an_dials;
	  an_ctl_gate ! CtlDial ? n1`,' n2 : Num;
	  an_proc_name2 [an_gates] (IdNum (id1, n1), n2)
      []
	[not (IsReq (prim))] ->
	  an_proc_name2 [an_gates] (IdNum (id1, n1), n2)
      )
    []
      exit (any Num, n2, any Result)
    endproc (* an_proc_name2 *)

  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')',
  `rep_err(Cannot dial with an_prop property)')')

# "dials_code(beh)" modifies the number translation expression in
# global "an_dials" to expand abbreviated numbers, assuming "n1" is the
# calling number

define(dials_code,
  `define(`an_dials',`ProfCallAbbr (n1,
	      'an_dials`, Profiles)')`$1'')

# "dials_one(beh)" modifies the number translation expression in global
# "an_dials" to call one-numbers

define(dials_one,
  `define(`an_dials',`ProfCallOne (
	      'an_dials`, Profiles)')`$1'')

# "diverts_always(beh)" modifies the number translation expression in global
# "an_dials" to handle unconditional diversion

define(diverts_always,
  `define(`an_dials',`ProfFwdUncond (
	      'an_dials`, Profiles)')`$1'')

# "diverts_busy(beh)" handle diversion on busy by modifying busy number
# handling in global "checks_busy_assoc"

define(diverts_busy,
  `define(`checks_busy_assoc',
    ifelse(index(checks_busy_assoc,IdAssocNum),-1,
      `define(`an_ind_cb',
	index(checks_busy_assoc,n2))ifelse(an_ind_cb,-1,
	  `rep_err(Internal error - busy association inconsistent)',
	  `substr(checks_busy_assoc,0,
	    an_ind_cb)
	   UnHeld (ProfFwdBusy (n2, Calls, Profiles))substr(
	     checks_busy_assoc,eval(an_ind_cb+2))')',
      ProfFwdBusy (n2, Calls, Profiles)))`$1'')

# "returns_automatic(proc,beh)" produces a process definition and process
# instantiation that handles ring-back (if not already defined for behaviour
# "beh"). It deals with automatic ring-back that invokes ring-back process
# "proc" by modifying busy number handling in global
# "checks_busy_engaged", and modifying hangup handling in global
# checks_busy_hangup".

define(returns_automatic,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_feat2',
      `feat_of(`$2')')define(`an_func',
	`noexit')define(`an_proc_name1',
	  next_no(RingsBack))define(`an_proc_name2',
	    an_proc_name1`'an_lab1)define(`an_proc_res',
	      `an_func')add_proc_attrs(an_proc_name1,
		`exit_of(an_proc_res)')ifelse(index(`$2',RingsBack),-1,
		  `file_save(an_comb_file,
`  '(* allows ring-back in group_name(`an_feat2') *)

  process an_proc_name1 [an_gates] : an_proc_res :=
      `$2'
    |||
      an_proc_name2 [an_gates]

    where

    process an_proc_name2 [an_gates] : noexit :=
      `an_ctl_gate ! CtlReturn ? n1`,' n2 : Num;'
      (
        `$1'
      |||
        an_proc_name2 [an_gates]
      )
    endproc (* an_proc_name2 *)

  endproc (* an_proc_name1 *)
)an_proc_name1 [an_gates]define(`an_num_pars',
  `n1| n2')',`$2')define(`checks_busy_engaged',
	     `(
	        [ProfCallBack (n1, Profiles) and
		 (ProfCallScrIn (n1, n2, Profiles) ne NoNum)] ->
		  an_proc_name2 [an_gates]
		   (Calls, NoWaits, checks_busy_dial, NumAssocLink (n1, n2, Returns))
	      []
		[not (ProfCallBack (n1, Profiles)) or
		 (ProfCallScrIn (n1, n2, Profiles) eq NoNum)] ->
		  an_proc_name2 [an_gates] (Calls, NoWaits, checks_busy_dial, Returns)
	      )')define(`checks_busy_hangup',
        `(
	      let
		id2 : Id = NumAssocId (id, Returns),
		NewCalls : IdAssocs = IdAssocRem (id, Calls) in
		let
		  n1`'an_lab1 : Num = IdNum (id),
		  n1`'an_lab2 : Num = IdNum (id2) in
		  let
		    n2`'an_lab1 : Num = NumAssocNum (n1`'an_lab1, Returns),
		    n2`'an_lab2 : Num = NumAssocNum (n1`'an_lab2, Returns) in
		    [((n2`'an_lab1 ne NoNum) or (n2`'an_lab2 ne NoNum)) and
		      IdAssocAvail (id2, Calls)] ->
		      (
			[n2`'an_lab1 ne NoNum] ->
			  an_ctl_gate ! CtlReturn ! n1`'an_lab1 ! n2`'an_lab1;
			  an_proc_name2 [an_gates] (IdAssocAdd (id2,
			    IdAssocAdd (id, NewCalls)), NoWaits, Dials,
			      NumAssocUnlink (n1`'an_lab1, n1`'an_lab2, Returns))
		      []
			[n2`'an_lab2 ne NoNum] ->
			  an_ctl_gate ! CtlReturn ! n1`'an_lab2 ! n2`'an_lab2;
			  an_proc_name2 [an_gates] (IdAssocAdd (id2,
			    IdAssocAdd (id, NewCalls)), NoWaits, Dials,
			      NumAssocUnlink (n1`'an_lab2, n1`'an_lab2, Returns))
		      )
		  []
		    [((n2`'an_lab1 eq NoNum) and (n2`'an_lab2 eq NoNum)) or
		      not (IdAssocAvail (id2, Calls))] ->
		      an_proc_name2 [an_gates] (NewCalls,
		        NoWaits, Dials, Returns)
	    )')')

# "returns_manual(proc,beh)" produces a process definition and process
# instantiation that handles ring-back (if not already defined for behaviour
# "beh"). It deals with manual ring-back that invokes ring-back process "proc"
# by modifying hangup handling in global "checks_busy_hangup", and adding
# select handling in global "checks_busy_select"

define(returns_manual,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_feat2',
      `feat_of(`$2')')define(`an_func',
	`noexit')define(`an_proc_name1',
	  next_no(RingsBack))define(`an_proc_name2',
	    an_proc_name1`'an_lab1)define(`an_proc_res',
	      `an_func')add_proc_attrs(an_proc_name1,
		`exit_of(an_proc_res)')ifelse(index(`$2',RingsBack),-1,
		  `file_save(an_comb_file,
`  '(* allows ring-back in group_name(`an_feat2') *)

  process an_proc_name1 [an_gates] : an_proc_res :=
      `$2'
    |||
      an_proc_name2 [an_gates]

    where

    process an_proc_name2 [an_gates] : noexit :=
      `an_ctl_gate ! CtlReturn ? n1`,' n2 : Num;'
      (
        `$1'
      |||
        an_proc_name2 [an_gates]
      )
    endproc (* an_proc_name2 *)

  endproc (* an_proc_name1 *)
)an_proc_name1 [an_gates]define(`an_num_pars',
  `n1| n2')',`$2')define(`checks_busy_hangup',
        `(
	      let
		id2 : Id = NumAssocId (id, Returns),
		NewCalls : IdAssocs = IdAssocRem (id, Calls) in
		let
		  n1`'an_lab1 : Num = IdNum (id),
		  n1`'an_lab2 : Num = IdNum (id2) in
		  let
		    n2`'an_lab1 : Num = NumAssocNum (n1`'an_lab1, Returns),
		    n2`'an_lab2 : Num = NumAssocNum (n1`'an_lab2, Returns) in
		    [((n2`'an_lab1 ne NoNum) or (n2`'an_lab2 ne NoNum)) and
		      IdAssocAvail (id2, Calls)] ->
		      (
			[n2`'an_lab1 ne NoNum] ->
			  an_ctl_gate ! CtlReturn ! n1`'an_lab1 ! n2`'an_lab1;
			  an_proc_name2 [an_gates] (IdAssocAdd (id2,
			    IdAssocAdd (id, NewCalls)), NoWaits, Dials,
			      NumAssocUnlink (n1`'an_lab1, n1`'an_lab2, Returns))
		      []
			[n2`'an_lab2 ne NoNum] ->
			  an_ctl_gate ! CtlReturn ! n1`'an_lab2 ! n2`'an_lab2;
			  an_proc_name2 [an_gates] (IdAssocAdd (id2,
			    IdAssocAdd (id, NewCalls)), NoWaits, Dials,
			      NumAssocUnlink (n1`'an_lab2, n1`'an_lab2, Returns))
		      )
		  []
		    [((n2`'an_lab1 eq NoNum) and (n2`'an_lab2 eq NoNum)) or
		      not (IdAssocAvail (id2, Calls))] ->
		      an_proc_name2 [an_gates] (NewCalls,
		        NoWaits, Dials, Returns)
	    )')define(`checks_busy_return',`
        [IsKind (prim, SelectReqKind) and (DigOf (prim) eq 5)] ->
	  (
	    let n1 : Num = IdNum (id) in
	      let n2 : Num = NumAssocNum (n1, Dials) in
		let id2 : Id = NumId (n2) in
		  [(id2 ne id) and
		   (ProfCallScrIn (n1, n2, Profiles) ne NoNum)] ->
		    an_proc_name2 [an_gates]
		      (Calls, NoWaits, Dials, NumAssocLink (n1, n2, Returns))
		[]
		  [(id2 eq id) or
		   (ProfCallScrIn (n1, n2, Profiles) eq NoNum)] ->
		    an_proc_name2 [an_gates] (Calls, NoWaits, Dials, Returns)
	  )
      []')')

# "rings(beh)" produces a process definition and process instantiation
# that fixes the called message in behaviour "beh"

define(rings,
  `define(`an_feat',
    `feat_of(`$1')')define(`an_patt',
	`patt_of(`$1')')define(`an_prop',
          `prop_of(`$1')')ifelse(an_prop,single,
	    `ifelse(
	      an_patt,local_confirmed,
	        `rep_err(
		  Cannot have ring for user-initiated pattern)',
	      an_patt,user_initiated,
	        `rep_err(
		  Cannot have ring for user-initiated pattern)',
	      `define(`an_proc_name1',
		next_no(Rings))define(`an_proc_name2',
		  an_proc_name1`'an_lab1)add_num_pars(
		    `$1')define(`an_proc_res',
		      an_exit_func)add_proc_attrs(an_proc_name1,
		        exit)file_save(an_comb_file,
`  '(* called message in _`'an_feat`'_ is constrained *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    proc_call(`$1')
  ||
    an_proc_name2 [an_nrm_gate``,'' an_ctl_gate] (proc_pars_of(`$1'))

    where

    process an_proc_name2 [an_gates] (n1, n2 : Num) : an_proc_res :=
      an_nrm_gate ? id2 : Id ? prim : Prim
        [(IsInd (prim) and IsId (id2, n2)) implies
          (an_rings)];
      an_proc_name2 [an_gates] (n1, n2)
    []
      any_res
    endproc (* an_proc_name2 *)

  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')',
  `rep_err(Cannot have ring for an_prop property)')')

# "rings_display(beh)" modifies the number check in global "an_rings_disp" to
# check that the caller's number is supplied if calling number display has
# been selected in the profile

define(rings_display,
  `define(`an_rings_disp',
    `IsCalledNum (n1, ProfCallRing (n2, Profiles),
		  CalledMessOf (prim))')`$1'')

# "rings_preference(beh)" modifies the called message check in global
# "an_rings_pref" to check that the ring preference is supplied if distinctive
# ring has been selected in the profile

define(rings_preference,
  `define(`an_rings_pref',
    `IsCalledMess (ProfCallRing (n2, Profiles),
	      CalledMessOf (prim))')`$1'')

# "screens_in(beh)" modifies the calling number check in global
# "an_rings_screen" to screen out numbers according to the profile

define(screens_in,
  `define(`an_rings_screen',` and
		    (ProfCallScrIn (n2, n1, Profiles) ne NoNum)')`$1'')

# "screens_out(beh)" modifies the number translation expression in global
# "an_dials" to screen outgoing calls, assuming "n1" is the calling number

define(screens_out,
  `define(`an_dials',`ProfCallScrOut (n1,
	      'an_dials`, Profiles)')`$1'')

# "waits(beh1, beh2)" starts as normal behaviour "beh2", and may resume this
# on signal "CtlNormal"; (re-)enters behaviour "beh1" on signal "CtlWaiting"

define(waits,
  `define(`an_feat1',
    `feat_of(`$1')')define(`an_feat2',
      `feat_of(`$2')')define(`an_proc_name1',
	next_no(Waits))define(`an_proc_name2',
	  an_proc_name1`'an_lab1)define(`an_proc_name3',
	    an_proc_name1`'an_lab2)define(`an_proc_name4',
	      an_proc_name1`'an_lab1`'an_lab2)add_num_pars(
		`$1')define(`an_proc_res',
		`func_max_of(func_of(`$1'),
		  func_of(`$2'))')add_proc_attrs(an_proc_name1,
		    `exit_of(an_proc_res)')file_save(an_comb_file,
`  '(* normal behaviour group_name(`an_feat2') may enter waiting behaviour group_name(`an_feat1') *)

  process an_proc_name1 [an_gates] (an_comb_pars) : an_proc_res :=
    `$2'
  [>
    (
      an_ctl_gate ! CtlNormal ! n1;
      comb_call(an_proc_name1)
    []
      an_ctl_gate ! CtlNormal ! n2;
      comb_call(an_proc_name1)
    []
      an_ctl_gate ! CtlWaiting ! n1;
      comb_call(an_proc_name2)
    []
      an_ctl_gate ! CtlWaiting ! n2;
      comb_call(an_proc_name3)
    )

    where

    (* first number is in call waiting *)
    
    process an_proc_name2 [an_gates] (an_comb_pars) : an_proc_res :=
      `$1'
    [>
      (
	an_ctl_gate ! CtlNormal ! n1;
	comb_call(an_proc_name1)
      []
	an_ctl_gate ! CtlNormal ! n2;
	comb_call(an_proc_name2)
      []
	an_ctl_gate ! CtlWaiting ! n1;
	comb_call(an_proc_name2)
      []
	an_ctl_gate ! CtlWaiting ! n2;
	comb_call(an_proc_name4)
      )
    endproc (* an_proc_name2 *)

    (* second number is in call waiting *)
    
    process an_proc_name3 [an_gates] (an_comb_pars) : an_proc_res :=
      num_swap(`$1')
    [>
      (
	an_ctl_gate ! CtlNormal ! n1;
	comb_call(an_proc_name3)
      []
	an_ctl_gate ! CtlNormal ! n2;
	comb_call(an_proc_name1)
      []
	an_ctl_gate ! CtlWaiting ! n1;
	comb_call(an_proc_name4)
      []
	an_ctl_gate ! CtlWaiting ! n2;
	comb_call(an_proc_name3)
      )
    endproc (* an_proc_name3 *)

    (* first and second numbers are in call waiting *)
    
    process an_proc_name4 [an_gates] (an_comb_pars) : an_proc_res :=
      (
        `$1'
      |||
        num_swap(`$1')
      )
    [>
      (
	an_ctl_gate ! CtlNormal ! n1;
	comb_call(an_proc_name2)
      []
	an_ctl_gate ! CtlNormal ! n2;
	comb_call(an_proc_name3)
      []
	an_ctl_gate ! CtlWaiting ! n1;
	comb_call(an_proc_name4)
      []
	an_ctl_gate ! CtlWaiting ! n2;
	comb_call(an_proc_name4)
      )
    endproc (* an_proc_name4 *)

  endproc (* an_proc_name1 *)
)comb_inst(an_proc_name1)')

# "waits_call(beh)" deals with call waiting by modifying answer handling in
# global "checks_busy_answer", modifying busy number handling in global
# "checks_busy_assoc", modifying hangup handling in global
# "checks_busy_endwait", modifying ring condition in global
# "checks_busy_ring", modifying ring handling in global "checks_busy_rung",
# and adding select handling in global "checks_busy_select"

define(waits_call,
  `define(`checks_busy_answer',
    `(
	    let NewCalls : IdAssocs =
	     IdAssocAdd (IdAssocId (id, Calls), Calls) in
	      [IdAssocPeer (id, NewCalls) ne NoId] ->
		ctl ! CtlWaiting ! IdNum (id);
		an_proc_name2 [an_gates] (NewCalls, NoWaits, Dials, Returns)
	    []
	      [IdAssocPeer (id, NewCalls) eq NoId] ->
		an_proc_name2 [an_gates] (NewCalls, NoWaits, Dials, Returns)
	  )')define(`checks_busy_assoc',
	      ifelse(index(checks_busy_assoc,IdAssocNum),-1,
		ProfAssocNum (
	   UnHeld (checks_busy_assoc), Calls, NoWaits),
		ProfAssocNum (n2, Calls, NoWaits)))define(
        `checks_busy_endwait',
      `(
	      [IdAssocComm (id, Calls)] ->
		ctl ! CtlNormal ! IdNum (IdAssocSecond (id, Calls));
		exit (NoWaits)
	    []
	      [IdAssocPeer (id, Calls) ne NoId] ->
		ctl ! CtlNormal ! IdNum (IdAssocPeer (id, Calls));
		exit (NoWaits)
	    []
	      [IdAssocStop (id, Calls)] ->
		ctl ! CtlNormal ! IdNum (IdAssocFirst (id, Calls));
		exit (NoWaits)
	    []
	      [not (IdAssocComm (id, Calls)) and
		(IdAssocPeer (id, Calls) eq NoId) and
		  not (IdAssocStop (id, Calls))] ->
		exit (IdAssocRem (id, NoWaits))
	    )
	  >> accept NoWaits : IdAssocs in
	    ')define(`checks_busy_ring',
  ` and
	  (IsKind (prim, StartRingIndKind) implies
	    ((IdAssocSecond (id, Calls) ne NoId) eq
	      (CalledMessOf (prim) eq CallWaitTone)))')define(
        `checks_busy_rung',
        `(
	    [CalledMessOf (prim) eq CallWaitTone] ->
	      ctl ! CtlWaiting ! IdNum (IdAssocId (id, Calls));
	      an_proc_name2 [an_gates] (Calls, NoWaits, Dials, Returns)
	  []
	    [CalledMessOf (prim) ne CallWaitTone] ->
	      an_proc_name2 [an_gates] (IdAssocAdd (id, Calls),
	        NoWaits, Dials, Returns)
	  )')define(`checks_busy_wait',`
        [IsKind (prim, SelectReqKind) and
	  ((DigOf (prim) eq 0) or (DigOf (prim) eq 2))] ->
	  (
	    let id2 : Id = IdAssocSecond (id, Calls) in
	      [(id2 ne NoId) and (DigOf (prim) eq 0)] ->
		an_proc_name2 [an_gates] (Calls,
		  IdAssocAdd (id, NoWaits), Dials, Returns)
	    []
	      [(id2 ne NoId) and (DigOf (prim) eq 2)] ->
		(
		  [IdAssocPeer (IdAssocFirst (id, Calls), Calls) ne NoId] ->
		    ctl ! CtlWaiting ! IdNum (id2);
		    an_proc_name2 [an_gates] (IdAssocSwap (id, Calls),
		      NoWaits, Dials, Returns)
		[]
		  [IdAssocPeer (IdAssocFirst (id, Calls), Calls) eq NoId] ->
		    an_proc_name2 [an_gates] (IdAssocSwap (id, Calls),
		      NoWaits, Dials, Returns)
		)
	    []
	      [id2 eq NoId] ->
		an_proc_name2 [an_gates] (Calls, NoWaits, Dials, Returns)
	  )
      []')`$1'')
