################################### Header ###################################

# "anise_feat.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	12/08/98

# This "m4" macro file contains templates for generating Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.

# This particular file contains macros for feature processes.

# Copyright 1998 K. J. Turner, University of Stirling

########################### Generic Feature Macros ###########################

# "add_feat_attrs(proc,dir,patt,prop,group1,group2)" adds feature attributes
# to global "an_feat_attrs" as an internal list

define(add_feat_attrs,
  `define(`an_feat_attrs',[$1|$2|$3|$4|$5|$6]`'an_feat_attrs)')

# "an_feat_attrs" contains the current list of feature attributes as a list
# containing "<process direction pattern property group1 group2 >"

define(an_feat_attrs,
  `')

# "an_feat_file" gives the temporary filename used for feature processes

define(an_feat_file,
  maketemp(/tmp/featXXXXXX))

# "dir_of(beh)" returns the direction of "beh" if it is a feature, else a
# null string

define(dir_of,
  `define(`an_ind',`index(an_feat_attrs,[proc_of($1)|)')ifelse(an_ind,-1,,
    `get_word(substr(an_feat_attrs,an_ind),1)')')

# "feat_call(feat)" instantiates combinator process "feat"

define(feat_call,
  `$1 [an_nrm_gate``,'' an_nrm_gate] (extrn_of(an_num_pars))')

# "feat_dir(dir)" sets "an_g1"/"an_g2", "an_n1"/"an_n2" and "an_id1"/an_id2"
# according to the direction (12 or 21)

define(feat_dir,
  `ifelse(
    $1,12,`define(`an_g1',g1)define(`an_g2',g2)define(`an_n1',
      n1)define(`an_n2',n2)define(`an_id1',id1)define(`an_id2',id2)',
    $1,21,`define(`an_g1',g2)define(`an_g2',g1)define(`an_n1',
      n2)define(`an_n2',n1)define(`an_id1',id2)define(`an_id2',id1)',
    `rep_err(Direction $1 invalid)')')

# "feature(dir,patt,prop,group1,group2)" produces a process definition and
# process instantiation in direction "dir" for pattern "patt"
# (asymmetric_confirmed, local_confirmed, provider_confirmed,
# provider_initiated, remote_confirmed, unconfirmed,
# user_confirmed, user_initiated, user_provider_confirmed), property "prop"
# (consecutive, ordered, reliable, single, unreliable); the service primitive
# group and parameters for a try are given by "an_group1", while those for
# an acknowledgement (if relevant) are given by optional "group2"

define(feature,
  `feat_dir($1)define(`an_group1',
    proc_of($4))define(`an_group2',
      proc_of($5))define(`an_proc_name1',
	next_no(an_group1`'Feat))define(`an_proc_name2',
	  `an_proc_name1`'an_lab1')define(`an_proc_name3',
	    `an_proc_name1`'an_lab2')define(`an_proc_res',
	      noexit)define(`an_call',
	      `feat_`'ifelse(
		$3,consecutive,cons,
		$3,ordered,ord,
		$3,reliable,rel,
		$3,single,`sing`'define(`an_proc_res',`an_exit_func')',
		$3,unreliable,unrel,)')ifelse(an_call,feat_,
		  `rep_err(`Uknown property $3')',
		    `define(`an_call',
		      an_call``_''`ifelse(
			$2,asymmetric_confirmed,asymm_conf,
			$2,local_confirmed,loc_conf,
			$2,provider_confirmed,prov_conf,
			$2,provider_initiated,prov_init,
			$2,remote_confirmed,rem_conf,
			$2,unconfirmed,un_conf,
			$2,user_confirmed,user_conf,
			$2,user_provider_confirmed,userprov_conf,
			$2,user_initiated,user_init,)')ifelse(`an_call',
			  an_call,
			    `rep_err(`Uknown pattern $2')',
			       `add_proc_attrs(an_proc_name1,
			        exit_of(an_proc_res))add_feat_attrs(
				  an_proc_name1,
				    $1,$2,$3,an_group1`'Group,
				    ifelse(an_group2,,-,
				      an_group2`'Group))add_prim_types($2,
					$4,$5)file_save(an_feat_file,
`  '(* _`'an_group1`'_ in direction $1 is $2 and $3 *)

  process an_proc_name1 [g1``,'' g2] (n1, n2 : Num) : an_proc_res :=`'an_call
  endproc (* an_proc_name1 *)
)feat_call(an_proc_name1)')')')

# "group1_of(beh)" returns group 1 for "beh" if it is a feature, else a null
# string

define(group1_of,
  `define(`an_ind_go',`index(an_feat_attrs,
    [proc_of($1)|)')ifelse(an_ind_go,-1,,
      `get_word(substr(an_feat_attrs,an_ind_go),4)')')

# "group2_of(beh)" returns group 2 for "beh" if it is a feature ("-" means no
# group defined), else a null string

define(group2_of,
  `define(`an_ind_go',`index(an_feat_attrs,
    [proc_of($1)|)')ifelse(an_ind_go,-1,,
      `get_word(substr(an_feat_attrs,an_ind_go),5)')')

# "group_next(prim2,prim1)" returns 1 if the primitives were declared to be
# group 2 and group 1 of the same primitive; otherwise 0

define(group_next,
  `ifelse(index(an_feat_attrs,
    group_of($2)`'Group|group_of($1)`'Group),-1,0,1)')

# "group_same(prim2,prim1)" returns 1 if the primitives have the same group;
# otherwise 0

define(group_same,
  `ifelse(group_of($2),group_of($1),1,0)')

# "is_feat(beh)" checks if behaviour "beh" is a feature

define(is_feat,
  `define(`an_ind',`index(an_feat_attrs,[proc_of($1)|)')eval(an_ind != -1)')

# "patt_of(beh)" returns the pattern of "beh" if it is a feature, else a
# question mark

define(patt_of,
  `define(`an_ind',`index(an_feat_attrs,[proc_of($1)|)')ifelse(an_ind,-1,?,
    `get_word(substr(an_feat_attrs,an_ind),2)')')

# "prop_of(beh)" returns the property of "beh" if it is a feature, else a
# question mark

define(prop_of,
  `define(`an_ind',`index(an_feat_attrs,[proc_of($1)|)')ifelse(an_ind,-1,?,
    `get_word(substr(an_feat_attrs,an_ind),3)')')

####################### Consecutive Feature Processes #######################

# "feat_cons_asymm_conf" describes a consecutive asymmetric-confirmed feature

define(feat_cons_asymm_conf,`
    an_an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g2 ? an_id2 : Id ? prim2 : Prim
      [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
    an_g2 ! an_id2 ? prim3 : Prim
      [IsNextPrim (prim3, prim2)];
    an_proc_name1 [g1] (IdNum (id1, n1), IdNum (id2, n2))')

# "feat_cons_loc_conf" describes a consecutive local-confirmed feature

define(feat_cons_loc_conf,`
    an_an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g1 ! an_id1 ? prim2 : Prim
      [IsNextPrim (prim2, prim1)];
    an_proc_name1 [g1] (IdNum (id1, n1), an_n2)')

# "feat_cons_prov_conf" describes a consecutive provider-confirmed feature

define(feat_cons_prov_conf,`
    an_an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g2 ? an_id2 : Id ? prim2 : Prim
      [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
    an_g1 ! an_id1 ? prim3 : Prim
      [IsNextPrim (prim3, prim2)];
    an_proc_name1 [g1] (IdNum (id1, n1), IdNum (id2, n2))')

# "feat_cons_prov_init" describes a consecutive provider-initiated feature

define(feat_cons_prov_init,`
    an_g2 ? an_id2 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'IndKind) and IsId (an_id2, an_n2)];
    an_proc_name1 [g1] (an_n1, IdNum (id2, n2))')

# "feat_cons_rem_conf" describes a consecutive remote-confirmed feature

define(feat_cons_rem_conf,`
    an_g2 ? an_id2 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'IndKind) and IsId (an_id2, an_n2)];
    an_g2 ! an_id2 ? prim2 : Prim
      [IsNextPrim (prim2, prim1)];
    an_proc_name1 [g1] (an_n1, IdNum (id2, n2))')

# "feat_cons_un_conf" describes a consecutive unconfirmed feature

define(feat_cons_un_conf,`
    an_an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g2 ? an_id2 : Id ? prim2 : Prim
      [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
    an_proc_name1 [g1] (IdNum (id1, n1), IdNum (id2, n2))')

# "feat_cons_user_conf" describes a consecutive user-confirmed feature

define(feat_cons_user_conf,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g2 ? an_id2 : Id ? prim2 : Prim
      [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
    an_g2 ! an_id2 ? prim3 : Prim
      [IsNextPrim (prim3, prim2)];
    an_g1 ! an_id1 ? prim4 : Prim
      [IsNextPrim (prim4, prim3)];
    an_proc_name1 [g1] (IdNum (id1, n1), IdNum (id2, n2))')

# "feat_cons_user_init" describes a consecutive user-initiated feature

define(feat_cons_user_init,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_proc_name1 [g1] (IdNum (id1, n1), an_n2)')

# "feat_cons_userprov_conf" describes a consecutive user/provider-confirmed
# feature

define(feat_cons_userprov_conf,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g2 ? an_id2 : Id ? prim2 : Prim
      [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
    (
      an_g2 ! an_id2 ? prim3 : Prim
	[IsNextPrim (prim3, prim2)];
      an_g1 ! an_id1 ? prim4 : Prim
	[IsNextPrim (prim4, prim3)];
      an_proc_name1 [g1] (IdNum (id1, n1), IdNum (id2, n2))
    []
      an_g1 ! an_id1 ? prim4 : Prim
	[IsNextPrim (prim4, prim2)];
      an_g2 ! an_id2 ? prim3 : Prim
	[IsNextPrim (prim3, prim2)];
      an_proc_name1 [g1] (IdNum (id1, n1), IdNum (id2, n2))
    )')

####################### Ordered Feature Processes #######################

# "feat_ord_asymm_conf" describes an ordered asymmetric-confirmed feature

define(feat_ord_asymm_conf,`
    an_proc_name2 [g1`,' g2] (n1, n2)
  ||
    an_proc_name3 [g1`,' g2] (n1, n2, <<>>)

  where

    process an_proc_name2 [g1`,' g2] (n1, n2 : Num) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
      (
	an_g2 ? an_id2 : Id ? prim2 : Prim
	  [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
	an_g2 ! an_id2 ? prim3 : Prim
	  [IsNextPrim (prim3, prim2)];
	stop
      |||
	an_proc_name2 [g1`,' g2] (n1, n2)
      )
    endproc (* an_proc_name2 *)

    process an_proc_name3 [g1`,' g2] (n1, n2 : Num, primq : PrimQueue) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind)];
      an_proc_name3 [g1`,' g2] (IdNum (id1, n1), an_n2, prim1 + primq)
    []
      an_g2 ? an_id2 : Id ? prim2 : Prim
	[IsNextQueue (prim2, primq)];
      (
        [IsRes (prim2)] ->
          an_proc_name3 [g1`,' g2] (an_n1, IdNum (id2, n2), RemPrev (prim2, primq))
      []
        [not (IsRes (prim2))] ->
          an_proc_name3 [g1`,' g2] (an_n1, IdNum (id2, n2), RepPrev (prim2, primq))
      )
    endproc (* an_proc_name3 *)
')

# "feat_ord_loc_conf" describes an ordered local-confirmed feature

define(feat_ord_loc_conf,`
    an_proc_name2 [g1`,' g2] (n1, n2)
  ||
    an_proc_name3 [g1`,' g2] (an_n1, an_n2, <<>>)
  where

    process an_proc_name2 [g1`,' g2] (n1, n2 : Num) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
      (
	an_g1 ! an_id1 ? prim2 : Prim
	  [IsNextPrim (prim2, prim1)];
	stop
      |||
	an_proc_name2 [g1`,' g2] (n1, n2)
      )
    endproc (* an_proc_name2 *)

    process an_proc_name3 [g1`,' g2] (n1, n2 : Num, primq : PrimQueue) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind)];
      an_proc_name3 [g1`,' g2] (IdNum (id1, n1), an_n2, prim1 + primq)
    []
      an_g1 ! an_id1 ? prim2 : Prim
	[IsNextQueue (prim2, primq)];
      an_proc_name3 [g1`,' g2] (an_n1, an_n2, RemPrev (prim2, primq))
    endproc (* an_proc_name3 *)
')

# "feat_ord_prov_conf" describes an ordered provider-confirmed feature

define(feat_ord_prov_conf,`
    an_proc_name2 [g1`,' g2] (n1, n2)
  ||
    an_proc_name3 [g1`,' g2] (an_n1, an_n2, <<>>)
  where

    process an_proc_name2 [g1`,' g2] (n1, n2 : Num) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
      (
	an_g2 ? an_id2 : Id ? prim2 : Prim
	  [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
	an_g2 ! an_id2 ? prim3 : Prim
	  [IsNextPrim (prim3, prim2)];
	stop
      |||
	an_proc_name2 [g1`,' g2] (n1, n2)
      )
    endproc (* an_proc_name2 *)

    process an_proc_name3 [g1`,' g2] (n1, n2 : Num, primq : PrimQueue) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind)];
      an_proc_name3 [g1`,' g2] (IdNum (id1, n1), an_n2, prim1 + primq)
    []
      an_g2 ? an_id2 : Id ? prim2 : Prim
	[IsNextQueue (prim2, primq)];
      (
        [IsCon (prim2)] ->
          an_proc_name3 [g1`,' g2] (an_n1, IdNum (id2, n2), RemPrev (prim2, primq))
      []
        [not (IsCon (prim2))] ->
          an_proc_name3 [g1`,' g2] (an_n1, IdNum (id2, n2), RepPrev (prim2, primq))
      )
    endproc (* an_proc_name3 *)
')

# "feat_ord_prov_init" describes an ordered provider-initiated feature

define(feat_ord_prov_init,`
    an_g2 ? an_id2 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'IndKind) and IsId (an_id2, an_n2)];
    an_proc_name1 [g1`,' g2] (an_n1, IdNum (id2, n2))')

# "feat_ord_rem_conf" describes an ordered remote-confirmed feature

define(feat_ord_rem_conf,`
    an_proc_name2 [g1`,' g2] (n1, n2)
  ||
    an_proc_name3 [g1`,' g2] (an_n1, an_n2, <<>>)
  where

    process an_proc_name2 [g1`,' g2] (n1, n2 : Num) : noexit :=
      an_g2 ? an_id2 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'IndKind) and IsId (an_id2, an_n2)];
      (
	an_g2 ! an_id2 ? prim2 : Prim
	  [IsNextPrim (prim2, prim1)];
	stop
      |||
	an_proc_name2 [g1`,' g2] (n1, n2)
      )
    endproc (* an_proc_name2 *)

    process an_proc_name3 [g1`,' g2] (n1, n2 : Num, primq : PrimQueue) : noexit :=
      an_g2 ? an_id2 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'IndKind)];
      an_proc_name3 [g1`,' g2] (an_n1, IdNum (id2, n2), prim1 + primq)
    []
      an_g2 ? an_id2 : Id ? prim2 : Prim
	[IsNextQueue (prim2, primq)];
      an_proc_name3 [g1`,' g2] (an_n1, an_n2, RemPrev (prim2, primq))
    endproc (* an_proc_name3 *)
')

# "feat_ord_un_conf" describes an ordered unconfirmed feature

define(feat_ord_un_conf,`
    an_proc_name2 [g1`,' g2] (n1, n2)
  ||
    an_proc_name3 [g1`,' g2] (an_n1, an_n2, <<>>)
  where

    process an_proc_name2 [g1`,' g2] (n1, n2 : Num) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
      (
	an_g2 ? an_id2 : Id ? prim2 : Prim
	  [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
	stop
      |||
	an_proc_name2 [g1`,' g2] (n1, n2)
      )
    endproc (* an_proc_name2 *)

    process an_proc_name3 [g1`,' g2] (n1, n2 : Num, primq : PrimQueue) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind)];
      an_proc_name3 [g1`,' g2] (IdNum (id1, n1), an_n2, prim1 + primq)
    []
      an_g2 ? an_id2 : Id ? prim2 : Prim
	[IsNextQueue (prim2, primq)];
      an_proc_name3 [g1`,' g2] (an_n1, IdNum (id2, n2), RemPrev (prim2, primq))
    endproc (* an_proc_name3 *)
')

# "feat_ord_user_conf" describes an ordered user-confirmed feature

define(feat_ord_user_conf,`
    an_proc_name2 [g1`,' g2] (n1, n2)
  ||
    an_proc_name3 [g1`,' g2] (an_n1, an_n2, <<>>)
  where

    process an_proc_name2 [g1`,' g2] (n1, n2 : Num) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
      (
	an_g2 ? an_id2 : Id ? prim2 : Prim
	  [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
	an_g2 ! an_id2 ? prim3 : Prim
	  [IsNextPrim (prim3, prim2)];
	an_g1 ! an_id1 ? prim4 : Prim
	  [IsNextPrim (prim4, prim3)];
	stop
      |||
	an_proc_name2 [g1`,' g2] (n1, n2)
      )
    endproc (* an_proc_name2 *)

    process an_proc_name3 [g1`,' g2] (n1, n2 : Num, primq : PrimQueue) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind)];
      an_proc_name3 [g1`,' g2] (IdNum (id1, n1), an_n2, prim1 + primq)
    []
      an_g1 ? an_id2 : Id ? prim2 : Prim
	[IsNextQueue (prim2, primq) and IsCon (prim2)];
      an_proc_name3 [g1`,' g2] (an_n1, IdNum (id2, n2), RemPrev (prim2, primq))
    []
      an_g2 ? an_id2 : Id ? prim2 : Prim
	[IsNextQueue (prim2, primq) and not (IsCon (prim2))];
      an_proc_name3 [g1`,' g2] (an_n1, IdNum (id2, n2), RepPrev (prim2, primq))
    endproc (* an_proc_name3 *)
')

# "feat_ord_user_init" describes an ordered user-initiated feature

define(feat_ord_user_init,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_proc_name1 [g1`,' g2] (IdNum (id1, n1), an_n2)')

# "feat_ord_userprov_conf" describes an ordered user/provider-confirmed
# feature

define(feat_ord_userprov_conf,`
      an_proc_name2 [g1`,' g2] (n1, n2)
    ||
      an_proc_name3 [g1`,' g2] (an_n1, an_n2, <<>>)
    where

    process an_proc_name2 [g1`,' g2] (n1, n2 : Num) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
      (
	an_g1 ? an_id2 : Id ? prim2 : Prim
	  [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
	(
	  an_g2 ! an_id2 ? prim3 : Prim
	    [IsNextPrim (prim3, prim2)];
	  an_g1 ! an_id1 ? prim4 : Prim
	    [IsNextPrim (prim4, prim3)];
	  stop
	[]
	  an_g1 ! an_id1 ? prim4 : Prim
	    [IsNextPrim (prim4, prim1)];
	  an_g2 ! an_id2 ? prim3 : Prim
	    [IsNextPrim (prim3, prim2)];
	  stop
	)
      |||
	an_proc_name2 [g1`,' g2] (n1, n2)
      )
    endproc (* an_proc_name2 *)

    process an_proc_name3 [g1`,' g2] (n1, n2 : Num, primq : PrimQueue) : noexit :=
      an_g1 ? an_id1 : Id ? prim1 : Prim
	[IsKind (prim1, an_group1`'ReqKind)];
      an_proc_name3 [g1`,' g2] (IdNum (id1, n1), an_n2, prim1 + primq)
    []
      an_g1 ? an_id2 : Id ? prim2 : Prim
	[IsNextQueue (prim2, primq) and IsCon (prim2)];
      an_proc_name3 [g1`,' g2] (an_n1, IdNum (id2, n2), RemPrev (prim2, primq))
    []
      an_g2 ? an_id2 : Id ? prim2 : Prim
	[IsNextQueue (prim2, primq) and not (IsCon (prim2))];
      an_proc_name3 [g1`,' g2] (an_n1, IdNum (id2, n2), RepPrev (prim2, primq))
    endproc (* an_proc_name3 *)
')

####################### Reliable Feature Processes #######################

# "feat_rel_asymm_conf" describes a reliable asymmetric-confirmed feature

define(feat_rel_asymm_conf,`
  rep_err(`Sorry, reliable asymmetric-confirmed not yet implemented')stop')

# "feat_rel_loc_conf" describes a reliable local-confirmed feature

define(feat_rel_loc_conf,`
  rep_err(`Sorry, reliable local-confirmed not yet implemented')stop')

# "feat_rel_prov_conf" describes a reliable provider-confirmed feature

define(feat_rel_prov_conf,`
  rep_err(`Sorry, reliable provider-confirmed not yet implemented')stop')

# "feat_rel_prov_init" describes a reliable provider-initiated feature

define(feat_rel_prov_init,`
  rep_err(`Sorry, reliable provider-initiated not yet implemented')stop')

# "feat_rel_rem_conf" describes a reliable remote-confirmed feature

define(feat_rel_rem_conf,`
  rep_err(`Sorry, reliable remote-confirmed not yet implemented')stop')

# "feat_rel_un_conf" describes a reliable unconfirmed feature

define(feat_rel_un_conf,`
  rep_err(`Sorry, reliable unconfirmed not yet implemented')stop')

# "feat_rel_user_conf" describes a reliable user-confirmed feature

define(feat_rel_user_conf,`
  rep_err(`Sorry, reliable user-confirmed not yet implemented')stop')

# "feat_rel_user_init" describes a reliable user-initiated feature

define(feat_rel_user_init,`
  rep_err(`Sorry, reliable user-initiated not yet implemented')stop')

# "feat_rel_userprov_conf" describes a reliable user/provider-confirmed
# feature

define(feat_rel_userprov_conf,`
  rep_err(`Sorry, reliable user/provider-confirmed not yet implemented')stop')

####################### Single Feature Processes #######################

# "feat_sing_asymm_conf" describes a single asymmetric-confirmed feature

define(feat_sing_asymm_conf,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g2 ? an_id2 : Id ? prim2 : Prim
      [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
    an_g2 ! an_id2 ? prim3 : Prim
      [IsNextPrim (prim3, prim2)];
    exit (IdNum (id1, n1), IdNum (id2, n2), NoRes)')

# "feat_sing_loc_conf" describes a single local-confirmed feature

define(feat_sing_loc_conf,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g1 ! an_id1 ? prim2 : Prim
      [IsNextPrim (prim2, prim1)];
    exit (ifelse(an_g1,g1,`IdNum (id1, n1), n2',
      `n1, IdNum (id2, n2)'), ResultOf (prim2))')

# "feat_sing_prov_conf" describes a single provider-confirmed feature

define(feat_sing_prov_conf,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g2 ? an_id2 : Id ? prim2 : Prim
      [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
    an_g1 ! an_id1 ? prim3 : Prim
      [IsNextPrim (prim3, prim2)];
    exit (IdNum (id1, n1), IdNum (id2, n2), ResultOf (prim3))')

# "feat_sing_prov_init" describes a single provider-initiated feature

define(feat_sing_prov_init,`
    an_g2 ? an_id2 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'IndKind) and IsId (an_id2, an_n2)];
    exit (ifelse(an_g1,g1,`n1, IdNum (id2, n2)',
      `IdNum (id1, n1), n2'), NoRes)')

# "feat_sing_rem_conf" describes a single remote-confirmed feature

define(feat_sing_rem_conf,`
    an_g2 ? an_id2 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'IndKind) and IsId (an_id2, an_n2)];
    an_g2 ! an_id2 ? prim2 : Prim
      [IsNextPrim (prim2, prim1)];
    exit (ifelse(an_g1,g1,`n1, IdNum (id2, n2)',
      `IdNum (id1, n1), n2'), NoRes)')

# "feat_sing_un_conf" describes a single unconfirmed feature

define(feat_sing_un_conf,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g2 ? an_id2 : Id ? prim2 : Prim
      [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
    exit (IdNum (id1, n1), IdNum (id2, n2), NoRes)')

# "feat_sing_user_conf" describes a single user-confirmed feature

define(feat_sing_user_conf,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g2 ? an_id2 : Id ? prim2 : Prim
      [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
    an_g2 ! an_id2 ? prim3 : Prim
      [IsNextPrim (prim3, prim2)];
    an_g1 ! an_id1 ? prim4 : Prim
      [IsNextPrim (prim4, prim3)];
    exit (IdNum (id1, n1), IdNum (id2, n2), ResultOf (prim4))')

# "feat_sing_user_init" describes a single user-initiated feature

define(feat_sing_user_init,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    exit (ifelse(an_g1,g1,`IdNum (id1, n1), n2',
      `n1, IdNum (id2, n2)'), ResultOf (prim1))')

# "feat_sing_userprov_conf" describes a single user/provider-confirmed
# feature

define(feat_sing_userprov_conf,`
    an_g1 ? an_id1 : Id ? prim1 : Prim
      [IsKind (prim1, an_group1`'ReqKind) and IsId (an_id1, an_n1)];
    an_g2 ? an_id2 : Id ? prim2 : Prim
      [IsNextPrim (prim2, prim1) and IsId (an_id2, an_n2)];
    (
      an_g2 ! an_id2 ? prim3 : Prim
	[IsNextPrim (prim3, prim2)];
      an_g1 ! an_id1 ? prim4 : Prim
	[IsNextPrim (prim4, prim3)];
      exit (IdNum (id1, n1), IdNum (id2, n2), ResultOf (prim4))
    []
      an_g1 ! an_id1 ? prim4 : Prim
	[IsNextPrim (prim4, prim2)];
      an_g2 ! an_id2 ? prim3 : Prim
	[IsNextPrim (prim3, prim2)];
      exit (IdNum (id1, n1), IdNum (id2, n2), ResultOf (prim4))
    )')

####################### Unreliable Feature Processes #######################

# "feat_unrel_asymm_conf" describes a unreliable asymmetric-confirmed feature

define(feat_unrel_asymm_conf,`
  rep_err(`Sorry, unreliable asymmetric-confirmed not yet implemented')stop')

# "feat_unrel_loc_conf" describes a unreliable local-confirmed feature

define(feat_unrel_loc_conf,`
  rep_err(`Sorry, unreliable local-confirmed not yet implemented')stop')

# "feat_unrel_prov_conf" describes a unreliable provider-confirmed feature

define(feat_unrel_prov_conf,`
  rep_err(`Sorry, unreliable provider-confirmed not yet implemented')stop')

# "feat_unrel_prov_init" describes a unreliable provider-initiated feature

define(feat_unrel_prov_init,`
  rep_err(`Sorry, unreliable provider-initiated not yet implemented')stop')

# "feat_unrel_rem_conf" describes a unreliable remote-confirmed feature

define(feat_unrel_rem_conf,`
  rep_err(`Sorry, unreliable remote-confirmed not yet implemented')stop')

# "feat_unrel_un_conf" describes a unreliable unconfirmed feature

define(feat_unrel_un_conf,`
  rep_err(`Sorry, unreliable unconfirmed not yet implemented')stop')

# "feat_unrel_user_conf" describes a unreliable user-confirmed feature

define(feat_unrel_user_conf,`
  rep_err(`Sorry, unreliable user-confirmed not yet implemented')stop')

# "feat_unrel_user_init" describes a unreliable user-initiated feature

define(feat_unrel_user_init,`
  rep_err(`Sorry, unreliable user-initiated not yet implemented')stop')

# "feat_unrel_userprov_conf" describes a unreliable user/provider-confirmed
# feature

define(feat_unrel_userprov_conf,`
  rep_err(`Sorry, unreliable user/provider-confirmed not yet implemented')stop')
