divert(-1)

# "anise_gen.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	07/08/98
# 
# This "m4" macro file generates description changes of Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.
# 
# Copyright 1998 K. J. Turner, University of Stirling

############################## General Macros ##############################

# "context_err(edit,str)" generates perl to report failure to find a context
# string "str" for edit command "edit"

define(context_err,`
  else {
    print STDERR "Error - File \"an_file\" $1 context \"$2\" not found\n\n";
  }')

# "text_err(edit,str)" generates perl to report failure to find a text
# string "str" for edit command "edit"

define(text_err,`
    else {
      print STDERR "Error - File \"an_file\" $1 text \"$2\" not found\n\n";
    }')

# "decl_of(decl)" produces the macro name if a declaration is present in the
# form "declare(name,..."

define(decl_of,
  `define(`an_ind1',`index($1,`declare(')')ifelse(an_ind1,-1,,
    `define(`an_ind1',eval(an_ind1+8))define(`an_ind2',
      `index($1,`,')')ifelse(an_ind2,-1,,
	`substr($1,an_ind1,
	  eval(an_ind2-an_ind1))')')')')')

############################## Editing Macros ##############################

# "append(old,new,context)" searches for the given old text and appends the
# given new text; an optional context can be given for the search; if "old"
# is a macro parameter (followed by close parenthesis or comma) then
# "new" is followed by a comma

define(append,`
`#' Context "decl_of($2)" Append "$1"ifelse($3,,,`
  if (/\n[^%\n]*$3\W/g) {')
    if (/(\W+)$1(\W)/g) {
      $pre = $PREMATCH; $bef = $`'1; $aft = $`'2; $post = $POSTMATCH;
      if ($aft =~ /^\)\s*$/) {
        $_ = "${pre}${bef}$1,$2${aft}${post}";
      }
      elsif ($aft =~ /^,\s*$/) {
        $_ = "${pre}${bef}$1${aft}$2,${post}";
      }
      else {
        $_ = "${pre}${bef}$1$2${aft}${post}";
      }
    }text_err(Append,`$1')ifelse($3,,,`
  }context_err(Append,`$3')')')

# "change(old,new,context)" searches for the given old text and changes
# it to the given new text; an optional context can be given for the search;
# if "old" and "new" are both macro calls, the parameters of "old" are
# retained after those of "new"

define(change,`
  ifelse($3,,`
`#' Context "" Change "$1"',`
`#' Context "$3" Change "$1" 
  if (/\n[^%\n]*$3\W/g) {')
    if (/(\W+)$1(\W)/g) {
      $pre = $PREMATCH; $bef = $`'1; $aft = $`'2; $post = $POSTMATCH;ifelse(
        index($2,`('),-1,`
      $_ = "${pre}${bef}$2${aft}${post}";',`
      if ($aft eq "(") {
        $_ = "${pre}${bef}substr($2,0,decr(len($2))),${post}";
      }
      else {
        $_ = "${pre}${bef}$2${aft}${post}";
      }')
    }text_err(Change,`$1')ifelse($3,,,`
  }context_err(Change,`$3')')')

# "delete(old,context)" searches for the given old text and deletes
# it; an optional context can be given for the search

define(delete,`
  ifelse($2,,`
`#' Context "" Delete "$1"',`
`#' Context "$2" Delete "$1" 
  if (/\n[^%\n]*$2\W/g) {')
    if (/(\W)$1(\W)/g) {
      $_ = "${PREMATCH}$`'1$`'2${POSTMATCH}";
    }text_err(Delete,`$1')ifelse($2,,,`
  }context_err(Delete,`$3')')')

# "fill(old,new,context)" searches for the given old text (which may be a
# macro call starting with blank space and/or a comment) and fills it with the
# given new text (which may be a macro call) applied to the parameters
# (including its own if present); an optional context can be given for the
# search

define(fill,`
  ifelse($3,,`
`#' Context "" Fill "$1"',`
`#' Context "$3" Fill "$1" 
  if (/\n[^%\n]*$3\W/g) {')
    if (/($1\((?:\s*%[^\n]*\n)?\s*)(.*?\)(?:\s*\))*)/gs) {
      $pre = $PREMATCH; $bef = $`'1; $aft = $`'2; $post = $POSTMATCH;ifelse(
        index($2,`('),-1,`
      $_ = "${pre}${bef}$2(${aft})${post}";',`
      $_ = "${pre}${bef}substr($2,0,decr(len($2))),${aft})${post}";')
    }text_err(Fill,`$1')ifelse($3,,,`
  }context_err(Fill,`$3')')')

# "header(str)" add the given header text "str" before the first blank line,
# then output the first non-comment line as an ANISE header

define(header,`
`#' Header
  if (qq/$1/ =~ /[%\s]*(.*)/) {
    $`header' = "`header'($`'1)";
  }
  else {
    $`header' = "";
  }
  if (/\n\s*\n/) {
    s//
$`header'$1

/;
  }
  else {
    print STDERR "angen: Header blank line not found\n";
  }')

# "prefix(old,new,context)" searches for the given old text and prefixes the
# given new text; an optional context can be given for the search; if "old"
# is a macro parameter (preceded by open parenthesis or comma) then
# "new" is followed by a comma

define(prefix,`
`#' Context "decl_of($2)" Prefix "$1"ifelse($3,,,`
  if (/\n[^%\n]*$3\W/g) {')
    if (/(\W+)$1(\W)/g) {
      $pre = $PREMATCH; $bef = $`'1; $aft = $`'2; $post = $POSTMATCH;
      if ($bef =~ /^\(\s*$/) {
        $_ = "${pre}${bef}$2,$1${aft}${post}";
      }
      elsif ($bef =~ /^,\s*$/) {
        $_ = "${pre},$2${bef}$1${aft}${post}";
      }
      else {
        $_ = "${pre}${bef}$2$1${aft}${post}";
      }
    }text_err(Prefix,`$1')ifelse($3,,,`
  }context_err(Prefix,`$3')')')

# "wrap(old,new,context)" searches for the given old text (which may contain
# up to six levels of parentheses including outer ones) and surrounds it with
# the given new text; an optional context can be given for the search

define(wrap,`
  ifelse($3,,`
`#' Context "" Wrap "$1"',`
`#' Context "$3" Wrap "$1" 
  if (/\n[^%\n]*$3\W/g) {')
    if (/($1\(([^\(]*\(([^\(]*\(([^\(]*\(([^\(]*\(([^\(]*\([^\(\)]*\))*[^\(]*\))*[^\(]*\))*[^\(]*\))*[^\(]*\))*[^\(]*\)|$1(?![\(\w]))/gs) {
      ifelse(index(`$2',`('),-1,
        `$_ = "${PREMATCH}$2($`'1)${POSTMATCH}";',
        `$_ = "${PREMATCH}substr($2,0,decr(len($2))),$`'1)${POSTMATCH}";')
    }text_err(Wrap,`$1')ifelse($3,,,`
  }context_err(Wrap,`$3')')')

########################### Trailer ##############################

divert
