################################### Header ###################################

# "anise_prim_int.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	10/08/98

# This "m4" macro file contains templates for generating Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.

# This particular file contains macros for internal parameters.

# Copyright 1998 K. J. Turner, University of Stirling

############################ Internal Type Macros ############################

# "control_type" produces call control type definitions

define(control_type,`
  (* call control functions *)

  type Control is
    sorts Control
    opns
      CtlDial, CtlNormal, CtlReturn, CtlWaiting : -> Control
  endtype (* Control *)')

# "group_type" produces a service primitive group type definition

define(group_type,`
  (* service primitive group *)

  type Group is NaturalNumber, Boolean
    sorts Group
    opns
      Ord :		Group		-> Nat
      _ eq _, _ ne _ :	Group, Group	-> Bool
    eqns
      forall group`'an_lab1, group`'an_lab2 : Group
        ofsort Bool
	  group`'an_lab1 eq group`'an_lab2 = Ord (group`'an_lab1) eq Ord (group`'an_lab2);
	  group`'an_lab1 ne group`'an_lab2 = Ord (group`'an_lab1) ne Ord (group`'an_lab2);
  endtype (* Group *)')

# "id_assoc_type" produces identifier association type definitions

define(id_assoc_type,`
  (* association between ids *)

  type IdAssoc is Id
    sorts IdAssoc
    opns
      IdAssoc :	      Id, Id		-> IdAssoc	(* caller, called *)
      IdAssocFrom :   IdAssoc		-> Id		(* caller id *)
      IdAssocTo :     IdAssoc		-> Id		(* called id *)
      _eq _, _ ne _ : IdAssoc, IdAssoc	-> Bool
    eqns
      forall id`'an_lab1, id`'an_lab2 : Id, as`'an_lab1, as`'an_lab2 : IdAssoc
        ofsort Id
	  IdAssocFrom (IdAssoc (id`'an_lab1, id`'an_lab2)) = id`'an_lab1;
	  IdAssocTo (IdAssoc (id`'an_lab1, id`'an_lab2)) = id`'an_lab2;
        ofsort Bool
	  as`'an_lab1 eq as`'an_lab2 =
	    (IdAssocFrom (as`'an_lab1) eq IdAssocFrom (as`'an_lab2)) and
	      (IdAssocTo (as`'an_lab1) eq IdAssocTo (as`'an_lab2));
	  as`'an_lab1 ne as`'an_lab2 = not (as`'an_lab1 eq as`'an_lab2);
  endtype (* IdAssoc *)

  (* list of id associations *)

  type IdAssocs0 is String actualizedby IdAssoc, Boolean using
    sortnames
      IdAssocs	for String
      IdAssoc	for Element
      Bool	for FBool
    opnnames
      IdAssocs	for String
  endtype (* IdAssocs0 *)

  (* id association operations *)

  type IdAssocs is IdAssocs0, Id, Num, Profs
    opns
      IdAssocAvail :  Id, IdAssocs	-> Bool		 (* valid/free Id? *)
      IdAssocCall :   Id, IdAssocs	-> Bool		 (* called Id? *)
      IdAssocComm :   Id, IdAssocs	-> Bool		 (* common Id? *)
      IdAssocConn :   Id, IdAssocs	-> Bool		 (* connected Id? *)
      IdAssocIn :     Id, Id, IdAssocs	-> Bool		 (* Ids in list? *)
      IdAssocStop :   Id, IdAssocs	-> Bool		 (* stopping Id? *)
      IdAssocFirst :  Id, IdAssocs	-> Id		 (* current CW Id *)
      IdAssocId :     Id, IdAssocs	-> Id		 (* associated Id *)
      IdAssocPeer :   Id, IdAssocs	-> Id		 (* other CW Id *)
      IdAssocPeer`'an_lab1 :  Id, IdAssocs, IdAssocs -> Id       (* other CW Id *)
      IdAssocPeer`'an_lab2 :  Id, IdAssocs      -> Id            (* other CW Id *)
      IdAssocSecond : Id, IdAssocs	-> Id		 (* waiting CW Id *)
      IdAssocAdd :    Id, IdAssocs	-> IdAssocs	 (* add Id *)
      IdAssocLink :   Id, Id, IdAssocs	-> IdAssocs      (* associate Ids *)
      IdAssocRem :    Id, IdAssocs	-> IdAssocs	 (* remove Id *)
      IdAssocRem`'an_lab1 :   Id, IdAssocs, IdAssocs -> IdAssocs (* remove Id *)
      IdAssocSwap :   Id, IdAssocs	-> IdAssocs	 (* Id pair to end *)
      IdAssocNum :    Num, IdAssocs	-> Num		 (* associated num *)
    eqns
      forall
       id, id1, id2, id`'an_lab1, id`'an_lab2 : Id, n : Num,
       as : IdAssoc, ass, ass`'an_lab1, ass`'an_lab2 : IdAssocs

        ofsort Bool

	  (* false if id/id2 or id1/id exists irrespective of held status *)
	  IdAssocAvail (id, <>) = true;
	  (id eq id`'an_lab1) or (Held (id) eq id`'an_lab1) or
	   (id eq id`'an_lab2) or (Held (id) eq id`'an_lab2) =>
	    IdAssocAvail (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      false;
	  id ne id`'an_lab1, Held (id) ne id`'an_lab1,
	   id ne id`'an_lab2, Held (id) ne id`'an_lab2 =>
	    IdAssocAvail (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocAvail (id, ass);

	  (* true if id/id2, Held(id)/id2, id1/id or id1/Held(id) exists *)
	  IdAssocCall (id, <>) = false;
	  (id eq id`'an_lab1) or (Held (id) eq id`'an_lab1) or
	   (id eq id`'an_lab2) or (Held (id) eq id`'an_lab2) =>
	    IdAssocCall (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      true;
	  id ne id`'an_lab1, Held (id) ne id`'an_lab1,
	   id ne id`'an_lab2, Held (id) ne id`'an_lab2 =>
	    IdAssocCall (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocCall (id, ass);

	  (* true if id1/id and id2/id, or id/id1 and id2/id both exist *)
	  IdAssocComm (id, <>) = false;
	  (id eq id`'an_lab1) or (id eq id`'an_lab2) =>
	    IdAssocComm (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocConn (id, ass);
	  id ne id`'an_lab1, id ne id`'an_lab2 =>
	    IdAssocComm (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocComm (id, ass);

	  (* true if id/id2 or id1/id exists *)
	  IdAssocConn (id, <>) = false;
	  id eq id`'an_lab2 =>
	    IdAssocConn (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      true;
	  id ne id`'an_lab2 =>
	    IdAssocConn (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocConn (id, ass);

	  (* true if id pair is in list *)
	  IdAssocIn (id1, id2, <>) = false;
	  id1 eq id`'an_lab1, id2 eq id`'an_lab2 =>
	    IdAssocIn (id1, id2, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) = true;
	  (id1 ne id`'an_lab1) or (id2 ne id`'an_lab2) =>
	    IdAssocIn (id1, id2, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocIn (id1, id2, ass);

	  (* true if -/Held(id) in list *)
	  IdAssocStop (id, ass) = IdAssocIn (NoId, Held (id), ass);

        ofsort Id

	  (* first (current) id1 for id1/id, or id2 for id/id2
	     irrespective of held status *)
	  (id eq NoId) or (ass eq <>) =>
	    IdAssocFirst (id, ass) = NoId;
	  id ne NoId,
	   (id eq id`'an_lab1) or (id eq Held (id`'an_lab1)) or (Held (id) eq id`'an_lab1) =>
	    IdAssocFirst (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) = id`'an_lab2;
	  id ne NoId,
	   (id eq id`'an_lab2) or (id eq Held (id`'an_lab2)) or (Held (id) eq id`'an_lab2) =>
	    IdAssocFirst (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) = id`'an_lab1;
	  id ne NoId,
	   id ne id`'an_lab1, id ne Held (id`'an_lab1), Held (id) ne id`'an_lab1,
	    id ne id`'an_lab2, id ne Held (id`'an_lab2), Held (id) ne id`'an_lab2 =>
	    IdAssocFirst (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocFirst (id, ass);

	  (* id2 for id/id2 (either of which may be held)
	     id1 for id1/id (either of which may be held) *)
	  IdAssocId (id, <>) = NoId;
	  (id eq id`'an_lab1) or (Held (id) eq id`'an_lab1) =>
	    IdAssocId (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) = UnHeld (id`'an_lab2);
	  (id eq id`'an_lab2) or (Held (id) eq id`'an_lab2) =>
	    IdAssocId (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) = UnHeld (id`'an_lab1);
	  id ne id`'an_lab1, Held (id) ne id`'an_lab1,
	   id ne id`'an_lab2, Held (id) ne id`'an_lab2 =>
	    IdAssocId (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocId (id, ass);

	  (* if id/id1 or id/id1 exists then peer id2 if id2/id1 exists *)
	  IdAssocPeer (id, ass) = IdAssocPeer`'an_lab1 (id, ass, <>);
	  IdAssocPeer`'an_lab1 (id, <>, ass`'an_lab2) = NoId;
	  id eq id`'an_lab1 =>
	    IdAssocPeer`'an_lab1 (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass`'an_lab1, ass`'an_lab2) =
	      IdAssocPeer`'an_lab2 (id`'an_lab2, ass`'an_lab2 ++ ass`'an_lab1);
	  id eq id`'an_lab2 =>
	    IdAssocPeer`'an_lab1 (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass`'an_lab1, ass`'an_lab2) =
	      IdAssocPeer`'an_lab2 (id`'an_lab1, ass`'an_lab2 ++ ass`'an_lab1);
	  id ne id`'an_lab1, id ne id`'an_lab2 =>
	    IdAssocPeer`'an_lab1 (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass`'an_lab1, ass`'an_lab2) =
	      IdAssocPeer`'an_lab1 (id, ass`'an_lab1, ass`'an_lab2 + IdAssoc (id`'an_lab1, id`'an_lab2));
	  (id eq NoId) or (ass eq <>) =>
	    IdAssocPeer`'an_lab2 (id, ass) = NoId;
	  id ne NoId, id eq id`'an_lab1 =>
	    IdAssocPeer`'an_lab2 (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) = id`'an_lab2;
	  id ne NoId, id eq id`'an_lab2 =>
	    IdAssocPeer`'an_lab2 (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) = id`'an_lab1;
	  id ne NoId, id ne id`'an_lab1, id ne id`'an_lab2 =>
	    IdAssocPeer`'an_lab2 (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocPeer`'an_lab2 (id, ass);

	  (* second (waiting) id1 for id1/id, or id2 for id/id2
	     irrespective of held status *)
	  (id eq NoId) or (ass eq <>) =>
	    IdAssocSecond (id, ass) = NoId;
	  id ne NoId,
	   (id eq id`'an_lab1) or (id eq Held (id`'an_lab1)) or (Held (id) eq id`'an_lab1) =>
	    IdAssocSecond (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocFirst (id, ass);
	  id ne NoId,
	   (id eq id`'an_lab2) or (id eq Held (id`'an_lab2)) or (Held (id) eq id`'an_lab2) =>
	    IdAssocSecond (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocFirst (id, ass);
	  id ne NoId,
	   id ne id`'an_lab1, id ne Held (id`'an_lab1), Held (id) ne id`'an_lab1,
	    id ne id`'an_lab2, id ne Held (id`'an_lab2), Held (id) ne id`'an_lab2 =>
	    IdAssocSecond (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssocSecond (id, ass);

        ofsort IdAssocs

	  (* add id/- if id new
	     update id1/Held(id) to id1/id if id1/Held(id) exists *)
	  IdAssocAdd (id, <>) = IdAssocs (IdAssoc (id, NoId));
	  id eq id`'an_lab1 =>
	    IdAssocAdd (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssoc (id`'an_lab1, id`'an_lab2) + IdAssocAdd (id, ass);
	  id ne id`'an_lab1, id eq id`'an_lab2 =>
	    IdAssocAdd (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssoc (id`'an_lab1, id`'an_lab2) + ass;
	  id ne id`'an_lab1, id ne id`'an_lab2, Held (id) eq id`'an_lab2 =>
	    IdAssocAdd (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssoc (id`'an_lab1, id) + ass;
	  id ne id`'an_lab1, id ne id`'an_lab2, Held (id) ne id`'an_lab2 =>
	    IdAssocAdd (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssoc (id`'an_lab1, id`'an_lab2) + IdAssocAdd (id, ass);

	  (* add id1/Held(id2) if id1 new and id2 valid
	     update id1/id2 to id1/Held(id2) if id1 exists and id2 valid *)
	  (id2 eq NoId) or (id2 eq BusyId) =>
	    IdAssocLink (id1, id2, ass) = ass;
	  id2 ne NoId, id2 ne BusyId =>
	    IdAssocLink (id1, id2, <>) = IdAssocs (IdAssoc (id1, Held (id2)));
	  id2 ne NoId, id2 ne BusyId, id1 eq id`'an_lab1 =>
	    IdAssocLink (id1, id2, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssoc (id`'an_lab1, Held (id2)) + ass;
	  id2 ne NoId, id2 ne BusyId, id1 ne id`'an_lab1 =>
	    IdAssocLink (id1, id2, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssoc (id`'an_lab1, id`'an_lab2) + IdAssocLink (id1, id2, ass);

	  (* <1, 2> is an id pair, - is no id or pair, 2H means 2 is held
	     nullify first id:
		Rem(1, <1, 2>) = <-, 2>
		Rem(1, <3, 2> <1, 2H>) = <3, 2> <-, 2H>
		Rem(1, <1, 2> <3, 1H>) = <-, 2> <3, 2H>
		Rem(1, <1, 2> <3, 1>) = <-, 2> <3, 1>
		Rem(3, <1, 2> <3, 1H>) = <1, 2> <-, 1H>
	      nullify second id:
		Rem(2, <1, 2>) = <1, ->
		Rem(2, <3, 2> <1, 2H>) = <3, -> <1, 2H>
		Rem(2, <3, 2> <1, 2>) = <3, -> <1, 2>
	      remove id pair:
		Rem(1, <1, ->) = -
		Rem(1, <1, 2H>) = -
		Rem(3, <3, 2> <1, 2H>) = <1, 2H>
		Rem(1, <3, 2> <1, 2>) = <3, 2>
		Rem(3, <3, 2> <1, 2>) = <1, 2>
		Rem(3, <1, 2> <3, 1>) = <1, 2>
		Rem(2, <-, 2>) = -
		Rem(2, <-, 2H>) = -
		Rem(2, <1, 2> <3, 1H>) = <3, 1H>
		Rem(2, <1, 2> <3, 1>) = <3, 1>
	      recurse:
		Rem(1, <1, 2> <-, 1H>) = <1, 2>
		Rem(2, <3, 2> <-, 2H>) = <3, 2> *)
	  IdAssocRem (id, ass) = IdAssocRem`'an_lab1 (id, ass, <>);
	  IdAssocRem`'an_lab1 (id, <>, ass`'an_lab2) = ass`'an_lab2;
	  (* nullify first id *)
	  id eq id`'an_lab1, id`'an_lab2 ne NoId,
	    not (IsHeld (id`'an_lab2) or IdAssocStop (id`'an_lab1, ass`'an_lab1)) or
	     (IdAssocFirst (id`'an_lab2, ass`'an_lab2) ne NoId),
	      IsHeld (id`'an_lab2) or not (IdAssocCall (id`'an_lab2, ass`'an_lab1) or
	        (IdAssocFirst (id`'an_lab2, ass`'an_lab2) ne NoId)) =>
	    IdAssocRem`'an_lab1 (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass`'an_lab1, ass`'an_lab2) =
	      ass`'an_lab2 ++ (IdAssoc (NoId, id`'an_lab2) + ass`'an_lab1);
	  (* nullify second id *)
	  id eq id`'an_lab2, id`'an_lab1 ne NoId, not (IdAssocStop (id`'an_lab2, ass`'an_lab1)),
	    not (IdAssocCall (id`'an_lab1, ass`'an_lab1)) =>
	    IdAssocRem`'an_lab1 (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass`'an_lab1, ass`'an_lab2) =
	      ass`'an_lab2 ++ (IdAssoc (id`'an_lab1, NoId) + ass`'an_lab1);
	  (* remove id pair *)
	  ((id eq id`'an_lab1) and (id`'an_lab2 eq NoId)) or
	   ((id eq id`'an_lab1) and (id`'an_lab2 ne NoId) and
	    ((IsHeld (id`'an_lab2) and (IdAssocFirst (id`'an_lab2, ass`'an_lab2) eq NoId)) or
	     (not (IsHeld (id`'an_lab2)) and
	       (IdAssocCall (id`'an_lab2, ass`'an_lab1) or
		(IdAssocFirst (id`'an_lab2, ass`'an_lab2) ne NoId))))) or
	   (((id eq id`'an_lab2) or (Held (id) eq id`'an_lab2)) and (id`'an_lab1 eq NoId)) or
	   ((id eq id`'an_lab2) and (id`'an_lab1 ne NoId) and IdAssocCall (id`'an_lab1, ass`'an_lab1)) =>
	    IdAssocRem`'an_lab1 (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass`'an_lab1, ass`'an_lab2) =
	      ass`'an_lab2 ++ ass`'an_lab1;
	  (* recurse *)
	  (id eq id`'an_lab1) and (IdAssocStop (id`'an_lab1, ass`'an_lab1)) or
	   ((id eq id`'an_lab2) and (id`'an_lab1 ne NoId) and IdAssocStop (id`'an_lab2, ass`'an_lab1)) or
	    ((id ne id`'an_lab1) and (id ne id`'an_lab2) and (Held (id) ne id`'an_lab2)) =>
	    IdAssocRem`'an_lab1 (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass`'an_lab1, ass`'an_lab2) =
	      IdAssocRem`'an_lab1 (id, ass`'an_lab1, ass`'an_lab2 + IdAssoc (id`'an_lab1, id`'an_lab2));

	  (* move id1/id or id/id1 to end of associations, thus swapping
	     with id2/id *)
	  IdAssocSwap (id, <>) = <>;
	  (id eq id`'an_lab1) or (id eq id`'an_lab2) =>
	    IdAssocSwap (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      ass + IdAssoc (id`'an_lab1, id`'an_lab2);
	  id ne id`'an_lab1, id ne id`'an_lab2 =>
	    IdAssocSwap (id, IdAssoc (id`'an_lab1, id`'an_lab2) + ass) =
	      IdAssoc (id`'an_lab1, id`'an_lab2) + IdAssocSwap (id, ass);

        ofsort Num

	  (* no/n/Held(n) according to availability of n *)
	  NumId (n) eq NoId =>
	    IdAssocNum (n, ass) = NoNum;
	  NumId (n) ne NoId, not (IdAssocAvail (NumId (n), ass)) =>
	    IdAssocNum (n, ass) = Held (n);
	  NumId (n) ne NoId, IdAssocAvail (NumId (n), ass) =>
	    IdAssocNum (n, ass) = n;

  endtype (* IdAssocs *)')

# "id_of(id)" produces the LOTOS representation of the decimal "id", such
# as "Id (4)+1+9" for "419"

define(id_of,
  `define(`an_num',`translit($1,`*#',`SH')')define(`an_len',
    `len(an_num)')ifelse(an_len,0,,
      an_len,1,`Id(an_num)',
        `Id(substr(an_num,0,1))+id_of_aux(decr(an_len),
	  substr(an_num,1))')')

define(id_of_aux,
  `ifelse($1,1,$2,
      `substr($2,0,1)+id_of_aux(decr($1),substr($2,1))')')

# "id_type" produces interaction group identifier type definitions

define(id_type,`
  (* line identifiers as decimal numbers *)

  type Id0 is Num0 renamedby
    sortnames
      Id for  Num
    opnnames
      Id for  Num
  endtype (* Id0 *)

  (* operations on line identifiers *)

  type Id is Id0, Boolean
    opns
      NoId :		-> Id				(* null id *)
      BusyId :		-> Id				(* busy id *)
      Held :	Id	-> Id				(* held id *)
      UnHeld :	Id	-> Id				(* id even if held *)
      IsHeld :	Id	-> Bool				(* id is held *)
    eqns
      forall d, d`'an_lab1, d`'an_lab2 : Dig, id, id`'an_lab1, id`'an_lab2 : Id
        ofsort Id
	  NoId				= <>;
	  BusyId			= Held (<>);
	  UnHeld (<>)			= <>;
	  UnHeld (d + id)		= d + id;
	  UnHeld (Held (id))		= id;
        ofsort Bool
	  IsHeld (<>)			= false;
	  IsHeld (d + id)		= false;
	  IsHeld (Held (id))		= true;
	  <> eq <>			= true;
	  <> eq (d`'an_lab2 + id`'an_lab2)		= false;
	  <> eq Held (id`'an_lab2)		= false;
	  (d`'an_lab1 + id`'an_lab1) eq <>		= false;
	  (d`'an_lab1 + id`'an_lab1) eq (d`'an_lab2 + id`'an_lab2)	= (d`'an_lab1 eq d`'an_lab2) and (id`'an_lab1 eq id`'an_lab2);
	  (d`'an_lab1 + id`'an_lab1) eq Held (id`'an_lab2)	= false;
	  Held (id`'an_lab1) eq <>		= false;
	  Held (id`'an_lab1) eq (d`'an_lab2 + id`'an_lab2)	= false;
	  Held (id`'an_lab1) eq Held (id`'an_lab2)	= id`'an_lab1 eq id`'an_lab2;
  endtype (* Id *)')

# "kind_type" produces a service primitive kind type definition

define(kind_type,`
  (* kind of individual service primitive *)

  type Kind is NaturalNumber, Boolean
    sorts Kind
    opns
      Ord :		Kind		-> Nat
      _ eq _, _ ne _ :	Kind, Kind	-> Bool
    eqns
      forall kind`'an_lab1, kind`'an_lab2 : Kind
        ofsort Bool
	  kind`'an_lab1 eq kind`'an_lab2 = Ord (kind`'an_lab1) eq Ord (kind`'an_lab2);
	  kind`'an_lab1 ne kind`'an_lab2 = Ord (kind`'an_lab1) ne Ord (kind`'an_lab2);
  endtype (* Kind *)')

# "lib_type" invokes library type definitions

define(lib_type,`
  library
    Boolean, NaturalNumber, OctetString, String, Set
  endlib')

# "num_assoc_type" produces number association type definitions

define(num_assoc_type,`
  (* association between numbers *)

  type NumAssoc is Num
    sorts NumAssoc
    opns
      NumAssoc :      Num, Num		 -> NumAssoc	(* caller, called *)
      NumAssocFrom :  NumAssoc		 -> Num		(* caller number *)
      NumAssocTo :    NumAssoc		 -> Num		(* called number *)
      _eq _, _ ne _ : NumAssoc, NumAssoc -> Bool
    eqns
      forall n`'an_lab1, n`'an_lab2 : Num, as`'an_lab1, as`'an_lab2 : NumAssoc
        ofsort Num
	  NumAssocFrom (NumAssoc (n`'an_lab1, n`'an_lab2)) = n`'an_lab1;
	  NumAssocTo (NumAssoc (n`'an_lab1, n`'an_lab2)) = n`'an_lab2;
        ofsort Bool
	  as`'an_lab1 eq as`'an_lab2 =
	    (NumAssocFrom (as`'an_lab1) eq NumAssocFrom (as`'an_lab2)) and
	      (NumAssocTo (as`'an_lab1) eq NumAssocTo (as`'an_lab2));
	  as`'an_lab1 ne as`'an_lab2 = not (as`'an_lab1 eq as`'an_lab2);
  endtype (* NumAssoc *)

  (* list of number associations *)

  type NumAssocs0 is String actualizedby NumAssoc, Boolean using
    sortnames
      NumAssocs	for String
      NumAssoc	for Element
      Bool	for FBool
    opnnames
      NumAssocs	for String
  endtype (* NumAssocs0 *)

  (* number association operations *)

  type NumAssocs is NumAssocs0, Id, Num, Profs
    opns
      NumAssocLink :   Num, Num, NumAssocs -> NumAssocs	(* associate nums *)
      NumAssocUnlink : Num, Num, NumAssocs -> NumAssocs	(* remove nums *)
      NumAssocNum :    Num, NumAssocs	   -> Num	(* associated num *)
      NumAssocId :     Id, NumAssocs	   -> Id	(* associated id *)
    eqns
      forall
       n, n1, n2, n`'an_lab1, n`'an_lab2 : Num, id : Id,
       as : NumAssoc, ass : NumAssocs
        ofsort NumAssocs
	  NumAssocLink (n1, n2, <>) = NumAssocs (NumAssoc (n1, n2));
	  n1 eq n`'an_lab1 =>
	    NumAssocLink (n1, n2, NumAssoc (n`'an_lab1, n`'an_lab2) + ass) =
	      NumAssoc (n1, n2) + ass;
	  n1 ne n`'an_lab1 =>
	    NumAssocLink (n1, n2, NumAssoc (n`'an_lab1, n`'an_lab2) + ass) =
	      NumAssoc (n`'an_lab1, n`'an_lab2) + NumAssocLink (n1, n2, ass);
	  NumAssocUnlink (n1, n2, <>) = <>;
	  n1 eq n`'an_lab1, n2 eq n`'an_lab2 =>
	    NumAssocUnlink (n1, n2, NumAssoc (n`'an_lab1, n`'an_lab2) + ass) = ass;
	  (n1 ne n`'an_lab1) or (n2 ne n`'an_lab2) =>
	    NumAssocUnlink (n1, n2, NumAssoc (n`'an_lab1, n`'an_lab2) + ass) =
	       NumAssoc (n`'an_lab1, n`'an_lab2) + NumAssocUnlink (n1, n2, ass);
        ofsort Num
	  NumAssocNum (n, <>) = NoNum;
	  n eq n`'an_lab1 =>
	    NumAssocNum (n, NumAssoc (n`'an_lab1, n`'an_lab2) + ass) = n`'an_lab2;
	  n ne n`'an_lab1 =>
	    NumAssocNum (n, NumAssoc (n`'an_lab1, n`'an_lab2) + ass) = NumAssocNum (n, ass);
        ofsort Id
	  NumAssocId (id, <>) = NoId;
	  id eq NumId (n`'an_lab1) =>
	    NumAssocId (id, NumAssoc (n`'an_lab1, n`'an_lab2) + ass) = NumId (n`'an_lab2);
	  id eq NumId (n`'an_lab2) =>
	    NumAssocId (id, NumAssoc (n`'an_lab1, n`'an_lab2) + ass) = NumId (n`'an_lab1);
	  id ne NumId (n`'an_lab1), id ne NumId (n`'an_lab2) =>
	    NumAssocId (id, NumAssoc (n`'an_lab1, n`'an_lab2) + ass) = NumAssocId (id, ass);
  endtype (* NumAssocs *)')

# "res_type" produces a primitive result type definition

define(res_type,`
  (* result of features *)

  type Result is
   NaturalNumber, Boolean, CalledMess, CallingMess, Dig, Num, Voice
    sorts Result
    opns
      NoRes:				-> Result
      Result:		CalledMess	-> Result
      Result:		CallingMess	-> Result
      Result:		Dig		-> Result
      Result:		Num		-> Result
      Result:		Voice		-> Result
      Ord :		Result		-> Nat
      _ eq _, _ ne _ :	Result, Result	-> Bool
    eqns
      forall
        res`'an_lab1, res`'an_lab2 : Result,
	cdm, cdm`'an_lab1, cdm`'an_lab2 : CalledMess,
	cgm, cgm`'an_lab1, cgm`'an_lab2 : CallingMess,
	d, d`'an_lab1, d`'an_lab2 : Dig,
	n, n`'an_lab1, n`'an_lab2 : Num,
	v, v`'an_lab1, v`'an_lab2 : Voice
	ofsort Nat
	  Ord (NoRes) = 0;
	  Ord (Result (cdm)) = Succ (Ord (NoRes));
	  Ord (Result (cgm)) = Succ (Ord (Result (NoCalledMess)));
	  Ord (Result (d)) = Succ (Ord (Result (NoCallingMess)));
	  Ord (Result (n)) = Succ (Ord (Result (NoDig)));
	  Ord (Result (v)) = Succ (Ord (Result (NoNum)));
	ofsort Bool
	  Ord (res`'an_lab1) ne Ord (res`'an_lab2) =>
	    res`'an_lab1 eq res`'an_lab2 = false;
	  NoRes eq NoRes = true;
	  Result (cdm`'an_lab1) eq Result (cdm`'an_lab2) =
            cdm`'an_lab1 eq cdm`'an_lab2;
	  Result (cgm`'an_lab1) eq Result (cgm`'an_lab2) =
            cgm`'an_lab1 eq cgm`'an_lab2;
	  Result (d`'an_lab1) eq Result (d`'an_lab2) =
            d`'an_lab1 eq d`'an_lab2;
	  Result (n`'an_lab1) eq Result (n`'an_lab2) =
            n`'an_lab1 eq n`'an_lab2;
	  Result (v`'an_lab1) eq Result (v`'an_lab2) =
            v`'an_lab1 eq v`'an_lab2;
	  res`'an_lab1 ne res`'an_lab2 = not (res`'an_lab1 eq res`'an_lab2);
  endtype (* Result *)')
