################################### Header ###################################

# "anise_prim_par.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	14/04/98

# This "m4" macro file contains templates for generating Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.

# This particular file contains macros for service primitive parameters.

# Copyright 1998 K. J. Turner, University of Stirling

###################### Primitive Parameter Type Macros ######################

# "called_mess_type" produces a called message type definition

define(called_mess_type,`
  (* messages received by the called party *)

  type CalledMess is Boolean, NaturalNumber, Num
    sorts CalledMess
    opns
      NoCalledMess :				-> CalledMess
      NormRing, DistRing1, DistRing2, DistRing3, DistRing4,
        CallWaitTone :				-> CalledMess
      NormRing, DistRing1, DistRing2, DistRing3, DistRing4,
        CallWaitTone :	Num			-> CalledMess
      CalledNumOf :	CalledMess		-> Num		(* message number *)
      CalledTypeOf :	CalledMess		-> CalledMess	(* message type *)
      IsCalledMess :	CalledMess, CalledMess	-> Bool		(* called message pref? *)
      IsCalledNum :	Num, CalledMess, CalledMess -> Bool	(* called number pref? *)
      Ord :		CalledMess		-> Nat
      _ eq _, _ ne _ :	CalledMess, CalledMess	-> Bool
    eqns
      forall cm, cm`'an_lab1, cm`'an_lab2 : CalledMess, n : Num
        ofsort Nat
	  Ord (NoCalledMess)		= 0;
	  Ord (NormRing)		= Succ (Ord (NoCalledMess));
	  Ord (DistRing1)		= Succ (Ord (NormRing));
	  Ord (DistRing2)		= Succ (Ord (DistRing1));
	  Ord (DistRing3)		= Succ (Ord (DistRing2));
	  Ord (DistRing4)		= Succ (Ord (DistRing3));
	  Ord (CallWaitTone)		= Succ (Ord (DistRing4));
	  Ord (NormRing (n))		= Succ (Ord (CallWaitTone));
	  Ord (DistRing1 (n))		= Succ (Ord (NormRing (n)));
	  Ord (DistRing2 (n))		= Succ (Ord (DistRing1 (n)));
	  Ord (DistRing3 (n))		= Succ (Ord (DistRing2 (n)));
	  Ord (DistRing4 (n))		= Succ (Ord (DistRing3 (n)));
	  Ord (CallWaitTone (n))	= Succ (Ord (DistRing4 (n)));
        ofsort Num
	  Ord (cm) le Ord (CallWaitTone) =>
	    CalledNumOf (cm)			= NoNum;
	  CalledNumOf (NormRing (n))		= n;
	  CalledNumOf (DistRing1 (n))		= n;
	  CalledNumOf (DistRing2 (n))		= n;
	  CalledNumOf (DistRing3 (n))		= n;
	  CalledNumOf (DistRing4 (n))		= n;
	  CalledNumOf (CallWaitTone (n))	= n;
        ofsort CalledMess
	  Ord (cm) le Ord (CallWaitTone) =>
	    CalledTypeOf (cm)			= cm;
	  CalledTypeOf (NormRing (n))		= NormRing;
	  CalledTypeOf (DistRing1 (n))		= DistRing1;
	  CalledTypeOf (DistRing2 (n))		= DistRing2;
	  CalledTypeOf (DistRing3 (n))		= DistRing3;
	  CalledTypeOf (DistRing4 (n))		= DistRing4;
	  CalledTypeOf (CallWaitTone (n))	= CallWaitTone;
        ofsort Bool
	  IsCalledMess (cm`'an_lab1, cm`'an_lab2) =
	    (cm`'an_lab1 ne NoCalledMess) implies
	     (CalledTypeOf (cm`'an_lab1) eq CalledTypeOf (cm`'an_lab2));
	  IsCalledNum (n, cm`'an_lab1, cm`'an_lab2) =
	    (CalledNumOf (cm`'an_lab1) ne NoNum)
	     implies (CalledNumOf (cm`'an_lab2) eq n);
	  cm`'an_lab1 eq cm`'an_lab2 =
	    (Ord (cm`'an_lab1) eq Ord (cm`'an_lab2)) and
	     (CalledNumOf (cm`'an_lab1) eq CalledNumOf (cm`'an_lab2));
	  cm`'an_lab1 ne cm`'an_lab2 = not (cm`'an_lab1 eq cm`'an_lab2);
  endtype (* CalledMess *)')

# "calling_mess_type" produces a calling message type definition

define(calling_mess_type,`
  (* messages received by the calling party *)

  type CallingMess is Boolean, NaturalNumber, Num
    sorts CallingMess
    opns
      NoCallingMess, DialTone, EquipBusyTone, RecAnnounce, RingBackAnnounce,
        RingTone, SubsBusyTone, UnobtainTone :		-> CallingMess
      IsCallingMess : Num, CallingMess			-> Bool
      Ord :		 CallingMess			-> Nat
      _ eq _, _ ne _ :	 CallingMess, CallingMess	-> Bool
    eqns
      forall
       cm, cm`'an_lab1, cm`'an_lab2 : CallingMess,
       n : Num
        ofsort Nat
	  Ord (NoCallingMess)		= 0;
	  Ord (DialTone)		= Succ (Ord (NoCallingMess));
	  Ord (EquipBusyTone)		= Succ (Ord (DialTone));
	  Ord (RecAnnounce)		= Succ (Ord (EquipBusyTone));
	  Ord (RingBackAnnounce)	= Succ (Ord (RecAnnounce));
	  Ord (RingTone)		= Succ (Ord (RingBackAnnounce));
	  Ord (SubsBusyTone)		= Succ (Ord (RingTone));
	  Ord (UnobtainTone)		= Succ (Ord (SubsBusyTone));
        ofsort Bool
	  n eq NoNum =>
	    IsCallingMess (n, cm)	= cm eq UnobtainTone;
	  n ne NoNum, IsHeld (n) =>
	    IsCallingMess (n, cm)	= cm eq SubsBusyTone;
	  n ne NoNum, not (IsHeld (n)) =>
	    IsCallingMess (n, cm) =
	      (cm eq EquipBusyTone) or (cm eq RecAnnounce) or
	        (cm eq RingTone);
	  cm`'an_lab1 eq cm`'an_lab2		= Ord (cm`'an_lab1) eq Ord (cm`'an_lab2);
	  cm`'an_lab1 ne cm`'an_lab2		= not (cm`'an_lab1 eq cm`'an_lab2);
  endtype (* CallingMess *)')

# "dig_type" produces a telephone digit type definition

define(dig_type,`
  (* dialled number digit *)

  type Dig is Boolean, NaturalNumber
    sorts Dig
    opns
      NoDig, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, H, S :	-> Dig	(* 0..9#* *)
      Ord :			Dig			-> Nat
      _ eq _, _ ne _, _ lt _ :	Dig, Dig		-> Bool
    eqns
      forall d`'an_lab1, d`'an_lab2 : Dig
        ofsort Nat
	  Ord (NoDig)	= 0;
	  Ord (0)	= Succ (Ord (NoDig));
	  Ord (1)	= Succ (Ord (0));
	  Ord (2)	= Succ (Ord (1));
	  Ord (3)	= Succ (Ord (2));
	  Ord (4)	= Succ (Ord (3));
	  Ord (5)	= Succ (Ord (4));
	  Ord (6)	= Succ (Ord (5));
	  Ord (7)	= Succ (Ord (6));
	  Ord (8)	= Succ (Ord (7));
	  Ord (9)	= Succ (Ord (8));
	  Ord (H)	= Succ (Ord (9));
	  Ord (S)	= Succ (Ord (H));
        ofsort Bool
	  d`'an_lab1 eq d`'an_lab2	= Ord (d`'an_lab1) eq Ord (d`'an_lab2);
	  d`'an_lab1 ne d`'an_lab2	= Ord (d`'an_lab1) ne Ord (d`'an_lab2);
	  d`'an_lab1 lt d`'an_lab2	= Ord (d`'an_lab1) lt Ord (d`'an_lab2);
  endtype (* Dig *)')

# "num_of(num)" produces the LOTOS representation of the decimal "num", such
# as "Num (S)+1+2+H" for "*12#"

define(num_of,
  `define(`an_num',`translit($1,`*#',`SH')')define(`an_len',
    `len(an_num)')ifelse(an_len,0,,
      an_len,1,`Num(an_num)',
        `Num(substr(an_num,0,1))+num_of_aux(decr(an_len),
	  substr(an_num,1))')')

define(num_of_aux,
  `ifelse($1,1,$2,
      `substr($2,0,1)+num_of_aux(decr($1),substr($2,1))')')

# "num_type" produces telephone number type definitions

define(num_type,`
  (* dialled number as digit string *)

  type Num0 is String actualizedby Dig, Boolean using
    sortnames
      Num	for String
      Dig	for Element
      Bool	for FBool
    opnnames
      Num	for String
  endtype (* Num0 *)

  (* dialled number operations *)

  type Num is Num0
    opns
      NoNum :		-> Num				(* null number *)
      BusyNum :		-> Num				(* busy number *)
      Held :	Num	-> Num				(* held number *)
      UnHeld :	Num	-> Num				(* num even if held *)
      IsHeld :	Num	-> Bool				(* number is held *)
    eqns
      forall d, d`'an_lab1, d`'an_lab2 : Dig, n, n`'an_lab1, n`'an_lab2 : Num
        ofsort Num
	  NoNum				= <>;
	  BusyNum			= Held (<>);
	  UnHeld (<>)			= <>;
	  UnHeld (d + n)		= d + n;
	  UnHeld (Held (n))		= n;
        ofsort Bool
	  IsHeld (<>)			= false;
	  IsHeld (d + n)		= false;
	  IsHeld (Held (n))		= true;
	  <> eq <>			= true;
	  <> eq (d`'an_lab2 + n`'an_lab2)		= false;
	  <> eq Held (n`'an_lab2)		= false;
	  (d`'an_lab1 + n`'an_lab1) eq <>		= false;
	  (d`'an_lab1 + n`'an_lab1) eq (d`'an_lab2 + n`'an_lab2)	= (d`'an_lab1 eq d`'an_lab2) and (n`'an_lab1 eq n`'an_lab2);
	  (d`'an_lab1 + n`'an_lab1) eq Held (n`'an_lab2)	= false;
	  Held (n`'an_lab1) eq <>		= false;
	  Held (n`'an_lab1) eq (d`'an_lab2 + n`'an_lab2)	= false;
	  Held (n`'an_lab1) eq Held (n`'an_lab2)	= n`'an_lab1 eq n`'an_lab2;
  endtype (* Num *)')

# "voice_type" produces a voice segment type definition

define(voice_type,`
  (* digitised voice segment *)

  type Voice0 is OctetString renamedby
    sortnames
      Voice	for OctetString
    opnnames
      Voice	for Octet
  endtype (* Voice0 *)

  type Voice is Voice0
    opns
      NoVoice : -> Voice				(* null id *)
    eqns
      ofsort Voice
        NoVoice = <>;
  endtype (* Voice *)')
