################################### Header ###################################

# "anise_prim_queue.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	16/02/98

# This "m4" macro file contains templates for generating Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.

# This particular file contains macros for service primitive queues.

# Copyright 1998 K. J. Turner, University of Stirling

###################### Primitive Queue Type Macros #########################

# "primqaux_type" produces a service primitive queue auxiliary type
# definition

define(primqaux_type,`
  (* service primitive queue auxiliary operations *)

  type PrimQueueAux is String actualizedby Prim using
    sortnames
      Prim for Element
      Bool for FBool
      PrimQueue for String
    opnnames
      <<>> for <>
      PrimQueue for String
  endtype (* PrimQueueAux *)')

# "primq_type" produces a service primitive queue type definition

define(primq_type,`primqaux_type

  (* service primitive queue *)

  type PrimQueue is PrimQueueAux
    opns
      Head		: PrimQueue		-> Prim
      Tail		: PrimQueue		-> PrimQueue
      RemPrev		: Prim, PrimQueue	-> PrimQueue
      RepPrev		: Prim, PrimQueue	-> PrimQueue
      IsNextQueue	: Prim, PrimQueue	-> Bool
      IsAheadQueue	: Prim, PrimQueue	-> Bool
    eqns
      forall prim, prim`'an_lab1, prim`'an_lab2 : Prim, primq : PrimQueue
        ofsort Prim
	  Head (prim`'an_lab2 + <<>>)			= prim`'an_lab2;
	  Head (prim`'an_lab2 + (prim`'an_lab1 + primq))	= Head (prim`'an_lab1 + primq);
	ofsort PrimQueue
	  Tail (prim`'an_lab2 + <<>>)			= <<>>;
	  Tail (prim`'an_lab2 + (prim`'an_lab1 + primq))	= prim`'an_lab2 + Tail (prim`'an_lab1 + primq);
	  RemPrev (prim`'an_lab2, <<>>)			= <<>>;
	  IsNextPrim (prim`'an_lab2, Head (prim`'an_lab1 + primq)) =>
	    RemPrev (prim`'an_lab2, prim`'an_lab1 + primq)	= Tail (prim`'an_lab1 + primq);
	  not (IsNextPrim (prim`'an_lab2, Head (prim`'an_lab1 + primq))) =>
	    RemPrev (prim`'an_lab2, prim`'an_lab1 + primq)	=
	      RemPrev (prim`'an_lab2, Tail (prim`'an_lab1 + primq)) + Head (prim`'an_lab1 + primq);
	  RepPrev (prim`'an_lab2, <<>>)			= <<>>;
	  IsNextPrim (prim`'an_lab2, Head (prim`'an_lab1 + primq)) =>
	    RepPrev (prim`'an_lab2, prim`'an_lab1 + primq)	= Tail (prim`'an_lab1 + primq) + prim`'an_lab2;
	  not (IsNextPrim (prim`'an_lab2, Head (prim`'an_lab1 + primq))) =>
	    RepPrev (prim`'an_lab2, prim`'an_lab1 + primq)	=
	      RepPrev (prim`'an_lab2, Tail (prim`'an_lab1 + primq)) + Head (prim`'an_lab1 + primq);
        ofsort Bool
	  IsNextQueue (prim`'an_lab2, <<>>)		= false;
	  IsNextQueue (prim`'an_lab2, prim`'an_lab1 + primq)	=
	    IsNextPrim (prim`'an_lab2, Head (prim`'an_lab1 + primq));
	  IsAheadQueue (prim`'an_lab2, <<>>)		= false;
	  IsNextPrim (prim`'an_lab2, Head (prim`'an_lab1 + primq)) =>
	    IsAheadQueue (prim`'an_lab2, prim`'an_lab1 + primq)	= true;
	  not (IsNextPrim (prim`'an_lab2, Head (prim`'an_lab1 + primq))),
	   GroupOf (prim`'an_lab2) eq GroupOf (Head (prim`'an_lab1 + primq)) =>
	    IsAheadQueue (prim`'an_lab2, prim`'an_lab1 + primq)	= false;
	  not (IsNextPrim (prim`'an_lab2, Head (prim`'an_lab1 + primq))),
	   GroupOf (prim`'an_lab2) ne GroupOf (Head (prim`'an_lab1 + primq)) =>
	    IsAheadQueue (prim`'an_lab2, prim`'an_lab1 + primq)	=
	      IsAheadQueue (prim`'an_lab2, Tail (prim`'an_lab1 + primq));
  endtype (* PrimQueue *)')
