################################### Header ###################################

# "anise_prim_type.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	12/08/98

# This "m4" macro file contains templates for generating Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.

# This particular file contains macros for service primitive types.

# Copyright 1998 K. J. Turner, University of Stirling

##################### All Type Definitions #######################

# "add_prim_type(prim)" adds the service primitive with parameters to the
# global "an_prims"

define(add_prim_type,
  `define(`an_prims',an_prims`'$1)')

# "add_prim_types(patt,group1,group2)" adds the service primitive names and
# parameters for pattern "patt" (asymmetric_confirmed, local_confirmed,
# provider_confirmed, provider_initiated, remote_confirmed, unconfirmed,
# user_confirmed, user_initiated, user_provider_confirmed), tries "an_group"
# and (optionally) acknowledgements "group2"; the pattern controls which
# request/indication/response/confirm primitives are generated. Note that
# for user_provider_confirmed, an additional Req/Con (or Req/Ind for two
# groups) is added to generated the required "next primitive" equations.

define(add_prim_types,
 `define(`an_proc1',`proc_of($2)')define(`an_pars1',
   `intrn_of(pars_of($2))')define(`an_proc2',`proc_of($3)')define(`an_pars2',
     `intrn_of(pars_of($3))')ifelse(an_proc1,,
      `rep_err(`Primitive type needed for $1')')ifelse(an_pars1,,
	`define(`an_pars1',intrn_of(`()'))')ifelse(an_pars2,,
	  `define(`an_pars2',
	    an_pars1)')ifelse(
	    $1,asymmetric_confirmed,
	      `add_prim_type(
	        an_proc1`'Req`'an_pars1)add_prim_type(
		  an_proc1`'Ind`'an_pars1)ifelse(an_proc2,,
		    `add_prim_type(
		      an_proc1`'Res`'an_pars2)',`add_prim_type(
		        an_proc2`'Req`'an_pars2)')',
	    $1,local_confirmed,
	      `add_prim_type(
	        an_proc1`'Req`'an_pars1)ifelse(an_proc2,,
		  `add_prim_type(
		    an_proc1`'Con`'an_pars2)',`add_prim_type(
		      an_proc2`'Ind`'an_pars2)')',
	    $1,provider_confirmed,
	      `add_prim_type(
	        an_proc1`'Req`'an_pars1)add_prim_type(
		  an_proc1`'Ind`'an_pars1)ifelse(an_proc2,,
		    `add_prim_type(
		      an_proc1`'Con`'an_pars2)',`add_prim_type(
		        an_proc2`'Ind`'an_pars2)')',
	    $1,provider_initiated,
	      `ifelse(an_proc2,,
	        `ifelse(an_pars1,an_pars2,`add_prim_type(
		  an_proc1`'Ind`'an_pars1)',
		    `rep_err(`No second group parameters in provider_initiated')')',
		      `rep_err(`No second group in provider_initiated')')',
	    $1,remote_confirmed,
	      `add_prim_type(
		an_proc1`'Ind`'an_pars1)ifelse(an_proc2,,
		  `add_prim_type(
		    an_proc1`'Res`'an_pars2)',`add_prim_type(
		      an_proc2`'Req`'an_pars2)')',
	    $1,unconfirmed,
	      `ifelse(an_proc2,,
	        `ifelse(an_pars1,an_pars2,`add_prim_type(
		  an_proc1`'Req`'an_pars1)add_prim_type(
		    an_proc1`'Ind`'an_pars1)',
		      `rep_err(
		        `No second group parameters in unconfirmed')')',
			  `rep_err(
			    `No second group in unconfirmed')')',
	    $1,user_confirmed,
	      `add_prim_type(
	        an_proc1`'Req`'an_pars1)add_prim_type(
		  an_proc1`'Ind`'an_pars1)ifelse(an_proc2,,
		    `add_prim_type(
		      an_proc1`'Res`'an_pars2)add_prim_type(
		        an_proc1`'Con`'an_pars2)',`add_prim_type(
		          an_proc2`'Req`'an_pars2)add_prim_type(
		            an_proc2`'Ind`'an_pars2)')',
	    $1,user_initiated,
	      `ifelse(an_proc2,,
	        `ifelse(an_pars1,an_pars2,`add_prim_type(
		  an_proc1`'Req`'an_pars1)',
		    `rep_err(`No second group parameters in user_initiated')')',
		      `rep_err(`No second group in user_initiated')')',
	    $1,user_provider_confirmed,
	      `add_prim_type(
	        an_proc1`'Req`'an_pars1)add_prim_type(
		  an_proc1`'Ind`'an_pars1)ifelse(an_proc1,an_proc2,
		    `add_prim_type(
		      an_proc1`'Res`'an_pars2)add_prim_type(
		        an_proc1`'Con`'an_pars2)add_prim_type(
			  an_proc1`'Req`'an_pars1)add_prim_type(
			    an_proc1`'Con`'an_pars2)',`add_prim_type(
			      an_proc2`'Req`'an_pars2)add_prim_type(
				an_proc2`'Ind`'an_pars2)add_prim_type(
				  an_proc1`'Req`'an_pars1)add_prim_type(
				    an_proc2`'Ind`'an_pars2)')',
	    `rep_err(`Unknown pattern $1')')')

# "all_types(string)" produces all type definitions based on the primitives
# given as functions in the string

define(all_types,`lib_type

(******************** Service Primitive Parameter Types ********************)
called_mess_type
calling_mess_type
dig_type
num_type
voice_type

(************************* Service Primitive Types *************************)
prim_type($1)
primq_type

(************************** Service Profile Types **************************)
call_fwd_type
dial_code_type
dial_one_type
screen_in_type
screen_out_type
prof_type

(******************** Service Primitive Internal Types ********************)
control_type
group_type
id_type
id_assoc_type
kind_type
num_assoc_type
res_type
')

# "an_prims" gives the kinds and parameters of service features

define(an_prims,
  `')

###################### Primitive Type Macros #########################

# "primaux_type" produces a service primitive auxiliary type definition

define(primaux_type,`
  (* service primitive operations *)

  type PrimAux is Kind, Group
    sorts Prim
    opns
      KindOf		: Prim		-> Kind
      GroupOf		: Prim		-> Group
      IsReq, IsInd	: Prim		-> Bool
      IsRes, IsCon	: Prim		-> Bool
      IsKind		: Prim, Kind	-> Bool
      IsGroup		: Prim, Group	-> Bool
      IsNextPrim	: Prim, Prim	-> Bool
      _ eq _, _ ne _	: Prim, Prim	-> Bool
    eqns
      forall prim : Prim, kind : Kind, group : Group
        ofsort Bool
	  IsKind (prim, kind)	= KindOf (prim) eq kind;
	  IsGroup (prim, group)	= GroupOf (prim) eq group;
  endtype (* PrimAux *)')

# "prim_con_opn(operation,parameters)" produces the signature of
# a constructor operation with given name and parameters

define(prim_con_opn,`
      $1 : ifelse($2,,,`extrn_of(ltrs_of($2)) ')-> Prim')

# "prim_con_opns(string)" produces the signatures of the
# constructor operations given as functions in the string

define(prim_con_opns,
  `map_funs($1,`prim_con_opn')')

# "prim_dir_eqn(operation,parameters)" produces the equation for
# the recogniser operation corresponding to the given operation
# and parameters. The global "dir1" defines the direction (Req/Ind/Res/Con).

define(prim_dir_eqn,
  `ifelse(eval(index($1,dir1) != -1),1,`ifdef(`an_list',
    `define(`line_len',
      eval(line_len + len(` or IsKind (Prim, $1Kind)')))ifelse(
        eval(line_len<line_max),1,
	  `define(`an_list',
	    an_list or IsKind (Prim, $1Kind))',`define(`an_list',
	      an_list or
		IsKind (Prim, $1Kind))define(`line_len',0)')',
	    `define(`an_list',`            IsKind (Prim, $1Kind)')')')')

# "prim_dir_eqns(string,direction)" produces the equations for the recogniser
# operations corresponding to the functions in the string

define(prim_dir_eqns,
  `undefine(`an_list')define(`line_len',0)define(`dir1',
    $2)map_funs($1,`prim_dir_eqn')ifdef(`an_list',
      `          Is`'dir1 (Prim) =
an_list;
')')

# "prim_eq_arg(parameter)" produces a conditional requiring
# equality of each parameter in the string

define(prim_eq_arg,
  `ifdef(`an_list',
    `define(`an_list',`('an_list`)' and `('$1`'an_lab1 eq $1`'an_lab2`)')',
      `define(`an_list',$1`'an_lab1 eq $1`'an_lab2)')')

# "prim_eq_args(string)" produces a compound conditional requiring
# equality of each argument in the string

define(prim_eq_args,
  `undefine(`an_list')map_args(
    lower_of($1),`prim_eq_arg')            an_list;')

# "prim_eq_eqn(operation,parameters)" produces the equation for
# the equality operation corresponding to the given operation and
# parameters

define(prim_eq_eqn,
  `          ifelse($2,,$1 eq $1 = true;,
    $1 (extrn_of(lab_args(lower_of($2),
      `an_lab1'))) eq $1 (extrn_of(lab_args(lower_of($2),
        `an_lab2'))) =
prim_eq_args($2))
')

# "prim_eq_eqns(string)" produces the equations for the equality
# operation corresponding to the functions in the string

define(prim_eq_eqns,`          KindOf (prim`'an_lab1) ne KindOf (prim`'an_lab2) =>
            prim`'an_lab1 eq prim`'an_lab2 = false;
map_funs($1,
  `prim_eq_eqn')          prim`'an_lab1 ne prim`'an_lab2 = not (prim`'an_lab1 eq prim`'an_lab2);
')

# "prim_eqns(string)" produces the signatures of the operations
# for the functions in the string, as well as the auxiliary
# operations

define(prim_eqns,
  `define(`uniq_prims',
    `uniq_funcs($1)')define(`uniq_prims_pars',
      `uniq_funcs_pars($1)')
        (* service primitive parameter extractors *)prim_par_eqns($1)

        (* service primitive kind names *)
        ofsort Kind
prim_kind_eqns(uniq_prims_pars)
        (* service primitive kind ordinals *)
        ofsort Nat
prim_kind_ord_eqns(uniq_prims)
        (* service primitive group names *)
        ofsort Group
prim_group_eqns(uniq_prims_pars)
        (* service primitive group ordinals *)
        ofsort Nat 
prim_group_ord_eqns(uniq_prims)
        (* service primitive results *)
        ofsort Result
prim_res_eqns(uniq_prims)
        (* service primitive (in)equality *)
        ofsort Bool
prim_eq_eqns(uniq_prims_pars)
        (* service primitive recognisers *)
        ofsort Bool
prim_rec_eqns(uniq_prims)
        (* service primitive successors *)
        ofsort Bool
prim_next_eqns($1)
')

# "prim_for_dec(operation,parameters)" produces the global
# variable declarations for the primitive with given parameters

define(prim_for_dec,
  `map_args($2,`prim_var_dec')')

# "prim_for_decs(string)" produces the global variable declarations for the
# primitives given as functions given in the string

define(prim_for_decs,
  `undefine(`an_list')map_funs([Prim]$1,`prim_for_dec')extrn_of(`an_list')')

# "prim_group_eqn(operation,parameters)" produces the equations for the group
# operation of the primitive with the given name and parameters

define(prim_group_eqn,
  `          GroupOf `('$1`'ifelse($2,,,
    ` `('extrn_of(lower_of($2))`)'')`)'	= group_of($1)Group;
')

# "prim_group_eqns(string)" produces the equations for the group operations of
# primitives given as functions in the string

define(prim_group_eqns,`map_funs($1,`prim_group_eqn')')

# "prim_group_ord_eqn(operation,parameters)" produces the equation for the
# ordinal value of the group operation defined by the primitive with the
# given name and parameters

define(prim_group_ord_eqn,
  `define(`an_eqn',)define(`an_group',group_of($1)Group)ifelse(`an_list',,,
    `define(`an_ind',index(an_list,an_group))ifelse(an_ind,-1,
      `define(`an_eqn',`          Ord (an_group)	= ord;
define(`ord',Succ (Ord (an_group)))')')')define(`an_list',an_list`'an_eqn)')

# "prim_group_ord_eqns(string)" produces the equations for the ordinal
# values of group operations defined by functions in the string

define(prim_group_ord_eqns,
  `define(`an_list',)define(`ord',0)map_funs($1,`prim_group_ord_eqn')an_list')

# "prim_group_opn(operation,parameters)" produces the signature of the group
# operation for the primitive with given name and parameters.

define(prim_group_opn,
  `define(`an_group',`group_of($1)Group')ifdef(`an_list',
    `define(`an_ind_go',
      index(an_list,an_group))ifelse(an_ind_go,-1,`define(`line_len',
	eval(line_len + len(|an_group)))ifelse(eval(line_len < line_max),1,
	  `define(`an_list',an_list| an_group)',`define(`an_list',an_list|
	an_group)define(`line_len',0)')')',`define(`an_list',an_group)')')

# "prim_group_opns(string)" produces the signature of the
# group operations for primitives given as functions in the string

define(prim_group_opns,
  `undefine(`an_list')define(`line_len',0)map_funs(
    $1,`prim_group_opn')      extrn_of(an_list) : -> Group')

# "prim_is_next_eqn(operation,parameters)" produces the equation for
# the "next primitive" operation corresponding to the current and
# previous operation and parameters ("an_oper2"/"an_pars2" and
# "an_oper1"/"an_pars1" respectively)

define(prim_is_next_eqn,
  `define(`an_oper2',$1)define(`an_pars2',$2)ifdef(`an_oper1',
    `ifelse(prim_next(an_oper2,an_oper1),1,
      `          IsNextPrim (an_oper2`'ifelse(an_pars2,,,
        ` (extrn_of(lab_args(lower_of(an_pars2),
        `an_lab1')))'), an_oper1`'ifelse(an_pars1,,,
        ` (extrn_of(lab_args(lower_of(an_pars1),
        `an_lab2')))')) = ifelse(an_pars1,an_pars2,ifelse(an_pars1,,true;,`
prim_eq_args($2)'),true;)
')')define(`an_oper1',an_oper2)define(`an_pars1',an_pars2)')

# "prim_is_next_eqns(string)" produces the equations for the "next primitive"
# operation corresponding to the functions in the string

define(prim_is_next_eqns,
  `undefine(`an_oper1')undefine(`an_pars1')map_funs($1,`prim_is_next_eqn')')

# "prim_kind_eqn(operation,parameters)" produces the equations for the kind
# operation of the primitive with the given name and parameters

define(prim_kind_eqn,
  `          KindOf ($1`'ifelse($2,,,
    ` (extrn_of(lower_of($2)))')) = proc_of($1)Kind;
')

# "prim_kind_eqns(string)" produces the equations for the kind operations of
# primitives given as functions in the string

define(prim_kind_eqns,`map_funs($1,`prim_kind_eqn')')

# "prim_kind_ord_eqn(operation,parameters)" produces the equation for the
# ordinal value of the kind operation defined by the primitive with the
# given name and parameters

define(prim_kind_ord_eqn,
  `          Ord ($1Kind)	= ord;define(`ord',
      Succ (Ord ($1Kind)))
')

# "prim_kind_ord_eqns(string)" produces the equations for the ordinal
# values of kind operations defined by functions in the string

define(prim_kind_ord_eqns,
  `define(`ord',0)map_funs($1,`prim_kind_ord_eqn')')

# "prim_kind_opn(operation,parameters)" produces the signature of the kind
# operation for the primitive with given name and parameters

define(prim_kind_opn,
  `ifdef(`an_list',
    `define(`line_len',
      eval(line_len + len(|$1Kind)))ifelse(eval(line_len < line_max),1,
        `define(`an_list',an_list| $1Kind)',`define(`an_list',an_list|
        $1Kind)define(`line_len',0)')',`define(`an_list',$1Kind)')')

# "prim_kind_opns(string)" produces the signature of the
# kind operations for primitives given as functions in the string

define(prim_kind_opns,
  `undefine(`an_list')define(`line_len',0)map_funs(
    $1,`prim_kind_opn')      extrn_of(an_list) : -> Kind')

# "prim_next(prim2,prim1)" returns 1 if "prim2" logically follows "prim1",
# i.e. it has the same group and is one of the pairs Con/Ind, Con/Req,
# Con/Res, Ind/Req, Res/Ind; alternatively returns 1 if the primitives are
# consecutive groups and are one of the pairs Ind/Req, Req/Ind;
# otherwise returns 0

define(prim_next,
  `define(`pn_role2',role_of($1))define(`pn_role1',role_of($2))ifelse(
    group_same($1,$2),1,
      `ifelse(
	pn_role2,Con,
	  `ifelse(pn_role1,Ind,1,pn_role1,Req,1,pn_role1,Res,1,0)',
	pn_role2,Ind,
	  `ifelse(pn_role1,Req,1,0)',
	pn_role2,Res,
	  `ifelse(pn_role1,Ind,1,0)',
	pn_role2,Req,
	  `ifelse(pn_role1,Ind,`group_next($1,$2)',0)',
	0)',
    group_next($1,$2),1,
      `ifelse(
	pn_role2,Ind,
	  `ifelse(pn_role1,Req,1,0)',
	pn_role2,Req,
	  `ifelse(pn_role1,Ind,1,0)')',0)')

# "prim_next_eqns(string)" produces the equations for the "next primitive"
# operation corresponding to the functions in the string

define(prim_next_eqns,
  `prim_not_next_eqns($1)
prim_is_next_eqns($1)')

# "prim_not_next_eqn(operation,parameters)" produces the equation for the
# not "next primitive" operation corresponding to the current and
# previous operation and parameters ("an_oper2"/"an_pars2" and
# "an_oper1"/"an_pars1" respectively). The comma in the list is "protected"
# by making it an internal "|"

define(prim_not_next_eqn,
  `define(`an_oper2',$1)ifdef(`an_oper1',
    `ifelse(prim_next(an_oper2,an_oper1),1,
      `ifdef(`an_list',`define(`an_list',an_list|
            not (IsKind (prim`'an_lab1, an_oper2`'Kind) and IsKind (prim`'an_lab2, an_oper1`'Kind)))',
        `define(`an_list',
not (IsKind (prim`'an_lab1, an_oper2`'Kind) and IsKind (prim`'an_lab2, an_oper1`'Kind)))')')')define(`an_oper1',
          an_oper2)')

# "prim_not_next_eqns(string)" produces the equations for the not
# "next primitive" operation corresponding to the functions in the string

define(prim_not_next_eqns,
  `undefine(`an_list')undefine(`an_oper1')map_funs($1,
    `prim_not_next_eqn')ifdef(`an_list',`          extrn_of(an_list) =>
              IsNextPrim (prim`'an_lab1, prim`'an_lab2) = false;')')

# "prim_opns(string)" produces the signatures of the operations
# for the functions in the string, as well as the auxiliary
# operations

define(prim_opns,
`define(`uniq_prims',
  `uniq_funcs($1)')define(`uniq_prims_pars',
    `uniq_funcs_pars($1)')prim_con_opns(
      uniq_prims_pars)`'prim_par_opns($1)
prim_kind_opns(
        uniq_prims)`
'prim_group_opns(uniq_prims)`
'prim_res_opns')

# "prim_par_eqn_eqn(operation,parameters)" produces the equations for the
# parameter extraction operation for the given parameters; global "an_par"
# is assumed to contain the current parameter name

define(prim_par_eqn_eqn,
  `define(`an_ind',
    `ifelse(`$2',,-1,
      `index(`$2',an_par)')')ifelse(an_ind,-1,,
        `ifelse(an_list1,,
	  `define(`an_list1',
	    IsKind (Prim, $1`'Kind))',
	  `define(`an_list1',
	    an_list1 or
            IsKind (Prim, $1`'Kind))')define(`an_list2',an_list2`
	  an_par`'Of ($1 (extrn_of(lower_of($2)))) = lower_of(an_par);')')')

# "prim_par_eqn_eqns(parameter)" produces the equations for the
# parameter extraction operation implied by the given parameter;
# global "an_prims" is assumed to contain all the primitives in internal form

define(prim_par_eqn_eqns,
  `define(`an_list1',
    `')define(`an_list2',
      `')define(`an_par',`$1')map_funs(an_prims,
        `prim_par_eqn_eqn')
	ofsort an_par
	  not (an_list1) =>
	      an_par`'Of (Prim) = No`'an_par;an_list2')

# "prim_par_eqn(operation,parameters)" produces the equations for the
# parameter extraction operation given by the parameters in the string

define(prim_par_eqn,
  `define(`an_ind',
    `ifelse(`an_list',,-1,
      `$2',,0,
        `index(an_list,[$2])')')ifelse(an_ind,-1,
	  `define(`an_list',an_list[$2])prim_par_eqn_eqns($2)')')

# "prim_par_eqns(string)" produces the equations for the parameter
# extraction operations given by functions in the string

define(prim_par_eqns,
  `define(`an_list',
    `')map_funs($1,`prim_par_eqn')')

# "prim_par_opn(operation,parameters)" produces the signature of
# a parameter operation with given name and parameters

define(prim_par_opn,
  `define(`an_ind',
    `ifelse(`an_list',,-1,
      `$2',,0,
        `index(an_list,[$2])')')ifelse(an_ind,-1,
	  `define(`an_list',an_list[$2])
      $2`'Of : Prim -> $2')')

# "prim_par_opns(string)" produces the signatures of the parameter operations
# given by functions in the string

define(prim_par_opns,
  `define(`an_list',
    `')map_funs($1,`prim_par_opn')')

# "prim_rec_eqns(string)" produces the equations for the recogniser
# operations corresponding to the functions in the string

define(prim_rec_eqns,
  `prim_dir_eqns($1,
    Req)prim_dir_eqns($1,
      Ind)prim_dir_eqns($1,
        Res)prim_dir_eqns($1,
          Con)')

# "prim_res_eqn(operation,parameters)" produces the equation for
# the result operation if the operation is for a confirm primitive

define(prim_res_eqn,
  `define(`an_oper',$1)define(`an_pars',
    $2)            ResultOf (an_oper`'ifelse(an_pars,,,
      ` (extrn_of(lab_args(lower_of(an_pars),
      `an_lab1')))')) = ifelse(an_pars,,NoRes,
      ` Result (extrn_of(lab_args(lower_of(an_pars),
      `an_lab1')))');
')

# "prim_res_eqns(string)" produces the equations for the result
# operation corresponding to the functions in the string

define(prim_res_eqns,
  `map_funs($1,`prim_res_eqn')')

# "prim_res_opns" produces the signature of the result operation

define(prim_res_opns,
  `      ResultOf : Prim -> Result')

# "prim_type(string)" produces a service primitive type definition based
# on the primitives given as functions in the string

define(prim_type,`primaux_type

  (* service primitives *)

  type Prim is PrimAux, Result
    opns`'prim_opns($1)
    eqns
      forall`'prim_for_decs($1)
prim_eqns($1)  endtype (* Prim *)')

# "prim_var_dec(parameter)" produces the global variable
# declarations for the given parameter of a constructor operation.
# Declarations of the same sort are grouped in an order such as:
#
#  Par, ParA, ParB, Par1, Par1A, Par1B, Par2, Par2A, Par2B : Par

define(prim_var_dec,
  `define(`an_par',
    lower_of($1))ifdef(`an_list',
      `ifelse(index(an_list,an_par| ),-1,
	`ifelse(index(an_list,an_par ),-1,
	  `define(`an_ind1',
	    index(an_list,ltrs_of($1)))ifelse(an_ind1,-1,
	    `define(`an_list',an_list|
       an_par| an_par`'an_lab1| an_par`'an_lab2 : ltrs_of($1))',
	      `ifelse($1,ltrs_of($1),
		`define(`an_list',
		  substr(an_list,0,
		    an_ind1)an_par| an_par`'an_lab1| an_par`'an_lab2| substr(an_list,
		      an_ind1))',
		  `define(`an_ind2',
		    `index(substr(an_list,an_ind1),` ')')define(`an_ind2',
		      eval(an_ind1+an_ind2))define(`an_list',
			substr(an_list,0,
			  an_ind2)| an_par| an_par`'an_lab1| an_par`'an_lab2`'substr(an_list,
			    an_ind2))')')')')',
      `define(`an_list',`
       'an_par| an_par`'an_lab1| an_par`'an_lab2 : ltrs_of($1))')')

