################################### Header ###################################

# "anise_prof.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	21/08/98

# This "m4" macro file contains templates for generating Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.

# This particular file contains macros for subscriber profiles.

# Copyright 1998 K. J. Turner, University of Stirling

############################ Prof Type Macros ############################

# "an_<par>" defines the current profile parameter ("dial_code",
# "call_fwd", "call_one", "ring", "screen_in", "screen_out")

# "an_profs" defines the current profile value

define(an_profs,
  `')

# "an_prof_checks" defines the profile values to be checked

define(an_prof_checks,
  `')

# "call_divert(num,cond)" produces in global "an_call_divert" a forwarding
# value; the default condition is "FwdUncond" if "cond" is omitted. Also
# adds the forwarding number to "an_prof_check".

define(call_divert,
  `define(`an_prof_check',
    ifelse(an_prof_check,,
      |$1,|$1substr(an_prof_check,1)))define(`an_call_divert',
        `Fwd (num_of($1), `ifelse($2,,FwdUncond,Fwd`'$2)')')')

# "call_fwd_type" produces a call forwarding type definition

define(call_fwd_type,`
  (* call forwarding condition *)

  type FwdCond is Boolean, NaturalNumber
    sorts FwdCond
    opns
      FwdNone, FwdUncond, FwdNoAnswer, FwdBusyLine :	-> FwdCond
      Ord :		FwdCond				-> Nat
      _ eq _, _ ne _ :	FwdCond, FwdCond		-> Bool
    eqns
      forall fc`'an_lab1, fc`'an_lab2 : FwdCond
        ofsort Nat
	  Ord (FwdNone)		= 0;
	  Ord (FwdUncond)	= Succ (Ord (FwdNone));
	  Ord (FwdNoAnswer)	= Succ (Ord (FwdUncond));
	  Ord (FwdBusyLine)	= Succ (Ord (FwdNoAnswer));
        ofsort Bool
	  fc`'an_lab1 eq fc`'an_lab2		= Ord (fc`'an_lab1) eq Ord (fc`'an_lab2);
	  fc`'an_lab1 ne fc`'an_lab2		= not (fc`'an_lab1 eq fc`'an_lab2);
  endtype (* FwdCond *)

  (* call forwarding definition *)

  type Fwd is FwdCond, Num
    sorts Fwd
    opns
      NoFwd :				-> Fwd		(* no forwarding *)
      Fwd :		Num, FwdCond	-> Fwd		(* fwd. num./cond. *)
      FwdNum :		Fwd		-> Num		(* forwarding num. *)
      FwdCond :		Fwd		-> FwdCond	(* forwarding cond. *)
      _eq _, _ ne _ :	Fwd, Fwd	-> Bool
    eqns
      forall
       n : Num, fc : FwdCond, fw`'an_lab1, fw`'an_lab2 : Fwd
        ofsort Num
	  FwdNum (NoFwd)	= NoNum;
	  FwdNum (Fwd (n, fc))	= n;
        ofsort FwdCond
	  FwdCond (NoFwd)	= FwdNone;
	  FwdCond (Fwd (n, fc))	= fc;
        ofsort Bool
	  fw`'an_lab1 eq fw`'an_lab2 =
	    (FwdNum (fw`'an_lab1) eq FwdNum (fw`'an_lab2)) and
	      (FwdCond (fw`'an_lab1) eq FwdCond (fw`'an_lab2));
	  fw`'an_lab1 ne fw`'an_lab2 = not (fw`'an_lab1 eq fw`'an_lab2);
  endtype (* Fwd *)')

# "call_wait" sets global "an_call_wait" for call ring-back

define(call_wait,
  `define(`an_call_wait',True)')

# "dial_code(pars)" produces in global "an_dial_code" a list of
# number expansions given the parameters "abbrev1->expans1, ..."

define(dial_code,
  `ifelse($1,,
    `define(`an_dial_code',<>)rep_err(Abbreviated numbers required)',
      `undefine(`an_dial_code')map_args(intrn_of(`$*'),
        `dial_code_val')')')

# "dial_code_type" produces an abbreviated number type definition

define(dial_code_type,`
  (* abbreviated number expansion *)

  type Abbrev is Num, Id
    sorts Abbrev
    opns
      Abbrev :		Num, Num	-> Abbrev	(* from/to number *)
      AbbrFrom :	Abbrev		-> Num		(* abbr. number *)
      AbbrTo :		Abbrev		-> Num		(* full number *)
      _eq _, _ ne _ :	Abbrev, Abbrev	-> Bool
    eqns
      forall
       n`'an_lab1, n`'an_lab2 : Num,
       ab`'an_lab1, ab`'an_lab2 : Abbrev
        ofsort Num
	  AbbrFrom (Abbrev (n`'an_lab1, n`'an_lab2)) = n`'an_lab1;
	  AbbrTo (Abbrev (n`'an_lab1, n`'an_lab2)) = n`'an_lab2;
        ofsort Bool
	  ab`'an_lab1 eq ab`'an_lab2 =
	    (AbbrFrom (ab`'an_lab1) eq AbbrFrom (ab`'an_lab2)) and
	      (AbbrTo (ab`'an_lab1) eq AbbrTo (ab`'an_lab2));
	  ab`'an_lab1 ne ab`'an_lab2 = not (ab`'an_lab1 eq ab`'an_lab2);
  endtype (* Abbrev *)

  (* list of abbreviated number expansions *)

  type Abbrevs is String actualizedby Abbrev, Boolean using
    sortnames
      Abbrevs	for String
      Abbrev	for Element
      Bool	for FBool
    opnnames
      Abbrevs	for String
  endtype (* Abbrevs *)')

# "dial_code_val(par)" adds to global "an_dial_code" the expansion
# value given by parameter "par"

define(dial_code_val,
  `define(`an_ind',`index($1,`->')')ifelse(
    an_ind,-1,
      `rep_err(`Missing arrow in abbreviation list')',
    `define(`an_num1',
      num_of(substr($1,0,an_ind)))define(`an_num2',
	num_of(substr($1,
	  eval(an_ind+2))))ifelse(
	    an_num1,,
	      `rep_err(Missing first number in abbreviation list)',
	    an_num2,,
	      `rep_err(Missing second number in abbreviation list)',
	    `define(`an_exp',Abbrev (an_num1, an_num2))ifdef(`an_dial_code',
	      `define(`an_dial_code',an_dial_code +`
	       'an_exp)',
		`define(`an_dial_code',
	      Abbrevs (an_exp))')')')')

# "dial_one(pars)" produces in global "an_dial_one" a list of one-numbers
# given by the parameters "num1, ..."

define(dial_one,
  `ifelse($1,,
    `define(`an_dial_one',<>)rep_err(One-numbers required)',
      `undefine(`an_dial_one')map_args(intrn_of(`$*'),
        `dial_one_val')')')

# "dial_one_type" produces a one-number type definition

define(dial_one_type,`
  (* list of numbers for one-number *)

  type Ones is String actualizedby Num, Boolean using
    sortnames
      Ones	for String
      Num	for Element
      Bool	for FBool
    opnnames
      Ones	for String
  endtype (* Ones *)')

# "dial_one_val(par)" adds to global "an_dial_one" the one-number given by
# parameter "par". Also adds the one-number to "an_prof_check".

define(dial_one_val,
  `define(`an_exp',`num_of($1)')define(`an_prof_check',
    ifelse(an_prof_check,,||$1,an_prof_check|$1))ifdef(`an_dial_one',
      `define(`an_dial_one',an_dial_one +`
                '(an_exp))',
		`define(`an_dial_one',`
              'Ones (an_exp))')')

# "prof_type" produces a profile type definition

define(prof_type,`
  (* subscriber `profile' *)

  type Prof is
   Num, Id, Abbrevs, Fwd, Ones, Boolean, CalledMess, ScrIns, ScrOuts
    sorts Prof
    opns
      Prof :		Num, Id, Abbrevs, Fwd, Bool, Ones, Bool, CalledMess,
			ScrIns, ScrOuts -> Prof
      ProfNum :		Prof		-> Num
      ProfId :		Prof		-> Id
      ProfAbbrs :	Prof		-> Abbrevs
      ProfFwd :		Prof		-> Fwd
      ProfOnes :	Prof		-> Ones
      ProfReturn :	Prof		-> Bool
      ProfRing :	Prof		-> CalledMess
      ProfScrIns :	Prof		-> ScrIns
      ProfScrOuts :	Prof		-> ScrOuts
      ProfWait :	Prof		-> Bool
      _eq _, _ ne _ :	Prof, Prof	-> Bool
    eqns
      forall
       n : Num, id : Id,
       as : Abbrevs, fw : Fwd, os : Ones, cw, rt : Bool, rp : CalledMess,
       sis : ScrIns, sos : ScrOuts,
       pr`'an_lab1, pr`'an_lab2 : Prof
        ofsort Num
	  ProfNum (Prof (n, id, as, fw, cw, os, rt, rp, sis, sos)) = n;
        ofsort Id
	  ProfId (Prof (n, id, as, fw, cw, os, rt, rp, sis, sos)) = id;
        ofsort Abbrevs
	  ProfAbbrs (Prof (n, id, as, fw, cw, os, rt, rp, sis, sos)) = as;
        ofsort Fwd
	  ProfFwd (Prof (n, id, as, fw, cw, os, rt, rp, sis, sos)) = fw;
        ofsort Bool
	  ProfWait (Prof (n, id, as, fw, cw, os, rt, rp, sis, sos)) = cw;
        ofsort Ones
	  ProfOnes (Prof (n, id, as, fw, cw, os, rt, rp, sis, sos)) = os;
        ofsort Bool
	  ProfReturn (Prof (n, id, as, fw, cw, os, rt, rp, sis, sos)) = rt;
        ofsort CalledMess
	  ProfRing (Prof (n, id, as, fw, cw, os, rt, rp, sis, sos)) = rp;
        ofsort ScrIns
	  ProfScrIns (Prof (n, id, as, fw, cw, os, rt, rp, sis, sos)) = sis;
        ofsort ScrOuts
	  ProfScrOuts (Prof (n, id, as, fw, cw, os, rt, rp, sis, sos)) = sos;
        ofsort Bool
	  pr`'an_lab1 eq pr`'an_lab2 =
	    (ProfNum (pr`'an_lab1) eq ProfNum (pr`'an_lab2)) and
	    (ProfId (pr`'an_lab1) eq ProfId (pr`'an_lab2)) and
	    (ProfAbbrs (pr`'an_lab1) eq ProfAbbrs (pr`'an_lab2)) and
	    (ProfFwd (pr`'an_lab1) eq ProfFwd (pr`'an_lab2)) and
	    (ProfOnes (pr`'an_lab1) eq ProfOnes (pr`'an_lab2)) and
	    (ProfReturn (pr`'an_lab1) eq ProfReturn (pr`'an_lab2)) and
	    (ProfRing (pr`'an_lab1) eq ProfRing (pr`'an_lab2)) and
	    (ProfScrIns (pr`'an_lab1) eq ProfScrIns (pr`'an_lab2)) and
	    (ProfScrOuts (pr`'an_lab1) eq ProfScrOuts (pr`'an_lab2)) and
	    (ProfWait (pr`'an_lab1) eq ProfWait (pr`'an_lab2));
	  pr`'an_lab1 ne pr`'an_lab2 =
	    not (pr`'an_lab1 eq pr`'an_lab2);
  endtype (* Prof *)

  (* list of subscriber profiles *)

  type Profs0 is String actualizedby Prof, Boolean using
    sortnames
      Profs	for String
      Prof	for Element
      Bool	for FBool
    opnnames
      Profs	for String
  endtype (* Profs0 *)

  (* subscriber `profile' list basic operations *)

  type Profs is Profs0
    opns
      Profiles :			  -> Profs	(* current profiles *)
      IsId :	       Id, Num		  -> Bool	(* id OK for num? *)
      IdNum :	       Id, Num		  -> Num	(* number for id *)
      IdNum :	       Id		  -> Num	(* number for id *)
      ProfIdNum :      Id, Profs	  -> Num	(* number for id *)
      NumId :	       Num		  -> Id		(* id for number *)
      ProfNumId :      Num, Profs	  -> Id		(* id for number *)
    eqns
      forall
       n, n`'an_lab1, n`'an_lab2 : Num, id : Id, pr : Prof, prs : Profs
        ofsort Profs
	  Profiles = ifelse(an_profs,,
	    `rep_err(No profiles defined)<>',`an_profs');
	ofsort Bool
          IsId (id, n) =
	    (n ne NoNum) implies (id eq ProfNumId (n, Profiles));
	ofsort Id
          NumId (n) = ProfNumId (n, Profiles);
	  ProfNumId (n, <>) = NoId;
	  n eq ProfNum (pr) =>
	    ProfNumId (n, pr + prs) = ProfId (pr);
	  n ne ProfNum (pr) =>
	    ProfNumId (n, pr + prs) = ProfNumId (n, prs);
	ofsort Num
          IdNum (id) = ProfIdNum (id, Profiles);
          IdNum (id, <>) = ProfIdNum (id, Profiles);
	  n ne NoNum =>
            IdNum (id, n) = n;
	  ProfIdNum (id, <>) = NoNum;
	  id eq ProfId (pr) =>
	    ProfIdNum (id, pr + prs) = ProfNum (pr);
	  id ne ProfId (pr) =>
	    ProfIdNum (id, pr + prs) = ProfIdNum (id, prs);
  endtype (* Profs *)

  (* subscriber `profile' list advanced operations *)

  type ProfOps is Profs, IdAssocs
    opns
      ProfCallBack :   Num, Profs	    -> Bool	  (* caller return? *)
      ProfCallWait :   Num, Profs	    -> Bool	  (* call waiting? *)
      ProfCallRing :   Num, Profs	    -> CalledMess (* called ring *)
      ProfNumOne :     Num, Ones	    -> Bool	  (* is one-number? *)
      ProfAssocNum :   Num, IdAssocs, IdAssocs -> Num     (* call wait num *)
      ProfCallAbbr :   Num, Num, Profs	    -> Num	  (* expand called *)
      ProfCallOne :    Num, Profs	    -> Num	  (* expand one-num *)
      ProfCallScrIn :  Num, Num, Profs	    -> Num	  (* screen caller *)
      ProfCallScrOut : Num, Num, Profs	    -> Num	  (* screen called *)
      ProfFwdBusy :    Num, IdAssocs, Profs -> Num	  (* forward busy *)
      ProfFwdUncond :  Num, Profs	    -> Num	  (* forward uncond *)
      ProfNumAbbr :    Num, Abbrevs	    -> Num	  (* expand called *)
      ProfNumBusy :    Num, IdAssocs, Profs -> Num	  (* forward busy *)
      ProfNumScrIn :   Num, ScrIns	    -> Num	  (* screen caller *)
      ProfNumScrOut :  Num, ScrOuts	    -> Num	  (* screen called *)
     eqns
      forall
       n, n`'an_lab1, n`'an_lab2 : Num,
       as : Abbrevs, fw : Fwd, os : Ones, sis : ScrIns, sos : ScrOuts,
       ass, nws :IdAssocs, pr : Prof, prs : Profs

	ofsort Bool

	  (* n allows ring-back? *)
	  ProfCallBack (n, <>) = false;
	  n eq ProfNum (pr) =>
	    ProfCallBack (n, pr + prs) = ProfReturn (pr);
	  n ne ProfNum (pr) =>
	    ProfCallBack (n, pr + prs) = ProfCallBack (n, prs);

	  (* n allows call waiting? *)
	  ProfCallWait (n, <>) = false;
	  n eq ProfNum (pr) =>
	    ProfCallWait (n, pr + prs) = ProfWait (pr);
	  n ne ProfNum (pr) =>
	    ProfCallWait (n, pr + prs) = ProfCallWait (n, prs);

	  (* n has one-number equivalent? *)
	  ProfNumOne (n, <>) = false;
	  n`'an_lab1 eq n`'an_lab2 =>
	    ProfNumOne (n`'an_lab1, n`'an_lab2 + os) = true;
	  n`'an_lab1 ne n`'an_lab2 =>
	    ProfNumOne (n`'an_lab1, n`'an_lab2 + os) =
	      ProfNumOne (n`'an_lab1, os);

	ofsort CalledMess

	  (* calling number display, distinctive ring *)
	  ProfCallRing (n, <>) = NoCalledMess;
	  n eq ProfNum (pr) =>
	    ProfCallRing (n, pr + prs) = ProfRing (pr);
	  n ne ProfNum (pr) =>
	    ProfCallRing (n, pr + prs) = ProfCallRing (n, prs);

	ofsort Num

	  (* -/n/Held(n) according to availability of n, call waiting
	     available for n, and call waiting not suspended for n *)
	  NumId (n) eq NoId =>
	    ProfAssocNum (n, ass, nws) = NoNum;
	  NumId (n) ne NoId, IdAssocAvail (NumId (n), ass) =>
	    ProfAssocNum (n, ass, nws) = n;
	  NumId (n) ne NoId, not (IdAssocAvail (NumId (n), ass)),
	   ProfCallWait (n, Profiles), IdAssocAvail (NumId (n), nws) =>
	    ProfAssocNum (n, ass, nws) = n;
	  NumId (n) ne NoId, not (IdAssocAvail (NumId (n), ass)),
	   not (ProfCallWait (n, Profiles)) or
	    not (IdAssocAvail (NumId (n), nws)) =>
	    ProfAssocNum (n, ass, nws) = Held (n);

	  (* abbreviated dialling expansion for n2 in `profile' for n1 *)
	  ProfCallAbbr (n`'an_lab1, n`'an_lab2, <>) = n`'an_lab2;
	  n`'an_lab1 eq ProfNum (pr) =>
	    ProfCallAbbr (n`'an_lab1, n`'an_lab2, pr + prs) =
	      ProfNumAbbr (n`'an_lab2, ProfAbbrs (pr));
	  n`'an_lab1 ne ProfNum (pr) =>
	    ProfCallAbbr (n`'an_lab1, n`'an_lab2, pr + prs) =
	      ProfCallAbbr (n`'an_lab1, n`'an_lab2, prs);

	  (* one-number expansion for n in its `profile' *)
	  ProfCallOne (n, <>) = n;
	  ProfNumOne (n, ProfOnes (pr)) =>
	    ProfCallOne (n, pr + prs) = ProfNum (pr);
	  not (ProfNumOne (n, ProfOnes (pr))) =>
	    ProfCallOne (n, pr + prs) = ProfCallOne (n, prs);

	  (* terminating call screening for n2 in `profile' for n1 *)
	  ProfCallScrIn (n`'an_lab1, n`'an_lab2, <>) = n`'an_lab1;
	  n`'an_lab1 eq ProfNum (pr) =>
	    ProfCallScrIn (n`'an_lab1, n`'an_lab2, pr + prs) =
	      ProfNumScrIn (n`'an_lab2, ProfScrIns (pr));
	  n`'an_lab1 ne ProfNum (pr) =>
	    ProfCallScrIn (n`'an_lab1, n`'an_lab2, pr + prs) =
	      ProfCallScrIn (n`'an_lab1, n`'an_lab2, prs);

	  (* originating call screening for n2 in `profile' for n1 *)
	  ProfCallScrOut (n`'an_lab1, n`'an_lab2, <>) = n`'an_lab2;
	  n`'an_lab1 eq ProfNum (pr) =>
	    ProfCallScrOut (n`'an_lab1, n`'an_lab2, pr + prs) =
	      ProfNumScrOut (n`'an_lab2, ProfScrOuts (pr));
	  n`'an_lab1 ne ProfNum (pr) =>
	    ProfCallScrOut (n`'an_lab1, n`'an_lab2, pr + prs) =
	      ProfCallScrOut (n`'an_lab1, n`'an_lab2, prs);

	  (* n1/Held(n1) in call forwarding for n, recursively until n1
	     (a free number or one without call forwarding on busy) *)
	  ProfFwdBusy (n, ass, <>) = IdAssocNum (n, ass);
	  n eq ProfNum (pr), IsHeld (IdAssocNum (n, ass)) =>
	    ProfFwdBusy (n, ass, pr + prs) = ProfNumBusy (n, ass, pr + prs);
	  n eq ProfNum (pr), not (IsHeld (IdAssocNum (n, ass))) =>
	    ProfFwdBusy (n, ass, pr + prs) =
	      IdAssocNum (ProfFwdUncond (n, pr + prs), ass);
	  n ne ProfNum (pr) =>
	    ProfFwdBusy (n, ass, pr + prs) = ProfFwdBusy (n, ass, prs);

	  (* n1 in call forwarding unconditional for n and its `profile',
	     recursively until n1 (without call forwarding unconditional) *)
	  ProfFwdUncond (n, <>) = n;
	  n eq ProfNum (pr), FwdCond (ProfFwd (pr)) eq FwdUncond =>
	    ProfFwdUncond (n, pr + prs) =
	      ProfFwdUncond (FwdNum (ProfFwd (pr)), Profiles);
	  n eq ProfNum (pr), FwdCond (ProfFwd (pr)) ne FwdUncond =>
	    ProfFwdUncond (n, pr + prs) = n;
	  n ne ProfNum (pr) =>
	    ProfFwdUncond (n, pr + prs) = ProfFwdUncond (n, prs);

	  (* abbreviated dialling expansion for n in abbreviation list *)
	  ProfNumAbbr (n, <>) = n;
	  n`'an_lab1 eq n`'an_lab2 =>
	    ProfNumAbbr (n`'an_lab1, Abbrev (n`'an_lab2, n) + as) = n;
	  n`'an_lab1 ne n`'an_lab2 =>
	    ProfNumAbbr (n`'an_lab1, Abbrev (n`'an_lab2, n) + as) =
	      ProfNumAbbr (n`'an_lab1, as);

	  (* n1/Held(n1) in call forwarding for n according to its `profile' *)
	  ProfNumBusy (n, ass, <>) = Held (n);
	  n eq ProfNum (pr), FwdCond (ProfFwd (pr)) eq FwdBusyLine =>
	    ProfNumBusy (n, ass, pr + prs) =
	      ProfFwdBusy (FwdNum (ProfFwd (pr)), ass, Profiles);
	  n eq ProfNum (pr), FwdCond (ProfFwd (pr)) ne FwdBusyLine =>
	    ProfNumBusy (n, ass, pr + prs) = Held (n);
	  n ne ProfNum (pr) =>
	    ProfNumBusy (n, ass, pr + prs) = ProfNumBusy (n, ass, prs);

	  (* terminating call screening for n in screening list *)
	  ProfNumScrIn (n, <>) = n;
	  (n`'an_lab1 eq n`'an_lab2) or (n`'an_lab2 eq NoNum) =>
	    ProfNumScrIn (n`'an_lab1, n`'an_lab2 + sis) = NoNum;
	  n`'an_lab1 ne n`'an_lab2, n`'an_lab2 ne NoNum =>
	    ProfNumScrIn (n`'an_lab1, n`'an_lab2 + sis) =
	      ProfNumScrIn (n`'an_lab1, sis);

	  (* outgoing call screening for n in screening list *)
	  ProfNumScrOut (n, <>) = n;
	  (n`'an_lab1 eq n`'an_lab2) or (n`'an_lab2 eq NoNum) =>
	    ProfNumScrOut (n`'an_lab1, n`'an_lab2 + sos) = NoNum;
	  n`'an_lab1 ne n`'an_lab2, n`'an_lab2 ne NoNum =>
	    ProfNumScrOut (n`'an_lab1, n`'an_lab2 + sos) =
	      ProfNumScrOut (n`'an_lab1, sos);

  endtype (* ProfOps *)')

# "prof_check" checks the profile values in "an_prof_checks"

define(prof_check,
  `define(`an_check_ones',
    ` ')map_funs(an_prof_checks,`prof_check_num')')

# "prof_check_one(pos,check)" checks the one-number in position "pos" of
# "check" to see if it is unique

define(prof_check_one,
  `define(`an_check_one',`get_word($2,$1)')ifelse(an_check_one,,,
    `ifelse(index(an_prof_checks,[an_check_one|),-1,
      `ifelse(index(an_check_ones,` 'an_check_one` '),-1,,
        `rep_err(Number an_check_num: One-Number an_check_one already a One-Number)')',
      `rep_err(Number an_check_num: One-Number an_check_one already a Number)')define(`an_check_ones',
        an_check_ones`'an_check_one` ')prof_check_one(incr($1),$2)')')

# "prof_check_fwd(num)" checks for a forwarding loop starting with "num"

define(prof_check_fwd,
  `define(`an_ind_cf',
    index(an_prof_checks,[$1|))ifelse(an_ind_cf,-1,,
      `define(`an_fwd_num',
        `get_word(substr(an_prof_checks,an_ind_cf),2)')ifelse(an_fwd_num,,,
	  `ifelse(index(an_check_fwds,` $1 '),-1,
	    `define(`an_check_fwds',
	      an_check_fwds`$1 ')prof_check_fwd(an_fwd_num)',
	    `rep_err(
	      Number an_check_num: Forwarding Loop`'an_check_fwds`'$1)')')')')

# "prof_check_num(func,check)" checks the profile values in "check"; the
# function "func" is void

define(prof_check_num,
  `define(`an_check_fwds',
    ` ')define(`an_check_num',
    get_word($2,0))prof_check_fwd(an_check_num)prof_check_one(3,[$2])')

# "prof_init" initialises profile values and sets these up immediately

define(prof_init,
  `define(
    `an_prof_check')define(
      `an_call_divert',NoFwd)define(
	`an_call_wait',False)define(
	  `an_dial_code',<>)define(
	    `an_dial_one',<>)define(
	      `an_return',False)define(
		`an_ring',NormRing)define(
		  `an_screen_in',<>)define(
		    `an_screen_out',<>)')

prof_init

# "profile(num,id)" adds to global "an_profs" a set value for a
# profile; macros "an_<par>" may be set before the call to define profile
# parameter values. Check that "num" has not previously been defined.

define(profile,
  `define(`an_prof',
    Prof (num_of($1), id_of($2),
             an_dial_code, an_call_divert, an_call_wait, an_dial_one,
	     an_return, an_ring, an_screen_in, an_screen_out))ifelse(
      an_profs,,`ifelse(an_trace,1,
        `errprint(Declaring Profiles
)')define(`an_profs',`
            'Profs (an_prof))',
        `define(`an_profs',an_profs +`
	    'an_prof)')ifelse(index(an_prof_checks,[$1|),-1,
	      `define(`an_prof_checks',
	        an_prof_checks[$1|$2`'an_prof_check])',
	      `rep_err(Number $1: already a Number)')prof_init')

# "ring_automatic" sets global "an_return" for automatic call ring-back

define(ring_automatic,
  `define(`an_return',True)')

# "ring_display" applies global "an_ring" to a value selecting calling number
# display (i.e. "BusyNum")

define(ring_display,
  `define(`an_ring',an_ring`'(BusyNum))')

# "ring_preference(ring)" prefixes global "an_ring" with a ring preference
# given by the parameter "ring" (distinctive ring 1/2/3/4)

define(ring_preference,
  `define(`an_ring_pref',`ifelse(
    $1,,`define(`an_ring_pref')rep_err(Ring preference required)',
    $1,1,DistRing1,
    $1,2,DistRing2,
    $1,3,DistRing3,
    $1,3,DistRing4,
    `rep_err(`Ring preference must be 1 to 4')')')define(`an_ring',
      an_ring_pref`'substr(an_ring,8))')

# "screen_in(pars)" produces in global "an_screen_in" a list of incoming
# screened numbers given the parameters "num1, ..."

define(screen_in,
  `ifelse($1,,
    `define(`an_screen_in',<>)rep_err(Incoming screened numbers required)',
      `undefine(`an_screen_in')map_args(intrn_of(`$*'),
        `screen_in_num')')')

# "screen_in_num(par)" adds to global "an_screen_in" the screened number given
# by parameter "par" (using "NoNum" for "all")

define(screen_in_num,
  `define(`an_exp',`ifelse($1,all,NoNum,`num_of($1)')')ifdef(`an_screen_in',
    `define(`an_screen_in',an_screen_in +`
                '(an_exp))',
		`define(`an_screen_in',
              ScrIns (an_exp))')')

# "screen_in_type" produces an incoming screening list type definition

define(screen_in_type,`
  (* list of numbers for terminating call screening *)

  type ScrIns is String actualizedby Num, Boolean using
    sortnames
      ScrIns	for String
      Num	for Element
      Bool	for FBool
    opnnames
      ScrIns	for String
  endtype (* ScrIns *)')

# "screen_out(pars)" produces in global "an_screen_out" a list of outgoing
# screened numbers given the parameters "num1, ..."

define(screen_out,
  `ifelse($1,,
    `define(`an_screen_out',<>)rep_err(Outgoing screened numbers required)',
      `undefine(`an_screen_out')map_args(intrn_of(`$*'),
        `screen_out_num')')')

# "screen_out_num(par)" adds to global "an_screen_out" the screened number
# given by parameter "par" (supplying "NoNum" for "all")

define(screen_out_num,
  `define(`an_exp',`ifelse($1,all,NoNum,`num_of($1)')')ifdef(`an_screen_out',
    `define(`an_screen_out',an_screen_out +`
                '(an_exp))',
		`define(`an_screen_out',`
              'ScrOuts (an_exp))')')

# "screen_out_type" produces an outgoing screening list type defoutition

define(screen_out_type,`
  (* list of numbers for originating call screening *)

  type ScrOuts is String actualizedby Num, Boolean using
    sortnames
      ScrOuts	for String
      Num	for Element
      Bool	for FBool
    opnnames
      ScrOuts	for String
  endtype (* ScrOuts *)')
