divert(-1)

# "anise_test.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	20/08/98
# 
# This "m4" macro file generates tests of Intelligent Network
# service specifications in LOTOS according to the ANISE (Architectural
# Notions in Service Engineering) approach.
# 
# The following macros are expected to be set on the "m4" command line:
# 
#   an_gate		gate for service communication (default "t")
# 
#   an_<prim>		primitive with given name exists (default no Con/Res)
# 
#   profile_<num>	number profile parameters, with words quoted ([[...]])
#			and commas changed to bars (default no profile for
#			number)
# 
# Copyright 1998 K. J. Turner, University of Stirling

############################## General Macros ##############################

# allow use of single quotes by changing to [[...]] instead

changequote([[,]])

# "an_ind_amt" is the amount of one indent

define(an_ind_amt,
  [[2]])

# "an_ind_lev" is the current indentation level (0 = top level)

define(an_ind_lev,
  [[0]])

# "an_ind_off" is the initial indentation offset

define(an_ind_off,
  [[4]])

# "id_of(id)" produces the LOTOS representation of the decimal "id", such
# as "Id (4)+1+9" for "419"

define(id_of,
  [[define([[an_num]],[[translit($1,[[*#]],[[SH]])]])define([[an_len]],
    [[len(an_num)]])ifelse(an_len,0,,
      an_len,1,[[Id(an_num)]],
        [[Id(substr(an_num,0,1))+id_of_aux(decr(an_len),
	  substr(an_num,1))]])]])

define(id_of_aux,
  [[ifelse($1,1,$2,
      [[substr($2,0,1)+id_of_aux(decr($1),substr($2,1))]])]])

# "indent(lev)" produces indentation for the given level "lev"

define(indent,
  [[spaces(eval(an_ind_off+$1*an_ind_amt))]])

# "is_num(str)" returns 1/0 if the string is/is not numeric

define(is_num,
  [[ifelse(translit($1,[[0-9*#]]),,1,0)]])

# "is_str(str)" returns 1/0 if the string is/is in double quotes

define(is_str,
  [[ifelse(substr($1,0,1),",
    [[ifelse(substr($1,decr(len($1))),",1,0)]],0)]])

# "num_of(num)" produces the LOTOS representation of the decimal "num", such
# as "Num (S)+1+2+H" for "*12#"; a single digit taken literally

define(num_of,
  [[define([[an_num]],[[translit($1,[[*#]],[[SH]])]])define([[an_len]],
    [[len(an_num)]])ifelse(an_len,0,,
      an_len,1,[[an_num]],
        [[Num(substr(an_num,0,1))+num_of_aux(decr(an_len),
	  substr(an_num,1))]])]])

define(num_of_aux,
  [[ifelse($1,1,$2,
      [[substr($2,0,1)+num_of_aux(decr($1),substr($2,1))]])]])

# "oct_of(ch)" returns the octet for character "ch" in a form such as
#  "Octet(1,0,1,1,0,0,1,0)"

define(oct_of,
  [[define([[an_oct]],[[ord_of($1)]])ifelse(an_oct,-1,,
    Octet(eval((an_oct&128)>>7)[[,]]eval((an_oct&64)>>6)[[,]]eval(
      (an_oct&32)>>5)[[,]]eval((an_oct&16)>>4)[[,]]eval((an_oct&8)>>3)[[,]]eval(
        (an_oct&4)>>2)[[,]]eval((an_oct&2)>>1)[[,]]eval(an_oct&1)))]])

# "ord_of(ch)" returns the character code for "ch"

define(ord_of,
  [[define([[an_ord]],index([[ !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~]],$1))ifelse(an_ord,-1,-1,eval(an_ord+32))]])

# "par_of(str)" checks the string for a number or string parameter (perhaps
# as a parameter) to be converted to LOTOS form

define(par_of,
  [[ifelse(
    is_num($1),1,[[num_of($1)]],
    is_str($1),1,[[voice_of($1)]],
    [[define([[an_ind1]],index($1,[[(]]))ifelse(an_ind1,-1,$1,
      [[define([[an_ind2]],index($1,[[)]]))ifelse(an_ind2,-1,$1,
        [[define([[an_ind1]],incr(an_ind1))substr($1,0,
	    an_ind1)define([[an_par]],substr($1,an_ind1,
	      eval(an_ind2-an_ind1)))ifelse(
	        is_num(an_par),1,[[num_of(an_par)]],
	        is_str(an_par),1,[[voice_of(an_par)]],
		an_par)[[]]substr($1,
		  an_ind2)]])]])]])]])

# "rep_err(string)" report the error message "string"

define(rep_err,
  [[errprint([[antest: Error on Line ]]__line__[[ - $1
]])]])

# "spaces(num)" produces the number of spaces "num"

define(spaces,
  [[ifelse(eval($1 < 0),1,[[rep_err(Negative space not allowed)]],
    $1,0,,
    [[ spaces(decr($1))]])]])

# "voice_of(str)" translates the string in double quotes (assumed) to a
# succession of voice octets

define(voice_of,
  [[ifelse($1,"",NoVoice,
    [[Voice(oct_of(substr($1,1,1)))[[]]voice_of_aux(
      [[substr($1,2,eval(len($1)-3))]])]])]])

define(voice_of_aux,
  [[ifelse($1,,,[[+oct_of(substr($1,0,1))[[]]voice_of_aux(
    [[substr($1,1)]])]])]])

############################## Profile Macros ###############################

# "call_divert(num)" returns the forwarding number for number "num" or 0
# if it has none according to its profile
# 
# "call_divert(num,cond)" returns 1/0 according to whether number "num" has
# the given Call Forwarding condition in its profile or not (None, Uncond,
# NoAnswer, BusyLine - assuming a condition of Uncond if none is given in the
# profile)

define(call_divert,
  [[ifdef([[profile_$1]],
    [[define([[an_prof]],
      [[profile_$1]])define([[an_cd]],
	[[regexp(an_prof,[[call_divert(\([0-9]+\)]],
	  [[\1]])]])ifelse($#,1,
	    [[ifelse(an_cd,,
	      0,
	      [[an_cd]])]],
	    [[ifelse(an_cd,,
	      0,
	      [[define([[an_cd]],
	        [[regexp(an_prof,[[call_divert([0-9]+|?\([^)]*\))]],
		  [[\1]])]])ifelse(an_cd,,
		    [[ifelse($2,None,1,0)]],
		    [[ifelse($2,an_cd,1,0)]])]])]])]],
    [[rep_err(No such number as $1)]]0)]])

# "call_wait(num)" returns 1/0 according to whether number "num" has
# Call Waiting in its profile or not

define(call_wait,
  [[ifdef([[profile_$1]],
    [[define([[an_prof]],
      [[profile_$1]])define([[an_ind_pr]],
	index(an_prof,[[call_wait]]))eval(an_ind_pr != -1)]],
    [[rep_err(No such number as $1)]]0)]])

# "dial_code(num,code)" returns 1/0 according to whether number "num" has
# Abbreviated Dialling for "code" for in its profile or not

define(dial_code,
  [[ifdef([[profile_$1]],
    [[define([[an_prof]],
      [[profile_$1]])define([[an_rp]],
	[[regexp(an_prof,
	  [[dial_code(\([0-9\*->]+|\)*\*\*$2->]])]])eval(an_rp != -1)]],
    [[rep_err(No such number as $1)]]0)]])

# "dial_one(num1,num2)" returns 1/0 according to whether number "num1" has
# Originating Call Screening for "num2" for in its profile or not

define(dial_one,
  [[ifdef([[profile_$1]],
    [[define([[an_prof]],
      [[profile_$1]])define([[an_rp]],
	[[regexp(an_prof,
	  [[dial_one(\([0-9]+|\)*$2[|)]]])]])eval(an_rp != -1)]],
    [[rep_err(No such number as $1)]]0)]])

# "ring_automatic(num)" returns 1/0 according to whether number "num" has
# Automatic Call Back in its profile or not

define(ring_automatic,
  [[ifdef([[profile_$1]],
    [[define([[an_prof]],
      [[profile_$1]])define([[an_ind_pr]],
	[[index(an_prof,[[ring_automatic]])]])eval(an_ind_pr != -1)]],
    [[rep_err(No such number as $1)]]0)]])

# "ring_display(num)" returns 1/0 according to whether number "num" has
# Distinctive Ring in its profile or not

define(ring_display,
  [[ifdef([[profile_$1]],
    [[define([[an_prof]],
      [[profile_$1]])define([[an_ind_pr]],
	[[index(an_prof,[[ring_display]])]])eval(an_ind_pr != -1)]],
    [[rep_err(No such number as $1)]]0)]])

# "ring_preference(num1,num2)" returns the Distinctive Ring preference for
# number "num1" (NormRing or DistRing1..3 - default NormRing) with an
# optional parameter "(num2)" if Calling Number Delivery is defined

define(ring_preference,
  [[ifdef([[profile_$1]],
    [[define([[an_prof]],
      [[profile_$1]])define([[an_rp]],
	[[regexp(an_prof,[[ring_preference(\([0-9]+\)]],
	  [[\1]])]])define([[an_rp]],
	    ifelse(an_rp,,
	      NormRing,
	      DistRing[[]]an_rp))define([[an_ind_pr]],
	        index(an_prof,[[ring_display]]))ifelse(an_ind_pr,-1,
		an_rp,
		an_rp[[]]($2))]],
    [[rep_err(No such number as $1)]]NormRing)]])

# "screen_in(num1,num2)" returns 1/0 according to whether number "num1" has
# Terminating Call Screening for "num2" for in its profile or not

define(screen_in,
  [[ifdef([[profile_$1]],
    [[define([[an_prof]],
      [[profile_$1]])define([[an_rp]],
	[[regexp(an_prof,
	  [[screen_in(\([0-9]+|\)*$2[|)]]])]])eval(an_rp != -1)]],
    [[rep_err(No such number as $1)]]0)]])

# "screen_out(num1,num2)" returns 1/0 according to whether number "num1" has
# Originating Call Screening for "num2" for in its profile or not

define(screen_out,
  [[ifdef([[profile_$1]],
    [[define([[an_prof]],
      [[profile_$1]])define([[an_rp]],
	[[regexp(an_prof,
	  [[screen_out(\([0-9]+|\)*$2[|)]]])]])eval(an_rp != -1)]],
    [[rep_err(No such number as $1)]]0)]])

############################# Basic Test Macros #############################

# "an_gate" gives the gate name to be used by test processes (default "t")

ifdef([[an_gate]],,[[define(an_gate,t)]])

# "an_succ" gives the gate name to be used by test processes for success

define(an_succ,
  [[OK]])

# "an_group_<no>" is defined by "recv" and "send" to be the most recent
# primitive group for the given number "no" (e.g. 124)

# "recv(num,prim,par)" creates an event offer at number "num" for primitive
# "prim" and optional parameter "par" (converted to LOTOS internal
# representation for numbers and voice)

define(recv,
  [[define([[an_group]],
    ifdef([[an_group_$1]],an_group_$1))define([[an_group_$1]],
      $2)define([[an_prim]],
        [[ifelse($2,an_group,[[ifdef(an_[[]]$2[[]]Con,
	  $2[[]]Con,$2[[]]Ind)]],[[ifdef(an_[[]]$2[[]]Con,
	    $2[[]]Con,$2[[]]Ind)]])]])ifelse($3,,,
	      [[define([[an_prim]],
		an_prim (par_of($3)))]])an_gate ! id_of($1) ! an_prim]])

# "send(num,group,par)" creates an event offer at number "num" for primitive
# group "group" and optional parameter "par" (converted to LOTOS internal
# representation for numbers and voice)

define(send,
  [[define([[an_group]],
    ifdef([[an_group_$1]],an_group_$1))define([[an_group_$1]],
      $2)define([[an_prim]],
        [[ifelse($2,an_group,[[ifdef(an_[[]]$2[[]]Res,
	  $2[[]]Res,$2[[]]Req)]],[[ifdef(an_[[]]$2[[]]Res,
	    $2[[]]Res,$2[[]]Req)]])]])ifelse($3,,,
	      [[define([[an_prim]],
		an_prim (par_of($3)))]])an_gate ! id_of($1) ! an_prim]])

# "test(name,beh)" produces a test process for behaviour "beh" with name
# "Test_<name>"

define(test,
  [[ifelse($2,,[[rep_err(Need one or more tests)]],
    [[define([[an_proc_name]],
      [[Test[[]]_$1]])
  process an_proc_name [an_gate[[,]] an_succ] : noexit :=
    tests_aux(shift($@))
  endproc (* an_proc_name *)]])]])

define(tests_aux,
  [[ifelse(
    $#,0,,
    $#,1,[[$1]],[[$1[[]]tests_aux(shift($@))]])]])

########################## Test Combination Macros ##########################

# "decides(beh1,beh2,...)" produces a test process for behaviours "beh1",
# "beh2", etc. as non-deterministic alternatives

define(decides,
  [[ifelse(
    $#,0,[[rep_err(Need at least one behaviour for decision)]],
    $#,1,[[$1]],[[[[(define([[an_ind_lev]],
      incr(an_ind_lev))]]decides_aux($@)
[[define([[an_ind_lev]],
  decr(an_ind_lev))]][[indent(an_ind_lev)]][[)]]]])]])

define(decides_aux,
  [[ifelse(
    $#,0,,
    $#,1,[[
[[indent(an_ind_lev)]]i;
[[indent(an_ind_lev)]][[$1]]]],[[
[[indent(an_ind_lev)]]i;
[[indent(an_ind_lev)]][[$1]]
[[indent(decr(an_ind_lev))]][]decides_aux(shift($@))]])]])

# "depends(cond1,test1,cond2,test2,...,testN)" applies "test1" if "cond1"
# evaluates to 1, etc. with "testN" as the otherwise case

define(depends,
  [[ifelse(
    eval($# < 2),1,
      [[rep_err(Need one or more tests)]],
    eval($# < 4),1,
      [[ifelse(
        eval([[$1]]),1,[[$2]],[[$3]])]],
    eval($# < 6),1,
      [[ifelse(
        eval([[$1]]),1,[[$2]],
	eval([[$3]]),1,[[$4]],[[$5]])]],
    eval($# < 8),1,
      [[ifelse(
        eval([[$1]]),1,[[$2]],
	eval([[$3]]),1,[[$4]],
	eval([[$5]]),1,[[$6]],[[$7]])]],
    eval($# < 10),1,
      [[ifelse(
        eval([[$1]]),1,[[$2]],
	eval([[$3]]),1,[[$4]],
	eval([[$5]]),1,[[$6]],
	eval([[$7]]),1,[[$8]],$9)]],
    eval($# < 12),1,
      [[ifelse(
        eval([[$1]]),1,[[$2]],
	eval([[$3]]),1,[[$4]],
	eval([[$5]]),1,[[$6]],
	eval([[$7]]),1,[[$8]],
	eval([[$9]]),1,[[$10]],[[$11]])]],
    [[rep_err(Too many conditions and tests)]])]])

# "fails(beh1,beh2,...)" produces a test behaviour for "beh1", "beh2", etc.
# in sequence, followed by stop

define(fails,
  [[ifelse(
    $#,0,[[rep_err(Need at least one behaviour for failure sequence)]],
    $#,1,[[[[$1]];
[[indent(an_ind_lev)]]stop]],[[[[$1]];
[[indent(an_ind_lev)]]fails(shift($@))]])]])

# "interleaves(beh1,beh2,...)" produces a test process for behaviours "beh1",
# "beh2", etc. interleaved

define(interleaves,
  [[ifelse(
    $#,0,[[rep_err(Need at least one behaviour for interleaving)]],
    $#,1,[[$1]],[[[[(define([[an_ind_lev]],
      incr(an_ind_lev))]]interleaves_aux($@)
[[define([[an_ind_lev]],
  decr(an_ind_lev))]][[indent(an_ind_lev)]][[)]]]])]])

define(interleaves_aux,
  [[ifelse(
    $#,0,,
    $#,1,[[
[[indent(an_ind_lev)]][[$1]]]],[[
[[indent(an_ind_lev)]][[$1]]
[[indent(decr(an_ind_lev))]]|[an_succ]|interleaves_aux(shift($@))]])]])

# "offers(beh1,beh2,...)" produces a test process for behaviours "beh1",
# "beh2", etc. as alternatives at the discretion of the system

define(offers,
  [[ifelse(
    $#,0,[[rep_err(Need at least one behaviour for offer)]],
    $#,1,[[$1]],[[[[(define([[an_ind_lev]],
      incr(an_ind_lev))]]offers_aux($@)
[[define([[an_ind_lev]],
  decr(an_ind_lev))]][[indent(an_ind_lev)]][[)]]]])]])

define(offers_aux,
  [[ifelse(
    $#,0,,
    $#,1,[[
[[indent(an_ind_lev)]][[$1]]]],[[
[[indent(an_ind_lev)]][[$1]]
[[indent(decr(an_ind_lev))]][]offers_aux(shift($@))]])]])

# "refuses(beh1,...behN)" produces a test behaviour for "beh1", "beh2", etc.
# as a sequence, followed by a choice of "behN" (that must not happen) and
# success; "behN" may be a compound behaviour (e.g. made with "offers")

define(refuses,
  [[ifelse(
    $#,0,
      [[rep_err(Need at least one behaviour for refusal)]],
    $#,1,
      [[ifelse(eval(index([[$1]],an_succ;)>=0),1,
        [[rep_err(Refusal behaviour must not succeed)]],
[[([[define([[an_ind_lev]],incr(an_ind_lev))]]
[[indent(an_ind_lev)]][[$1]]
[[indent(decr(an_ind_lev))]][]
[[indent(an_ind_lev)]]i;
[[indent(an_ind_lev)]]an_succ;
[[indent(an_ind_lev)]]stop[[[[]]]][[define([[an_ind_lev]],decr(an_ind_lev))]]
[[indent(an_ind_lev)]])]])]],
    [[[[$1]];
[[indent(an_ind_lev)]]refuses(shift($@))]])]])

# "sequences(beh1,beh2,...)" produces a test behaviour for "beh1", "beh2",
# etc. in sequence (and no terminating stop)

define(sequences,
  [[ifelse(
    $#,0,[[rep_err(Need at least one behaviour for success sequence)]],
    $#,1,[[[[$1]]]],[[[[$1]];
[[indent(an_ind_lev)]]sequences(shift($@))]])]])

# "succeeds(beh1,beh2,...)" produces a test behaviour for "beh1", "beh2", etc.
# in sequence, followed by the success event and stop

define(succeeds,
  [[ifelse(
    $#,0,
      [[an_succ;
    stop]],
    $#,1,
      [[ifelse(eval(index([[$1]],an_succ;)>=0),1,
        [[rep_err(Success behaviour may not be nested)]],
    [[[[$1]];
[[indent(an_ind_lev)]]an_succ;
[[indent(an_ind_lev)]]stop]])]],
    [[[[$1]];
[[indent(an_ind_lev)]]succeeds(shift($@))]])]])

########################### Trailer ##############################

divert
