divert(-1)

############################ Header ##############################

# "basil.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	28/05/96

# This "m4" macro file contains templates for generating connection-oriented
# service specifications in LOTOS according to the BASIL (Basic Architectural
# Semantics in LOTOS) approach.

# Copyright 1996 K. J. Turner, University of Stirling

#################### General Purpose Macros ######################

# "ltrs_of(string)" produces the same string with digits deleted.

define(ltrs_of,`translit($1,0123456789)'))

ltrs_of(Addr1|Addr2|Bool|Data)

# "low_of(string)" produces the same string with upper case
# letters changed to lower case.

define(low_of,
  `translit(
    $1,ABCDEFGHIJKLMNOPQRSTUVWXYZ,abcdefghijklmnopqrstuvwxyz)'))

# "intrn_of(string)" produces the same string with function calls
# changed into internal form, i.e. "f(a,b)" translated to
# "f[a|b]". This is because "(", "," and ")" are special to m4.
# Newlines, blanks and tabs are also removed.

define(intrn_of,`translit(translit(`$1',`(,)',[|]),`
' 	)')

# "extrn_of(string)" produces the external equivalent of the
# internal form of function calls.

define(extrn_of,`translit($1,[|],`(,)')')

# "map_funs(string,macro)" calls the macro for each function call
# in the string. This macro is called with the function name as
# its first parameter, and the function parameter list as its
# second parameter.
#
# The macro uses the macros "mf_ind1" and "mf_ind2" which must
# not be altered by the argument macro.

define(map_funs,
  `define(`mf_ind1',
    index($1,[))define(
      `mf_ind2',index($1,]))ifelse(
	mf_ind1,-1,,
	  mf_ind2,-1,,
	     `$2(
	       substr($1,0,mf_ind1),substr($1,incr(mf_ind1),
		   eval(mf_ind2-mf_ind1-1)))'``''`map_funs(
		     substr($1,incr(mf_ind2)),`$2')')')

# "map_args(string,macro)" calls the macro for each parameter in
# the string. The macro is called with the function parameter list
# as its only parameter.
#
# The macro uses the macros "ma_ind1" which must not be altered
# by the argument macro.

define(map_args,
  `define(`ma_ind1',
    index($1,|))ifelse(
      $1,,,
	ma_ind1,-1,`$2($1)',
	  `$2(substr($1,0,ma_ind1))'``''`map_args(
	    substr($1,incr(ma_ind1)),`$2')')')

# "lab_1" and "lab_2" produce the labels to distinguish the
# parameters of two constructor operations.

define(lab_1,A)

define(lab_2,B)

# "lab_args(string,label)" labels each argument in the string by
# appending the given label.

define(lab_args,
  `undefine(`list')define(`lab_arg',
    `define(`par',
      $'1`)ifdef(`list',
        `define(`list',list|par`'$2)',
          `define(`list',par`'$2)')')map_args($1,
            `lab_arg')list')

###################### Library Macros #########################

# "lib_type" invokes library type definitions.

define(lib_type,`
  library
    Boolean,BasicNaturalNumber,Octet,Set,String
      (*** import further types for primitive parameters ***)
  endlib')

###################### Parameter Macros #########################

# "richer_types" produces octet and string type definitions with less than.

define(richer_types,`
  type RicherOctet is Octet
    opns
      NatNum : Octet -> Nat
      _lt_ : Octet, Octet -> Bool
    eqns
      forall o, o1, o2 : Octet
	ofsort Nat
	  NatNum (o) =
	    Succ (Succ (0)) *
	    (Succ (Succ (0)) *
	      (Succ (Succ (0)) *
	      (Succ (Succ (0)) *
		(Succ (Succ (0)) *
		(Succ (Succ (0)) *
		  (Succ (Succ (0)) *
		  NatNum (Bit1 (o)) + NatNum (Bit2 (o))) +
		    NatNum (Bit3 (o))) + NatNum (Bit4 (o))) +
		    NatNum (Bit5 (o))) + NatNum (Bit6 (o))) +
		      NatNum (Bit7 (o))) + NatNum (Bit8 (o))
	ofsort Bool
	  o1 lt o2 = NatNum (o1) lt NatNum (o2)
  endtype (* RicherOctet *)

  type RicherString is String

    formalopns
      _lt_	: Element,Element -> FBool

    opns
      _lt_	: String,String -> Bool

    eqns
      forall
        x,y : Element,
        s,t : String

        ofsort Bool
	  <> of String lt <> of String	= false;
	  (x+s) lt <>			= false;
	  <> lt (y+t)			= true;
	  x lt y =>
	    (x+s) lt (y+t)		= false;
	  x eq y =>
	    (x+s) lt (y+t)		= s lt t;
	  y lt x =>
	    (x+s) lt (y+t)		= true;

  endtype (* RicherString *)')

# "data_type" produces a data type definition.

define(data_type,`
  type DATA is RicherString actualizedby RicherOctet using

    sortnames
      Octet for Element
      Bool for FBool
      Data for String

    opnnames
      Data for String

  endtype (* DATA *)')

# "addr_type" produces an address type definition.

define(addr_type,`
  type ADDR is Boolean

    sorts Addr

    opns
      BaseAddr          : -> Addr
      AnotherAddr       : Addr -> Addr
      _eq_,_ne_,_lt_	: Addr,Addr -> Bool

    eqns
      forall Addr`'lab_1, Addr`'lab_2 : Addr

        ofsort Bool
          BaseAddr            eq BaseAddr            = true;
          AnotherAddr (Addr`'lab_1) eq BaseAddr            = false;
          BaseAddr            eq AnotherAddr (Addr`'lab_2) = false;
          AnotherAddr (Addr`'lab_1) eq AnotherAddr (Addr`'lab_2) = Addr`'lab_1 eq Addr`'lab_2;

          Addr`'lab_1 ne Addr`'lab_2 = not (Addr`'lab_1 eq Addr`'lab_2);

          BaseAddr            lt BaseAddr            = false;
          AnotherAddr (Addr`'lab_1) lt BaseAddr            = false;
          BaseAddr            lt AnotherAddr (Addr`'lab_2) = true;
          AnotherAddr (Addr`'lab_1) lt AnotherAddr (Addr`'lab_2) = Addr`'lab_1 lt Addr`'lab_2;

  endtype (* ADDR *)')

# "ident_type" produces an interaction group identifier type
# definition.

define(ident_type,`
  type IDENT is ADDR renamedby

    sortnames Ident for Addr

    opnnames
      BaseIdent    for BaseAddr
      AnotherIdent for AnotherAddr

  endtype (* IDENT *)')

# "pair_act_type" produces an address/identifier pair type
# definition.

define(pair_act_type,`
  type PAIR is ADDR,IDENT

    sorts Pair

    opns
      Pair		: Addr,Ident -> Pair
      Addr		: Pair -> Addr
      Ident		: Pair -> Ident

      _eq_,_ne_,_lt_	: Pair, Pair -> Bool

    eqns
      forall
        Addr,Addr`'lab_1,Addr`'lab_2	: Addr,
        Ident,Ident`'lab_1,Ident`'lab_2	: Ident,
        Pair`'lab_1,Pair`'lab_2		: Pair

      ofsort Addr
        Addr (Pair (Addr, Ident))	= Addr;

      ofsort Ident
        Ident (Pair (Addr, Ident))	= Ident;

      ofsort Bool
        Pair`'lab_1 eq Pair`'lab_2 =
          (Addr (Pair`'lab_1) eq Addr (Pair`'lab_2))
            and (Ident (Pair`'lab_1) eq Ident (Pair`'lab_2));
        Pair`'lab_1 ne Pair`'lab_2 = not (Pair`'lab_1 eq Pair`'lab_2);
        Pair`'lab_1 lt Pair`'lab_2 =
          (Addr (Pair`'lab_1) lt Addr (Pair`'lab_2))
            and (Ident (Pair`'lab_1) lt Ident (Pair`'lab_2));

  endtype (* PAIR *)')

# "pair_set_type" produces a set of address/identifier pair type
# definition.

define(pair_set_type,`
  type PAIRSET is Set actualizedby PAIR using

    sortnames
      PairSet	for Set
      Pair	for Element
      Bool	for FBool

  endtype (* PAIRSET *)')

# "pair_type" produces pair type definitions.

define(pair_type,
`pair_act_type
pair_set_type')

################### Service Primitive Macros #####################

# "prim_var_dec(parameter)" produces the global variable
# declarations for the given parameter of a constructor operation.
# Declarations of the same sort are grouped in an order such as:
#
#  Par,ParA,ParB,Par1,Par1A,Par1B,Par2,Par2A,Par2B : Par

define(prim_var_dec,
  `ifdef(`list',
    `ifelse(index(list,`$1|'),-1,
      `ifelse(index(list,`$1 '),-1,
        `define(`ind1',
          index(list,ltrs_of($1)))ifelse(ind1,-1,
          `define(`list',list|
        $1|$1`'lab_1|$1`'lab_2 : ltrs_of($1))',
            `ifelse($1,ltrs_of($1),
              `define(`list',
                substr(list,0,
                  ind1)$1|$1`'lab_1|$1`'lab_2|substr(list,
                    ind1))',
                `define(`ind2',
                  `index(substr(list,ind1),` ')')define(`ind2',
                    eval(ind1+ind2))define(`list',
                      substr(list,0,
                        ind2)|$1|$1`'lab_1|$1`'lab_2`'substr(list,
                          ind2))')')')')',
      `define(`list',`
        $1|$1`'lab_1|$1`'lab_2 : ltrs_of($1)')')')

# "prim_for_dec(operation, parameters)" produces the global
# variable declarations for the constructor operation with given
# parameters.

define(prim_for_dec,`map_args($2,`prim_var_dec')')

# "prim_for_decs(string)" produces the global variable
# declarations for the constructor operations given as functions 
# given in the string.

define(prim_for_decs,
  `undefine(`list')map_funs([Prim]$1,`prim_for_dec')extrn_of(`list')')

# "prim_con_opn(operation,parameters)" produces the signature of
# the constructor operation with given name and parameters.

define(prim_con_opn,
  `      $1 : ifelse($2,,,`extrn_of(ltrs_of($2)) ')-> Prim
')

# "prim_con_opns(string)" produces the signatures of the
# constructor operations given as functions in the string.

define(prim_con_opns,`map_funs($1,`prim_con_opn')')

# "prim_rec_opn(operation,parameters)" produces the signature of
# the recogniser operation with given operation and parameters.

define(prim_rec_opn,
  `ifdef(`list',
    `define(`list',list|Is$1)',
      `define(`list',Is$1)')')

# "prim_rec_opns(string)" produces the signatures of the
# recogniser operations given as functions in the string.

define(prim_rec_opns,
  `undefine(`list')map_funs(
    $1,`prim_rec_opn')      extrn_of(list) : Prim -> Bool')

# "prim_opns(string)" produces the signatures of the operations
# for the functions in the string, as well as the auxiliary
# operations.

define(prim_opns,
`prim_con_opns($1)
prim_rec_opns($1)
      IsReq,IsInd,IsInit,IsData,IsTerm : Prim -> Bool

      Ord	: Prim -> Nat

      _eq_,_ne_,_lt_	: Prim,Prim -> Bool')

# "prim_ord_eqn(operation,parameters)" produces the equations
# for the ordinal value of the constructor operation with the
# given name and parameters.

define(prim_ord_eqn,
  `          Ord ($1`'ifelse($2,,,
    ` '(extrn_of($2))))	= ord;define(`ord',
      Succ (Ord ($1`'ifelse($2,,,
    ` '(extrn_of($2))))))
')

# "prim_ord_eqns(string)" produces the equations for the ordinal
# values of constructors given as functions in the string.

define(prim_ord_eqns,`define(`ord',0)map_funs($1,`prim_ord_eqn')')

# "prim_rec_eqn(operation,parameters)" produces the equation for
# the recogniser operation corresponding to the given operation
# and parameters.

define(prim_rec_eqn,
  `          Is$1 (Prim) = Ord (Prim) eq Ord ($1`'ifelse($2,,,
    ` '(extrn_of($2))));
')

# "prim_rec_eqns(string)" produces the equations for the
# recogniser operations corresponding to the functions in the
# string.

define(prim_rec_eqns,`map_funs($1,`prim_rec_eqn')')

# "prim_eq_arg(parameter)" produces a conditional requiring
# equality of each parameter in the string.

define(prim_eq_arg,
  `ifdef(`list',
    `define(`list',`('list`)'
              and `('$1`'lab_1 eq $1`'lab_2`)')',
      `define(`list',$1`'lab_1 eq $1`'lab_2)')')

# "prim_eq_args(string)" produces a compound conditional requiring
# equality of each argument in the string.

define(prim_eq_args,
  `undefine(`list')map_args(
    $1,`prim_eq_arg')            list;')

# "prim_eq_eqn(operation,parameters)" produces the equation for
# the equality operation corresponding to the given operation and
# parameters.

define(prim_eq_eqn,
  `          ifelse($2,,$1 eq $1 = true;,
    $1 (extrn_of(lab_args($2,`lab_1'))) eq $1 (extrn_of(lab_args($2,`lab_2'))) =
prim_eq_args($2))
')

# "prim_eq_eqns(string)" produces the equations for the equality
# operation corresponding to the functions in the string.

define(prim_eq_eqns,`map_funs($1,`prim_eq_eqn')')

# "prim_lt_arg(parameter)" produces a conditional requiring
# less than of each parameter in the string.

define(prim_lt_arg,
  `ifdef(`list',
    `define(`list',`('list`)'
              and `('$1`'lab_1 lt $1`'lab_2`)')',
      `define(`list',$1`'lab_1 lt $1`'lab_2)')')

# "prim_lt_args(string)" produces a compound conditional requiring
# less than of each argument in the string.

define(prim_lt_args,
  `undefine(`list')map_args(
    $1,`prim_lt_arg')            list;')

# "prim_lt_eqn(operation,parameters)" produces the equation for
# the less than operation corresponding to the given operation and
# parameters.

define(prim_lt_eqn,
  `          ifelse($2,,$1 lt $1 = false;,
    $1 (extrn_of(lab_args($2,`lab_1'))) lt $1 (extrn_of(lab_args($2,`lab_2'))) =
prim_lt_args($2))
')

# "prim_lt_eqns(string)" produces the equations for the less than
# operation corresponding to the functions in the string.

define(prim_lt_eqns,`map_funs($1,`prim_lt_eqn')')

# "prim_eqns(string)" produces the signatures of the operations
# for the functions in the string, as well as the auxiliary
# operations.

define(prim_eqns,`
        ofsort Nat
prim_ord_eqns($1)
        ofsort Bool
prim_rec_eqns($1)
          IsReq (Prim) =
            (((IsConReq (Prim) or IsConRsp (Prim)) or IsDatReq (Prim))
              or IsExpReq (Prim)) or IsDisReq (Prim);
          IsInd (Prim) =
            (((IsConInd (Prim) or IsConCnf (Prim)) or IsDatInd (Prim))
              or IsExpInd (Prim)) or IsDisInd (Prim);
          IsInit (Prim) = IsConReq (Prim) or IsConInd (Prim);
          (*** insert equation for IsData ***)
          IsTerm (Prim) = IsDisReq (Prim) or IsDisInd (Prim);

          Ord (Prim`'lab_1) ne Ord (Prim`'lab_2) =>
            Prim`'lab_1 eq Prim`'lab_2 = false;

prim_eq_eqns($1)
          Prim`'lab_1 ne Prim`'lab_2 = not (Prim`'lab_1 eq Prim`'lab_2);

          Ord (Prim`'lab_1) ne Ord (Prim`'lab_2) =>
            Prim`'lab_1 lt Prim`'lab_2 = Ord (Prim`'lab_1) lt Ord (Prim`'lab_2);

prim_lt_eqns($1)')

# "prim_type(string)" produces a service primitive type
# definition for the functions in the string.

define(prim_type,`
  (*** insert further types for primitive parameters ***)

  type PRIM is Boolean, BasicNaturalNumber, DATA, ADDR
    (*** import further types for primitive parameters ***) 

    sorts Prim

    opns
prim_opns($1)

    eqns
      forall`'prim_for_decs($1)
prim_eqns($1)
  endtype (* PRIM *)')

#################### Service Object Macros ######################

# "obj_var_dec(parameter)" produces the global variable
# declarations for the given parameter of a constructor operation.
# Declarations of the same sort are grouped in an order such as:
#
#  Par,Par1,Par2 : Par

define(obj_var_dec,
  `ifdef(`list',
    `ifelse(index(list,`$1|'),-1,
      `ifelse(index(list,`$1 '),-1,
        `define(`ind1',
          index(list,ltrs_of($1)))ifelse(ind1,-1,
          `define(`list',list|
        $1 : ltrs_of($1))',
            `ifelse($1,ltrs_of($1),
              `define(`list',
                substr(list,0,ind1)$1|substr(list,ind1))',
                `define(`ind2',
                  `index(substr(list,ind1),` ')')define(`ind2',
                    eval(ind1+ind2))define(`list',
                      substr(list,0,ind2)|$1`'substr(list,
                        ind2))')')')')',
      `define(`list',`
        $1 : ltrs_of($1)')')')

# "obj_for_dec(operation, parameters)" produces the global
# variable declarations for the constructor operation with given
# parameters.

define(obj_for_dec,`map_args($2,`obj_var_dec')')

# "obj_for_decs(string)" produces the global variable
# declarations for the constructor operations given as functions 
# given in the string.

define(obj_for_decs,
  `undefine(`list')map_funs(
    $1,`obj_for_dec')
        Obj`'lab_1,Obj`'lab_2 : Obj,
        Prim : Prim,
        extrn_of(list)')

# "obj_con_opns(string)" produces the signatures of the
# constructor operations.

define(obj_con_opns,
  `      Req		: Prim -> Obj
      Ind		: Obj -> Prim')

# "obj_rec_opn(operation,parameters)" produces the signature of
# the recogniser operation with given operation and parameters.

define(obj_rec_opn,
  `define(`len1',len($1))define(`class',
    substr($1,0,eval(len1-3)))define(`kind',
      substr($1,eval(len1-3)))ifelse(
	kind,Req,`define(`kind',Msg)',
	  kind,Ind,`undefine(`kind')',
	    kind,Rsp,`define(`kind',Ack)',
	       kind,Cnf,`undefine(`kind')')ifdef(`kind',
		 `ifdef(`list',
		   `define(`list',list|Is`'class`'kind)',
		     `define(`list',Is`'class`'kind)')')')

# "obj_rec_opns(string)" produces the signatures of the
# recogniser operations given as functions in the string.

define(obj_rec_opns,
  `undefine(`list')map_funs(
    $1,`obj_rec_opn')      extrn_of(list) : Obj -> Bool')

# "obj_opns(string)" produces the signatures of the operations
# for the functions in the string, as well as the auxiliary
# operations.

define(obj_opns,
`obj_con_opns($1)

obj_rec_opns($1)

      _eq_,_ne_,_lt_	: Obj,Obj -> Bool')

# "obj_ind_eqn(operation,parameters)" produces the equations
# "Ind" operation on the constructor operation with the given
# name and parameters.

define(obj_ind_eqn,
  `define(`len1',len($1))define(`class',
    substr($1,0,eval(len1-3)))define(`kind',
      substr($1,eval(len1-3)))ifelse(
	kind,Req,`define(`kind',Ind)',
	  kind,Ind,,
	    kind,Rsp,`define(`kind',Cnf)',
	       kind,Cnf,)
          Ind (Req ($1`'ifelse($2,,,` '(extrn_of($2))))) = class`'kind`'ifelse($2,,,` '(extrn_of($2)));')

# "obj_ind_eqns(string)" produces the equations for the "Ind"
# operation on constructors given as functions in the string.

define(obj_ind_eqns,`map_funs($1,`obj_ind_eqn')')

# "obj_rec_eqn(operation,parameters)" produces the equation for
# the recogniser operation corresponding to the given operation
# and parameters.

define(obj_rec_eqn,
  `define(`len1',len($1))define(`class',
    substr($1,0,eval(len1-3)))define(`kind',
      substr($1,eval(len1-3)))ifelse(
	kind,Req,`define(`kind',Msg)',
	  kind,Ind,`undefine(`kind')',
	    kind,Rsp,`define(`kind',Ack)',
	       kind,Cnf,`undefine(`kind')')ifelse(
	         kind,Msg,`
          Is`'class`'kind (Req (Prim)) = Is`'class`'Req (Prim) or Is`'class`'Ind (Prim);',
		   kind,Ack,`
          Is`'class`'kind (Req (Prim)) =
            Is`'class`'Rsp (Prim) or Is`'class`'Cnf (Prim);')')

# "obj_rec_eqns(string)" produces the equations for the
# recogniser operations corresponding to the functions in the
# string.

define(obj_rec_eqns,`map_funs($1,`obj_rec_eqn')')

# "obj_eq_eqns(string)" produces the equations for the equality
# operations.

define(obj_eq_eqns,`
	  Obj`'lab_1 eq Obj`'lab_2 = Ind (Obj`'lab_1) eq Ind (Obj`'lab_2);
	  Obj`'lab_1 ne Obj`'lab_2 = not (Obj`'lab_1 eq Obj`'lab_2);

	  Obj`'lab_1 lt Obj`'lab_2 = Ind (Obj`'lab_1) lt Ind (Obj`'lab_2);')

# "obj_eqns(string)" produces the signatures of the operations
# for the functions in the string, as well as the auxiliary
# operations.

define(obj_eqns,`
        ofsort Prim`'obj_ind_eqns($1)

        ofsort Bool`'obj_rec_eqns($1)
obj_eq_eqns($1)
')

# "obj_type(string)" produces a service object type definition
# for the functions in the string.

define(obj_type,`
  type OBJ is PRIM

    sorts Obj

    opns
obj_opns($1)

    eqns
      forall`'obj_for_decs($1)
obj_eqns($1)
  endtype (* OBJ *)')

######################## Medium Macros ###########################

# "med_act_type" produces an actualised medium type definition.

define(med_act_type,`
  type MED is RicherString actualizedby OBJ using

    sortnames
      Med	for String
      Obj	for Element
      Bool	for FBool

    opnnames
      Med	for String

  endtype (* MED *)')

# "med_set_type" produces an actualised medium set type
# definition.

define(med_set_type,`
  type MEDSET is Set actualizedby MED using

    sortnames
      MedSet	for Set
      Med	for Element
      Bool	for FBool

  endtype (* MEDSET *)')

# "med_ops_type" produces a medium set type definition.

define(med_ops_type,`
  type MEDOPS is MEDSET

    opns
      _overtakes_,_destroys_,_cancels_,_ignores_ : Obj,Obj -> Bool

      SetOf	: Med -> MedSet

      _&_	: MedSet,Med -> MedSet	(* prefix medium to elements *)
      _&_	: Med,MedSet -> MedSet	(* append medium to elements *)

      Reorders	: Med -> MedSet		(* reorderings of medium *)
      Reorders	: MedSet -> MedSet	(* reorderings of medium set *)

    eqns
      forall
	Obj,Obj`'lab_1,Obj`'lab_2	: Obj,
	Med,Med`'lab_1,Med`'lab_2	: Med,
	MedSet		: MedSet

	ofsort Bool
	  (*** insert equations for overtakes, destroys, cancels ***)
	  Obj`'lab_1 ignores Obj`'lab_2 =
	    not (
	      ((Obj`'lab_1 overtakes Obj`'lab_2) or (Obj`'lab_1 destroys Obj`'lab_2))
	        or (Obj`'lab_1 cancels Obj`'lab_2));

        ofsort MedSet
          SetOf (Med) = Insert (Med, {});

          {} & Med = {};
          Insert (Med`'lab_1, MedSet) & Med`'lab_2 = Insert (Med`'lab_1++Med`'lab_2, MedSet & Med`'lab_2);

          Med & {} = {};
          Med`'lab_1 & Insert (Med`'lab_2, MedSet) = Insert (Med`'lab_1++Med`'lab_2, Med`'lab_1 & MedSet);

          Reorders (<>)				= {};
          Reorders (<> + Obj)			= {};
          Obj`'lab_1 overtakes Obj`'lab_2 =>
            Reorders ((<> + Obj`'lab_1) + Obj`'lab_2)	= SetOf ((<> + Obj`'lab_2) + Obj`'lab_1);
          Obj`'lab_1 destroys Obj`'lab_2 =>
            Reorders ((<> + Obj`'lab_1) + Obj`'lab_2)	= SetOf (<> + Obj`'lab_1);
          Obj`'lab_1 cancels Obj`'lab_2 =>
            Reorders ((<> + Obj`'lab_1) + Obj`'lab_2)	= SetOf (<>);
          Obj`'lab_1 ignores Obj`'lab_2 =>
            Reorders ((<> + Obj`'lab_1) + Obj`'lab_2)	= {};

          Reorders ((Med + Obj`'lab_1) + Obj`'lab_2) =
            Reorders (
              ((Med & Reorders ((<> + Obj`'lab_2) + Obj`'lab_1))
                Union (Reorders (Med + Obj`'lab_2) & (<> + Obj`'lab_1)))
                  Union (Reorders (Med) & ((<> + Obj`'lab_2) + Obj`'lab_1)));

  endtype (* MEDOPS *)')

# "meds_type" produces medium type definitions.

define(meds_type,
`med_act_type
med_set_type
med_ops_type')

###################### Connection Macros #########################

# "conn_proc(gate)" produces process definitions for one
# connection at the given gate.

define(conn_proc,`
    process Conn [$1] : noexit :=

      choice Pair`'lab_1,Pair`'lab_2 : Pair []
	(
	  ConnLoc [$1] (Pair`'lab_1)
	|||
	  ConnLoc [$1] (Pair`'lab_2)
	)
      ||
	(
	  ConnRem [$1] (Pair`'lab_1,Pair`'lab_2,<> of Med)
	|||
	  ConnRem [$1] (Pair`'lab_2,Pair`'lab_1,<> of Med)
	)

      where
conn_loc_proc($1)
conn_rem_proc($1)

    endproc (* Conn *)')

# "conns_proc(gate)" produces process definitions for all
# connections at the given gate.

define(conns_proc,`
  process Conns [$1] : noexit :=

    Conn [$1] ||| Conns [$1]

    where
conn_proc($1)

  endproc (* Conns *)')

#################### Connection Local Macros #####################

# "conn_loc_init_proc(gate)" produces a process definition for all
# local initiation constraints on a connection at the given gate.

define(conn_loc_init_proc,`
	process ConnLocInit [$1] (PairX : Pair): exit :=

	  exit (*** insert local initiation constraints ***)

	endproc (* ConnLocInit *)')

# "conn_loc_data_nrm_proc(gate)" produces a process definition
# for all local normal data transfer constraints on a connection
# at the given gate.

define(conn_loc_data_nrm_proc,`
	  process ConnLocDataNrm [$1] (PairX : Pair) : noexit :=

	    stop (*** insert local normal data transfer constraints ***)

	  endproc (* ConnLocDataNrm *)')

# "conn_loc_data_exp_proc(gate)" produces a process definition
# for all local expedited data transfer constraints on a
# connection at the given gate.

define(conn_loc_data_exp_proc,`
	  process ConnLocDataExp [$1] (PairX : Pair) : noexit :=

	    stop (*** insert local expedited data transfer constraints ***)

	  endproc (* ConnLocDataExp *)')

# "conn_loc_data_proc(gate)" produces process definitions for all
# local data transfer constraints on a connection at the given
# gate.

define(conn_loc_data_proc,`
	process ConnLocData [$1] (PairX : Pair): noexit :=

	  (
	    ConnLocDataNrm [$1] (PairX)
	  []
	    i;
	    (ConnLocDataExp [$1] (PairX) [] exit)
	  )
	>>
	  ConnLocData [$1] (PairX)

	  where
conn_loc_data_nrm_proc($1)
conn_loc_data_exp_proc($1)

	endproc (* ConnLocData *)')

# "conn_loc_term_proc(gate)" produces a process definition for all
# local termination constraints on a connection at the given gate.

define(conn_loc_term_proc,`
	process ConnLocTerm [$1] (PairX : Pair) : exit :=

	  exit (*** insert local termination constraints ***)

	endproc (* ConnLocTerm *)')

# "conn_loc_proc(gate)" produces process definitions for all
# local constraints on a connection at the given gate.

define(conn_loc_proc,`
      process ConnLoc [$1] (PairX : Pair) : noexit :=

	ConnLocInit [$1] (PairX)
      >>
	(
	  ConnLocData [$1] (PairX)
	[>
	  (
	    i;
	    ConnLocTerm [$1] (PairX)
	  >>
	    ConnLoc [$1] (PairX)
	  )
	)

	where
conn_loc_init_proc($1)
conn_loc_data_proc($1)
conn_loc_term_proc($1)

      endproc (* ConnLoc *)')

#################### Connection Remote Macros ####################

# "conn_rem_init_proc(gate)" produces a process definition for all
# remote initiation constraints on a connection at the given gate.

define(conn_rem_init_proc,`
	process ConnRemInit [$1] (PairX,PairY : Pair,Med : Med): exit (Med):=

	  exit (any Med) (*** insert remote initiation constraints ***)

	endproc (* ConnRemInit *)')

# "conn_rem_data_nrm_proc(gate)" produces a process definition
# for all remote normal data transfer constraints on a connection
# at the given gate.

define(conn_rem_data_nrm_proc,`
	  process ConnRemDataNrm [$1] (PairX,PairY : Pair,Med : Med) : exit (Med) :=

	    exit (any Med) (*** insert remote normal data transfer constraints ***)

	  endproc (* ConnRemDataNrm *)')

# "conn_rem_data_exp_proc(gate)" produces a process definition
# for all remote expedited data transfer constraints on a
# connection at the given gate.

define(conn_rem_data_exp_proc,`
	  process ConnRemDataExp [$1] (PairX,PairY : Pair,Med : Med) : exit (Med) :=

	    exit (any Med) (*** insert remote expedited data transfer constraints ***)

	  endproc (* ConnRemDataExp *)')

# "conn_rem_data_proc(gate)" produces process definitions for all
# remote data transfer constraints on a connection at the given
# gate.

define(conn_rem_data_proc,`
	process ConnRemData [$1] (PairX,PairY : Pair,Med : Med) : exit (Med) :=

	    ConnRemDataNrm [$1] (PairX,PairY,Med)
	  []
	    ConnRemDataExp [$1] (PairX,PairY,Med)

	  where
conn_rem_data_nrm_proc($1)
conn_rem_data_exp_proc($1)

	endproc (* ConnRemData *)')

# "conn_rem_term_proc(gate)" produces a process definition for all
# remote termination constraints on a connection at the given
# gate.

define(conn_rem_term_proc,`
	process ConnRemTerm [$1] (PairX,PairY : Pair,Med : Med): exit (Med) :=

	  exit (any Med) (*** insert remote termination constraints ***)

	endproc (* ConnRemTerm *)')

# "conn_rem_proc(gate)" produces process definitions for all
# remote constraints on a connection at the given gate.

define(conn_rem_proc,`
      process ConnRem [$1] (PairX,PairY : Pair,Med1 : Med) : noexit :=

	(
	  ConnRemInit [$1] (PairX,PairY,Med1)
	[]
	  ConnRemData [$1] (PairX,PairY,Med1)
	[]
	  ConnRemTerm [$1] (PairX,PairY,Med1)
	)
      >>
	accept Med2 : Med in
	  (
	    choice Med3 : Med []
	      [(Med3 eq Med2) or (Med3 IsIn Reorders (Med2))] ->
		i;
		ConnRem [$1] (PairX,PairY,Med3)
	  )

	where
conn_rem_init_proc($1)
conn_rem_data_proc($1)
conn_rem_term_proc($1)

      endproc (* ConnRem *)')

##################### Global Refusal Macros ######################

# "pair_ref_proc(gate)" produces a process definition which
# refuses connections for an identifier pair already in use at the
# given gate.

define(pair_ref_proc,`
  process PairRefusals [$1] (UsedPairs : PairSet) : noexit :=

    choice Pair : Pair []
      $1 ! Addr (Pair) ! Ident (Pair) ? Prim : Prim
	[IsInit (Prim) Implies (Pair NotIn UsedPairs)];
      (
	[IsInit (Prim)] ->
	  PairRefusals [$1] (Insert (Pair, UsedPairs))
      []
	[IsTerm (Prim)] ->
	  PairRefusals [$1] (Remove (Pair, UsedPairs))
      []
	[not (IsInit (Prim) or IsTerm (Prim))] ->
	  PairRefusals [$1] (UsedPairs)
      )

  endproc (* PairRefusals *)')

# "conn_ref_proc(gate)" produces a process definition which
# refuses connections under congestion conditions at the given
# gate.

define(conn_ref_proc,`
  process ConnRefusals [$1] : noexit :=

    choice Pair : Pair,ConnPairs : PairSet []
      $1 ! Addr (Pair) ! Ident (Pair) ? Prim : Prim
	[IsInit (Prim) Implies (Pair IsIn ConnPairs)];
      ConnRefusals [$1]
    []
      i;		(* revise set of acceptable pairs *)
      ConnRefusals [$1]

  endproc (* ConnRefusals *)')

# "data_ref_proc(gate)" produces a process definition which
# refuses data transfer under congestion conditions at the given
# gate.

define(data_ref_proc,`
  process DataRefusals [$1] : noexit :=

    choice Pair : Pair,DataPairs : PairSet []
      $1 ! Addr (Pair) ! Ident (Pair) ? Prim : Prim
	[(IsData (Prim) and IsReq (Prim)) Implies (Pair IsIn DataPairs)];
      DataRefusals [$1]
    []
      i;		(* revise set of acceptable pairs *)
      DataRefusals [$1]

  endproc (* DataRefusals *)')

###################### Behaviour Macros ##########################

# "beh_proc(gate)" produces an overall
# behaviour definition at the given gate.

define(beh_proc,`
  behaviour
    Conns [$1]
  ||
    PairRefusals [$1] ({} of PairSet)
  ||
    ConnRefusals [$1]
  ||
    DataRefusals [$1]

  where')

##################### Specification Macros #######################

define(co_serv_spec,`define(`gate',
  `low_of($1)')define(`prims',
    `intrn_of($2)')specification $1Service [gate] : noexit
lib_type
beh_proc(gate)
richer_types
data_type
addr_type
ident_type
pair_type
prim_type(prims)
obj_type(prims)
meds_type
conns_proc(gate)
pair_ref_proc(gate)
conn_ref_proc(gate)
data_ref_proc(gate)

endspec (* $1Service *)')

########################### Trailer ##############################

divert
