divert(-1)

# "coserv.m4"	K. J. Turner (kjt@cs.stir.ac.uk)	28/05/96
# 
# Copyright 1996 K. J. Turner, University of Stirling

# This "m4" macro file uses BASIL (Basic Architectural Semantics in LOTOS) to
# generate a LOTOS specification of a connection-oriented service. Its
# characteristics are as follows:
# 
#   o Either user may initiate a connection with primitives:
#   
#     ConReq (Addr1, Addr2)
#     ConInd (Addr1, Addr2)
#     ConRsp (Addr)
#     ConCnf (Addr)
#     
#   o Either user may initiate normal data transfer with primitives:
#   
#     DatReq (Data)
#     DatInd (Data)
#     
#   o Either user may initiate expedited data transfer with primitives:
#   
#     ExpReq (Data)
#     ExpInd (Data)
#     
#   o Either user may initiate disconnection with primitives:
#   
#     DisReq ()
#     DisInd ()

include(basil.m4)

divert

co_serv_spec(
  CO,
  ConReq(Addr1,Addr2) ConInd(Addr1,Addr2)
  ConRsp(Addr)        ConCnf(Addr)
  DatReq(Data)        DatInd(Data)
  ExpReq(Data)        ExpInd(Data)
  DisReq()            DisInd()
)

