%{

/*****************************************************************

chktex.lex

K. J. Turner, University of Stirling, 15th November 1988

Developed on a Sun/3 using OS 3.5.

This program checks that begin-end pairs of LaTeX commands do in
fact match. The pairs which are checked are:

  - \begin{thing} and \end{thing}
  
  - ( and )
  
  - [ and ] (but not when escaped with \)
  
  - { and } (but not when escaped with \)
  
  - \( and \)
  
  - \[ and \]
  
  - $ and $ (must be treated specially because $ is ambiguous as
    to whether it starts or ends a pair)

Verbatim text is ignored:

  - \begin{verbatim@} and \end{verbatim@} (where @ should be
    void or *, but is not checked to be)

Pairs which are not checked are:

  - ` and '
  
  - " and "

  - \verb@ and @ (where @ is an arbitrary delimiter, and \verb
    may be followed by *)
  
*****************************************************************/

#define StackMax 128		/* maximum depth of nesting */

int I;				/* for counting */

int InVerbatim = 0;		/* in verbatim text (1 = true) */

int Line = 1;			/* current line number
				   (1 = first) */

int StackInd = 0;		/* current top of stack
				   (0 = bottom) */

char * StackName [StackMax];	/* stack of nested symbol names */

int StackLine [StackMax];	/* stack of nested symbol line
				   numbers */

char * malloc ();

%}

BeginPair	("("|"["|"{"|"\\("|"\\["|"$"|"\\begin{"[^}]*"}")
EndPair		(")"|"]"|"}"|"\\)"|"\\]"|"$"|"\\end{"[^}]*"}")
Ignore		("\\\\"|"\\{"|"\\}"|"\\$"|.)

%%

\n		Line++;

{BeginPair}	{
		  if (InVerbatim ||
		       (! strcmp (yytext, "$") && StackInd > 0 &&
		       ! strcmp (StackName [StackInd - 1], "$")))
		    REJECT
		  if (StackInd < StackMax)
		    {
		      StackLine [StackInd] = Line;
		      StackName [StackInd] = malloc (yyleng + 1);
		      if (StackName [StackInd] == NULL)
		        {
		          printf ("Line %d : memory allocation failed\n");
		          return 1;
		        }
		      strcpy (StackName [StackInd], yytext);
		      InVerbatim =
		        ! strncmp (yytext, "\\begin{verbatim", 15);
		      StackInd++;
		    }
		  else
		    {
		      printf ("Line %d : more than %d ", Line, StackMax);
		      printf ("nested commands found\n");
		      return 1;
		    }
		}

{EndPair}	{
		  if (InVerbatim &&
		       strncmp (yytext, "\\end{verbatim", 13))
		    REJECT
		  InVerbatim = 0;
		  if (StackInd == 0)
		    {
		      printf ("Line %d : %s ", Line, yytext);
		      printf ("has no corresponding beginning \n");
		    }
		  else
		    {
		      StackInd--;
		      if (! MatchName (StackName [StackInd], yytext))
			{
			  printf ("Line %d : %s ", Line, yytext);
			  printf ("does not match ");
			  printf ("Line %d : ", StackLine [StackInd]);
			  printf ("%s\n", StackName [StackInd]);
			}
		      free (StackName [StackInd]);
		    }
		}

{Ignore}	;

%%

int MatchName (Name1, Name2) char * Name1, * Name2;
{
  if (! strcmp (Name1, "("))
    return ! strcmp (Name2, ")");
  else
    if (! strcmp (Name1, "["))
      return ! strcmp (Name2, "]");
    else
      if (! strcmp (Name1, "{"))
	return ! strcmp (Name2, "}");
      else
	if (! strcmp (Name1, "\\("))
	  return ! strcmp (Name2, "\\)");
	else
	  if (! strcmp (Name1, "\\["))
	    return ! strcmp (Name2, "\\]");
	  else
	    if (! strcmp (Name1, "$"))
	      return ! strcmp (Name2, "$");
	    else
	      if (! strncmp (Name1, "\\begin{", 7) &&
		  ! strncmp (Name2, "\\end{", 5))
		return ! strcmp (Name1 + 7, Name2 + 5);
	      else return 0;
}

int yywrap ()
{
  printf ("\n");
  for (I = 0; I < StackInd; I++)
    {
      printf ("Line %d :  ", StackLine [I]);
      printf ("%s ", StackName [I]);
      printf ("has no corresponding ending\n");
    }
  return 1;
}

