// ChordDB.java	 (c) Y. P. Tay, K. J. Turner	04/08/03

// Class to handle the chord database "ChordDB"

import waba.fx.*;
import waba.sys.*;
import waba.util.*;
import waba.ui.*;
import waba.io.*;

public class ChordDB extends Window {
  private int keyIndex, ChordIndex;
  private static final String CATALOG_NAME = "ChordDB.ChTu.DATA";
  private Catalog cat;
  private ResizeStream rs;
  private DataStream ds;

  public ChordDB () {
  }

  // This method draws the keyboard

  public void drawKeyboard (Graphics g) {
    drawBorder (g, 0, 20, 160, 50);

    drawBlackKey (g, 7, 20);
    drawWhiteKey (g, 7, 0);			// C
    drawBlackKey (g, 15, 20);
    drawWhiteKey (g, 15, 0);			// D

    drawWhiteKey (g, 15, 1);			// E

    drawBlackKey (g, 31, 20);
    drawWhiteKey (g, 31, 0);			// F
    drawBlackKey (g, 39, 20);
    drawWhiteKey (g, 39, 0);			// G
    drawBlackKey (g, 47, 20);
    drawWhiteKey (g, 47, 0);			// A

    drawWhiteKey (g, 47, 1);			// B

    drawBlackKey (g, 63, 20);
    drawWhiteKey (g, 63, 0);			// C'
    drawBlackKey (g, 71, 20);
    drawWhiteKey (g, 71, 0);			// D'

    drawWhiteKey (g, 71, 1);			// E'

    drawBlackKey (g, 87, 20);
    drawWhiteKey (g, 87, 0);			// F'
    drawBlackKey (g, 95, 20);
    drawWhiteKey (g, 95, 0);			// G'
    drawBlackKey (g, 103, 20);
    drawWhiteKey (g, 103, 0);			// A'

    drawWhiteKey (g, 103, 1);			// B'

    drawBlackKey (g, 119, 20);
    drawWhiteKey (g, 119, 0);			// C''
    drawBlackKey (g, 127, 20);
    drawWhiteKey (g, 127, 0);			// D''

    drawWhiteKey (g, 127, 1);			// E''

    drawBlackKey (g, 143, 20);
    drawWhiteKey (g, 143, 0);			// F''
    drawBlackKey (g, 151, 20);
    drawWhiteKey (g, 151, 0);			// G''
  }

  // draw a black key

  public void drawBlackKey (Graphics g, int start_x, int start_y) {
    g.drawRect (start_x, start_y, 6, 15);
    g.setBackColor (Color.BLACK);
    g.fillRect (start_x, start_y, 6, 15);
  }

  // draw a white key

  public void drawWhiteKey (Graphics g, int start_x, int divider) {
    int start_pos = 0, div_pos = 0;

    if (divider == 0) {
      start_pos = start_x + 3;
      g.drawLine (start_pos, 35, start_pos, 50);
    }
    else if (divider == 1) {
      div_pos = start_x + 12;
      g.drawLine (div_pos, 20, div_pos, 50);
    }
  }

  // draw the border of the keyboard

  public void drawBorder (
   Graphics g, int start_x, int start_y, int end_x, int end_y) {
    g.drawLine (start_x, start_y, start_x, end_y);
    g.drawLine (start_x, start_y, end_x, start_y);
    g.drawLine (end_x, start_y, end_x, end_y);
    g.drawLine (start_x, end_y, end_x, end_y);
  }

  // return the scale details based on the key index

  public String getScale (int keyIndex) {
    this.keyIndex = keyIndex;
    int i = keyIndex + 55;
    cat.setRecordPos (i);
    String Notes = ds.readString ();
    return Notes;
  }

  // return the chord details based on the chord index

  public String getChordDetails (int ChordIndex) {
    this.ChordIndex = ChordIndex;
    return readCatalog (ChordIndex);
  }

  // open the chord database

  public boolean openCatalog () {
    boolean result = true;
    cat = new Catalog (CATALOG_NAME, Catalog.READ_ONLY);
    if (!cat.isOpen ()) {
      result = false;
      return result;
    }
    if (result) {
      rs = new ResizeStream (cat, 512);
      ds = new DataStream (rs);
    }
    return result;
  }

  // close the chord database

  public void closeCatalog () {
    if (cat.isOpen ()) {
      rs.close ();
      ds.close ();
    }
  }

  // read the 'i' element of the pdb file and return it as a string

  public String readCatalog (int i) {
    cat.setRecordPos (i);
    String chord = ds.readString ();
    if (chord != null)
      return chord;
    return null;
 }

 // return the key as a string

  public String getKey (int index) {
    String key=" ";
    switch (index) {
      case 0:
	key = "C";
	break;
      case 1:
	key = "C#";
	break;
      case 2:
	key = "D";
	break;
      case 3:
	key = "Eb";
	break;
      case 4:
	key = "E"; break;
      case 5:
	key = "F";
	break;
      case 6:
	key = "F#";
	break;
      case 7:
	key = "G";
	break;
      case 8:
	key = "Ab";
	break;
      case 9:
	key = "A";
	break;
      case 10:
	key = "Bb";
	break;
      case 11:
	key = "B";
	break;
    }
    return key;
  }
}
