// CreateChords.java	 (c) Y. P. Tay, K. J. Turner	04/08/03

// Self-standing program to create the "ChordTutorDB.pdb" chord database for
// other programs

import waba.sys.*;
import waba.ui.*;
import waba.fx.*;
import waba.util.*;
import waba.io.*;

public class CreateChords extends MainWindow {
  private static final String CATALOG_NAME = "ChordDB.ChTu.DATA";
  private Catalog cat;
  private ResizeStream rs;
  private DataStream ds;

  public static final int CHORDS = 55;		// chords numbered 0 to 54
  String[] ChordDetails = new String[67];

  public void onStart () {
    if (openCatalog ()) {
      writeRecords ();
      ds.close (); // ds already closes the catalog
      exit (0);
    }
  }

  // create and open the catalog

  public boolean openCatalog () {
    cat = new Catalog (CATALOG_NAME, Catalog.READ_ONLY);

    // if exists, delete all records
    if (cat.isOpen ())
      cat.delete ();

    // open again, creating
    cat = new Catalog (CATALOG_NAME, Catalog.CREATE);
    if (!cat.isOpen ())
      return false;

    // create the streams
    rs = new ResizeStream (cat,512);
    ds = new DataStream (rs);

    return true;
  }

  // write the records

  public void writeRecords () {
    ChordDetails[0]  = "Major:,Maj,M:Major:1,3,5";
    ChordDetails[1]  = "5:Power Chord::1,5";
    ChordDetails[2]  = "-5:(b5),Flat'd 5th:Major:1,3,b5";
    ChordDetails[3]  = "6:Maj6,M6:Major:1,3,5,6";
    ChordDetails[4]  =
      "6/9:6Add9,6 (Add 9),Maj6 (Add 9),M6 (add9):Major:1,3,(5),6,9";
    ChordDetails[5]  = "7:Dominant Seventh,Dom:Dominant:1,3,5,b7";
    ChordDetails[6]  = "Add9:(Add 9),Added 9th:Dominant:1,3,5,9";
    ChordDetails[7]  = "Maj7:Maj7,M7:Major:1,3,5,7";
    ChordDetails[8]  = "Maj7+5:Maj7#5,M7+5:Major:1,3,#5,7";
    ChordDetails[9]  = "Maj9:Maj7 (Add 9),M7 (Add 9):Major:1,3,(5),7,9";
    ChordDetails[10] = "Maj11:Maj7 (Add 11),M7 (Add 11):Major:1,(3),5,7,(9),11";
    ChordDetails[11] =
      "Maj13:Maj7 (Add 13),M7 (Add 13):Major:1,3,(5),7,(9),(11),13";
    ChordDetails[12] = "m:Minor,Min,-:Minor:1,b3,5";
    ChordDetails[13] = "M6:Minor6,Min6:Minor:1,b3,5,6";
    ChordDetails[14] = "M6/9::Minor:1,b3,(5),6,9";
    ChordDetails[15] =
      "mMaj7:Min/Maj7,mM7,m (AddM 7),M (+7),- (M7):Minor:1,b3,5,7";
    ChordDetails[16] =
      "mMaj9:Min/Maj9,mM9,m (Add M9),m (+9),- (M9):Minor:1,b3,(5),7,9";
    ChordDetails[17] = "mAdd9:Minor (Add 9),- (Add 9):Minor:1,b3,(5),9";
    ChordDetails[18] = "m7:Minor7,Min7,-7:Minor Seventh:1,b3,5,b7";
    ChordDetails[19] = "m9:Minor9,Min9,-9:Minor Seventh:1,b3,(5),b7,9";
    ChordDetails[20] = "m11:Minor11,Min11,-11:Minor Seventh:1,b3,(5),b7,(9),11";
    ChordDetails[21] =
      "m13:Minor13,Min13,-13:Minor Seventh:1,b3,(5),b7,(9),11,13";
    ChordDetails[22] = "m-5:m (b5):Diminished:1,b3,b5";
    ChordDetails[23] = "Dim:Dim7:Diminished:1,b3,b5,bb7";
    ChordDetails[24] =
      "m7-5:dim,dim7,m (b7),Minor7b5:Half diminished:1,b3,b5,b7";
    ChordDetails[25] = "7:Dominant Seventh,Dom:Dominant:1,3,5,b7";
    ChordDetails[26] = "7-9:7b9,7 (Add b9):Dominant:1,3,(5),b7,b9";
    ChordDetails[27] = "7+9:7 (Add #9):Dominant:1,3,(5),b7,#9";
    ChordDetails[28] = "7-5:7b5:Dominant:1,3,b5,b7";
    ChordDetails[29] = "7+5:7+,7#5:Dominant:1,3,#5,b7";
    ChordDetails[30] = "7/6:7 (Add 6):Dominant:1,3,(5),6,b7";
    ChordDetails[31] = "9:7 (Add 9):Dominant:1,3,(5),b7,9";
    ChordDetails[32] = "9-5:9b5,Ninth Flat'd 5th:Dominant:1,(3),b5,b7,9";
    ChordDetails[33] = "9+5:9#5,Ninth Augm'd 5th:Dominant:1,(3),#5,b7,9";
    ChordDetails[34] = "9/6:9 (Add 6):Dominant:1,(3),(5),6,b7,9";
    ChordDetails[35] =
      "9+11:9Aug11,Ninth Augm'd 11th:Dominant:1,3,(5),b7,9,#11";
    ChordDetails[36] = "11:7 (Add 11):Dominant:1,(3),5,b7,(9),11";
    ChordDetails[37] =
      "11-9:11 (b9),11 (Flat'd 9th):Dominant:1,(3),(5),b7,b9,11";
    ChordDetails[38] = "13:7 (Add 13):Dominant:1,(3),5,b7,(9),(11),13";
    ChordDetails[39] = "13-9:13b9:Dominant:1,(3),(5),b7,b9,(11),13";
    ChordDetails[40] = "13-9-5:13b9b5:Dominant:(1),(3),b5,b7,b9,(11),13";
    ChordDetails[41] = "13-9+11:13b9#11:Dominant:(1),(3),(5),b7,9,#11,13";
    ChordDetails[42] = "13+11:13 Augm'd 11th:Dominant:1,(3),(5),b7,(9),#11,13";
    ChordDetails[43] = "7/13:7/6:Dominant:1,3,(5),b7,13";
    ChordDetails[44] = "Aug:+,+5,(#5),Augm'd:Augmented:1,3,#5";
    ChordDetails[45] = "Sus2::Ambiguous:1,2,5";
    ChordDetails[46] = "Sus4:Sus:Ambiguous:1,4,5";
    ChordDetails[47] = "7Sus4:7Sus,7Sus11:Ambiguous:1,4,5,b7";
    ChordDetails[48] = "-9:b9,Flat'd 9th::1,3,(5),b7,b9";
    ChordDetails[49] = "-9+5:b9#5,Flat'd 9th Augm'd 5th::1,(3),#5,b7,b9";
    ChordDetails[50] =
      "-9+11:b9#11,Flat'd 9th Augm'd 11th::1,(3),(5),b7,b9,#11";
    ChordDetails[51] = "-9-5:b9b5,Flat'd 9th Flat'd 5th::1,(3),b5,b7,b9";
    ChordDetails[52] = "+5:Aug5,Augm'd 5th::1,3,#5";
    ChordDetails[53] = "+9:Aug9,Augm'd 9th::1,3,(5),b7,#9";
    ChordDetails[54] = "+11:Aug11,Augm'd 11th::1,(3),(5),b7,9,#11";

    ChordDetails[55] =
      "C,6,44:D,14,44:E,22,44:F,30,44:G,38,44:A,46,44:B,54,44:" +
      "C,62,44:D,70,44:E,78,44:F,86,44:G,94,44:A,102,44";
    ChordDetails[56] =
      "C#,10,30:D#,18,30:E,22,44:F#,34,30:G#,42,30:A#,50,30:B#,62,44:" +
      "C#,66,30:D#,74,30:E,78,44:F#,90,30:G#,98,30:A#,106,30";
    ChordDetails[57] =
      "D,14,44:E,22,44:F#,34,30:G,38,44:A,46,44:B,54,44:C#,66,30:" +
      "D,70,44:E,78,44:F#,90,30:G,94,44:A,102,44:B,110,44";
    ChordDetails[58] =
      "Eb,18,30:F,30,44:G,38,44:Ab,42,30:Bb,50,30:C,62,44:" +
      "D,70,44:Eb,74,30:F,86,44:G,94,44:Ab,98,30:Bb,106,30:C,118,44";
    ChordDetails[59] =
      "E,22,44:F#,34,30:G#,42,30:A,46,44:B,54,44:C#,66,30:" +
      "D#,74,30:E,78,44:F#,90,30:G#,98,30:A,102,44:B,110,44:C#,122,30";
    ChordDetails[60] =
      "F,30,44:G,38,44:A,46,44:Bb,50,30:C,62,44:D,70,44:" +
      "E,78,44:F,86,44:G,94,44:A,102,44:Bb,106,30:C,118,44:D,126,44";
    ChordDetails[61] =
      "F#,34,30:G#,42,30:A#,50,30:B,54,44:C#,66,30:D#,74,30:" +
      "E#,86,44:F#,90,30:G#,98,30:A#,106,30:B,110,44:C#,122,30:D#,130,30";
    ChordDetails[62] =
      "G,38,44:A,46,44:B,54,44:C,62,44:D,70,44:E,78,44:" +
      "F#,90,30:G,94,44:A,102,44:B,110,44:C,118,44:D,126,44:E,134,44";
    ChordDetails[63] =
      "Ab,42,30:Bb,50,30:C,62,44:Db,66,30:Eb,74,30:F,86,44:" +
      "G,94,44:Ab,98,30:Bb,106,30:C,118,44:D,122,30:Eb,130,30:F,142,44";
    ChordDetails[64] =
      "A,46,44:B,54,44:C#,66,30:D,70,44:E,78,44:F#,90,30:" +
      "G#,98,30:A,102,44:B,110,44:C#,122,30:D,126,44:E,134,44:F#,146,30";
    ChordDetails[65] =
      "Bb,50,30:C,62,44:D,70,44:Eb,74,30:F,86,44:G,94,44:A,102,44:" +
      "Bb,106,30:C,118,44:D,126,44:Eb,130,30:F,142,44:G,150,44";
    ChordDetails[66] =
      "B,54,44:C#,66,30:D#,74,30:E,78,44:F#,90,30:G#,98,30:" +
      "A#,106,30:B,110,44:C#,122,30:D#,130,30:E,134,44:F#,146,30:G#,154,30";

    for (int i = 0; i < 67; i++)  {
       // append the record
       rs.startRecord ();
       ds.writeString (ChordDetails[i]);
       rs.endRecord ();
    }
  }
}


