// Score.java	 (C) Y. P. Tay, K. J. Turner	04/08/03

// Class to handle composed scores and the "ChordTutorDB" score database

import waba.fx.*;
import waba.sys.*;
import waba.util.*;
import waba.ui.*;
import waba.io.*;
import java.lang.*;

public class Score extends Window {
  private int x_pos, y_pos, display, count=0, numRecords;
  private Vector NotesVec;
  Catalog scoreCat;
  private ResizeStream rs;
  private DataStream ds;
  private int recordPos, numNotes;
  private ChordTutor chordtut;

  private static final String CATALOG_NAME = "ChordTutorDB.ChTu.DATA";
  // Note value constants
  // C note
  public static final int C = 0;
  public static final int CSHARP = 1;
  public static final int CFLAT = 2;
  public static final int HIGH_C = 3;
  public static final int HIGH_CSHARP = 4;
  public static final int HIGH_CFLAT = 5;
  public static final int HIGHER_C = 6;
  public static final int HIGHER_CFLAT = 7;
  public static final int HIGHER_CSHARP = 8;

  // D note
  public static final int D = 9;
  public static final int DSHARP = 10;
  public static final int DFLAT = 11;
  public static final int HIGH_D = 12;
  public static final int HIGH_DFLAT = 13;
  public static final int HIGH_DSHARP = 14;
  public static final int HIGHER_D = 15;
  public static final int HIGHER_DFLAT = 16;
  public static final int HIGHER_DSHARP = 17;

  // E note
  public static final int E = 18;
  public static final int ESHARP = 19;
  public static final int EFLAT = 20;
  public static final int HIGH_E = 21;
  public static final int HIGH_EFLAT = 22;
  public static final int HIGH_ESHARP = 23;
  public static final int HIGHER_E = 24;
  public static final int HIGHER_EFLAT = 25;
  public static final int HIGHER_ESHARP = 26;

  // F note
  public static final int F = 27;
  public static final int FSHARP = 28;
  public static final int FFLAT = 29;
  public static final int HIGH_F = 30;
  public static final int HIGH_FFLAT = 31;
  public static final int HIGH_FSHARP = 32;
  public static final int HIGHER_F = 33;
  public static final int HIGHER_FFLAT = 34;
  public static final int HIGHER_FSHARP = 35;

  // G note
  public static final int LOW_G = 36;
  public static final int LOW_GSHARP = 37;
  public static final int LOW_GFLAT = 38;
  public static final int G = 39;
  public static final int GSHARP = 40;
  public static final int GFLAT = 41;
  public static final int HIGH_G = 42;
  public static final int HIGH_GFLAT = 43;
  public static final int HIGH_GSHARP = 44;
  public static final int HIGHER_G = 45;
  public static final int HIGHER_GFLAT = 46;
  public static final int HIGHER_GSHARP = 47;

  // A note
  public static final int LOW_A = 48;
  public static final int LOW_ASHARP = 49;
  public static final int LOW_AFLAT = 50;
  public static final int A = 51;
  public static final int ASHARP = 52;
  public static final int AFLAT = 53;
  public static final int HIGH_A = 54;
  public static final int HIGH_AFLAT = 55;
  public static final int HIGH_ASHARP = 56;
  public static final int HIGHER_AFLAT = 57;

  // B note
  public static final int LOW_B = 58;
  public static final int LOW_BSHARP = 59;
  public static final int LOW_BFLAT = 60;
  public static final int B = 61;
  public static final int BSHARP = 62;
  public static final int BFLAT = 63;
  public static final int HIGH_B = 64;
  public static final int HIGH_BFLAT = 65;
  public static final int HIGH_BSHARP = 66;

  // Notes' frequency constant
  private static final int LOW_B_FREQ = 247;
  private static final int LOW_A_FREQ = 220;
  private static final int LOW_G_FREQ = 196;
  private static final int C_FREQUENCY = 262;
  private static final int D_FREQUENCY = 294;
  private static final int E_FREQUENCY = 330;
  private static final int F_FREQUENCY = 349;
  private static final int G_FREQUENCY = 392;
  private static final int A_FREQUENCY = 440;
  private static final int B_FREQUENCY = 494;
  private static final int HIGH_C_FREQUENCY = 523;
  private static final int HIGH_D_FREQUENCY = 587;
  private static final int HIGH_E_FREQUENCY = 659;
  private static final int HIGH_F_FREQUENCY = 698;
  private static final int HIGH_G_FREQUENCY = 784;
  private static final int HIGH_A_FREQUENCY = 880;
  private static final int HIGH_B_FREQUENCY = 988;
  private static final int HIGHER_C_FREQUENCY = 1046;
  private static final int HIGHER_D_FREQUENCY = 1175;
  private static final int HIGHER_E_FREQUENCY = 1318;
  private static final int HIGHER_F_FREQUENCY = 1397;
  private static final int HIGHER_G_FREQUENCY = 1568;
  private static final int HIGHER_A_FREQUENCY = 1760;

  private static final int LOW_BFLAT_FREQ = 233;
  private static final int LOW_AFLAT_FREQ = 208;
  private static final int LOW_GFLAT_FREQ = 185;
  private static final int CSHARP_FREQUENCY = 277;
  private static final int EFLAT_FREQUENCY = 311;
  private static final int FSHARP_FREQUENCY = 370;
  private static final int AFLAT_FREQUENCY = 415;
  private static final int BFLAT_FREQUENCY = 466;
  private static final int HIGH_CSP_FREQUENCY = 554;
  private static final int HIGH_EFLAT_FREQUENCY = 622;
  private static final int HIGH_FSP_FREQUENCY = 740;
  private static final int HIGH_AFLAT_FREQUENCY = 831;
  private static final int HIGH_BFLAT_FREQUENCY = 932;
  private static final int HIGHER_CSP_FREQUENCY = 1109;
  private static final int HIGHER_EFLAT_FREQUENCY = 1244;
  private static final int HIGHER_FSP_FREQUENCY = 1480;
  private static final int HIGHER_AFLAT_FREQUENCY = 1661;

  // note duration constants
  public static final int BREVE_DURATION = 1600;
  public static final int DOTTED_MINIM_DURATION = 1200;
  public static final int MINIM_DURATION = 800;
  public static final int DOTTED_CROTCHET_DURATION = 600;
  public static final int CROTCHET_DURATION = 400;
  public static final int QUAVER_DURATION = 200;
  public static final int SEMIQUAVER_DURATION = 100;

  // rest duration
  public static final int BREVE_REST_DURATION = 1600;
  public static final int MINIM_REST_DURATION = 800;
  public static final int CROTCHET_REST_DURATION = 400;
  public static final int QUAVER_REST_DURATION = 200;

  // notes constants
  public static final int SEMIBREVE = 0;
  public static final int DOTTED_MINIM = 1;
  public static final int MINIM = 2;
  public static final int DOTTED_CROTCHET = 3;
  public static final int CROTCHET = 4;
  public static final int QUAVER = 5;
  public static final int SEMIQUAVER = 6;
  public static final int FLAT = 7;
  public static final int SHARP = 8;
  public static final int CROTCHET_REST = 9;
  public static final int MINIM_REST = 10;
  public static final int BREVE_REST = 11;
  public static final int QUAVER_REST = 12;
  public static final int NATURAL = 13;
  public static final int _REST = 14;

  // constructor

  public Score (ChordTutor myCT) {
    chordtut = myCT;
    openCatalog ();
  }

  // draws the score and the ledger lines

  public void drawScore (Graphics g, int pageCount) {
    g.setForeColor (Color.BLACK);
    g.setBackColor (Color.BLACK);

    // draw the score (5 lines)
    g.drawLine (0, 40, 160, 40);
    g.drawLine (0, 46, 160, 46);
    g.drawLine (0, 52, 160, 52);
    g.drawLine (0, 58, 160, 58);
    g.drawLine (0, 64, 160, 64);

    // draw the separator for the notes & accidentals
    g.drawLine (10, 98, 10, 130);
    g.drawLine (25, 98, 25, 130);
    g.drawLine (40, 98, 40, 130);
    g.drawLine (55, 98, 55, 130);
    g.drawLine (70, 98, 70, 130);
    g.drawLine (85, 98, 85, 130);
    g.drawLine (100, 98, 100, 130);
    g.drawLine (0, 98, 100, 98);
    g.drawLine (0, 115, 100, 115);
    g.drawLine (0, 130, 100, 130);

    // draw the notes, rests and accidentals
    drawDisplayNotes (g);

    // additional two more ledger lines for the top and bottom
    g.setForeColor (Color.WHITE);
    g.setBackColor (Color.BLACK);

    // the ledger lines start at different position from the first and the rest
    if (pageCount == 1) {
      g.drawDots (15, 28, 160, 28);
      g.drawDots (15, 34, 160, 34);
      g.drawDots (15, 70, 160, 70);
      g.drawDots (15, 76, 160, 76);
    }
    else {
      g.drawDots (0, 28, 160, 28);
      g.drawDots (0, 34, 160, 34);
      g.drawDots (0, 70, 160, 70);
      g.drawDots (0, 76, 160, 76);
    }
  }

  // the semibreve (whole note)

  public void drawBreve (Graphics g, int x_pos, int y_pos) {
    this.x_pos = x_pos;
    this.y_pos = y_pos;
    g.setForeColor (Color.BLACK);
    g.setBackColor (Color.BLACK);
    if (y_pos >= 27 && y_pos <= 29) {
     g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
     g.drawLine (x_pos - 3, y_pos+6, x_pos + 3, y_pos+6);
    }
    // for the ledger lines
    else if ((y_pos >= 33 && y_pos <= 35) || (y_pos >= 69 && y_pos <= 71))
      g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
    else if ((y_pos >= 30 && y_pos <= 32))
      g.drawLine (x_pos - 3, y_pos + 3, x_pos + 3, y_pos + 3);
    else if (y_pos >= 72 && y_pos <= 74)
      g.drawLine (x_pos - 3, y_pos - 3, x_pos + 3, y_pos - 3);
    else if (y_pos >= 75 && y_pos <= 77) {
      g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
      g.drawLine (x_pos - 3, y_pos - 6, x_pos + 3, y_pos - 6);
    }
    g.drawCircle (x_pos, y_pos, 2);
  }

  // the minim note (half note)

  public void drawMinim (Graphics g, int x_pos, int y_pos, boolean dot) {
    boolean dotted;
    dotted = dot;
    this.x_pos = x_pos;
    this.y_pos = y_pos;

    g.setForeColor (Color.BLACK);
    g.setBackColor (Color.BLACK);

    // for dotted minim, have to include a dot
    if (dotted == true) {
      g.drawRect (x_pos+4, y_pos, 2, 2);
      g.fillRect (x_pos+4, y_pos, 2, 2);
    }

    // for the ledger lines
    if (y_pos >= 27 && y_pos <= 29) {
     g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
     g.drawLine (x_pos - 3, y_pos+6, x_pos + 3, y_pos+6);
    }
    else if ((y_pos >= 33 && y_pos <= 35)|| (y_pos >= 69 && y_pos <= 71))
      g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
    else if ((y_pos >= 30 && y_pos <= 32))
      g.drawLine (x_pos - 3, y_pos + 3, x_pos + 3, y_pos + 3);
    else if (y_pos >= 72 && y_pos <= 74)
      g.drawLine (x_pos - 3, y_pos - 3, x_pos + 3, y_pos - 3);
    else if (y_pos >= 75 && y_pos <= 77) {
      g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
      g.drawLine (x_pos - 3, y_pos - 6, x_pos + 3, y_pos - 6);
    }
    g.drawCircle (x_pos, y_pos, 2);
    g.drawLine (x_pos+2, y_pos-10, x_pos+2, y_pos);
  }

  // the crotchet note (quarter note)

  public void drawCrotchet (Graphics g, int x_pos, int y_pos, boolean dot) {
    boolean dotted;
    dotted = dot;
    this.x_pos = x_pos;
    this.y_pos = y_pos;

    g.setForeColor (Color.BLACK);
    g.setBackColor (Color.BLACK);
    g.drawCircle (x_pos, y_pos, 2);
    g.fillCircle (x_pos, y_pos, 2);

    // for the ledger lines
    if (y_pos >= 27 && y_pos <= 29) {
      g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
      g.drawLine (x_pos - 3, y_pos+6, x_pos + 3, y_pos+6);
    }
    else if ((y_pos >= 33 && y_pos <= 35)|| (y_pos >= 69 && y_pos <= 71))
      g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
    else if ((y_pos >= 30 && y_pos <= 32))
      g.drawLine (x_pos - 3, y_pos + 3, x_pos + 3, y_pos + 3);
    else if (y_pos >= 72 && y_pos <= 74)
      g.drawLine (x_pos - 3, y_pos - 3, x_pos + 3, y_pos - 3);
    else if (y_pos >= 75 && y_pos <= 77) {
      g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
      g.drawLine (x_pos - 3, y_pos - 6, x_pos + 3, y_pos - 6);
    }

    // for dotted crotchet, draw a dot
    if (dotted == true) {
     g.drawRect (x_pos+4, y_pos, 2, 2);
     g.fillRect (x_pos+4, y_pos, 2, 2);
    }

   g.drawLine (x_pos+2, y_pos-10, x_pos+2, y_pos);
  }

  // the quaver note (eighth note)

  public void drawSQuaver (Graphics g, int x_pos, int y_pos, int semi) {
    this.x_pos = x_pos;
    this.y_pos = y_pos;

    g.setForeColor (Color.BLACK);
    g.setBackColor (Color.BLACK);
    g.drawCircle (x_pos, y_pos, 2);
    g.fillCircle (x_pos, y_pos, 2);

    // for the ledger lines
    if (y_pos >= 27 && y_pos <= 29) {
      g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
      g.drawLine (x_pos - 3, y_pos+6, x_pos + 3, y_pos+6);
    }
    else if ((y_pos >= 33 && y_pos <= 35)|| (y_pos >= 69 && y_pos <= 71))
      g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
    else if ((y_pos >= 30 && y_pos <= 32))
      g.drawLine (x_pos - 3, y_pos + 3, x_pos + 3, y_pos + 3);
    else if (y_pos >= 72 && y_pos <= 74)
      g.drawLine (x_pos - 3, y_pos - 3, x_pos + 3, y_pos - 3);
    else if (y_pos >= 75 && y_pos <= 77) {
      g.drawLine (x_pos - 3, y_pos, x_pos + 3, y_pos);
      g.drawLine (x_pos - 3, y_pos - 6, x_pos + 3, y_pos - 6);
    }

    g.drawLine (x_pos+2, y_pos-10, x_pos+2, y_pos);
    g.drawLine (x_pos+2, y_pos-10, x_pos+5, y_pos - 6);

    // for drawing the semiquaver
    if (semi == 1) {
     g.drawLine (x_pos+2, y_pos - 6, x_pos+5, y_pos-2);
    }
  }

  // plays the notes from the passed-in vector.
  // Each of the item in the array is accessed and break
  // down into the individual fields and the notes are played
  // based on their frequency and duration with the method
  // Sound.tone (frequency, duration).

  public void playNotes (Vector NotesVec) {
    String[] freqDur = new String[5];
    int frequency;
    int duration;
    this.NotesVec = NotesVec;
    int VecLength;

    // get the length of the vector
    VecLength = NotesVec.getCount ();

    // for each of the item, split them and get the frequency and
    // duration. If frequency is 0, it is a rest and is achieved by
    // calling the Vm sleep method.
    for (int i=0; i < VecLength; i++) {
      freqDur = Convert.tokenizeString ((String) NotesVec.get (i), ':');
      frequency = Convert.toInt (freqDur[3]);
      duration = Convert.toInt (freqDur[4]);
      if (frequency == 0)
	Vm.sleep (duration);
      else
	Sound.tone (frequency, duration);
    }
  }

  // returns the duration of the note being selected.

  public int getNoteDuration (int noteSelected) {
    int duration=0;

    switch (noteSelected) {
       case (SEMIBREVE):
	 duration = BREVE_DURATION;
	 break;
       case (MINIM):
	 duration = MINIM_DURATION;
	 break;
       case (DOTTED_MINIM):
	 duration = DOTTED_MINIM_DURATION;
	 break;
       case (CROTCHET):
	 duration = CROTCHET_DURATION;
	 break;
       case (DOTTED_CROTCHET):
	 duration = DOTTED_CROTCHET_DURATION;
	 break;
       case (QUAVER):
	 duration = QUAVER_DURATION;
	 break;
       case (SEMIQUAVER):
	 duration = SEMIQUAVER_DURATION;
	 break;
       case (BREVE_REST):
	 duration = BREVE_REST_DURATION;
	 break;
       case (MINIM_REST):
	 duration = MINIM_REST_DURATION;
	 break;
       case (CROTCHET_REST):
	 duration = CROTCHET_REST_DURATION;
	 break;
       case (QUAVER_REST):
	 duration = QUAVER_REST_DURATION;
	 break;
    }

    return duration;
  }

  // returns the frequency of the note being selected

  public int getNoteFrequency (int noteSelected) {
    int frequency=0;

    switch (noteSelected) {
       case (LOW_B):
	 frequency = LOW_B_FREQ;
	 break;
       case (LOW_BFLAT):
       case (LOW_ASHARP):
	 frequency = LOW_BFLAT_FREQ;
	 break;
       case (LOW_A):
	 frequency = LOW_A_FREQ;
	 break;
       case (LOW_AFLAT):
       case (LOW_GSHARP):
	 frequency = LOW_AFLAT_FREQ;
	 break;
       case (LOW_G):
	 frequency = LOW_G_FREQ;
	 break;
       case (LOW_GFLAT):
	 frequency = LOW_GFLAT_FREQ;
	 break;
       case (C):
	 frequency = C_FREQUENCY;
	 break;
       case (CSHARP):
       case (DFLAT):
	 frequency = CSHARP_FREQUENCY;
	 break;
       case (D):
	 frequency = D_FREQUENCY;
	 break;
       case (DSHARP):
       case (EFLAT):
	 frequency = EFLAT_FREQUENCY;
	 break;
       case (E):
	 frequency = E_FREQUENCY;
	 break;
       case (ESHARP):
       case (F):
	 frequency = F_FREQUENCY;
	 break;
       case (FSHARP):
       case (GFLAT):
	 frequency = FSHARP_FREQUENCY;
	 break;
       case (G):
	 frequency = G_FREQUENCY;
	 break;
       case (GSHARP):
       case (AFLAT):
	 frequency = AFLAT_FREQUENCY;
	 break;
       case (A):
	 frequency = A_FREQUENCY;
	 break;
       case (ASHARP):
       case (BFLAT):
	 frequency = BFLAT_FREQUENCY;
	 break;
       case (B):
       case (HIGH_CFLAT):
	 frequency = B_FREQUENCY;
	 break;
       case (BSHARP):
       case (HIGH_C):
	 frequency = HIGH_C_FREQUENCY;
	 break;
       case (HIGH_CSHARP):
       case (HIGH_DFLAT):
	 frequency = HIGH_CSP_FREQUENCY;
	 break;
       case (HIGH_D):
	 frequency = HIGH_D_FREQUENCY;
	 break;
       case (HIGH_DSHARP):
       case (HIGH_EFLAT):
	 frequency = HIGH_EFLAT_FREQUENCY;
	 break;
       case (HIGH_E):
	 frequency = HIGH_E_FREQUENCY;
	 break;
       case (HIGH_ESHARP):
       case (HIGH_F):
	 frequency = HIGH_F_FREQUENCY;
	 break;
       case (HIGH_FSHARP):
       case (HIGH_GFLAT):
	 frequency = HIGH_FSP_FREQUENCY;
	 break;
       case (HIGH_G):
	 frequency = HIGH_G_FREQUENCY;
	 break;
       case (HIGH_GSHARP):
       case (HIGH_AFLAT):
	 frequency = HIGH_AFLAT_FREQUENCY;
	 break;
       case (HIGH_A):
	 frequency = HIGH_A_FREQUENCY;
	 break;
       case (HIGH_ASHARP):
       case (HIGH_BFLAT):
	 frequency = HIGH_BFLAT_FREQUENCY;
	 break;
       case (HIGH_B):
       case (HIGHER_CFLAT):
	 frequency = HIGH_B_FREQUENCY;
	 break;
       case (HIGHER_C):
	 frequency = HIGHER_C_FREQUENCY;
	 break;
       case (HIGHER_CSHARP):
       case (HIGHER_DFLAT):
	 frequency = HIGHER_CSP_FREQUENCY;
	 break;
       case (HIGHER_D):
	 frequency = HIGHER_D_FREQUENCY;
	 break;
       case (HIGHER_DSHARP):
       case (HIGHER_EFLAT):
	 frequency = HIGHER_EFLAT_FREQUENCY;
	 break;
       case (HIGHER_E):
	 frequency = HIGHER_E_FREQUENCY;
	 break;
       case (HIGHER_ESHARP):
       case (HIGHER_F):
	 frequency = HIGHER_F_FREQUENCY;
	 break;
       case (HIGHER_FSHARP):
       case (HIGHER_GFLAT):
	 frequency = HIGHER_FSP_FREQUENCY;
	 break;
       case (HIGHER_G):
	 frequency = HIGHER_G_FREQUENCY;
	 break;
       case (HIGHER_GSHARP):
       case (HIGHER_AFLAT):
	 frequency = HIGHER_AFLAT_FREQUENCY;
	 break;
    }
    return frequency;
  }

  // draws the notes, rests and accidentals for selection

  public void drawDisplayNotes (Graphics g) {
    // draw semibreve
    drawBreve (g, 4, 110);

    // draw minim
    drawMinim (g, 17, 110, false);
    drawMinim (g, 32, 110, true);

    // draw crotchet
    drawCrotchet (g, 47, 110, false);
    drawCrotchet (g, 62, 110, true);

    // draw quaver or semiquave
    // if the last parameter is 1, a semiquaver will be drawn
    drawSQuaver (g, 75, 110, 0);
    drawSQuaver (g, 90, 110, 1);

    // draw the accidentals
    drawSharp (g, 14, 121);
    drawFlat (g, 3, 119);
    drawNatural (g, 92, 118);

    // draw the rests
    drawCrotchetRest (g, 30, 118);
    drawMinimRest (g, 45, 122);
    drawBreveRest (g, 60, 122);
    drawQuaverRest (g, 77, 120);
  }

  // draw the treble clef

  public void drawTrebleClef (Graphics g) {
    g.setForeColor (Color.BLACK);
    g.drawArc (10, 58, 5, 0, 180);
    g.drawArc (8, 58, 7, 180, 360);
    g.drawLine (1, 58, 15, 40);
    g.drawLine (15, 40, 10, 30);
    g.drawLine (10, 30, 10, 70);
    g.drawArc (8, 70, 2, 180, 360);
  }

  // draw the sharp

  public void drawSharp (Graphics g, int x_pos, int y_pos) {
    this.x_pos = x_pos;
    this.y_pos = y_pos;

    g.setBackColor (Color.BLACK);
    g.setForeColor (Color.BLACK);
    g.drawLine (x_pos, y_pos, x_pos+7, y_pos);
    g.drawLine (x_pos-1, y_pos+4, x_pos+6, y_pos+4);
    g.drawLine (x_pos + 3, y_pos - 3, x_pos, y_pos+7);
g.drawLine (x_pos+6, y_pos - 3, x_pos + 3, y_pos+7);
  }

  // draw the flat

  public void drawFlat (Graphics g, int x_pos, int y_pos) {
    this.x_pos = x_pos;
    this.y_pos = y_pos;

    g.setBackColor (Color.BLACK);
    g.setForeColor (Color.BLACK);
    g.drawLine (x_pos, y_pos, x_pos, y_pos+9);
    g.drawLine (x_pos, y_pos+5, x_pos+2, y_pos + 3);
    g.drawArc (x_pos+2, y_pos+5, 2, 270, 90);
    g.drawLine (x_pos, y_pos+9, x_pos+2, y_pos+7);
  }

  // draw the natural sign

  public void drawNatural (Graphics g, int x_pos, int y_pos) {
    this.x_pos = x_pos;
    this.y_pos = y_pos;

    g.setBackColor (Color.BLACK);
    g.setForeColor (Color.BLACK);
    g.drawLine (x_pos, y_pos, x_pos - 3, y_pos+7);
    g.drawLine (x_pos - 3, y_pos+7, x_pos+2, y_pos+7);
    g.drawLine (x_pos-2, y_pos+4, x_pos + 3, y_pos+4);
    g.drawLine (x_pos + 3, y_pos+4, x_pos, y_pos+11);
  }

  // draw the crotchet rest

  public void drawCrotchetRest (Graphics g, int x_pos, int y_pos) {
    this.x_pos = x_pos;
    this.y_pos = y_pos;

    g.setBackColor (Color.BLACK);
    g.setForeColor (Color.BLACK);
    g.drawLine (x_pos, y_pos, x_pos+5, y_pos+2);
    g.drawLine (x_pos+5, y_pos+2, x_pos, y_pos+4);
    g.drawLine (x_pos, y_pos+4, x_pos+5, y_pos+6);
    g.drawLine (x_pos+5, y_pos+6, x_pos, y_pos+8);
    g.drawLine (x_pos, y_pos+8, x_pos+5, y_pos+10);
  }

  // draw the minim rest

  public void drawMinimRest (Graphics g, int x_pos, int y_pos) {
    this.x_pos = x_pos;
    this.y_pos = y_pos;

    g.setBackColor (Color.BLACK);
    g.setForeColor (Color.BLACK);

    g.drawRect (x_pos, y_pos, 6, 3);
    g.fillRect (x_pos, y_pos, 6, 3);
    g.drawLine (x_pos-2, y_pos + 3, x_pos+7, y_pos + 3);
  }

  // draw the semibreve rest

  public void drawBreveRest (Graphics g, int x_pos, int y_pos) {
    this.x_pos = x_pos;
    this.y_pos = y_pos;

    g.setBackColor (Color.BLACK);
    g.setForeColor (Color.BLACK);
    g.drawRect (x_pos, y_pos, 6, 4);
    g.fillRect (x_pos, y_pos, 6, 4);
    g.drawLine (x_pos-2, y_pos, x_pos+7, y_pos);
  }

  // draw the quaver rest

  public void drawQuaverRest (Graphics g, int x_pos, int y_pos) {
    this.x_pos = x_pos;
    this.y_pos = y_pos;

    g.setBackColor (Color.BLACK);
    g.setForeColor (Color.BLACK);
    g.drawRect (x_pos, y_pos, 2, 2);
    g.fillRect (x_pos, y_pos, 2, 2);
    g.drawLine (x_pos+2, y_pos, x_pos+1, y_pos+5);
  }

  // change C note to the accidental based on the accidental

  public int changeCNote (int noteVal, int accidental) {
    int noteValue = noteVal;
    int newValue = -1;
    int accType = accidental;

    // if accidental is sharp, the note will be changed to the sharp value
    if (accType == SHARP) {
      switch (noteValue) {
	 case (CFLAT):
	   newValue = C;
	   break;
	 case (C):
	   newValue = CSHARP;
	   break;
	 case (HIGH_CFLAT) :
	   newValue = HIGH_C;
	   break;
	 case (HIGH_C) :
	   newValue = HIGH_CSHARP;
	   break;
	 case (HIGHER_CFLAT):
	   newValue = HIGHER_C;
	   break;
	 case (HIGHER_C):
	   newValue = HIGHER_CSHARP;
	   break;
      }
    }
    // if accidental is flat, the note will be changed to the flat value
    else if (accType == FLAT) {
      switch (noteValue) {
	 case (C):
	   newValue = CFLAT;
	   break;
	 case (CSHARP):
	   newValue = C;
	   break;
	 case (HIGH_C):
	   newValue = HIGH_CFLAT;
	   break;
	 case (HIGH_CSHARP):
	   newValue = HIGH_C;
	   break;
	 case (HIGHER_C):
	   newValue = HIGHER_CFLAT;
	   break;
	 case (HIGHER_CSHARP):
	   newValue = HIGHER_C;
	   break;
      }
    }
    // if accidental is natural, note will be changed back to original value
    else if (accType == NATURAL) {
      switch (noteValue) {
	 case (CSHARP):
	 case (CFLAT):
	   newValue = C;
	   break;
	 case (HIGH_CSHARP):
	 case (HIGH_CFLAT):
	   newValue = HIGH_C;
	   break;
	 case (HIGHER_CSHARP):
	 case (HIGHER_CFLAT):
	   newValue = HIGHER_C;
	   break;
      }
    }
    // if it is already an accidental, the value will be returned
    // unchanged.
    if (newValue != -1)
      return newValue;
    else
      return noteValue;
  }

  // change D note to the accidental based on the accidental

  public int changeDNote (int noteVal, int accidental) {
    int noteValue = noteVal;
    int newValue = 0;
    int accType = accidental;

    // if accidental is sharp, the note will be changed to the sharp value
    if (accType == SHARP) {
      switch (noteValue) {
	 case (DFLAT):
	   newValue = D;
	   break;
	 case (D):
	   newValue = DSHARP;
	   break;
	 case (HIGH_DFLAT):
	   newValue = HIGH_D;
	   break;
	 case (HIGH_D):
	   newValue = HIGH_DSHARP;
	   break;
	 case (HIGHER_DFLAT):
	   newValue = HIGHER_D;
	   break;
	 case (HIGHER_D):
	   newValue = HIGHER_DSHARP;
	   break;
      }
    }
    // if accidental is flat, the note will be changed to the flat value
    else if (accType == FLAT) {
      switch (noteValue) {
	 case (D):
	   newValue = DFLAT;
	   break;
	 case (DSHARP):
	   newValue = D;
	   break;
	 case (HIGH_D):
	   newValue = HIGH_DFLAT;
	   break;
	 case (HIGH_DSHARP):
	   newValue = HIGH_D;
	   break;
	 case (HIGHER_D):
	   newValue = HIGHER_DFLAT;
	   break;
	 case (HIGHER_DSHARP):
	   newValue = HIGHER_D;
	   break;
     }
    }
    // if accidental is natural, note will be changed back to original value
    else if (accType == NATURAL) {
      switch (noteValue) {
	 case (DSHARP):
	 case (DFLAT):
	   newValue = D;
	   break;
	 case (HIGH_DFLAT):
	 case (HIGH_DSHARP):
	   newValue = HIGH_D;
	   break;
	 case (HIGHER_DFLAT):
	 case (HIGHER_DSHARP):
	   newValue = HIGHER_D;
	   break;
      }
    }
    // if it is already an accidental, the value will be returned
    // unchanged.
    if (newValue != 0)
      return newValue;
    else
      return noteValue;
  }

  // change E note to the accidental based on the accidental

  public int changeENote (int noteVal, int accidental) {
    int noteValue = noteVal;
    int newValue = 0;
    int accType = accidental;

    // if accidental is sharp, the note will be changed to the sharp value
    if (accType == SHARP) {
      switch (noteValue) {
	 case (EFLAT):
	   newValue = E;
	   break;
	 case (E):
	   newValue = ESHARP;
	   break;
	 case (HIGH_E):
	   newValue = HIGH_ESHARP;
	   break;
	 case (HIGH_EFLAT):
	   newValue = HIGH_E;
	   break;
	 case (HIGHER_E):
	   newValue = HIGHER_ESHARP;
	   break;
	 case (HIGHER_EFLAT):
	   newValue = HIGHER_E;
	   break;
      }
    }
    // if accidental is flat, the note will be changed to the flat value
    else if (accType == FLAT) {
      switch (noteValue) {
	 case (E):
	   newValue = EFLAT;
	   break;
	 case (ESHARP):
	   newValue = E;
	   break;
	 case (HIGH_E):
	   newValue = HIGH_EFLAT;
	   break;
	 case (HIGH_ESHARP):
	   newValue = HIGH_E;
	   break;
	 case (HIGHER_E):
	   newValue = HIGHER_EFLAT;
	   break;
	 case (HIGHER_ESHARP):
	   newValue = HIGHER_E;
	   break;
      }
    }
    // if accidental is natural, note will be changed back to original value
    else if (accType == NATURAL) {
      switch (noteValue) {
	 case (ESHARP):
	 case (EFLAT):
	   newValue = E;
	   break;
	 case (HIGH_ESHARP):
	 case (HIGH_EFLAT):
	   newValue = HIGH_E;
	   break;
	 case (HIGHER_ESHARP):
	 case (HIGHER_EFLAT):
	   newValue = HIGHER_E;
	   break;
      }
    }
    // if it is already an accidental, the value will be returned
    // unchanged.
    if (newValue != 0)
      return newValue;
    else
      return noteValue;
  }

  // change F note to the accidental based on the accidental

  public int changeFNote (int noteVal, int accidental) {
    int noteValue = noteVal;
    int newValue = 0;
    int accType = accidental;

    // if accidental is sharp, the note will be changed to the sharp value
    if (accType == SHARP) {
      switch (noteValue) {
	 case (FFLAT):
	   newValue = F;
	   break;
	 case (F):
	   newValue = FSHARP;
	   break;
	 case (HIGH_FFLAT):
	   newValue = HIGH_F;
	   break;
	 case (HIGH_F):
	   newValue = HIGH_FSHARP;
	   break;
	 case (HIGHER_FFLAT):
	   newValue = HIGHER_F;
	   break;
	 case (HIGHER_F):
	   newValue = HIGHER_FSHARP;
	   break;
     }
    }
    // if accidental is flat, the note will be changed to the flat value
    else if (accType == FLAT) {
      switch (noteValue) {
	 case (F):
	   newValue = FFLAT;
	   break;
	 case (FSHARP):
	   newValue = F;
	   break;
	 case (HIGH_F):
	   newValue = HIGH_FFLAT;
	   break;
	 case (HIGH_FSHARP):
	   newValue = HIGH_F;
	   break;
	 case (HIGHER_F):
	   newValue = HIGHER_FFLAT;
	   break;
	 case (HIGHER_FSHARP):
	   newValue = HIGHER_F;
	   break;
      }
    }
    // if accidental is natural, note will be changed back to original value
    else if (accType == NATURAL) {
      switch (noteValue) {
	 case (FSHARP):
	 case (FFLAT):
	   newValue = F;
	   break;
	 case (HIGH_FSHARP):
	 case (HIGH_FFLAT):
	   newValue = HIGH_F;
	   break;
	 case (HIGHER_FSHARP):
	 case (HIGHER_FFLAT):
	   newValue = HIGHER_F;
	   break;
      }
    }
    // if it is already an accidental, the value will be returned
    // unchanged.
    if (newValue != 0)
      return newValue;
    else
      return noteValue;
  }

  // change G note to the accidental based on the accidental

  public int changeGNote (int noteVal, int accidental) {
    int noteValue = noteVal;
    int newValue = 0;
    int accType = accidental;

    // if accidental is sharp, the note will be changed to the sharp value
    if (accType == SHARP) {
      switch (noteValue) {
	 case (LOW_GFLAT):
	   newValue = LOW_G;
	   break;
	 case (LOW_G):
	   newValue = LOW_GSHARP;
	   break;
	 case (GFLAT):
	   newValue = G;
	   break;
	 case (G):
	   newValue = GSHARP;
	   break;
	 case (HIGH_G):
	   newValue = HIGH_GSHARP;
	   break;
	 case (HIGH_GFLAT):
	   newValue = HIGH_G;
	   break;
      }
    }
    // if accidental is flat, the note will be changed to the flat value
    else if (accType == FLAT) {
      switch (noteValue) {
	 case (LOW_G):
	   newValue = LOW_GFLAT;
	   break;
	 case (LOW_GSHARP):
	   newValue = LOW_G;
	   break;
	 case (G):
	   newValue = GFLAT;
	   break;
	 case (GSHARP):
	   newValue = G;
	   break;
	 case (HIGH_G):
	   newValue = HIGH_GFLAT;
	   break;
	 case (HIGH_GFLAT):
	   newValue = HIGH_G;
	   break;
      }
    }
    // if accidental is natural, note will be changed back to original value
    else if (accType == NATURAL) {
      switch (noteValue) {
	 case (LOW_GSHARP):
	 case (LOW_GFLAT):
	   newValue = LOW_G;
	   break;
	 case (GSHARP):
	 case (GFLAT):
	   newValue = G;
	   break;
	 case (HIGH_GSHARP):
	 case (HIGH_GFLAT):
	   newValue = HIGH_G;
	   break;
      }
    }
    // if it is already an accidental, the value will be returned unchanged
    if (newValue != 0)
      return newValue;
    else
      return noteValue;
  }

  // change a note to the accidental based on the accidental

  public int changeANote (int noteVal, int accidental) {
    int noteValue = noteVal;
    int newValue = 0;
    int accType = accidental;

    // if accidental is sharp, the note will be changed to the sharp value
    if (accType == SHARP) {
      switch (noteValue) {
	 case (LOW_AFLAT):
	   newValue = LOW_A;
	   break;
	 case (LOW_A):
	   newValue = LOW_ASHARP;
	   break;
	 case (AFLAT):
	   newValue = A;
	   break;
	 case (A):
	   newValue = ASHARP;
	   break;
	 case (HIGH_AFLAT):
	   newValue = HIGH_A;
	   break;
	 case (HIGH_A):
	   newValue = HIGH_ASHARP;
	   break;
      }
    }
    // if accidental is flat, the note will be changed to the flat value
    else if (accType == FLAT) {
      switch (noteValue) {
	 case (LOW_A):
	   newValue = LOW_AFLAT;
	   break;
	 case (LOW_ASHARP):
	   newValue = LOW_A;
	   break;
	 case (A):
	   newValue = AFLAT;
	   break;
	 case (ASHARP):
	   newValue = A;
	   break;
	 case (HIGH_A):
	   newValue = HIGH_AFLAT;
	   break;
	 case (HIGH_ASHARP):
	   newValue = HIGH_A;
	   break;
      }
    }
    // if accidental is natural, note will be changed back to original value
    else if (accType == NATURAL) {
      switch (noteValue) {
	 case (LOW_ASHARP):
	 case (LOW_AFLAT):
	   newValue = LOW_A;
	 case (ASHARP):
	 case (AFLAT):
	   newValue = A;
	   break;
	 case (HIGH_ASHARP):
	 case (HIGH_AFLAT):
	   newValue = HIGH_A;
	   break;
      }
    }
    // if it is already an accidental, the value will be returned
    // unchanged.
    if (newValue != 0)
      return newValue;
    else
      return noteValue;
  }

  // change B note to the accidental based on the accidental

  public int changeBNote (int noteVal, int accidental) {
    int noteValue = noteVal;
    int newValue = 0;
    int accType = accidental;

    // if accidental is sharp, the note will be changed to the sharp value
    if (accType == SHARP) {
      switch (noteValue) {
	 case (LOW_BFLAT):
	   newValue = LOW_B;
	   break;
	 case (LOW_B):
	   newValue = LOW_BSHARP;
	   break;
	 case (BFLAT):
	   newValue = B;
	   break;
	 case (B):
	   newValue = BSHARP;
	   break;
	 case (HIGH_BFLAT):
	   newValue = HIGH_B;
	   break;
	 case (HIGH_B):
	   newValue = HIGH_BSHARP;
	   break;
      }
    }
    // if accidental is flat, the note will be changed to the flat value
    else if (accType == FLAT) {
      switch (noteValue) {
	 case (LOW_B):
	   newValue = LOW_BFLAT;
	   break;
	 case (LOW_BSHARP):
	   newValue = LOW_B;
	   break;
	 case (B):
	   newValue = BFLAT;
	   break;
	 case (BSHARP):
	   newValue = B;
	   break;
	 case (HIGH_B):
	   newValue = HIGH_BFLAT;
	   break;
	 case (HIGH_BSHARP):
	   newValue = HIGH_B;
	   break;
      }
    }
    // if accidental is natural, note will be changed back to original value
    else if (accType == NATURAL) {
      switch (noteValue) {
	 case (LOW_BSHARP):
	 case (LOW_BFLAT):
	   newValue = LOW_B;
	   break;
	 case (BSHARP):
	 case (BFLAT):
	   newValue = B;
	   break;
	 case (HIGH_BSHARP):
	 case (HIGH_BFLAT):
	   newValue = HIGH_B;
	   break;
      }
    }
    // if it is already an accidental, the value will be returned
    // unchanged.
    if (newValue != 0)
      return newValue;
    else
      return noteValue;
  }

  // return true if is a C note, false otherwise

  public boolean checkCNote (int noteValue) {
    if (noteValue >= C && noteValue <= HIGHER_CSHARP)
      return true;
    else
      return false;
  }

  // return true if is a D note, false otherwise

  public boolean checkDNote (int noteValue) {
    if (noteValue >= D && noteValue <= HIGH_DSHARP)
      return true;
    else
      return false;
  }

  // return true if is a E note, false otherwise

  public boolean checkENote (int noteValue) {
    if (noteValue >= E && noteValue <= HIGH_ESHARP)
      return true;
    else
      return false;
  }

  // return true if is a F note, false otherwise

  public boolean checkFNote (int noteValue) {
    if (noteValue >= F && noteValue <= HIGH_FSHARP)
      return true;
    else
      return false;
  }

  // return true if is a G note, false otherwise

  public boolean checkGNote (int noteValue) {
    if (noteValue >= LOW_G && noteValue <= HIGH_GSHARP)
      return true;
    else
      return false;
  }

  // return true if is a A note, false otherwise

  public boolean checkANote (int noteValue) {
    if (noteValue >= LOW_A && noteValue <= HIGH_ASHARP)
      return true;
    else
      return false;
  }

  // return true if is a B note, false otherwise

  public boolean checkBNote (int noteValue) {
    if (noteValue >= LOW_B && noteValue <= HIGH_BSHARP)
      return true;
    else
      return false;
  }

  // opens score database for reading and wrting. A new pdb file will be
  // created if the pdb does not exist

  public void openCatalog () {
    scoreCat = new Catalog (CATALOG_NAME, Catalog.READ_WRITE);
    // create if pdb file does not exist.
    if (!scoreCat.isOpen ()) {
      scoreCat = new Catalog (CATALOG_NAME, Catalog.CREATE);
    }
    rs = new ResizeStream (scoreCat,512);
    ds = new DataStream (rs);
  }

  // close the score database file

  public void closeCatalog () {
    rs.close ();
    ds.close ();
  }

  // does the insertion of a new record in the pdb file

  public void insertRecord (String title, Object keySign, Vector vec) {
    String songInfo;
    String songTitle = title;
    Vector NotesVec = vec;
    String keySignature = (String)keySign;

    // check for title existent
    boolean ifExists = checkTitleExist (songTitle);

    // if it exists, delete the record
    if (ifExists) {
      scoreCat.setRecordPos (recordPos);
      scoreCat.deleteRecord ();
    }

    rs.startRecord ();

    // get the number of items in the vector array
    int notescount = NotesVec.getCount ();
    // formulate the string of information
    songInfo = songTitle+","+keySignature;
    for (int i=0; i<notescount; i++) {
      String notesInfo = (String)NotesVec.get (i);
      songInfo = songInfo+","+notesInfo;
    }
    // write the information to score database and end the record
    ds.writeString (songInfo);
    rs.endRecord ();
  }

  // goes through score database and check for the existent of title

  public boolean checkTitleExist (String title) {
    int numRecords;
    int i = 0;
    boolean result=false;
    String[] tmparray;
    String songTitle, keySignature;

    // get the number of item in score database
    numRecords = scoreCat.getRecordCount ();
    // go through all the records
    while (i < numRecords) {
      // set the record position
      scoreCat.setRecordPos (i);
      // retrieve the information
      String songInfo = ds.readString ();
      // put them in an array
      tmparray = Convert.tokenizeString (songInfo, ',');
      // get the song title
      songTitle = tmparray[0];
      // compare the song title with the title entered by user
      // if exists, break from loop and assign i to the record position
      if (songTitle.equalsIgnoreCase (title.trim ())) {
	 recordPos = i;
	 result =  true;
	 break;
      }
      // if not, go to the next record
      else {
	 i++;
      }
    }
    return result;
  }

  // loads the song from score database

  public Vector loadSong (String songTitle) {
    boolean isExist;
    MessageBox mb;
    Vector vec = new Vector ();
    String[] tmparray, tmparray1;

    // check for the existent of the song title
    isExist = checkTitleExist (songTitle);

    // if not exist, return an empty array
    if (!isExist) {
      return vec;
    }
    // if exist, retrieve the information
    else {
      // set the record position
      scoreCat.setRecordPos (recordPos);
      // retrieve the information
      String songInfo = ds.readString ();
      // store them in an array
      tmparray = Convert.tokenizeString (songInfo, ',');
      // set the key signature
      chordtut.keySignature = tmparray[1];
      Vm.debug ("key sign : " + chordtut.keySignature);
      // assign the notes to the vector
      for (int i = 2; i < tmparray.length; i++) {
	 vec.add (tmparray[i]);
      }
    }
    return vec;
    }
}
