################################### Header ###################################

# "dill.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with general macros (utility, circuit) and
# includes all other required macros.

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

############################## Included Macros ##############################

include(dill_adder.m4)
include(dill_adder_bb.m4)
include(dill_bit.m4)
include(dill_bitarray.m4)
include(dill_coder.m4)
include(dill_coder_wb.m4)
include(dill_comparator.m4)
include(dill_comparator_bb_wb.m4)
include(dill_counter.m4)
include(dill_counter_bb.m4)
include(dill_flipflop.m4)
include(dill_flipflop_bb.m4)
include(dill_gate.m4)
include(dill_gate_tri.m4)
include(dill_latch.m4)
include(dill_latch_bb_wb.m4)
include(dill_memory.m4)
include(dill_memory_bb.m4)
include(dill_multi.m4)
include(dill_parity.m4)
include(dill_parity_bb.m4)
include(dill_plexer.m4)
include(dill_plexer_bb_wb.m4)
include(dill_register.m4)
include(dill_register_bb.m4)

############################### General Macros ###############################

# "capitalise(string)" produces the same string with the first letter made
# upper case

define(capitalise,
  `translit(
    substr($1,0,1),
      abcdefghijklmnopqrstuvwxyz,ABCDEFGHIJKLMNOPQRSTUVWXYZ)`'substr($1,1)')

# "proc_of(string)" produces the name in a process instantiation

define(proc_of,
  `ifelse(len(`$1'),0,,
    `define(`char',substr(`$1',0,1))ifelse(char,` ',,
      `ifelse(char,`(',,
        `ifelse(char,`[',,
	  `char`'proc_of(substr(`$1',1))')')')')')

# "change_comm(param)" repeats its input with LOTOS comments changed into
# [* ... *]

define(change_comm,
  `define(comm_file,
    maketemp(/tmp/dillXXXXXX))syscmd(`cat > comm_file << "EOF"
$1
EOF')syscmd(`cp comm_file /tmp/temp2')syscmd(`sed -e s/\(\\*/[*/ -e s/\\*\)/*]/ < comm_file')')

# "declare(name,declaration)" generates "declaration" the first time that
# "name" is declared

define(declare,
  `ifdef(`$1ared',,`define($1ared)$2')')

# "decr(number)" produces the number less one - uncomment this if your
# version of m4 does not have a decrement macro

# define(decr,
#   `eval($1-1)')

# "Lib_Decl" invokes library type definitions

define(Lib_Decl,`
  library
    Boolean, NaturalNumber, Bit, DecDigit, DecString, DecNatRepr
  endlib')

# "circuit(parameters,behaviour)" generates a specification with given
# "parameters" and "behaviour"

define(circuit,`dnl
(*****************************************************************************

  Specification of proc_of($1) Circuit
  Generated by DILL on syscmd(date)
  The DILL specification was:
  
  `circuit'(
    changequote([,
      ])`changequote`$1'changequote([,
        ])',`changequote`'change_comm(`$2')`'changequote([,
	  ])  'changequote)
    
*****************************************************************************)

specification $1 : noexit
Lib_Decl
Bit_Decl
BitArray_Decl

  behaviour $2

endspec (* proc_of($1) *)
')
