################################### Header ###################################

# "dill_adder.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with adders (half, full, parallel,
# ripple-through).

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

################################### Adders ###################################

# HalfAdder_Decl" defines a half adder

define(HalfAdder_Decl,`declare(`$0',`Xor2_Decl`'And2_Decl
  process HalfAdder [A, B, S, C] : noexit :=
    Xor2 [A, B, S]
  |[A, B]|
    And2 [A, B, C]
  endproc (* HalfAdder *)
')')

# "FullAdder_Decl" defines a full adder

define(FullAdder_Decl,`declare(`$0',`Or2_Decl`'HalfAdder_Decl
  process FullAdder [A, B, Cin, S, Cout] : noexit :=
    hide Sint, Cint0, Cint1 in
      (
        HalfAdder [A, Sint, S, Cint0]
      |[Sint]|
        HalfAdder [B, Cin, Sint, Cint1]
      )
    |[Cint0, Cint1]|
      Or2 [Cint0, Cint1, Cout]
  endproc (* FullAdder *)
')')

# "ParallelAdder2_Decl" defines a two-stage parallel adder

define(ParallelAdder2_Decl,`declare(`$0',
  ``$0' is not yet in the macro library
')')

# "RippleAdder2_Decl" defines a two-bit ripple-through adder

define(RippleAdder2_Decl,`declare(`$0',`Zero_Decl`'FullAdder_Decl
  process RippleAdder2 [A1, A0, B1, B0, S1, S0, Cout] : noexit :=
    hide Cint0, Cint1 in
      (
        Zero [Cint0]
      |[Cint0]|
        FullAdder [A0, B0, Cint0, S0, Cint1]
      )
    |[Cint1]|
      FullAdder [A1, B1, Cint1, S1, Cout]
  endproc (* RippleAdder2 *)
')')

# RippleAdder4_Decl defines a 4-bit ripple adder

define(RippleAdder4_Decl,`declare(`$0',`FullAdder_Decl`'Zero_Decl
  process RippleAdder4 [MWire(4,`A,B'), C0, MWire(4,S),C4] : noexit :=
    hide MWire(3,C+) in
      MComp(4,C,`FullAdder [A, B, C, S, C+]')
    |[C0]|
      Zero [C0]
  endproc (* RippleAdder4 *)
')')

# "RippleAdder8_Decl" defines an 8-bit ripple adder with:
#    A0-A7, B0-B7 input data
#    C0 input carry
#    S0-S7 output data
#    C8 output carry

define(RippleAdder8_Decl, 
  `declare(`$0',`FullAdder_Decl`'Zero_Decl
  process RippleAdder8 [MWire(8,`A,B'),C0, MWire(8,S), C8] :noexit :=
    hide MWire(7,C+) in
      MComp(8,C,`FullAdder [A, B, C, S, C+]')
    |[C0]|
      Zero [C0]
  endproc (* RippleAdder8 *)
')')
