################################### Header ###################################

# "dill_adder_bb.m4"	Ji He, K. J. Turner	24/09/97

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with the black-box form of adders.

# Copyright 1997 Ji He, K. J. Turner, University of Stirling

################################### Adders ###################################

# HalfAdder_BB_Decl" defines a half adder

define(HalfAdder_BB_Decl, `declare(`$0', `
  process HalfAdder_BB [A, B, S, C] : noexit :=
    HalfAdder_BB_Aux [A, B, S, C] (X of bit, X of bit, X of bit, X of bit) 
 
    where
    process HalfAdder_BB_Aux [A, B, S, C] (dtA, dtB, dtS, dtC : Bit) : noexit :=
      A ? newdtA : Bit;
      HalfAdder_BB_Aux [A, B, S, C] (newdtA, dtB, dtS, dtC)
    []
      B ? newdtB : Bit;
      HalfAdder_BB_Aux [A, B, S, C] (dtA, newdtB, dtS, dtC)
    []
      (
        let newdtS: bit = dtA + dtB, newdtC: bit = carry(dtA , dtB) in
	(
	  [(newdtS eq X) and (dtS eq X)] ->
	    S ? newdtS : Bit [newdtS ne X];
	    HalfAdder_BB_Aux [A, B, S, C] (dtA, dtB, newdtS, dtC)
	[]
	  [(newdtC eq X) and (dtC eq X)] ->
	    C ? newdtC : Bit [newdtC ne X];
	    HalfAdder_BB_Aux [A, B, S, C] (dtA, dtb, dtS, newdtC)
	[]
	  [(newdtS ne X) and (newdtS ne dtS)] ->
	    S ! newdtS ;
	    HalfAdder_BB_Aux [A, B, S, C] (dtA, dtB, newdtS, dtC)
	[]
	  [(newdtC ne X) and (newdtC ne dtC)] ->
	    C ! newdtC ;
	    HalfAdder_BB_Aux [A, B, S, C] (dtA, dtb, dtS, newdtC)
	)
      )
    endproc (* HalfAdder_BB_Aux *)
  endproc (* HalfAdder_BB *)
')')

# "FullAdder_BB_Decl" defines a full adder

define(FullAdder_BB_Decl, `declare(`$0', `
  process FullAdder_BB [A, B, Cin, S, Cout] : noexit :=
    FullAdder_BB_Aux [A, B, Cin, S, Cout]
      (X of bit, X of bit, X of bit, X of bit, X of bit)

    where
    process FullAdder_BB_Aux [A, B, Cin, S, Cout]
	(dtA, dtB, dtCin, dtS, dtCout : Bit) : noexit :=
      A ? newdtA: Bit;
      FullAdder_BB_Aux [A, B, Cin, S, Cout] (newdtA, dtB, dtCin, dtS, dtCout)
    []
      B ? newdtB: Bit;
      FullAdder_BB_Aux [A, B, Cin, S, Cout] (dtA, newdtB, dtCin, dtS, dtCout)
    []
      Cin ? newdtCin: Bit;
      FullAdder_BB_Aux [A, B, Cin, S, Cout] (dtA, dtB, newdtCin, dtS, dtCout)
    []
      (
        let newdtS: Bit = sum(dtA, dtB, dtCin),
	    newdtCout: Bit = carry(dtA, dtB, dtCin) in
	  (
	    [(newdtS eq X) and (dtS eq X)] ->
	      S ? newdtS : Bit [newdtS ne X];
	      FullAdder_BB_Aux [A, B, Cin, S, Cout]
		(dtA, dtB, dtCin, newdtS, dtCout)
	  []
	    [(newdtCout eq X) and (dtCout eq X)] ->
	      Cout ? newdtCout : Bit [newdtCout ne X];
	      FullAdder_BB_Aux [A, B, Cin, S, Cout]
	        (dtA, dtB, dtCin, dtS, newdtCout)
	  []
	    [(newdtS ne X) and (newdtS ne dtS)] ->
	      S ! newdtS;
	      FullAdder_BB_Aux [A, B, Cin, S, Cout]
	        (dtA, dtB, dtCin, newdtS, dtCout)
	  []
	    [(newdtCout ne X) and (newdtCout ne dtCout)] ->
	      Cout ! newdtCout;
	      FullAdder_BB_Aux [A, B, Cin, S, Cout]
	        (dtA, dtB, dtCin, dtS, newdtCout)
	  )
      )
    endproc (* FullAdder_BB_Aux *)       
  endproc (* FullAdder_BB *)
')')

# "Adder2_BB_Decl" defines a two-bit adder

define(Adder2_BB_Decl, `declare(`$0', `
  process Adder2_BB [A1, A0, B1, B0, S1, S0, Cout] : noexit :=
    Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout] 
      (X of bit, X of bit, X of bit, X of bit, X of bit, X of bit, X of bit)
  
    where
    process Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
      (dtA1, dtA0, dtB1, dtB0, dtS1, dtS0, dtCout:Bit) : noexit :=
      A1 ? newdtA1 : Bit;
      Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
	(newdtA1, dtA0, dtB1, dtB0, dtS1, dtS0, dtCout)
    []
      A0 ? newdtA0 : Bit;
      Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
	(dtA1, newdtA0, dtB1, dtB0, dtS1, dtS0, dtCout)
    []
      B1 ? newdtB1 : Bit;
      Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
	(dtA1, dtA0, newdtB1, dtB0, dtS1, dtS0, dtCout)
    []
      B0 ? newdtB0 : Bit;
      Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
	(dtA1, dtA0, dtB1, newdtB0, dtS1, dtS0, dtCout)
    []
      (
        let newdtS0 : Bit = dtA0 + dtB0,          
	    newdtS1 : Bit =sum(dtA1, dtB1, carry(dtA0, dtB0)),
	    newdtCout: Bit = carry(dtA1, dtB1, carry(dtA0, dtB0)) in
	(
	  [(newdtS0 eq X) and (dtS0 eq X)] -> 
	    S0 ? newdtS0 : Bit [newdtS0 ne X];
	    Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
	      (dtA1, dtA0, dtB1, dtB0, dtS1, newdtS0, dtCout)
	[]
	  [(newdtS1 eq X) and (dtS1 eq X)] -> 
	    S1 ? newdtS1 : Bit [newdtS1 ne X];
	    Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
	      (dtA1, dtA0, dtB1, dtB0, newdtS1, dtS0, dtCout)
	[]
	  [(newdtCout eq X) and (dtCout eq X)] -> 
	    Cout ? newdtCout : Bit [newdtCout ne X];
	    Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
	      (dtA1, dtA0, dtB1, dtB0, dtS1, dtS0, newdtCout)
	[]
	  [(newdtS1 ne X) and (newdtS1 ne dtS1)] ->
	    S1 ! newdtS1;
	    Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
	    (dtA1, dtA0, dtB1, dtB0, newdtS1, dtS0, dtCout)
	[]
	  [(newdtS0 ne X) and (newdtS0 ne dtS0)] ->
	    S0 ! newdtS0;
	    Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
	      (dtA1, dtA0, dtB1, dtB0, dtS1, newdtS0, dtCout)
	[]
	  [(newdtCout ne X) and (newdtCOut ne dtCout)] ->
	    Cout ! newdtCout;
	    Adder2_BB_Aux [A1, A0, B1, B0, S1, S0, Cout]
	      (dtA1, dtA0, dtB1, dtB0, dtS1, dtS0, newdtCout)
	) (* end of let *)
      ) (* end of output *)
    endproc (* Adder2_BB_Aux *)
  endproc (* Adder2_BB *)
')')

# "Adder4_Decl" defines an adder with:
#    A0-A3, B0-B3 input data
#    C0 input carry
#    S0-S3 output data
#    C4 outpurt carry

define(Adder4_BB_Decl, `declare(`$0', `
  process Adder4_BB [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4] :noexit :=
    Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
                (bit(X)#X#X#X, bit(X)#X#X#X, X of bit, bit(X)#X#X#X, X of bit)

    where 
    process Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
      (dtA, dtB: BitArray, dtC0 : Bit, dtS: BitArray, dtC4 : Bit) : noexit :=
      A3 ? newdtA3: Bit;
      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
      (set(dtA, succ(succ(succ(0))), newdtA3), dtB, dtC0, dtS, dtC4)
    []
      A2 ? newdtA2: Bit;
      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
      (set(dtA, succ(succ(0)), newdtA2), dtB, dtC0, dtS, dtC4)
    []
      A1 ? newdtA1: Bit;
      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
      (set(dtA, succ(0), newdtA1), dtB, dtC0, dtS, dtC4)
    []
      A0 ? newdtA0: Bit;
      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
      (set(dtA, 0 of nat, newdtA0), dtB, dtC0, dtS, dtC4)
    []
      B3 ? newdtB3 : bit;
      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	(dtA, set(dtB, succ(succ(succ(0))), newdtB3), dtC0, dtS, dtC4)
    []
      B2 ? newdtB2 : bit;
      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	(dtA, set(dtB, succ(succ(0)), newdtB2), dtC0, dtS, dtC4)
    []
      B1 ? newdtB1 : bit;
      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	(dtA, set(dtB, succ(0), newdtB1), dtC0, dtS, dtC4)
    []
      B0 ? newdtB0 : bit;
      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	(dtA, set(dtB, 0 of nat, newdtB0), dtC0, dtS, dtC4)
    []
      C0 ? newdtC0: Bit;
      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	(dtA, dtB, newdtC0, dtS, dtC4)
    []
      (
        let newdtS : BitArray = (dtA + dtB) + dtC0,
	    newdtC4 : Bit =  carry(dtA, dtB) or carry((dtA + dtB), dtC0) in
	[(newdtS.succ(succ(succ(0))) eq X of bit) and  
	(dtS.succ(succ(succ(0))) eq X of bit)] -> 
	  S3 ? newdtS3 : Bit [newdtS3 ne X of bit];
	  Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	  (dtA, dtB, dtC0, set(dtS, succ(succ(succ(0))), newdtS3), dtC4)
      []
	[(newdtS.natnum(2) eq X of bit) and (dtS.natnum(2) eq X of bit)] -> 
	  S2 ? newdtS2 : Bit [newdtS2 ne X of bit];
	  Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	  (dtA, dtB, dtC0, set(dtS, succ(succ(0)), newdtS2), dtC4)
      []
	[(newdtS.succ(0) eq X of bit) and (dtS.succ(0) eq X of bit)] -> 
	  S1 ? newdtS1 : Bit [newdtS1 ne X of bit];
	  Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	  (dtA, dtB, dtC0, set(dtS, succ(0), newdtS1), dtC4)
      []
	[(newdtS.0 eq X of bit) and (dtS.0  eq X of bit)] -> 
	  S0 ? newdtS0 : Bit [newdtS0 ne X of bit];
	  Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	  (dtA, dtB, dtC0, set(dtS, 0 of nat, newdtS0), dtC4)
      []
	[(newdtC4 eq X of bit) and (dtC4 eq X of bit)] ->
	  C4 ? newdtC4: Bit [newdtC4 ne X of bit];
	  Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	  (dtA, dtB, dtC0, dtS, newdtC4)
      []
	[newdtS ne bit(X)] ->
	  (
	    [(newdtS.succ(succ(succ(0)))) ne (dtS.succ(succ(succ(0))))] ->
	      S3 !  newdtS.succ(succ(succ(0)));
	      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	       (dtA, dtB, dtC0, set(dtS, succ(succ(succ(0))),
		 newdtS.succ(succ(succ(0)))), dtC4)
	  []
	    [(newdtS.succ(succ(0))) ne (dtS.succ(succ(0)))] ->
	      S2 !  newdtS.succ(succ(0));
	      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	       (dtA, dtB, dtC0, set(dtS, succ(succ(0)), newdtS.succ(succ(0))), dtC4)
	  []
	    [(newdtS.succ(0)) ne (dtS.succ(0))] ->
	      S1 !  newdtS.succ(0);
	      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	       (dtA, dtB, dtC0, set(dtS, succ(0), newdtS.succ(0)) , dtC4)
	  []
	    [(newdtS.0 of nat) ne (dtS.0 of Nat)] ->
	      S0 !  newdtS.0 of Nat;
	      Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
	       (dtA, dtB, dtC0, set(dtS, 0 of nat, newdtS.0 of nat), dtC4)
	  )
      []
	[(newdtC4 ne dtC4) and (newdtC4 ne X)] ->
	    C4 ! newdtC4;
	    Adder4_BB_Aux [MWire(4, A), MWire(4, B), C0, MWire(4, S), C4]
		(dtA, dtB, dtC0, dtS, newdtC4)
      )
    endproc (* Adder4_BB_Aux *)
  endproc (* Adder4_BB *)')')

# AdderN_BB_Decl defines an adder with n-bits width.

define(AdderN_BB_Decl, `declare(`$0', `
  process AdderN_BB [A, B, Cin, S, Cout] : noexit :=
   AdderN_BB_Aux [A, B, Cin, S, Cout]
    (bit(X), bit(X), X of bit, bit(X), X of bit)

    where
    process AdderN_BB_Aux [A, B, Cin, S, Cout]
     (dtA, dtB: BitArray, dtCin: Bit, dtS:BitArray, dtCout : Bit) : noexit :=
      A ? newdtA: BitArray;
      AdderN_BB_Aux [A, B, Cin, S, Cout] (newdtA, dtB, dtCin, dtS, dtCout)
    []
      B ? newdtB: BitArray;
      AdderN_BB_Aux [A, B, Cin, S, Cout] (dtA, newdtB, dtCin, dtS, dtCout)
    []
      Cin ? newdtCin: Bit;
      AdderN_BB_Aux [A, B, Cin, S, Cout] (dtA, dtB, newdtCin, dtS, dtCout)
    []
      (
	let newdtS: BitArray =(dtA + dtB) + dtCin,
	    newdtCout: Bit = carry(dtA, dtB) + carry(dtA+dtB, dtCin) in
	(
	  [(newdtS eq bit(X)) and (dtS eq bit(X))] ->
	    S ? newdtS : BitArray [newdtS ne bit(X)];
	    AdderN_BB_Aux [A, B, Cin, S, Cout] (dtA, dtB, dtCin, newdtS, dtCout)
	[]
	  [(newdtCout eq X) and (dtCout eq X)] ->
	    Cout ? newdtCout : Bit [newdtCout ne X];
	    AdderN_BB_Aux [A, B, Cin, S, Cout] (dtA, dtB, dtCin, dtS, newdtCout)
	[]
	  [(newdtS ne bit(X)) and (newdtS ne dtS)] ->
	    S ! newdtS;
	    AdderN_BB_Aux [A, B, Cin, S, Cout] (dtA, dtB, dtCin, newdtS, dtCout)
	[]
	  [(newdtCout ne X) and (newdtCout ne dtCout)] ->
	    Cout ! newdtCout;
	    AdderN_BB_Aux [A, B, Cin, S, Cout] (dtA, dtB, dtCin, dtS, newdtCout)
	)
      )
    endproc (* AdderN_BB_Aux *)       
  endproc (* AdderN_BB *)
')')
