################################### Header ###################################

# "dill_bit.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach. Bit states (but not signals) may have an "X" (unknown)
# value - generally for their initial condition.
#
# This particular file deals with individual bits.

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

################################# Bits #################################

# "Bit_Decl" declares type definitions for bits

define(Bit_Decl,`
  type NaturalNumberX is NaturalNumber
    opns 
      X : -> Nat
    eqns
      forall n : Nat
	ofsort Nat
	  Succ (X)	= X;
	  n + X		= X;
	  X + n		= X;
	  n * X		= X;
	  X * n		= X;
	  n ** X	= X;
	  X ** n	= X;
	  
	ofsort Bool
	  0 eq X	= false;
	  0 ne X	= true;
	
	  X eq 0	= false;
	  X ne 0	= true;    
	  
	  X eq X	= true;
      
	  Succ (n) eq X	= false;
	  X eq Succ (n)	= false;
      
	  X lt 0	= false;
	  0 lt X	= false;
	  X lt X	= false;
	  X lt Succ (n)	= false;
	  Succ (n) lt X	= false;
      
	  X le 0	= false;
	  0 le X	= false;
	  X le X	= true;
	  X le Succ (n)	= false;
	  Succ (n) le X	= false;
      
	  X ge 0	= false;
	  0 ge X	= false;
	  X ge X	= true;
	  X ge Succ (n)	= false;
	  Succ (n) ge X	= false;
      
	  X gt 0	= false;
	  0 gt X	= false;
	  X gt X	= false;
	  X gt Succ (n)	= false;
	  Succ (n) gt X	= false;
  endtype (* NaturalNumberX *)
  
  type BitX is Bit, NaturalNumberX, Boolean
    opns
      X : -> Bit			(* unknown value - 0 or 1 *)
    eqns
      forall b1, b2 : Bit
	ofsort Bool			(* define (in)equality for X values *)
	  0 of Bit eq X of Bit	= false;
	  X of Bit eq 0 of Bit	= false;
	  X of Bit eq X of Bit	= true;
	  1 eq X of Bit		= false;
	  X of Bit eq 1		= false;
	  b1 ne b2		= not (b1 eq b2);
	ofsort Nat
	  NatNum (X of Bit)	= X of Nat;
  endtype (* BitX *)
    
  type BitOp0 is Boolean, NaturalNumber, BitX
    sorts BitOp
    opns
      same, not :					Bit		-> Bit
      _and_, _nand_, _or_, _nor_, _xor_, _xnor_ :	Bit, Bit	-> Bit
    eqns
      forall b, b1, b2 : Bit
	ofsort Bit
	  same (b)	= b;
	  
	  not (0)	= 1;
	  not (X)	= X;
	  not (1)	= 0;
	  
	  b and 0	= 0;
	  0 and X	= 0;
	  X and X	= X;
	  1 and X	= X;
	  b and 1	= b;
	  
	  b1 nand b2	= not (b1 and b2);
	  
	  b or 0	= b;
	  0 or X	= X;
	  X or X	= X;
	  1 or X	= 1;
	  b or 1	= 1;

	  b1 nor b2	= not (b1 or b2);

	  b xor 0	= b;
	  b xor X	= X;
	  b xor 1	= not (b);
	  
	  b1 xnor b2	= not (b1 xor b2);
  endtype (* BitOp0 *)

  type BitOp1 is BitOp0
    opns
      same, not :			-> BitOp
      Ord :		BitOp		-> Nat
      _eq_, _ne_ :	BitOp, BitOp	-> Bool
      IsUnary :		BitOp		-> Bool
      Apply :		BitOp, Bit	-> Bit
    eqns
      forall b : Bit, bop, bop1, bop2 : BitOp
	ofsort Nat
	  Ord (same)		= 0;
	  Ord (not)		= Succ (Ord (same));
	ofsort Bool
	  bop1 eq bop2		= Ord (bop1) eq Ord (bop2);
	  bop1 ne bop2		= Ord (bop1) ne Ord (bop2);
	  IsUnary (bop)		= Ord (bop) le Ord (not);
	ofsort Bit
	  not (IsUnary (bop)) =>
	    Apply (bop, b)	= X;	(* arbitrary error result *)
	  Apply (same, b)	= b;
	  Apply (not, b)	= not (b);
  endtype (* BitOp1 *)

  type BitOp2 is BitOp1
    opns
      and, nand, or, nor, xor, xnor :		-> BitOp
      Apply :			BitOp, Bit, Bit	-> Bit
    eqns
      forall b1, b2 : Bit, bop : BitOp
	ofsort Nat
	  Ord (and)		= Succ (Ord (not));
	  Ord (nand)		= Succ (Ord (and));
	  Ord (or)		= Succ (Ord (nand));
	  Ord (nor)		= Succ (Ord (or));
	  Ord (xor)		= Succ (Ord (nor));
          Ord (xnor)		= Succ (Ord (xor));
	ofsort Bit
	  IsUnary (bop) =>
	    Apply (bop, b1, b2)	= X;	(* arbitrary error result *)
	  Apply (and, b1, b2)	= b1 and b2;
	  Apply (nand, b1, b2)	= not (b1 and b2);
	  Apply (or, b1, b2)	= b1 or b2;
	  Apply (nor, b1, b2)	= not (b1 or b2);
	  Apply (xor, b1, b2)	= b1 xor b2;
          Apply (xnor, b1,b2)	= b1 xnor b2;
  endtype (* BitOp2 *)

  type BitOp3 is BitOp2
    opns
      Apply :	BitOp, Bit, Bit, Bit	-> Bit
    eqns
      forall b1, b2, b3 : Bit, bop : BitOp
	ofsort Bit
	  IsUnary (bop) =>
	    Apply (bop, b1, b2, b3)	= X;	(* arbitrary error result *)
	  Apply (and, b1, b2, b3)	= (b1 and b2) and b3;
	  Apply (nand, b1, b2, b3)	= not ((b1 and b2) and b3);
	  Apply (or, b1, b2, b3)	= (b1 or b2) or b3;
	  Apply (nor, b1, b2, b3)	= not ((b1 or b2) or b3);
	  Apply (xor, b1, b2, b3)	= (b1 xor b2) xor b3;
          Apply (xnor, b1, b2, b3)      = not((b1 xor b2) xor b3);
  endtype (* BitOp3 *)

  type BitOp4 is BitOp3
    opns
      Apply :	BitOp, Bit, Bit, Bit, Bit	-> Bit
    eqns
      forall b1, b2, b3, b4 : Bit, bop : BitOp
	ofsort Bit
	  IsUnary (bop) =>
	    Apply (bop, b1, b2, b3, b4)	= X;	(* arbitrary error result *)
	  Apply (and, b1, b2, b3, b4)	= ((b1 and b2) and b3) and b4;
	  Apply (nand, b1, b2, b3, b4)	= not (((b1 and b2) and b3) and b4);
	  Apply (or, b1, b2, b3, b4)	= ((b1 or b2) or b3) or b4;
	  Apply (nor, b1, b2, b3, b4)	= not (((b1 or b2) or b3) or b4);
	  Apply (xor, b1, b2, b3, b4)	= ((b1 xor b2) xor b3) xor b4;
          Apply (xnor, b1, b2, b3, b4)  = not(((b1 xor b2) xor b3) xor b4);
  endtype (* BitOp4 *)

  type BitOp8 is BitOp4
    opns
      Apply :	BitOp, Bit, Bit, Bit, Bit, Bit, Bit, Bit, Bit	-> Bit
    eqns
      forall b1, b2, b3 ,b4, b5, b6, b7, b8 : Bit, bop : BitOp
	ofsort Bit
	  IsUnary (bop) =>
	    Apply (bop, b1, b2, b3,b4, b5, b6, b7, b8)	= X;
						(* arbitrary error result *)
	  Apply (and, b1, b2, b3,b4, b5, b6, b7, b8)	= 
            ((((((b1 and b2) and b3) and b4) and b5) and b6) and b7) and b8;
	  Apply (nand, b1, b2, b3,b4, b5, b6, b7, b8)	= 
            not (((((((b1 and b2) and b3) and b4) and b5) and b6) and b7) and b8);
	  Apply (or, b1, b2, b3,b4, b5, b6, b7, b8)	= 
            ((((((b1 or b2) or b3) or b4) or b5) or b6) or b7) or b8;
	  Apply (nor, b1, b2, b3,b4, b5, b6, b7, b8)	= 
            not (((((((b1 or b2) or b3) or b4) or b5) or b6) or b7) or b8);
	  Apply (xor, b1, b2, b3,b4, b5, b6, b7, b8)	=
            ((((((b1 xor b2) xor b3) xor b4) xor b5) xor b6) xor b7) xor b8;
          Apply (xnor, b1, b2, b3, b4, b5, b6, b7, b8)  =
          not(((((((b1 xor b2) xor b3) xor b4) xor b5) xor b6) xor b7) xor b8);
  endtype (* BitOp8 *)

  type BitAdd is BitOp0
   opns 
     _+_ , carry :	Bit, Bit        -> Bit
     sum, carry :	Bit, Bit, Bit	-> Bit
   eqns
      forall b1, b2, b3 : Bit
      ofsort Bit

      b1 + b2			= b1 xor b2;
      carry (b1, b2)		= b1 and b2;
      sum (b1, b2, b3)		= (b1 + b2) + b3;
      carry (b1, b2, b3)	= carry (b1, b2) + carry (b1 + b2, b3);
  endtype (* BitAdd *)')
