################################### Header ###################################

# "dill_bitarray.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach. Bit states (but not signals) may have an "X" (unknown)
# value - generally for their initial condition.
#
# This particular file deals with arrays of Bits.

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

################################# Bits #################################

# "BitArray_Decl" declares type definitions for arrays Bits

define(BitArray_Decl,`
  type BitArray is BitX, NaturalNumberX, Boolean, BitOp0, BitAdd
    sorts BitArray
    opns
      <> :				-> BitArray
      Bit :	Bit			-> BitArray
      _ # _ :	BitArray, Bit		-> BitArray
      _ # _ :	Bit, BitArray		-> BitArray
      _ ## _ :	BitArray, BitArray	-> BitArray
      set :	BitArray, Nat, Bit	-> BitArray
      _ Add _ :	BitArray, BitArray	-> BitArray
      _ Add _ :	BitArray, Bit		-> BitArray
      _ + _ :	BitArray, BitArray	-> BitArray
      _ + _ :	BitArray, Bit		-> BitArray
      DectoBi :	Nat			-> BitArray
      expand  :	Nat, BitArray		-> BitArray
      tail :	BitArray		-> BitArray
      not :	BitArray		-> BitArray
      _ and _, _ or _, _ nand _, _ nor _, _ xor _ :
      		BitArray, BitArray -> BitArray
      length :	BitArray		-> Nat
      NatNum :	BitArray 		-> Nat
      Div :	Nat			-> Nat
      _ . _ :	BitArray, Nat		-> Bit
      carry :	BitArray, BitArray	-> Bit
      carry :	BitArray, Bit		-> Bit
      Mod :	Nat			-> Bit
      _ eq _, _ ne _, _ lt _ ,_ le _, _ ge _, _ gt _ :
      		BitArray, BitArray	-> Bool
    eqns
      forall a1, a2 : BitArray, y, z, b, b3, b2, b1, b0 : Bit, n : Nat 
	ofsort BitArray
	  y # <> =  Bit (y);
	  <> # y = Bit (y);
	  
	  a1 ## <> = a1;
	  <> ## a1 = a1;
	
	  y # Bit (z)			= Bit (y) # z ; 
	  a1 ## Bit (y)			= a1 # y;
	  a1 ## (a2 # z)		= (a1 ## a2) # z;
	
	  set (<>, n, b)		= <> ;
	  set (Bit (y), Succ (n), b)	= Bit (X);
	  set (Bit (y), 0, b)		= Bit (b);
	  set ((a1 # y), 0, b)		= a1 # b;
	  set ((a1 # y), Succ (n), b)	= set(a1,n,b) # y;
	
	  DectoBi (X of Nat)		= Bit (X of Bit);
	  DectoBi (0 of Nat)		= Bit (0 of Bit);
	  DectoBi (Succ (0))		= Bit (1); 
	
	  DectoBi (n) = DectoBi (Div (n)) ## Bit (Mod (n));
	  
	  length (a1) ge n =>
	    expand (n, a1)	= a1;
	  (length (a1) lt n) and (a1 ne Bit (X)) =>
	    expand(n, a1)	= expand(n,Bit (0) ## a1);
	  (length (a1) lt n) and (a1 eq Bit (X)) =>
	    expand(n,a1)	= expand(n,Bit (X) ## a1);
	
	  tail (Bit (b))	= <>;
	  tail (a1 # b)		= tail (a1) ## Bit (b);
	
	  length (a1) eq length (a2) => 
	    a1 Add a2	= expand (length (a1), DectoBi(NatNum (a1) + NatNum (a2)));
	  a1 Add y	= expand (length (a1),DectoBi(NatNum (a1) + NatNum (y)));
	
	  (length (a1) eq length (a2)) and (length (a1) eq length (a1 Add a2)) =>
	    a1 + a2 = a1 Add a2;
	  (length (a1) eq length (a1)) and (length (a1) lt length (a1 Add a2)) =>
	    a1 + a2 = tail (a1 Add a2) ;
	
	  length (a1) eq length (a1 Add y) =>
	    a1 + y = a1 Add y;
	  length (a1) lt length (a1 Add y) =>
	    a1 + y = tail (a1 Add y) ;
    
	  not (Bit (y)) = Bit (not (y));
	  not (a1 # y) = not (a1) # not (y);
	
	  Bit (y) and Bit (z) = Bit (y and z);
	  length (a1) eq length (a2) =>
	    (a1 # y) and (a2 # z) = (a1 and a2) # (y and z);
	
	  Bit (y) nand Bit (z) = Bit (y nand z);
	  length (a1) eq length (a2) =>
	    (a1 # y) nand (a2 # z) = (a1 nand a2) # (y nand z);
	  
	  Bit (y) or Bit (z) = Bit (y or z);
	  length (a1) eq length (a2) =>
	    (a1 # y) or (a2 # z) = (a1 or a2) # (y or z);
	
	  Bit (y) xor Bit (z) = Bit (y xor z);
	  length (a1) eq length (a2) =>
	    (a1 # y) xor (a2 # z) = (a1 xor a2) # (y xor z);
	
	  Bit (y) nor Bit (z) = Bit (y nor z);
	  length (a1) eq length (a2) =>
	    (a1 # y) nor (a2 # z) = (a1 nor a2) # (y nor z);
      
	ofsort Nat
	  length (<>) = 0;
	  length (Bit (y)) = Succ (0);
	  length (a1 # y) = Succ (length (a1));
	
	  NatNum (Bit (y)) = NatNum (y);
	  NatNum (a1 # y) = NatNum (a1) * Succ (Succ (0)) + NatNum (y);  
	
	  Div(X of Nat) = X of Nat;
	  Div(0 of Nat) = 0 of Nat;
	  Div(Succ (0)) = 0 of Nat;
	  Div(Succ (Succ (n))) = Succ (Div(n));
  
	ofsort Bit
	  <> . n = X;
	  Bit (y).Succ (n) = X;
	  Bit (y) . 0 = y ;
	  (a1 # y). 0 = y;
	  (a1 # y). Succ (n) = a1 . n;
	
	  Mod(X of Nat) = X of Bit; 
	  Mod(0 of Nat) = 0 of Bit;
	  Mod(Succ (0)) = 1 of Bit;
	  Mod(Succ (Succ (n))) = Mod(n);
	
	  (length (a1) eq length (a2)) and 
	  (length (a1 Add a2) gt length (a1)) =>
	    carry (a1,a2) = 1;
	  (length (a1) eq length (a2)) and 
	  (length (a1 Add a2) eq length (a1)) and ((a1 Add a2) ne Bit (X)) =>
	    carry (a1,a2) = 0 of Bit;
	  (length (a1) eq length (a2)) and 
	  (length (a1 Add a2) eq length (a1)) and ((a1 Add a2) eq Bit (X)) =>
	    carry (a1,a2) = X of Bit;
	
	  (length (a1 Add y ) gt length (a1))=>
	    carry (a1, y)	= 1;
	  (length (a1 Add y) eq length (a1)) and ((a1 Add y) ne Bit (X))=>
	    carry (a1,y)	=0;
	  (length (a1 Add y) eq length (a1)) and ((a1 Add y) eq Bit (X))=>
	    carry (a1,y)	=X of Bit;
    
	ofsort Bool
	  a1 eq a2 = NatNum (a1) eq NatNum (a2);
	  a1 ne a2 = NatNum (a1) ne NatNum (a2);
	  a1 lt a2 = NatNum (a1) lt NatNum (a2);
	  a1 le a2 = NatNum (a1) le NatNum (a2);
	  a1 ge a2 = NatNum (a1) ge NatNum (a2);
	  a1 gt a2 = NatNum (a1) gt NatNum (a2);
  endtype (* BitArray *)')
