################################### Header ###################################

# "dill_coder.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with coders (encoder, decoder, code converter).

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

################################### Coders ###################################

# "Decoder2to4_Decl" defines a 2-to-4 line decoder

define(Decoder2to4_Decl, `declare(`$0', `Inverter_Decl`'And2_Decl
  process Decoder2to4 [D1, D0, Q3, Q2, Q1, Q0] : noexit :=
    hide Dint0, Dint1 in
      (
	Inverter [D0, Dint0]
      |||
	Inverter [D1, Dint1]
      )
    |[D0, D1, Dint0, Dint1]|
      (
        And2 [Dint0, Dint1, Q0]
      |||
        And2 [D0, D1, Q3]
      )
    |[D0, D1, Dint0, Dint1]|
      (
        And2 [D0, Dint1, Q1]
      |||
        And2 [Dint0, D1, Q2]
      )
  endproc (* Decoder2to4 *)
')')

# "Decoder3To8_Decl" defines a 3-to-8 line decoder
 
define(Decoder3To8_Decl, `declare(`$0', `And3_Decl`'Inverter_Decl
  process Decoder3To8 [MWire(3, D), MWire(8, Y)] : noexit:=
     hide MWire(3, InD) in
       (MComp(3, `Inverter[D, InD]'))
    |[D2, D1, D0, InD2, InD1, InD0]|
       (And3 [D2, D1, D0, Y7] ||| And3 [InD2, InD1, InD0, Y0] )
    |[D2, D1, D0, InD2, InD1, InD0]|
       (And3 [D2, D1, InD0, Y6] ||| And3 [InD2, InD1, D0, Y1] )
    |[D2, D1, D0, InD2, InD1, InD0]|
       (And3 [D2, InD1, D0, Y5] ||| And3 [InD2, D1, InD0, Y2] )
    |[D2, D1, D0, InD2, InD1, InD0]|
       (And3 [D2, InD1, InD0, Y4] ||| And3 [InD2, D1, D0, Y3] )
  endproc (* Decoder3To8 *)
')')

# "BCDtoDec_Decl" defines a BCD-to-Decimal decoder

define(BCDtoDec_Decl, `declare(`$0', `Nand4_Decl`'Inverter_Decl
  process BCDtoDec [MWire(4, D), MWire(10, Y)] : noexit:=
    hide  MWire(4, InD), MWire(10, Ybar) in
      MComp(4, `Inverter[D, InD]')
   |[MWire(4, `D, InD')]|
      (
	((((((((Nand4 [InD3, InD2, InD1, InD0, Y0]	|[InD3, InD2, InD1]|
	Nand4 [InD3, InD2, InD1, D0, Y1])		|[InD3, InD2, InD0]|
	Nand4 [InD3, InD2, D1, InD0, Y2])		|[InD3, InD2, D1, D0]|
	Nand4 [InD3, InD2, D1, D0, Y3])			|[InD3, InD1, InD0]|
	Nand4 [InD3, D2, InD1, InD0, Y4])		|[InD3, D2, InD1, D0]|
	Nand4 [InD3, D2 , InD1, D0, Y5])		|[InD3, D2, D1, InD0]|
	Nand4 [InD3, D2, D1, InD0, Y6])			|[InD3, D2, D1, D0]|
	Nand4 [InD3, D2, D1, D0, Y7])			|[InD2, InD1, InD0]|
	Nand4 [D3, InD2, InD1, InD0, Y8])		|[D3, InD2, InD1, D0]| 
	Nand4 [D3, InD2, InD1, D0, Y9]
      )
  endproc (* BCDtoDec *)
')')

# "Excess3toDec_Decl" defines a decoder changing excess-3 to decimal

define(Excess3toDec_Decl, `declare(`$0', `Nand4_Decl`'Inverter_Decl
  process Excess3toDec [MWire(4, D), MWire(10, Y)] : noexit:=
    hide MWire(4, InD), MWire(10, Ybar) in
      MComp(4, `Inverter[D, InD]')
   |[MWire(4, `D, InD')]|
      (
	((((((((Nand4 [InD3, InD2, D1, D0, Y0]	|[InD3]|
	Nand4 [InD3, D2, InD1, InD0, Y1])	|[InD3, D2, InD1, InD0]|
	Nand4 [InD3, D2, InD1, InD0, Y2])	|[InD3, D2, D1, InD0]|
	Nand4 [InD3, D2, D1, InD0, Y3])		|[InD3, D2, D1, D0]|
	Nand4 [InD3, D2, D1, D0, Y4])		|[InD2, InD1, InD0]|
	Nand4 [D3, InD2, InD1, InD0, Y5])	|[D3, InD2, InD1, D0]|
	Nand4 [D3, InD2, InD1, D0, Y6])		|[D3, InD2, D1, InD0]|
	Nand4 [D3, InD2, D1, InD0, Y7])		|[D3, InD2, D1, D0]|
	Nand4 [D3, InD2, D1, D0, Y8])		|[D3, D2, InD1, InD0]| 
	Nand4 [D3, D2, InD1, InD0, Y9]
      )
  endproc (* Excess3toDec *)
')')      

# "Excess3GrtoDec_Decl" defines a decoder changing excess-3 Gray to decimal
# All outputs are high for invalid input conditions

define(Excess3GrtoDec_Decl, `declare(`$0', `Nand4_Decl`'Inverter_Decl
  process Excess3GrtoDec[MWire(4, D), MWire(10, Y)] : noexit:=
    hide  MWire(4, InD), MWire(10, Ybar) in
      MComp(4, `Inverter[D, InD]')
   |[MWire(4, `D, InD')]|
      (
	((((((((Nand4 [InD3, InD2, D1, InD0, Y0]	|[InD3, D1, InD0]|
	Nand4 [InD3, D2, D1, InD0, Y1])			|[InD3, D2, D1]|
	Nand4 [InD3, D2, D1, D0, Y2])			|[InD3, D2, D0]|
	Nand4 [InD3, D2, InD1, D0, Y3])			|[InD3, D2, InD1, InD0]|
	Nand4 [InD3, D2, InD1, InD0, Y4])		|[D2, InD1, InD0]|
	Nand4 [D3, D2  , InD1, InD0, Y5])		|[D3, D2, InD1, D0]|
	Nand4 [D3, D2, InD1, D0, Y6])			|[D3, D2, D1, D0]|
	Nand4 [D3, D2, D1, D0, Y7])			|[D3, D2, D1, InD0]|
	Nand4 [D3, D2, D1, InD0, Y8])			|[D3, InD2, D1, InD0]| 
	Nand4 [D3, InD2, D1, InD0, Y9]
      )
  endproc (* Excess3GrtoDec *)
')')      

# "Encoder4to2_Decl" defines a two-bit encoder

define(Encoder4to2_Decl, `declare(`$0', `Sink_Decl`'Or2_Decl
  process Encoder4to2 [D3, D2, D1, D0, Q1, Q0] : noexit :=
    Sink [D0]
  |||
    (
      Or2 [D1, D3, Q0]
    |[D3]|
      Or2 [D2, D3, Q1]
    )
  endproc (* Encoder4to2 *)
')')
