################################### Header ###################################

# "dill_coder_wb.m4"	Ji He, K. J. Turner 	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with the white-box form of coders (encoder,
# decoder, code converter).

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

################################### Coders ###################################

# "Decoder2_WB_Decl" defines a 2-to-4 line decoder

# "Decoder2_WB_One_Decl" : the outputs is 1 active.

define(Decoder2_WB_One_Decl, `declare(`$0', `Decoder2_WB_Decl
  process Decoder2_WB_One [D1, D0, Q3, Q2, Q1, Q0] : noexit :=
   Decoder2_WB [D1, D0, Q3, Q2, Q1, Q0] (1 of bit)
  endproc (* Decoder2_WB_One *)
')')

# "Decoder2_WB_Zero_Decl" : the outputs is 0 active.

define(Decoder2_WB_Zero_Decl, `declare(`$0', `Decoder2_WB_Decl
  process Decoder2_WB_Zero [D1, D0, Q3, Q2, Q1, Q0] : noexit :=
   Decoder2_WB [D1, D0, Q3, Q2, Q1, Q0 ] (0 of bit)
  endproc (* Decoder2_WB_Zero *)
')')

define(Decoder2_WB_Decl, `declare(`$0', `
  process Decoder2_WB [D1, D0, Q3, Q2, Q1, Q0] (level: Bit) : noexit :=
    Decoder2_WB_Aux [D1, D0, Q3, Q2, Q1, Q0] 
     (level, X of bit, X of bit, X of bit, X of bit, X of bit, X of bit)

    where

    process Decoder2_WB_Aux [D1, D0, Q3, Q2, Q1, Q0]
     (Level, D1Curr, D0Curr, Q3Curr, Q2Curr, Q1Curr, Q0Curr : Bit) : noexit :=
      D1 ? D1New: Bit;
      Decoder2_WB_Aux [D1, D0, Q3, Q2, Q1, Q0]
       (Level, D1New, D0Curr, Q3Curr, Q2Curr, Q1Curr, Q0Curr)
    []
      D0 ? D0New: Bit;
      Decoder2_WB_Aux [D1, D0, Q3, Q2, Q1, Q0]
       (level, D1Curr, D0New , Q3Curr, Q2Curr, Q1Curr, Q0Curr)
    []
     ( let Q0new : bit = not ( ((not (D0Curr) and not (D1Curr))) xor level),
           Q1new : bit = not ( ((D0Curr and not (D1Curr))) xor level),
           Q2new : bit = not ( ((not (D0Curr) and D1Curr)) xor level),
           Q3new : bit = not ( (D0Curr and D1Curr) xor level) in
     ( ([(Q0Curr eq X) and (Q0new eq X)] -> 
        Q0 ? Q0new: Bit [Q0new ne X of bit]; 
        Decoder2_WB_Aux [D1, D0, Q3, Q2, Q1, Q0]
          (level, D1Curr, D0Curr , Q3Curr, Q2Curr, Q1Curr, Q0new)
      []
       [(Q0new ne X) and (Q0new  ne Q0Curr)]-> 
        Q0 ! Q0new  ;
        Decoder2_WB_Aux [ D1, D0, Q3, Q2, Q1, Q0]
          (level, D1Curr, D0Curr , Q3Curr, Q2Curr, Q1Curr, Q0new) 
       )
    []
     ([(Q1Curr eq X) and (Q1new eq X)] ->
        Q1 ? Q1new: Bit [Q1new ne X of bit]; 
        Decoder2_WB_Aux [  D1, D0, Q3, Q2, Q1, Q0]
          (level, D1Curr, D0Curr , Q3Curr , Q2Curr, Q1new , Q0Curr  )
      []
      [(Q1new ne X) and (Q1new ne Q1Curr)] ->
      Q1 ! Q1new ;
      Decoder2_WB_Aux [D1, D0, Q3, Q2, Q1, Q0]
       (level, D1Curr, D0Curr , Q3Curr , Q2Curr, Q1new , Q0Curr)
      )
    []
     ([(Q2Curr eq X) and (Q2new eq X)] ->
        Q2 ? Q2new: Bit [Q2new ne X of bit]; 
        Decoder2_WB_Aux [ D1, D0, Q3, Q2, Q1, Q0]
          (level, D1Curr, D0Curr , Q3Curr , Q2new , Q1Curr, Q0Curr)
      []
      [(Q2new ne X) and (Q2new ne Q2Curr)] ->
      Q2 ! Q2new ;
      Decoder2_WB_Aux [D1, D0, Q3, Q2, Q1, Q0]
       (level, D1Curr, D0Curr , Q3Curr , Q2new , Q1Curr, Q0Curr )
      )
    []
     ([(Q3Curr eq X) and (Q3new eq X)] ->
        Q3 ? Q3new: Bit [Q3new ne X of bit]; 
        Decoder2_WB_Aux [D1, D0, Q3, Q2, Q1, Q0]
          (level, D1Curr, D0Curr , Q3new, Q2Curr, Q1Curr, Q0Curr  )
      []
      [(Q3New ne X) and (Q3new ne Q3Curr)] -> 
      Q3 ! Q3new ;
      Decoder2_WB_Aux [ D1, D0, Q3, Q2, Q1, Q0]
       (level, D1Curr, D0Curr, Q3new, Q2Curr, Q1Curr, Q0Curr)
      )
     )
    )
    endproc (* Decoder2_WB_Aux *)
  endproc (* Decoder2_WB *)
')')

# "Decoder3To8_WB_Decl" defines a 3-to-8 line decoder
# "Decoder3To8_WB_One_Decl" : the outputs are 1 active
# "Decoder3To8_WB_Zero_Decl" : the outputs are 0 active

define(Decoder3To8_WB_One_Decl, `declare(`$0', `Decoder3To8_WB_Decl
  process Decoder3To8_WB_One [MWire(3, D), MWire(8, Y)] :noexit :=
   Decoder3To8_WB [MWire(3, D), MWire(8, Y)] (1 of bit)
  endproc (* Decoder3To8_WB_One *)
')')

define(Decoder3To8_WB_Zero_Decl, `declare(`$0', `Decoder3To8_WB_Decl
  process Decoder3To8_WB_Zero [MWire(3, D), MWire(8, Y)] :noexit :=
    Decoder3To8_WB [MWire(3, D), MWire(8, Y)] (0 of bit)
  endproc (* Decoder3To8_WB_Zero *)
')')
   
define(Decoder3To8_WB_Decl, `declare(`$0', `
  process Decoder3To8_WB [MWire(3, D), MWire(8, Y)] (level: Bit) : noexit:=
    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
     (level, MWire(3, X of bit=), MWire(8, X of bit=))

    where
    
    process Decoder3To8_WB_Aux[MWire(3, D), MWire(8, Y)]
     (level, MWire(3, dtD), MWire(8, dtY):Bit) :noexit :=
      D2 ? newdtD2: Bit;
      Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)] 
	 (level, newdtD2, dtD1, dtD0, MWire(8, dtY))
    []
      D1 ? newdtD1: Bit;
      Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)] 
	 (level, dtD2, newdtD1, dtD0, MWire(8, dtY))
    []
      D0 ? newdtD0: Bit;
      Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)] 
      (level, dtD2, dtD1, newdtD0, MWire(8, dtY))
    []
      (
        let newdtY0 :Bit =
	 not (( (not (dtD2) and not (dtD1) and not (dtD0)) xor level)),
	  newdtY1 :Bit = not (( (not (dtD2) and not (dtD1) and dtD0) xor level)),
	  newdtY2 :Bit = not (( (not (dtD2) and dtD1 and not (dtD0)) xor level)),
	  newdtY3 :Bit = not (( (not (dtD2) and dtD1 and dtD0) xor level)),
	  newdtY4 :Bit = not ((dtD2 and not (dtD1) and not (dtD0)) xor level),
	  newdtY5 :Bit = not ((dtD2 and not (dtD1) and dtD0) xor level),
	  newdtY6 :Bit = not ((dtD2 and dtD1 and not (dtD0)) xor level),
	  newdtY7 :Bit = not ((dtD2 and dtD1 and dtD0) xor level) in
	 (
	  [(newdtY0 eq X) and (dtY0 eq X)] -> 
	    Y0 ? newdtY0 :Bit [newdtY0 ne X];
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, dtY6, dtY5, dtY4, dtY3, dtY2, dtY1, newdtY0)
	[]
	  [(newdtY0 ne X) and (dtY0 ne newdtY0)] ->
	    Y0 ! newdtY0;
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, dtY6, dtY5, dtY4, dtY3, dtY2, dtY1, newdtY0)
	[]
	  [(newdtY1 eq X) and (dtY1 eq X)] ->
	    Y1 ? newdtY1 :Bit [newdtY1 ne X];
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, dtY6, dtY5, dtY4, dtY3, dtY2, newdtY1, dtY0)
	[]
	  [(newdtY1 ne X) and (dtY1 ne newdtY1)] ->
	    Y1 ! newdtY1;
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, dtY6, dtY5, dtY4, dtY3, dtY2, newdtY1, dtY0)
	[]
	  [(newdtY2 eq X) and (dtY2 eq X)] ->
	    Y2 ? newdtY2 :Bit [newdtY2 ne X];
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	    (level, MWire(3, dtD), dtY7, dtY6, dtY5, dtY4, dtY3, newdtY2, dtY1, dtY0)
	[]
	  [(newdtY2 ne X) and (dtY2 ne newdtY2)] ->
	    Y2 ! newdtY2;
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, dtY6, dtY5, dtY4, dtY3, newdtY2, dtY1, dtY0)
	[]
	  [(newdtY3 eq X) and (dtY3 eq X)] ->
	    Y3 ? newdtY3 :Bit [newdtY3 ne X];
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	      (level, MWire(3, dtD), dtY7, dtY6, dtY5, dtY4, newdtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY3 ne X) and (dtY3 ne newdtY3)] ->
	    Y3 ! newdtY3;
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, dtY6, dtY5, dtY4, newdtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY4 eq X) and (dtY4 eq X)] ->
	    Y4 ? newdtY4 :Bit [newdtY4 ne X];
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, dtY6, dtY5, newdtY4, dtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY4 ne X) and (dtY4 ne newdtY4)] ->
	    Y4 ! newdtY4;
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, dtY6, dtY5, newdtY4, dtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY5 eq X) and (dtY5 eq X)] ->
	    Y5 ? newdtY5 :Bit [newdtY5 ne X];
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, dtY6, newdtY5, dtY4, dtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY5 ne X) and (dtY5 ne newdtY5)] ->
	    Y5 ! newdtY5;
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, dtY6, newdtY5, dtY4, dtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY6 eq X) and (dtY6 eq X)] ->
	    Y6 ? newdtY6 :Bit [newdtY6 ne X];
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), dtY7, newdtY6, dtY5, dtY4, dtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY6 ne X) and (dtY6 ne newdtY6)] ->
	    Y6 ! newdtY6;
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	    (level, MWire(3, dtD), dtY7, newdtY6, dtY5, dtY4, dtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY7 eq X) and (dtY7 eq X)] ->
	    Y7 ? newdtY7 :Bit [newdtY7 ne X];
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), newdtY7, dtY6, dtY5, dtY4, dtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY7 ne X) and (dtY7 ne newdtY7)] ->
	    Y7 ! newdtY7;
	    Decoder3To8_WB_Aux [MWire(3, D), MWire(8, Y)]
	     (level, MWire(3, dtD), newdtY7, dtY6, dtY5, dtY4, dtY3, dtY2, dtY1, dtY0)
	)
      )
    endproc (* Decoder3To8_WB_Aux *)
  endproc (* decoder3To8_WB *)
')')

# "BCDtoDec_WB_Decl" defines a BCD-to-Decimal decoder
# "BCDtoDec_WB_One_Decl" : outputs are 1 active
# "BCDtoDec_WB_Zero_Decl": outputs are 0 active

define(BCDtoDec_WB_One_Decl, `declare(`$0', `BCDtoDec_WB_Decl
  process BCDtoDec_WB_One [MWire(4, D), MWire(10, Y)] :noexit :=
    BCDtoDec_WB[MWire(4, D), MWire(10, Y)] (1 of bit)
  endproc (*BCDtoDec_WB_One *)
')')

define(BCDtoDec_WB_Zero_Decl, `declare(`$0', `BCDtoDec_WB_Decl
  process BCDtoDec_WB_Zero [MWire(4, D), MWire(10, Y)] :noexit :=
    BCDtoDec_WB[MWire(4, D), MWire(10, Y)] (0 of bit)
  endproc (*BCDtoDec_WB_Zero *)
')')

define(BCDtoDec_WB_Decl, `declare(`$0', `
  process BCDtoDec_WB[MWire(4, D), MWire(10, Y)] (level:Bit): noexit:=
    BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
     (level, MWire(4, X of bit=), MWire(10, X of bit=))
  
    where 
    
    process  BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
     (level, MWire(4, dtD), MWire(10, dtY):Bit) :noexit :=
      D3 ? newdtD3 :Bit;
      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
       (level, newdtD3, dtD2, dtD1, dtD0, MWire(10, dtY))
    []
      D2 ? newdtD2 :Bit;
      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)]
       (level, dtD3, newdtD2, dtD1, dtD0, MWire(10, dtY))
    []
      D1 ? newdtD1 :Bit;
      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
       (level, dtD3, dtD2, newdtD1, dtD0, MWire(10, dtY))
    []
      D0 ? newdtD0 :Bit;
      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
       (level, dtD3, dtD2, dtD1, newdtD0, MWire(10, dtY))
    []
      (
        let newdtY0 : Bit = not ((not (dtD3) and not (dtD2) and not (dtD1) 
				and not (dtD0)) xor level),
	    newdtY1 : Bit = not ((not (dtD3) and not (dtD2) and not (dtD1) 
				and dtD0) xor level),
	    newdtY2 : Bit = not ((not (dtD3) and not (dtD2) and dtD1 
				and not (dtD0)) xor level),
	    newdtY3 : Bit = not ((not (dtD3) and not (dtD2) and dtD1 
				and dtD0) xor level),
	    newdtY4 : Bit = not ((not (dtD3) and dtD2 and not (dtD1) 
				and not (dtD0)) xor level),
	    newdtY5 : Bit = not ((not (dtD3) and dtD2 and not (dtD1) 
				  and dtD0) xor level),
	    newdtY6 : Bit = not ((not (dtD3) and dtD2 and dtD1 
				and not (dtD0)) xor level),
	    newdtY7 : Bit = not ((not (dtD3) and dtD2 and dtD1 and dtD0)
	                        xor level),
	    newdtY8 : Bit = not ((dtD3 and not (dtD2) and not (dtD1) 
				and not (dtD0)) xor level),
	    newdtY9 : Bit = not ((dtD3 and not (dtD2) and not (dtD1) and dtD0)
				xor level) in
	  (
	    [(newdtY0 eq X) and (dtY0 eq X)] ->
	      Y0 ? newdtY0 : Bit [newdtY0 ne X];
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), MWire(9, dtY+), newdtY0)
	  []
	    [(newdtY0 ne X) and (newdtY0 ne dtY0)] ->
	      Y0 ! newdtY0;
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), MWire(9, dtY+), newdtY0)
	  []
	    [(newdtY1 eq X) and (dtY1 eq X)] ->
	      Y1 ? newdtY1 : Bit [newdtY1 ne X];
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), MWire(8, dtY++), newdtY1, dtY0)
	  []
	    [(newdtY1 ne X) and (newdtY1 ne dtY1)] ->
	      Y1 ! newdtY1;
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), MWire(8, dtY++), newdtY1, dtY0)
	  []
	    [(newdtY2 eq X) and (dtY2 eq X)] ->
	      Y2 ? newdtY2 : Bit [newdtY2 ne X];
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), MWire(7, dtY+++), newdtY2, dtY1, dtY0)
	  []
	    [(newdtY2 ne X) and (newdtY2 ne dtY2)] ->
	      Y2 ! newdtY2;
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), MWire(7, dtY+++), newdtY2, dtY1, dtY0)
	  []
	    [(newdtY3 eq X) and (dtY3 eq X)] ->
	      Y3 ? newdtY3 : Bit [newdtY3 ne X];
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), MWire(6, dtY++++), newdtY3, dtY2, dtY1, dtY0)
	  []
	    [(newdtY3 ne X) and (newdtY3 ne dtY3)] ->
	      Y3 ! newdtY3;
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), MWire(6, dtY++++), newdtY3, dtY2, dtY1, dtY0)
	  []
	    [(newdtY4 eq X) and (dtY4 eq X)] ->
	      Y4 ? newdtY4 : Bit [newdtY4 ne X];
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
		 (level, MWire(4, dtD), MWire(5, dtY+++++), newdtY4, dtY3, dtY2, dtY1, dtY0)
	  []
	    [(newdtY4 ne X) and (newdtY4 ne dtY4)] ->
	      Y4 ! newdtY4;
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
		 (level, MWire(4, dtD), MWire(5, dtY+++++), newdtY4, dtY3, dtY2, dtY1, dtY0)
	  []
	    [(newdtY5 eq X) and (dtY5 eq X)] ->
	      Y5 ? newdtY5 : Bit [newdtY5 ne X];
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), dtY9, dtY8, dtY7, dtY6, newdtY5, MWire(5, dtY))
	  []
	    [(newdtY5 ne X) and (newdtY5 ne dtY5)] ->
	      Y5 ! newdtY5;
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), dtY9, dtY8, dtY7, dtY6, newdtY5, MWire(5, dtY))
	  []
	    [(newdtY6 eq X) and (dtY6 eq X)] ->
	      Y6 ? newdtY6 : Bit [newdtY6 ne X];
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), dtY9, dtY8, dtY7, newdtY6, MWire(6, dtY))
	  []
	    [(newdtY6 ne X) and (newdtY6 ne dtY6)] ->
	      Y6 ! newdtY6;
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), dtY9, dtY8, dtY7, newdtY6, MWire(6, dtY))
	  []
	    [(newdtY7 eq X) and (dtY7 eq X)] ->
	      Y7 ? newdtY7 : Bit [newdtY7 ne X];
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), dtY9, dtY8, newdtY7, MWire(7, dtY))
	  []
	    [(newdtY7 ne X) and (newdtY7 ne dtY7)] ->
	      Y7 ! newdtY7;
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), dtY9, dtY8, newdtY7, MWire(7, dtY))
	  []
	    [(newdtY8 eq X) and (dtY8 eq X)] ->
	      Y8 ? newdtY8 : Bit [newdtY8 ne X];
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), dtY9, newdtY8, MWire(8, dtY))
	  []
	    [(newdtY8 ne X) and (newdtY8 ne dtY8)] ->
	      Y8 ! newdtY8;
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), dtY9, newdtY8, MWire(8, dtY))
	  []
	    [(newdtY9 eq X) and (dtY9 eq X)] ->
	      Y9 ? newdtY9 : Bit [newdtY9 ne X];
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), newdtY9, MWire(9, dtY))
	  []
	    [(newdtY9 ne X) and (newdtY9 ne dtY9)] ->
	      Y9 ! newdtY9;
	      BCDtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	       (level, MWire(4, dtD), newdtY9, MWire(9, dtY))
	  )
	)
    endproc (* BCDtoDec_WB_Aux *)
  endproc (* BCDtoDec_WB *)
')')

# "Excess3toDec_WB_Decl" defines a decoder changeing excess-3 to Decimal
# "Excess3toDec_WB_One_Decl" : outputs are 1 active
# "Excess3toDec_WB_Zero_Decl": outputs are 0 active

define(Excess3toDec_WB_One_Decl, `declare(`$0', `Excess3toDec_WB_Decl
  process Excess3toDec_WB_One [MWire(4, D), MWire(10, Y)] : noexit:=
    Excess3toDec_WB[MWire(4, D), MWire(10, Y)] (1 of bit)
  endproc (* Excess3toDec_WB_One *)
')')

define(Excess3toDec_WB_Zero_Decl, `declare(`$0', `Excess3toDec_WB_Decl
  process Excess3toDec_WB_Zero [MWire(4, D), MWire(10, Y)] : noexit:=
    Excess3toDec_WB[MWire(4, D), MWire(10, Y)] (0 of bit)
  endproc (* Excess3toDec_WB_Zero *)
')')

define(Excess3toDec_WB_Decl, `declare(`$0', `
  process Excess3toDec_WB[MWire(4, D), MWire(10, Y)] (level : Bit) : noexit:=
    Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
     (level, MWire(4, X of bit=), MWire(10, X of bit=))

  where
  
  process Excess3toDec_WB_Aux[MWire(4, D), MWire(10, Y)] 
   (level, MWire(4, dtD), MWire(10, dtY):Bit):noexit:=
    D3 ? newdtD3 :Bit;
    Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
     (level, newdtD3, dtD2, dtD1, dtD0, MWire(10, dtY))
  []
    D2 ? newdtD2 :Bit;
    Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
     (level, dtD3, newdtD2, dtD1, dtD0, MWire(10, dtY))
  []
    D1 ? newdtD1 :Bit;
    Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)]
     (level, dtD3, dtD2, newdtD1, dtD0, MWire(10, dtY))
  []
    D0 ? newdtD0 :Bit;
    Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
     (level, dtD3, dtD2, dtD1, newdtD0, MWire(10, dtY))
  []
    (
      let newdtY0 : Bit = not ((not (dtD3) and not (dtD2) 
                              and dtD1 and dtD0) xor level),
         newdtY1 : Bit = not ((not (dtD3) and dtD2 
                             and not (dtD1) and not (dtD0)) xor level),
         newdtY2 : Bit = not ((not (dtD3) and dtD2 
                              and not (dtD1) and dtD0) xor level),
         newdtY3 : Bit = not ((not (dtD3) and dtD2 
                              and dtD1 and not (dtD0)) xor level),
         newdtY4 : Bit = not ((not (dtD3) and dtD2 
                              and dtD1 and dtD0) xor level),
         newdtY5 : Bit = not ((dtD3 and not (dtD2) 
                              and not (dtD1) and not (dtD0)) xor level),
         newdtY6 : Bit = not ((dtD3 and not (dtD2) 
                              and not (dtD1) and dtD0) xor level),
         newdtY7 : Bit = not ((dtD3 and not (dtD2) 
                              and dtD1 and not (dtD0)) xor level),
         newdtY8 : Bit = not ((dtD3 and not (dtD2) 
                              and dtD1 and dtD0) xor level),
         newdtY9 : Bit = not ((dtD3 and dtD2 and not (dtD1)
                              and not (dtD0)) xor level) in
    (
      [(newdtY0 eq X) and (dtY0 eq X)] ->
        Y0 ? newdtY0 : Bit [newdtY0 ne X];
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), MWire(9, dtY+), newdtY0)
    []
      [(newdtY0 ne X) and (newdtY0 ne dtY0)] ->
        Y0 ! newdtY0;
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), MWire(9, dtY+), newdtY0)
    []
      [(newdtY1 eq X) and (dtY1 eq X)] ->
        Y1 ? newdtY1 : Bit [newdtY1 ne X];
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), MWire(8, dtY++), newdtY1, dtY0)
    []
      [(newdtY1 ne X) and (newdtY1 ne dtY1)] ->
        Y1 ! newdtY1;
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), MWire(8, dtY++), newdtY1, dtY0)
    []
      [(newdtY2 eq X) and (dtY2 eq X)] ->
        Y2 ? newdtY2 : Bit [newdtY2 ne X];
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), MWire(7, dtY+++), newdtY2, dtY1, dtY0)
    []
      [(newdtY2 ne X) and (newdtY2 ne dtY2)] ->
        Y2 ! newdtY2;
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), MWire(7, dtY+++), newdtY2, dtY1, dtY0)
    []
      [(newdtY3 eq X) and (dtY3 eq X)] ->
        Y3 ? newdtY3 : Bit [newdtY3 ne X];
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), MWire(6, dtY++++), newdtY3, dtY2, dtY1, dtY0)
    []
      [(newdtY3 ne X) and (newdtY3 ne dtY3)] ->
        Y3 ! newdtY3;
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), MWire(6, dtY++++), newdtY3, dtY2, dtY1, dtY0)
    []
      [(newdtY4 eq X) and (dtY4 eq X)] ->
        Y4 ? newdtY4 : Bit [newdtY4 ne X];
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), MWire(5, dtY+++++), newdtY4, dtY3, dtY2, dtY1, dtY0)
    []
      [(newdtY4 ne X) and (newdtY4 ne dtY4)] ->
        Y4 ! newdtY4;
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), MWire(5, dtY+++++), newdtY4, dtY3, dtY2, dtY1, dtY0)
    []
      [(newdtY5 eq X) and (dtY5 eq X)] ->
        Y5 ? newdtY5 : Bit [newdtY5 ne X];
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), dtY9, dtY8, dtY7, dtY6, newdtY5, MWire(5, dtY))
    []
      [(newdtY5 ne X) and (newdtY5 ne dtY5)] ->
        Y5 ! newdtY5;
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), dtY9, dtY8, dtY7, dtY6, newdtY5, MWire(5, dtY))
    []
      [(newdtY6 eq X) and (dtY6 eq X)] ->
        Y6 ? newdtY6 : Bit [newdtY6 ne X];
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), dtY9, dtY8, dtY7, newdtY6, MWire(6, dtY))
    []
      [(newdtY6 ne X) and (newdtY6 ne dtY6)] ->
        Y6 ! newdtY6;
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), dtY9, dtY8, dtY7, newdtY6, MWire(6, dtY))
    []
      [(newdtY7 eq X) and (dtY7 eq X)] ->
        Y7 ? newdtY7 : Bit [newdtY7 ne X];
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), dtY9, dtY8, newdtY7, MWire(7, dtY))
    []
      [(newdtY7 ne X) and (newdtY7 ne dtY7)] ->
        Y7 ! newdtY7;
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), dtY9, dtY8, newdtY7, MWire(7, dtY))
    []
      [(newdtY8 eq X) and (dtY8 eq X)] ->
        Y8 ? newdtY8 : Bit [newdtY8 ne X];
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), dtY9, newdtY8, MWire(8, dtY))
    []
      [(newdtY8 ne X) and (newdtY8 ne dtY8)] ->
        Y8 ! newdtY8;
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), dtY9, newdtY8, MWire(8, dtY))
    []
      [(newdtY9 eq X) and (dtY9 eq X)] ->
        Y9 ? newdtY9 : Bit [newdtY9 ne X];
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), newdtY9, MWire(9, dtY))
    []
      [(newdtY9 ne X) and (newdtY9 ne dtY9)] ->
        Y9 ! newdtY9;
        Excess3toDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
         (level, MWire(4, dtD), newdtY9, MWire(9, dtY))
       )
      )
    endproc (* Excess3toDec_WB_Aux *)
  endproc (* Excess3toDec_WB *)
')')      

# "Excess3GrtoDec_WB_Decl" defines a decoder changeing excess-3 Gray to Decimal
# "Excess3GrtoDec_WB_One_Decl" : outputs are 1 active
# "Excess3GrtoDec_WB_Zero_Decl": outputs are 0 active

define(Excess3GrtoDec_WB_One_Decl, `declare(`$0', `Excess3GrtoDec_WB_Decl
  process Excess3GrtoDec_WB_One [MWire(4, D), MWire(10, Y)] : noexit:=
    Excess3GrtoDec_WB[MWire(4, D), MWire(10, Y)] (1 of bit)
  endproc (* Excess3GrtoDec_WB_One *)
')')

define(Excess3GrtoDec_WB_Zero_Decl, `declare(`$0', `Excess3GrtoDec_WB_Decl
  process Excess3GrtoDec_WB_Zero [MWire(4, D), MWire(10, Y)] : noexit:=
    Excess3GrtoDec_WB[MWire(4, D), MWire(10, Y)] (0 of bit)
  endproc (* Excess3GrtoDec_WB_Zero *)
')')

define(Excess3GrtoDec_WB_Decl, `declare(`$0', `
  process Excess3GrtoDec_WB[MWire(4, D), MWire(10, Y)] (level : Bit) : noexit:=
    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
      (level, MWire(4, X of bit=), MWire(10, X of bit=))

    where
    
    process Excess3GrtoDec_WB_Aux[MWire(4, D), MWire(10, Y)] 
      (level, MWire(4, dtD), MWire(10, dtY):Bit):noexit:=
      D3 ? newdtD3 :Bit;
      Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	(level, newdtD3, dtD2, dtD1, dtD0, MWire(10, dtY))
    []
      D2 ? newdtD2 :Bit;
      Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)]
	(level, dtD3, newdtD2, dtD1, dtD0, MWire(10, dtY))
    []
      D1 ? newdtD1 :Bit;
      Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)]
	(level, dtD3, dtD2, newdtD1, dtD0, MWire(10, dtY))
    []
      D0 ? newdtD0 :Bit;
      Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)]
	(level, dtD3, dtD2, dtD1, newdtD0, MWire(10, dtY))
    []
      (
	let newdtY0 : Bit = not ((not (dtD3) and not (dtD2) 
				and dtD1 and not (dtD0)) xor level),
	    newdtY1 : Bit = not ((not (dtD3) and dtD2 
				and dtD1 and not (dtD0)) xor level),
	    newdtY2 : Bit = not ((not (dtD3) and dtD2 
				and dtD1 and dtD0) xor level),
	    newdtY3 : Bit = not ((not (dtD3) and dtD2 
				and not (dtD1) and dtD0) xor level),
	    newdtY4 : Bit = not ((not (dtD3) and dtD2 
				and not (dtD1) and not (dtD0)) xor level),
	    newdtY5 : Bit = not ((dtD3 and dtD2 
				and not (dtD1) and not (dtD0)) xor level),
	    newdtY6 : Bit = not ((dtD3 and dtD2 
				and not (dtD1) and dtD0) xor level),
	    newdtY7 : Bit = not ((dtD3 and dtD2 
				and dtD1 and dtD0) xor level),
	    newdtY8 : Bit = not ((dtD3 and dtD2 
				and dtD1 and not (dtD0)) xor level),
	    newdtY9 : Bit = not ((dtD3 and not (dtD2)
				and dtD1 and not (dtD0)) xor level) in
	(
	  [(newdtY0 eq X) and (dtY0 eq X)] ->
	    Y0 ? newdtY0 : Bit [newdtY0 ne X];
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), MWire(9, dtY+), newdtY0)
	[]
	  [(newdtY0 ne X) and (newdtY0 ne dtY0)] ->
	    Y0 ! newdtY0;
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), MWire(9, dtY+), newdtY0)
	[]
	  [(newdtY1 eq X) and (dtY1 eq X)] ->
	    Y1 ? newdtY1 : Bit [newdtY1 ne X];
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), MWire(8, dtY++), newdtY1, dtY0)
	[]
	  [(newdtY1 ne X) and (newdtY1 ne dtY1)] ->
	    Y1 ! newdtY1;
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), MWire(8, dtY++), newdtY1, dtY0)
	[]
	  [(newdtY2 eq X) and (dtY2 eq X)] ->
	    Y2 ? newdtY2 : Bit [newdtY2 ne X];
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), MWire(7, dtY+++), newdtY2, dtY1, dtY0)
	[]
	  [(newdtY2 ne X) and (newdtY2 ne dtY2)] ->
	    Y2 ! newdtY2;
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), MWire(7, dtY+++), newdtY2, dtY1, dtY0)
	[]
	  [(newdtY3 eq X) and (dtY3 eq X)] ->
	    Y3 ? newdtY3 : Bit [newdtY3 ne X];
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), MWire(6, dtY++++), newdtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY3 ne X) and (newdtY3 ne dtY3)] ->
	    Y3 ! newdtY3;
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), MWire(6, dtY++++), newdtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY4 eq X) and (dtY4 eq X)] ->
	    Y4 ? newdtY4 : Bit [newdtY4 ne X];
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), MWire(5, dtY+++++), newdtY4, dtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY4 ne X) and (newdtY4 ne dtY4)] ->
	    Y4 ! newdtY4;
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), MWire(5, dtY+++++), newdtY4, dtY3, dtY2, dtY1, dtY0)
	[]
	  [(newdtY5 eq X) and (dtY5 eq X)] ->
	    Y5 ? newdtY5 : Bit [newdtY5 ne X];
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), dtY9, dtY8, dtY7, dtY6, newdtY5, MWire(5, dtY))
	[]
	  [(newdtY5 ne X) and (newdtY5 ne dtY5)] ->
	    Y5 ! newdtY5;
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), dtY9, dtY8, dtY7, dtY6, newdtY5, MWire(5, dtY))
	[]
	  [(newdtY6 eq X) and (dtY6 eq X)] ->
	    Y6 ? newdtY6 : Bit [newdtY6 ne X];
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), dtY9, dtY8, dtY7, newdtY6, MWire(6, dtY))
	[]
	  [(newdtY6 ne X) and (newdtY6 ne dtY6)] ->
	    Y6 ! newdtY6;
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), dtY9, dtY8, dtY7, newdtY6, MWire(6, dtY))
	[]
	  [(newdtY7 eq X) and (dtY7 eq X)] ->
	    Y7 ? newdtY7 : Bit [newdtY7 ne X];
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), dtY9, dtY8, newdtY7, MWire(7, dtY))
	[]
	  [(newdtY7 ne X) and (newdtY7 ne dtY7)] ->
	    Y7 ! newdtY7;
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), dtY9, dtY8, newdtY7, MWire(7, dtY))
	[]
	  [(newdtY8 eq X) and (dtY8 eq X)] ->
	    Y8 ? newdtY8 : Bit [newdtY8 ne X];
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), dtY9, newdtY8, MWire(8, dtY))
	[]
	  [(newdtY8 ne X) and (newdtY8 ne dtY8)] ->
	    Y8 ! newdtY8;
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), dtY9, newdtY8, MWire(8, dtY))
	[]
	  [(newdtY9 eq X) and (dtY9 eq X)] ->
	    Y9 ? newdtY9 : Bit [newdtY9 ne X];
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), newdtY9, MWire(9, dtY))
	[]
	  [(newdtY9 ne X) and (newdtY9 ne dtY9)] ->
	    Y9 ! newdtY9;
	    Excess3GrtoDec_WB_Aux [MWire(4, D), MWire(10, Y)] 
	      (level, MWire(4, dtD), newdtY9, MWire(9, dtY))
	)
      )
    endproc (* Excess3GrtoDec_WB_Aux *)
  endproc (* Excess3GrtoDec_WB *)
')')      

# "Encoder4to2_WB_Decl" defines a two-bit encoder
# "Encoder4to2_WB_One_Decl" : inputs are 1 active
# "Encoder4to2_WB_Zero_Decl": inputs are 0 active

define(Encoder4to2_WB_One_Decl, `declare(`$0', `Encoder4to2_WB_Decl
  process Encoder4to2_WB_One [D3, D2, D1, D0, Q1, Q0] : noexit:=
    Encoder4to2_WB[D3, D2, D1, D0, Q1, Q0] (1 of bit)
  endproc (* Encoder4to2_WB_One *)
')')

define(Encoder4to2_WB_Zero_Decl, `declare(`$0', `Encoder4to2_WB_Decl
  process Encoder4to2_WB_Zero [D3, D2, D1, D0, Q1, Q0] : noexit:=
    Encoder4to2_WB[D3, D2, D1, D0, Q1, Q0] (0 of bit)
  endproc (* Encoder4to2_WB_Zero *)
')')

define(Encoder4to2_WB_Decl, `declare(`$0', `
  process Encoder4to2_WB[D3, D2, D1, D0, Q1, Q0] (level : Bit) : noexit:=
    Encoder4to2_WB_Aux [D3, D2, D1, D0, Q1, Q0]
     (level, X of bit, X of bit, X of bit, X of bit, X of bit, X of bit)
  
    where
    
    process Encoder4to2_WB_Aux [D3, D2, D1, D0, Q1, Q0] 
     (level, dtD3, dtD2, dtD1, dtD0, dtQ1, dtQ0: Bit ) :noexit:=
      D3 ? newdtD3 :Bit;
      Encoder4to2_WB_Aux [D3, D2, D1, D0, Q1, Q0] 
        (level, newdtD3, dtD2, dtD1, dtD0, dtQ1, dtQ0)
    []
      D2 ? newdtD2 :Bit;
      Encoder4to2_WB_Aux [D3, D2, D1, D0, Q1, Q0]
        (level, dtD3, newdtD2, dtD1, dtD0, dtQ1, dtQ0)
    []
      D1 ? newdtD1 :Bit;
      Encoder4to2_WB_Aux [D3, D2, D1, D0, Q1, Q0] 
        (level, dtD3, dtD2, newdtD1, dtD0, dtQ1, dtQ0)
    []
      D0 ? newdtD0 :Bit;
      Encoder4to2_WB_Aux [D3, D2, D1, D0, Q1, Q0] 
        (level, dtD3, dtD2, dtD1, newdtD0, dtQ1, dtQ0)
    []
      (
      let newdtQ1 : Bit = not (dtD3 xor level) or not (dtD2 xor level),
	  newdtQ0 : Bit = not (dtD3 xor level) or not (dtD1 xor level) in
        (
	  [(newdtQ1 eq X) and (dtQ1 eq X)] ->
	    Q1 ? newdtQ1 : Bit [newdtQ1 ne X];
	    Encoder4to2_WB_Aux [D3, D2, D1, D0, Q1, Q0]
	     (level, dtD3, dtD2, dtD1, dtD0, newdtQ1, dtQ0)
	[]
	  [(newdtQ1 ne X) and (newdtQ1 ne dtQ1)] ->
	    Q1 ! newdtQ1;
	    Encoder4to2_WB_Aux [D3, D2, D1, D0, Q1, Q0] 
	     (level, dtD3, dtD2, dtD1, dtD0, newdtQ1, dtQ0)
	[]
	  [(newdtQ0 eq X) and (dtQ0 eq X)] ->
	    Q0 ? newdtQ0 : Bit [newdtQ0 ne X] ;
	    Encoder4to2_WB_Aux [D3, D2, D1, D0, Q1, Q0] 
	     (level, dtD3, dtD2, dtD1, dtD0, dtQ1, newdtQ0)
	[]
	  [(newdtQ0 ne X) and (newdtQ0 ne dtQ0)] ->
	    Q0 ! newdtQ0;
	    Encoder4to2_WB_Aux [D3, D2, D1, D0, Q1, Q0] 
	     (level, dtD3, dtD2, dtD1, dtD0, dtQ1, newdtQ0)
        )
      )
    endproc (* Encoder4to2_WB_Aux *)
  endproc (* Encoder4to2_WB *)
')')
