################################### Header ###################################

# "dill_comparator.m4"	Ji He, K. J. Turner 	24/09/97

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with comparators.

# Copyright 1997 Ji He, K. J. Turner, University of Stirling

##############################################################################

# "Comparator1_Decl" defines a 1 bit comparator, it is the cell from which
#  multi-bit comparators build:
# 
#    Ai, Bi: the i_th compared bits
#    Xi, Yi: compared result of i+1_th bits 
#    Xi=Yi=0: equal  ; Xi=1, Yi=0 : A < B ; Xi=0 Yi=1 A > B
#    Ap, Bp: compared result of i_th bits

define(Comparator1_Decl, `declare(`$0', `Nand3_Decl`'Nand2_Decl`'Inverter_Decl
  process Comparator1 [Ai, Bi, Xi, Yi, Ap, Bp] :noexit :=
    hide inx, InY, InA, InB, a3, b3 in
      (
        Inverter [Xi, inx] ||| Inverter [Yi, InY] 
      |||
        Inverter [Ai, InA] ||| Inverter [Bi, InB]
      )
    |[Xi, Yi, InA, InB, inx, InY]|
     (
       (Nand3 [inx, Yi, InB, a3] |[a3]| Nand2 [a3, InA, Ap]) 
     |[InA, InB]|
       (Nand3 [Xi, InY, InA, b3] |[b3]| Nand2 [b3, InB, Bp])
     )
   endproc (* Comparator1 *)
')')

# "Comparator4_Decl" defines a 4 bit comparator
 
define(Comparator4_Decl, `declare(`$0', `Comparator1_Decl
  process Comparator4 [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] :noexit :=
    hide MWire(3, `Ls+, Gr+') in
      MComp(4, `Ls, Gr', `Comparator1 [Ls+, Gr+, X, Y, Ls, Gr]')
  endproc (* Comparator4 *)
')')

# "Comparator8_Decl" defines a 8 bits comparator

define(Comparator8_Decl, `declare(`$0', `Comparator4_Decl`'Zero_Decl
  process Comparator8 [Ls8, Gr8, MWire(8, `X, Y'), Ls0, Gr0] :noexit :=
    hide Ls4, Gr4 in
      (Zero[Ls8] ||| Zero[Gr8]) 
    |[Ls8, Gr8]|
      Comparator4 [Ls8, Gr8, MWire(4, `X+++, Y+++'), Ls4, Gr4]
    |[Ls4, Gr4]|
      Comparator4 [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0]
  endproc (* Comparator8 *)
')')
