################################### Header ###################################

# "dill_comparator_bb_wb.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach. Bit states (but not signals) may have an "X" (unknown)
# value - generally for their initial condition.
#
# This particular file deals with the white-box form of comparators.

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

##############################################################################

# "Comparator1_WB_Decl" defines a 1 bit comparator, it is the cell from which
#  multibits comparators are built:
#
#    Xi, Yi: the i_th compared bits
#    Ai, Bi: compared result of i+1_th bits 
#    Ai=Bi=0: equal  ; Ai=1, Bi=0 : X < Y ; Ai=0 Bi=1 X > Y
#    Ap, Bp: compared result of i_th bits
#    Ap=Bp=0 : equal; Ap=1, Bp=0: Xi<Yi; Ap=0 Bp=1:Xi>Yi

define(Comparator1_WB_Decl, `declare(`$0',`
  process Comparator1_WB [Ai, Bi, Xi, Yi, Ap, Bp] :noexit :=
    Comparator1_WB_Aux [Ai, Bi, Xi, Yi, Ap, Bp] 
     (X of bit, X of bit, X of bit, X of bit, X of bit, X of bit)
  
    where
    
    process Comparator1_WB_Aux [Ai, Bi, Xi, Yi, Ap, Bp] 
     (dtAi, dtBi, dtXi, dtYi, dtAp, dtBp:Bit) : noexit :=
      Ai ? newdtAi: Bit;
      Comparator1_WB_Aux [Ai, Bi, Xi, Yi, Ap, Bp]
       (newdtAi, dtBi, dtXi, dtYi, dtAp, dtBp)
    []
      Bi ? newdtBi: Bit;
      Comparator1_WB_Aux [Ai, Bi, Xi, Yi, Ap, Bp]
       (dtAi, newdtBi, dtXi, dtYi, dtAp, dtBp)
    []
      Xi ? newdtXi: Bit;
      Comparator1_WB_Aux [Ai, Bi, Xi, Yi, Ap, Bp]
       (dtAi, dtBi, newdtXi, dtYi, dtAp, dtBp)
    []
      Yi ? newdtYi: Bit;
      Comparator1_WB_Aux [Ai, Bi, Xi, Yi, Ap, Bp]
       (dtAi, dtBi, dtXi, newdtYi, dtAp, dtBp)
    []
      (
        let newdtAp : Bit = dtAi or (not(dtXi) and dtYi and not(dtBi)), 
	    newdtBp : Bit = dtBi or (dtXi and not(dtYi) and not(dtAi)) in
	(
	  [(newdtAp eq X of bit) and (dtAp eq X of bit)] ->
	    Ap ? newdtAp: Bit[newdtAp ne X];
	    Comparator1_WB_Aux [Ai, Bi, Xi, Yi, Ap, Bp]
	     (dtAi, dtBi, dtXi, dtYi, newdtAp, dtBp)
	[]
	  [(newdtAp ne X of bit) and (newdtAp ne dtAp)] ->
	    Ap ! newdtAp ;
	    Comparator1_WB_Aux [Ai, Bi, Xi, Yi, Ap, Bp]
	     (dtAi, dtBi, dtXi, dtYi, newdtAp, dtBp)
	[]
	  [(newdtBp eq X of bit) and (dtBp eq X of bit)] ->
	    Bp ? newdtBp: Bit[newdtBp ne X];
	    Comparator1_WB_Aux [Ai, Bi, Xi, Yi, Ap, Bp]
	     (dtAi, dtBi, dtXi, dtYi, dtAp, newdtBp)
	[]
	  [(newdtBp ne X of bit) and (newdtBp ne dtBp)] ->
	    Bp ! newdtBp ;
	    Comparator1_WB_Aux [Ai, Bi, Xi, Yi, Ap, Bp]
	     (dtAi, dtBi, dtXi, dtYi, dtAp, newdtBp)
	)
      )
    endproc (* Comparator1_WB_Aux *)
 endproc (* Comparator1_WB*)
')')

# "Comparator4_BB_Decl" defines a 4 bit comparator
 
define(Comparator4_BB_Decl, `declare(`$0', `
  process Comparator4_BB[Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] :noexit :=
    Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
     (X of bit, X of bit, bit(X)#X#X#X, bit(X)#X#X#X, X of bit, X of bit)

    where
    
    process  Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
     (dtLs4, dtGr4: bit, dtX, dtY: bitarray, dtLs0, dtGr0 : Bit ) : noexit :=
      Ls4 ? newdtLs4 : Bit;
      Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
       (newdtLs4, dtGr4, dtX, dtY, dtLs0, dtGr0)
    []
      Gr4 ? newdtGr4 : Bit;
      Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
	(dtLs4, newdtGr4, dtX, dtY, dtLs0, dtGr0)
    []
      X3 ? newdtX3 : Bit;
      Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
	(dtLs4, dtGr4, set(dtX, natnum(3 of DecDigit), newdtX3), dtY, dtLs0, dtGr0)
    []
      Y3 ? newdtY3 : Bit;
      Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
	(dtLs4, dtGr4, dtX, set(dtY, natnum(3 of DecDigit), newdtY3), dtLs0, dtGr0)
    []
      X2 ? newdtX2 : Bit;
      Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
	(dtLs4, dtGr4, set(dtX, natnum(2 of Decdigit), newdtX2), dtY, dtLs0, dtGr0)
    [] 
      Y2 ? newdtY2 : Bit;
      Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
	(dtLs4, dtGr4, dtX, set(dtY, natnum(2 of Decdigit), newdtY2), dtLs0, dtGr0)
    []
      X1 ? newdtX1 : Bit;
      Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
	(dtLs4, dtGr4, set(dtX, natnum(1 of decdigit), newdtX1), dtY, dtLs0, dtGr0)
    []
      Y1 ? newdtY1 : Bit;
      Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
	(dtLs4, dtGr4, dtX, set(dtY, natnum(1 of decdigit), newdtY1), dtLs0, dtGr0)
    []
      X0 ? newdtX0 : Bit;
      Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
	(dtLs4, dtGr4, set(dtX, 0 of nat, newdtX0), dtY, dtLs0, dtGr0)
    []
      Y0 ? newdtY0 : Bit;
      Comparator4_BB_Aux [Ls4, Gr4, MWire(4, `X, Y'), Ls0, Gr0] 
	(dtLs4, dtGr4, dtX, set(dtY, 0 of nat, newdtY0), dtLs0, dtGr0)
    []
      (
        let newdtLs0 : Bit = dtLs4, 
	    newdtGr0 : Bit = dtGr4 in
	(
	  [(newdtLs0 xor newdtGr0) eq 1 of bit] ->
	    (
	      [newdtLs0 ne dtLs0] ->
		Ls0 ! newdtLs0;
		Comparator4_BB_Aux
		 [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
		  (dtLs4, dtGr4, dtX, dtY, newdtLs0, dtGr0)
	    []
	      [newdtGr0 ne dtGr0] ->
		Gr0 ! newdtGr0;
		Comparator4_BB_Aux
		 [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
		  (dtLs4, dtGr4, dtX, dtY, dtLs0, newdtGr0)
	    )
	[]
	  [(newdtLs0 eq 0 of bit) and (newdtGr0 eq 0 of bit)] ->
	    (
	      [dtX lt dtY] ->
		(
		  [dtLs0 ne 1 of bit] ->
		    Ls0 ! 1 of bit;
		    Comparator4_BB_Aux
		     [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
		      (dtLs4, dtGr4, dtX, dtY, 1 of bit, dtGr0)
		[]
		  [dtGr0 ne 0 of bit] ->
		    Gr0 ! 0 of bit;
		    Comparator4_BB_Aux
		     [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
		      (dtLs4, dtGr4, dtX, dtY, dtLs0, 0 of bit)
		)
	    []
	      [dtX gt dtY] ->
		(
		  [dtLs0 ne 0 of bit] ->
		    Ls0 ! 0 of bit;
		    Comparator4_BB_Aux
		     [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
		      (dtLs4, dtGr4, dtX, dtY, 0 of bit, dtGr0)
		[]
		  [dtGr0 ne 1 of bit] ->
		    Gr0 ! 1 of bit;
		    Comparator4_BB_Aux
		     [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
		      (dtLs4, dtGr4, dtX, dtY, dtLs0, 1 of bit)
		)
	    []
	      [(dtX eq dtY) and (natnum(dtX) ne X)] ->
		(
		  [dtLs0 ne 0 of bit] ->
		    Ls0 ! 0 of bit;
		    Comparator4_BB_Aux
		     [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
		      (dtLs4, dtGr4, dtX, dtY, 0 of bit, dtGr0)
		[]
		  [dtGr0 ne 0 of bit] ->
		    Gr0 ! 0 of bit;
		    Comparator4_BB_Aux
		     [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
		      (dtLs4, dtGr4, dtX, dtY, dtLs0, 0 of bit)
		)
	    []
	      [(dtX eq bit(X)) or (dtY eq bit(X))] ->
		(
		  [dtLs0 eq X of bit] ->
		    Ls0 ? newdtLs0 : Bit [newdtLs0 ne X of bit];
		    Comparator4_BB_Aux
		     [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
		      (dtLs4, dtGr4, dtX, dtY, newdtLs0, dtGr0)
		[]
		[dtGr0 eq X of bit] ->
		    Gr0 ? newdtGr0 : Bit [newdtGr0 ne X of bit];
		    Comparator4_BB_Aux
		     [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
		      (dtLs4, dtGr4, dtX, dtY, dtLs0, newdtGr0)
		) 
	    )
	)   
      )
    []
      [(dtLs0 eq X of bit) and ((dtLs4 eq X of bit) or (dtGr4 eq X of bit))] ->
	Ls0 ? newdtLs0 : Bit [newdtLs0 ne X of bit];
	Comparator4_BB_Aux [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
	 (dtLs4, dtGr4, dtX, dtY, newdtLs0, dtGr0)
    []
      [(dtGr0 eq X of bit) and ((dtLs4 eq X of bit) or (dtGr4  eq X of bit))] ->
	Gr0 ? newdtGr0 : Bit [newdtGr0 ne X of bit];
	Comparator4_BB_Aux [Ls4, Gr4, X3, Y3, X2, Y2, X1, Y1, X0, Y0, Ls0, Gr0] 
	 (dtLs4, dtGr4, dtX, dtY, dtLs0, newdtGr0)
    endproc (* Comparator4_BB_Aux *)
  endproc (* Comparator4_BB *)
')')

# ComparatorN_BB_Decl defines a n-bit comparator.

define(ComparatorN_BB_Decl, `declare(`$0', `
  process ComparatorN_BB [Ls, Gr, X, Y, Ls0, Gr0] :noexit :=
    ComparatorN_BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
     (X of bit, X of bit, bit(X), bit(X), X of bit, X of bit)
  
    where
    
    process ComparatorN_BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
     (dtLs, dtGr: Bit, dtX, dtY: BitArray, dtLs0, dtGr0: Bit) : noexit :=
      Ls ? newdtLs: Bit;
      ComparatorN_BB_Aux [Ls, Gr, X, Y, Ls0, Gr0]
       (newdtLs, dtGr, dtX, dtY, dtLs0, dtGr0)
    []
      Gr ? newdtGr: Bit;
      ComparatorN_BB_Aux [Ls, Gr, X, Y, Ls0, Gr0]
       (dtLs, newdtGr, dtX, dtY, dtLs0, dtGr0)
    []
      X ? newdtX: BitArray;
      ComparatorN_BB_Aux [Ls, Gr, X, Y, Ls0, Gr0]
       (dtLs, dtGr, newdtX, dtY, dtLs0, dtGr0)
    []
      Y ? newdtY: BitArray;
      ComparatorN_BB_Aux [Ls, Gr, X, Y, Ls0, Gr0]
       (dtLs, dtGr, dtX, newdtY, dtLs0, dtGr0)
    []
      (
        let newdtLs0 : Bit = dtLs, 
	    newdtGr0 : Bit = dtGr in
	(
	  [((newdtLs0 xor newdtGr0) eq 1) and (newdtLs0 ne dtLs0)] ->
	    Ls0 ! newdtLs0;
	    ComparatorN_BB_Aux  [Ls, Gr, X, Y, Ls0, Gr0]
	     (dtLs, dtGr, dtX, dtY, newdtLs0, dtGr0)
	[]
	  [((newdtLs0 xor newdtGr0) eq 1) and (newdtGr0 ne dtGr0)] ->
	    Gr0 ! newdtGr0 ;
	    ComparatorN_BB_Aux [Ls, Gr, X, Y, Ls0, Gr0]
	     (dtLs, dtGr, dtX, dtY, dtLs0, newdtGr0)
	[]
	  [(newdtLs0 eq 0 of bit) and (newdtGr0 eq 0 of bit)] ->
	  (
	    [dtX lt dtY] ->
	      (
	        [dtLs0 ne 1 of bit] ->
		  Ls0 ! 1 of bit;
		  ComparatorN_BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
		   (dtLs, dtGr, dtX, dtY, 1 of bit, dtGr0)
	      []
	        [dtGr0 ne 0 of bit] ->
		  Gr0 ! 0 of bit;
		  ComparatorN_BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
		   (dtLs, dtGr, dtX, dtY, dtLs0, 0 of bit)
	      )
	  []
	    [dtX gt dtY] ->
	      (
	        [dtLs0 ne 0 of bit] ->
		  Ls0 ! 0 of bit;
		  ComparatorN__BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
		   (dtLs, dtGr, dtX, dtY, 0 of bit, dtGr0)
	      []
	        [dtGr0 ne 1 of bit] ->
		  Gr0 ! 1 of bit;
		  ComparatorN__BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
		   (dtLs, dtGr, dtX, dtY, dtLs0, 1 of bit)
	      )
	  []
	    [(dtX eq dtY) and (dtX ne bit(X))] ->
	      (
	        [dtLs0 ne 0 of bit] ->
		  Ls0 ! 0 of bit;
		  ComparatorN__BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
		   (dtLs, dtGr, dtX, dtY, 0 of bit, dtGr0)
	      []
	        [dtGr0 ne 0 of bit] ->
		  Gr0 ! 0 of bit;
		  ComparatorN__BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
		   (dtLs, dtGr, dtX, dtY, dtLs0, 0 of bit)
	      )
	  []
	    [(dtX eq bit(X)) or (dtY eq bit(X))] ->
	      (
	        [dtLs0 eq X of bit] ->
		  Ls0 ? newdtLs0 : Bit[newdtLs0 ne X of bit];
		  ComparatorN__BB_Aux [Ls, Gr, X, Y, Ls0, Gr0]
		   (dtLs, dtGr, dtX, dtY, newdtLs0, dtGr0)
	      []
	        [dtGr0 eq X of bit] ->
		  Gr0 ? newdtGr0 : Bit[newdtGr0 ne X of bit];
		  ComparatorN__BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
		   (dtLs, dtGr, dtX, dtY, dtLs0, newdtGr0)
	      )
	  )       
	[]
	  [(dtLs0 eq X of bit) and ((newdtLs0 eq X of bit) 
	    or (newdtGr0 eq X of bit))] ->
	    Ls0 ? newdtLs0 : Bit[newdtLs0 ne X of bit];
	    ComparatorN__BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
	     (dtLs, dtGr, dtX, dtY, newdtLs0, dtGr0)
	[]
	  [(dtGr0 eq X of bit) and ((newdtLs0 eq X of bit) 
	    or (newdtGr0 eq X of bit))] ->
	    Gr0 ? newdtGr0 : Bit[newdtGr0 ne X of bit];
	    ComparatorN__BB_Aux [Ls, Gr, X, Y, Ls0, Gr0] 
	     (dtLs, dtGr, dtX, dtY, dtLs0, newdtGr0)
        )
      )
    endproc (* ComparatorN_BB_Aux *)
  endproc (* ComparatorN_BB*)
')')
