################################### Header ###################################

# "dill_counter.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach. Bit states (but not signals) may have an "X" (unknown)
# value - generally for their initial condition.
#
# This particular file deals with counters (clock, divider).

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

################################## Counters ##################################

# "Clock_Decl" defines a clock

define(Clock_Decl, `declare(`$0', `
  process Clock [C] : noexit :=
    C ! 0 of Bit;
    C ! 1 of Bit;
    Clock [C]
  endproc (* Clock *)
')')

# "Divider2_Decl" defines a divide-by-2 counter

define(Divider2_Decl, `declare(`$0', `TFlipFlop_Decl
  process Divider2 [C, Q] : noexit :=
    hide Qbar in
      TFlipFlop [C, Q, Qbar]
  endproc (* Divider2 *)
')')

# "Divider4_Decl" defines a divide-by-4 counter

define(Divider4_Decl, `declare(`$0', `TFlipFlop_Decl
  process Divider4 [C, Q1, Q0] : noexit :=
    hide Qbar0, Qbar1 in
      TFlipFlop [C, Q0, Qbar0]
    |[Qbar0]|
      TFlipFlop [Qbar0, Q1, Qbar1]
  endproc (* Divider4 *)
')')

# "Divider8_Decl" defines a divide-by-8 counter

define(Divider8_Decl, `declare(`$0', `TFlipFlop_Decl
  process Divider8 [C, Q2, Q1, Q0] : noexit :=
    hide Qbar0, Qbar1, Qbar2 in
      TFlipFlop [C, Q0, Qbar0]
    |[Qbar0]|
      TFlipFlop [Qbar0, Q1, Qbar1]
    |[Qbar1]|
      TFlipFlop [Qbar1, Q2, Qbar2]
  endproc (* Divider8 *)
')')

# "Bi_Counter4_Reset_Decl" defines a 4 bit binary counter with preclear
#   R1, R2:  pre_clear inputs
#   Q4:     clock
#   Q3--Q0: counter outputs
#   LS93

define(Bi_Counter4_Reset_Decl,
  `declare(`$0', `JKFlipFlop_PreClr_Decl`'Nand2_Decl`'One_Decl
  process Bi_Counter4_Reset [Q4, R1, R2, MWire(4, Q)] :noexit :=
    hide r1r2, MWire(4, `J, K, Pre, Qbar') in
      Nand2 [R1, R2, r1r2]
    |[r1r2]|
      MComp(4, `r1r2=, Q',
       `JKFlipFlop_PreClr [J, K, Pre, r1r2=, Q+, Q, Qbar]')
    |[MWire(4, `J, K, Pre')]|
      (MComp(4, One [J]) ||| MComp(4, One [K]) ||| MComp(4, One [Pre]))
  endproc (* Bi_Counter4_Reset *)
')')
