################################### Header ###################################

# "dill_counter_bb.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach. Bit states (but not signals) may have an "X" (unknown)
# value - generally for their initial condition.
#
# This particular file deals with the black-box form of counters (clock,
# divider).

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

################################## Counters ##################################

# "Divider2_BB_Decl" defines a divide-by-2 counter

define(Divider2_BB_Pos_Decl, `declare(`$0', `Divider2_BB_Decl
  process Divider2_BB_Pos[C, Q] : noexit :=
   Divider2_BB[C, Q] (1 of bit)
  endproc (* Divider2_BB_Pos *)
')')

define(Divider2_BB_Neg_Decl, `declare(`$0', `Divider2_BB_Decl
  process Divider2_BB_Neg[C, Q] : noexit :=
   Divider2_BB[C, Q] (0 of bit)
  endproc (* Divider2_BB_Neg *)
')')
 
define(Divider2_BB_Decl, `declare(`$0', `
  process Divider2_BB[C, Q] (edge : Bit) : noexit :=
    Divider2_BB_Aux [C, Q] (edge, X of bit, X of bit)
 
    where
    
    process  Divider2_BB_Aux [C, Q] (edge, dtC, dtQ : Bit) : noexit :=
      C ? newdtC : Bit;
      (
        [(newdtC eq edge) and (dtC eq not(edge))] ->
	  (
	    [dtQ eq X] ->
	      Q ? newdtQ : Bit [newdtQ ne X];
	      Divider2_BB_Aux [C, Q] (edge, newdtC, newdtQ)
	  []
	    [dtQ ne X] ->
	      Q ! not(dtQ);
	      Divider2_BB_Aux [C, Q] (edge, newdtC, not(dtQ))
	  )
      []
	[(newdtC ne edge ) or (dtC ne not(edge))] ->
	  Divider2_BB_Aux [C, Q] (edge, newdtC, dtQ)
      )
    []
      [dtQ eq X] ->
	Q ? newdtQ : Bit [newdtQ ne X];
	Divider2_BB_Aux [C, Q] (edge, dtC, newdtQ)
    endproc (* Divider2_BB_Aux *)
  endproc (* Divider2_BB *)
')')

# "Divider4_BB_Decl" defines a divide-by-4 counter

define(Divider4_BB_Pos_Decl, `declare(`$0', `Divider2_BB_Pos_Decl
  process Divider4_BB_Pos [C, Q1, Q0] : noexit :=
     Divider2_BB_Pos [C, Q0] |[Q0]| Divider2_BB_Pos[Q0, Q1]
  endproc (* Divider4_BB_Pos *)
')')

define(Divider4_BB_Neg_Decl, `declare(`$0', `Divider2_BB_Neg_Decl
  process Divider4_BB_Neg [C, Q1, Q0] : noexit :=
     Divider2_BB_Neg [C Q0] |[Q0]| Divider2_BB_Neg [Q0, Q1]
  endproc (* Divider4_BB_Neg *)
')')


# "Divider8_BB_Decl" defines a divide-by-8 counter

define(Divider8_BB_Pos_Decl, `declare(`$0', `Divider2_BB_Pos_Decl
  process Divider8_BB_Pos [C, Q2, Q1, Q0] : noexit :=
    Divider2_BB_Pos [C, Q0] 
  |[Q0]|
    Divider2_BB_Pos [Q0, Q1]
  |[Q1]|
    Divider2_BB_Pos [Q1, Q2]
  endproc (* Divider8_BB_Pos *)
')')

define(Divider8_BB_Neg_Decl, `declare(`$0', `Divider2_BB_Neg_Decl
  process Divider8_BB_Neg [C, Q2, Q1, Q0] : noexit :=
    Divider2_BB_Neg [C, Q0] 
  |[Q0]|
    Divider2_BB_Neg [Q0, Q1]
  |[Q1]|
    Divider2_BB_Neg [Q1, Q2]  
  endproc (* Divider8_BB_Neg *)
')')

# "Bi_Counter4_BB_Reset_Decl" defines a 4bits binary counter with pre_clear:
#
#    R1, R2:  pre_clear inputs (1 active )
#    Q4:     clock (negtive transition active )
#    Q3--Q0: counter outputs
#    LS93

define(Bi_Counter4_BB_Reset_Decl, `declare(`$0', `
  process Bi_Counter4_BB_Reset[Q4, R1, R2, MWire(4, Q)] :noexit :=
    Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)] 
     (X of bit, X of bit, X of bit, MWire(4, X of bit=))

    where
    
    process Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
     (dtQ4, dtR1, dtR2, MWire(4, dtQ): Bit ) : noexit :=
      R1 ? newdtR1 : Bit;
      Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
       (dtQ4, newdtR1, dtR2, MWire(4, dtQ))
    []
      R2 ? newdtR2 : Bit;
      Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
       (dtQ4, dtR1, newdtR2, MWire(4, dtQ))
    []
      Q4 ? newdtQ4 : Bit;
      (
	[(newdtQ4 eq 0 of bit) and (dtQ4 eq 1)] ->	(* -ve clock transition *)
	  (
	    [((dtR1 eq 1 ) and (dtR2 eq 1)) or ((dtR1 eq X ) or (dtR2 eq X))] -> 
	      (
	      
	      Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
		(newdtQ4, dtR1, dtR2, MWire(4, dtQ))	(* no change of output *)
	      )				(* end of clear state *)
	  []
	    [((dtR1 ne X) and (dtR2 ne X)) and ((dtR1 eq 0 of bit) 
		or (dtR2 eq 0  of bit))] -> 
	      (
		[(dtQ3 eq X) or (dtQ2 eq X) or (dtQ1 eq X) or (dtQ0 eq X)] -> 
		  (
		    (
		      Q0 ? newdtQ0 : Bit [newdtQ0 ne X]; 
		      exit(any bit, any bit, any bit, newdtQ0)
		    |||
		      Q1 ? newdtQ1 : Bit [newdtQ1 ne X];
		      exit(any bit, any bit, newdtQ1, any bit)
		    |||
		      Q2 ? newdtQ2 : Bit [newdtQ2 ne X];
		      exit(any bit, newdtQ2, any bit, any bit)
		    |||
		      Q3 ? newdtQ3 : Bit [newdtQ3 ne X]; 
		      exit(newdtQ3, any bit, any bit, any bit)
		  )
		>>
		  accept MWire(4, newdtQ) : bit in
		    Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
		     (newdtQ4, dtR1, dtR2, MWire(4, newdtQ))
		  )
	      []
		[(dtQ3 ne X) and  (dtQ2 ne X) and (dtQ1 ne X) and (dtQ0 ne X)] ->
		  (
		    let newdtQ0 : bit = dtQ0 + 1,
			newdtQ1 : bit = dtQ1 + carry(dtQ0, 1),
			newdtQ2 : bit = dtQ2 + carry(dtQ1, carry(dtQ0, 1)),
			newdtQ3 : bit =
			  dtQ3 + carry(dtQ2, carry(dtQ1, carry(dtQ0, 1))) in
		      (
			(
			  (
			    [newdtQ3 eq dtQ3] ->
			      exit(dtQ3, any bit, any bit, any bit)
			  []
			    [newdtQ3 ne dtQ3] ->
			      Q3 ! newdtQ3;
			      exit (newdtQ3, any bit, any bit, any bit)
			  )
			|||
			  (
			    [newdtQ2 eq dtQ2] ->
			      exit(any bit, dtQ2, any bit, any bit)
			  []
			    [newdtQ2 ne dtQ2] ->
			      Q2 ! newdtQ2;
			      exit (any bit, newdtQ2, any bit, any bit)
			  )
			|||
			  (
			    [newdtQ1 eq dtQ1] ->
			      exit(any bit, any bit, dtQ1, any bit)
			  []
			    [newdtQ1 ne dtQ1] ->
			      Q1 ! newdtQ1;
			      exit (any bit, any bit, newdtQ1, any bit)
			  )
			|||
			  (
			    [newdtQ0 eq dtQ0] ->
			      exit(any bit, any bit, any bit, dtQ0)
			  []
			    [newdtQ0 ne dtQ0] ->
			      Q0 ! newdtQ0;
			      exit (any bit, any bit, any bit, newdtQ0)
			  )
			)		(* end of interleaving *)
		      >>
			accept MWire(4, nowdtQ) : Bit in
			 Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
			  (newdtQ4, dtR1, dtR2, MWire(4, nowdtQ))
		      )			(* end of let *)
		  )			(* end of count *)
	      )				(* end of not in clear state *)
	  )				(* end of appropriate counter transition *)
      []
	[(newdtQ4 ne 0 of bit) or (dtQ4 ne 1)] ->
	  Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
	   (newdtQ4, dtR1, dtR2, MWire(4, dtQ))
      )				(* end of Q4 ? --- *)
    []
      [(dtR1 eq 1) and (dtR2 eq 1)] ->			(* clear counter *)
	(
	  [dtQ3 ne 0 of bit] ->
	    Q3 ! 0 of bit;
	    Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
	     (dtQ4, dtR1, dtR2, 0 of bit, dtQ2, dtQ1, dtQ0)
	[]
	  [dtQ2 ne 0 of bit] ->
	    Q2 ! 0 of bit;
	    Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
	     (dtQ4, dtR1, dtR2, dtQ3, 0 of bit, dtQ1, dtQ0)
	[]
	  [dtQ1 ne 0 of bit] ->
	    Q1 ! 0 of bit;
	    Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
	     (dtQ4, dtR1, dtR2, dtQ3, dtQ2, 0 of bit, dtQ0)
	[]
	  [dtQ0 ne 0 of bit] ->
	    Q0 ! 0 of bit;
	    Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
	     (dtQ4, dtR1, dtR2, dtQ3, dtQ2, dtQ1, 0 of bit)
	)			(* end of clear counter *)
    []
      [(dtQ3 eq X) or (dtQ2 eq X) or (dtQ1 eq X) or (dtQ0 eq X)] -> 
	(
	  (
	    Q0 ? newdtQ0 : Bit [newdtQ0 ne X]; 
	    exit(any bit, any bit, any bit, newdtQ0)
	  |||
	    Q1 ? newdtQ1 : Bit [newdtQ1 ne X]; 
	    exit(any bit, any bit, newdtQ1, any bit)
	  |||
	    Q2 ? newdtQ2 : Bit [newdtQ2 ne X]; 
	    exit(any bit, newdtQ2, any bit, any bit)
	  |||
	    Q3 ? newdtQ3 : Bit [newdtQ3 ne X]; 
	    exit(newdtQ3, any bit, any bit, any bit)
	  )
        >>
	  accept MWire(4, newdtQ) : bit in
	    Bi_Counter4_BB_Reset_Aux [Q4, R1, R2, MWire(4, Q)]
	     (dtQ4, dtR1, dtR2, MWire(4, newdtQ))
	)
    endproc (* Bi_Counter4_BB_Reset_Aux *)
  endproc (* Bi_Counter4_BB_Reset *)
')')
