################################### Header ###################################

# "dill_flipflop.m4"	Ji He, K. J. Turner	24/09/97

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with flip-flops (D, T, MS, JK).

# Copyright 1997 Ji He, K. J. Turner, University of Stirling

################################# Flip-Flops #################################

# "DFlipFlop_Decl" defines a delay flip-flop

define(DFlipFlop_Decl,`declare(`$0',`Inverter_Decl`'DLatch_Decl
  process DFlipFlop [D, C, Q, Qbar] : noexit :=
    hide Qint0, Qint1, Cint in
      Inverter [C, Cint]
    |[C, Cint]|
      (
        DLatch [D, C, Qint0, Qint1]
      |[Qint0]|
        DLatch [Qint0, Cint, Q, Qbar]
      )
  endproc (* DFlipFlop *)
')')

# "TFlipFlop_Decl" defines a toggle flip-flop

define(TFlipFlop_Decl,`declare(`$0',`DFlipFlop_Decl
  process TFlipFlop [C, Q, Qbar] : noexit :=
    DFlipFlop [Qbar, C, Q, Qbar]
  endproc (* TFlipFlop *)
')')

# "MSFlipFlop_Decl" defines a master-slave flip-flop

define(MSFlipFlop_Decl,`declare(`$0',`Inverter_Decl`'CRSLatch_Decl
  process MSFlipFlop [R, S, C, Q, Qbar] : noexit :=
    hide Rint, Sint, Cint in
      Inverter [C, Cint]
    |[C, Cint]|
      (
        CRSLatch [R, S, C, Sint, Rint]
      |[Rint, Sint]|
        CRSLatch [Rint, Sint, Cint, Q, Qbar]
      )
  endproc (* MSFlipFlop *)
')')

# "JKFlipFlop_Decl" defines a master-slave JK flip-flop

define(JKFlipFlop_Decl,`declare(`$0',`And2_Decl`'MSFlipFlop_Decl
  process JKFlipFlop [J, K, C, Q, Qbar] : noexit :=
    hide Rint, Sint in
      (
        And2 [J, Qbar, Sint]
      |||
        And2 [K, Q, Rint]
      )
    |[Q, Qbar, Rint, Sint]|
      MSFlipFlop [Rint, Sint, C, Q, Qbar]
  endproc (* JKFlipFlop *)
')')

# "MSFlipFlop_PreClr_Decl" defines a master slave RS flip-flop with pre-set and 
#  pre-clear inputs. pre-set and pre-clear are 0 active.

define(MSFlipFlop_PreClr_Decl, `declare(`$0', 
  `CRSLatch_Decl`'Latch_PreClr_Decl`'Inverter_Decl
  process MSFlipFlop_PreClr [R, S, Preset, Clear, Ck, Q, Qbar] :noexit :=
    hide Ckint,  Rint, Sint in
     Inverter[Ck, Ckint]
    |[Ck, Ckint]|
     (
       CRSLatch [R, S, Ck, Rint, Sint] 
     |[Rint, Sint]|
       Latch_PreClr [Sint, Rint, Preset, Clear, Ckint, Q, Qbar]
     )
  endproc (* MSFlipFlop_PreClr *)
')')

# "JKFlipFlop_PreClr_Decl" defines a master slave JK flip-flop with pre-set and 
#  pre-clear inputs; pre-set and pre-clear are 0 active.

define(JKFlipFlop_PreClr_Decl, `declare(`$0', `And2_Decl`'MSFlipFlop_PreClr_Decl
  process JKFlipFlop_PreClr [J, K, Preset, Clear, Ck, Q, Qbar] :noexit :=
    hide Rint, Sint in
      (And2 [J, Qbar, Sint] ||| And2 [K, Q, Rint])
    |[Rint, Sint, Q, Qbar]|
      MSFlipFlop_PreClr [Rint, Sint, Preset, Clear, Ck, Q, Qbar]
  endproc (* JKFlipFlop_PreClr *)
')')

# "DFlipFlop_PreClr_Decl" defines a master slave D flip-flop with pre-set and 
#  pre-clear inputs; pre-set and pre-clear are 0 active.

define(DFlipFlop_PreClr_Decl, 
  `declare(`$0', `Inverter_Decl`'JKFlipFlop_PreClr_Decl
  process DFlipFlop_PreClr [D, Preset, Clear, Ck, Q, Qbar] :noexit :=
    hide Dint in
     Inverter [D, Dint] 
   |[D, Dint]|
     JKFlipFlop_PreClr [D, Dint, Preset, Clear, Ck, Q, Qbar]
  endproc (* DFlipFlop_PreClr *)
')')

# "RSFlipFlopEdge_Decl" defines an edge-triggered RS flip-flop

define(RSFlipFlopEdge_Decl, `declare(`$0', `Nand2_Decl`'Or2_Decl
  process RSFlipFlopEdge [R, S, Ck, Q, Qbar] : noexit :=
    hide A, B, C, D in
      ((Nand2 [S, Ck, A] |[A, Ck]| Or2 [Ck, A, C]) |[C]| Nand2 [C, Qbar, Q]) 
    |[Ck, Q, Qbar]|
      ((Nand2 [R, Ck, B] |[B, Ck]| Or2 [Ck, B, D]) |[D]| Nand2 [D, Q, Qbar])
  endproc (* RSFlipFlopEdge *)
')')
