################################### Header ###################################

# "dill_gate.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with generic gates: 0, 1, 2, 3, 4, 8 input logic
# functions.

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

############################## Generic Gates ###############################

# "Gate_Decl(function,inputs)" declares a gate with the given function (zero,
# one, sink, repeater, inverter, and, nand, or, nor, xor) and for the given
# number of inputs (2, 3, 4 if relevant) unless it is already declared

define(Gate_Decl,
  `declare(`$1$2_Decl',`define(`ips',ifelse($2,,0,$2))define(`has_ips',
    eval(index(` and nand or nor xor xnor ',` $1 ') != -1))define(`no_ips',
      eval(
        index(` zero one sink repeater inverter ',` $1 ') != -
1))ifelse($1,zero,`Source_Decl
  process Zero [Op] : noexit :=
    Source [op] (0 of Bit)
  endproc (* Zero *)')ifelse($1,one,`Source_Decl
  process One [Op] : noexit :=
    Source [Op] (1 of Bit)
  endproc (* One *)')ifelse($1,sink,`
  process Sink [Ip] : noexit :=
    Ip ? b : Bit;
    Sink [ip]
  endproc (* Sink *)')ifelse($1,repeater,`Logic1_Decl
  process Repeater [Ip, Op] : noexit :=
    Logic1 [Ip, Op] (same)
  endproc (* Repeater *)')ifelse($1,inverter,`Logic1_Decl
  process Inverter [Ip, Op] : noexit :=
    Logic1 [Ip, Op] (not)
  endproc (* Inverter *)')ifelse(has_ips,1,
    define(`gate_name',capitalise($1)`'ips)ifelse(ips,2,``Logic2_Decl
  process gate_name [Ip1, Ip2, Op] : noexit :=
    Logic2 [Ip1, Ip2, Op] ($1)
  endproc (* gate_name *)'')ifelse(ips,3,``Logic3_Decl
  process gate_name [Ip1, Ip2, Ip3, Op] : noexit :=
    Logic3 [Ip1, Ip2, Ip3, Op] ($1)
  endproc (* gate_name *)'')ifelse(ips,4,``Logic4_Decl
  process gate_name [Ip1, Ip2, Ip3, Ip4, Op] : noexit :=
    Logic4 [Ip1, Ip2, Ip3, Ip4, Op] ($1)
  endproc (* gate_name *)'')ifelse(ips,8,``Logic8_Decl
  process gate_name [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op] : noexit :=
    Logic8 [Ip1, Ip2, IP3, Ip4, Ip5, Ip6, Ip7, Ip8, Op] ($1)
  endproc (* gate_name *)'')ifelse(eval(ips < 2 | ips > 8),1,`
  (*** $1 gate not allowed with ips inputs ***)'),ifelse(no_ips,0,`
  (*** $1 gate not known ***)'))')')

# "Logic1_Decl" declares a generic one-input gate

define(Logic1_Decl,`declare(`$0',`
  process Logic1 [Ip, Op] (BOp : BitOp) : noexit :=
    Logic1Aux [Ip, Op] (BOp, X of Bit, X of Bit)

    where

    process Logic1Aux [Ip, Op] (BOp : BitOp, BIn, BOut : Bit) : noexit :=
      Ip ? BInNew : Bit;
      Logic1Aux [Ip, Op] (BOp, BInNew, BOut)
    []
      (
	let BOutNew : Bit = Apply (BOp, BIn) in
	  [(BOutNew eq X of Bit) and (BOut eq X of Bit)] ->
	    Op ? BOutNew : Bit [BOutNew ne X of Bit];
	    Logic1Aux [Ip, Op] (BOp, BIn, BOutNew)
	[]
 	  [(BOutNew ne X of Bit) and (BOutNew ne BOut)] ->
	    Op ! BOutNew;
	    Logic1Aux [Ip, Op] (BOp, BIn, BOutNew)
      )
    endproc (* Logic1Aux *)

  endproc (* Logic1 *)
')')

# "Logic2_Decl" declares a generic two-input gate

define(Logic2_Decl,`declare(`$0',`
  process Logic2 [Ip1, Ip2, Op] (BOp : BitOp) : noexit :=
    Logic2Aux [Ip1, Ip2, Op] (BOp, X of Bit, X of Bit, X of Bit)

    where

    process Logic2Aux [Ip1, Ip2, Op]
     (BOp : BitOp, BIn1, BIn2, BOut : Bit) : noexit :=
      Ip1 ? BIn1New : Bit;
      Logic2Aux [Ip1, Ip2, Op]
       (BOp, BIn1New, BIn2, BOut)
    []
      Ip2 ? BIn2New : Bit;
      Logic2Aux [Ip1, Ip2, Op]
       (BOp, BIn1, BIn2New, BOut)
    []
      (
	let BOutNew : Bit = Apply (BOp, BIn1, BIn2) in
	  [(BOutNew eq X of Bit) and (BOut eq X of Bit)] ->
            Op ? BOutNew : Bit [BOutNew ne X of Bit];
            Logic2Aux [Ip1, Ip2, Op]
	     (BOp, BIn1, BIn2, BOutNew)
	[]
 	  [(BOutNew ne X of Bit) and (BOutNew ne BOut)] ->
	    Op ! BOutNew;
	    Logic2Aux [Ip1, Ip2, Op]
	     (BOp, BIn1, BIn2, BOutNew)
      )
    endproc (* Logic2Aux *)

  endproc (* Logic2 *)
')')

# "Logic3_Decl" declares a generic three-input gate

define(Logic3_Decl,`declare(`$0',`
  process Logic3 [Ip1, Ip2, Ip3, Op] (BOp : BitOp) : noexit :=
    Logic3Aux [Ip1, Ip2, Ip3, Op] (BOp, X of Bit, X of Bit, X of Bit, X of Bit)

    where

    process Logic3Aux [Ip1, Ip2, Ip3, Op]
     (BOp : BitOp, BIn1, BIn2, BIn3, BOut : Bit) : noexit :=
      Ip1 ? BIn1New : Bit;
      Logic3Aux [Ip1, Ip2, Ip3, Op]
       (BOp, BIn1New, BIn2, BIn3, BOut)
    []
      Ip2 ? BIn2New : Bit;
      Logic3Aux [Ip1, Ip2, Ip3, Op]
       (BOp, BIn1, BIn2New, BIn3, BOut)
    []
      Ip3 ? BIn3New : Bit;
      Logic3Aux [Ip1, Ip2, Ip3, Op]
       (BOp, BIn1, BIn2, BIn3New, BOut)
    []
      (
	let BOutNew : Bit = Apply (BOp, BIn1, BIn2, BIn3) in
	  [(BOutNew eq X of Bit) and (BOut eq X of Bit)] ->
	    Op ? BOutNew : Bit [BOutNew ne X of Bit];
	    Logic3Aux [Ip1, Ip2, Ip3, Op]
	      (BOp, BIn1, BIn2, BIn3, BOutNew)
	[]
 	  [(BOutNew ne X of Bit) and (BOutNew ne BOut)] ->
	    Op ! BOutNew;
	    Logic3Aux [Ip1, Ip2, Ip3, Op]
	     (BOp, BIn1, BIn2, BIn3, BOutNew)
      )
    endproc (* Logic3Aux *)

  endproc (* Logic3 *)
')')

# "Logic4_Decl" declares a generic four-input gate

define(Logic4_Decl,`declare(`$0',`
  process Logic4 [Ip1, Ip2, Ip3, Ip4, Op] (BOp : BitOp) : noexit :=
    Logic4Aux [Ip1, Ip2, Ip3, Ip4, Op]
     (BOp, X of Bit, X of Bit, X of Bit, X of Bit, X of Bit)

    where

    process Logic4Aux [Ip1, Ip2, Ip3, Ip4, Op]
     (BOp : BitOp, BIn1, BIn2, BIn3, BIn4, BOut : Bit) : noexit :=
      Ip1 ? BIn1New : Bit;
      Logic4Aux [Ip1, Ip2, Ip3, Ip4, Op]
       (BOp, BIn1New, BIn2, BIn3, BIn4, BOut)
    []
      Ip2 ? BIn2New : Bit;
      Logic4Aux [Ip1, Ip2, Ip3, Ip4, Op]
       (BOp, BIn1, BIn2New, BIn3, BIn4, BOut)
    []
      Ip3 ? BIn3New : Bit;
      Logic4Aux [Ip1, Ip2, Ip3, Ip4, Op]
       (BOp, BIn1, BIn2, BIn3New, BIn4, BOut)
    []
      Ip4 ? BIn4New : Bit;
      Logic4Aux [Ip1, Ip2, Ip3, Ip4, Op]
       (BOp, BIn1, BIn2, Bin3, BIn4New, BOut)
    []
      (
	let BOutNew : Bit = Apply (BOp, BIn1, BIn2, BIn3, BIn4) in
	  [(BOutNew eq X of Bit) and (BOut eq X of Bit)] ->
	    Op ? BOutNew : Bit [BOutNew ne X of Bit];
	    Logic4Aux [Ip1, Ip2, Ip3, Ip4, Op]
	     (BOp, BIn1, BIn2, BIn3, BIn4, BOutNew)
	[]
 	  [(BOutNew ne X of Bit) and (BOutNew ne BOut)] ->
	    Op ! BOutNew;
	    Logic4Aux [Ip1, Ip2, Ip3, Ip4, Op]
	     (BOp, BIn1, BIn2, BIn3, BIn4, BOutNew)
      )
    endproc (* Logic4Aux *)

  endproc (* Logic4 *)
')')

# "Logic8_Decl" declares a generic eight-input gate

define(Logic8_Decl, `declare(`$0', `
  process Logic8
   [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op] (BOp : BitOp) :noexit :=
 
    Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
     (BOp, X of Bit, X of Bit, X of Bit, X of Bit, X of Bit, X of Bit, X of Bit, X of Bit, X of Bit)
  
    where

    process Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
     (BOp : BitOp, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8, BOut : Bit) : noexit :=
      Ip1 ? BIn1New : Bit;
      Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
       (BOp, BIn1New, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8, Bout)
    []
      Ip2 ? BIn2New : Bit;
      Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
       (BOp, BIn1, BIn2New, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8, Bout)
    []
      Ip3 ? BIn3New : Bit;
      Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
       (BOp, BIn1, BIn2, BIn3New, BIn4, BIn5, BIn6, BIn7, BIn8, Bout)
    []
      Ip4 ? BIn4New : Bit;
      Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
       (BOp, BIn1, BIn2, BIn3, BIn4New, BIn5, BIn6, BIn7, BIn8, Bout)
    []
      Ip5 ? BIn5New : Bit;
      Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
       (BOp, BIn1, BIn2, BIn3, BIn4, BIn5New, BIn6, BIn7, BIn8, Bout)
    []
      Ip6 ? BIn6New : Bit;
      Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
       (BOp, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6New, BIn7, BIn8, Bout)
    []
      Ip7 ? BIn7New : Bit;
      Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
       (BOp, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7New, BIn8, Bout)
    []
      Ip8 ? BIn8New : Bit;
      Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
       (BOp, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8New, Bout)
    []
      (
        let BOutNew : Bit =
	 Apply (BOp, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8) in
	  [(BOutNew eq X of Bit) and (BOut eq X of Bit)] ->
	    Op ? BOutNew : Bit [BOutNew ne X of Bit];
	    Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
	      (BOp, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8, BOutNew)
	[]
	  [(BOutNew ne X of Bit) and (BOutNew ne BOut)] ->
	    Op ! BOutNew;
	    Logic8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, Op]
	     (BOp, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8, BOutNew)
      )
    endproc (* Logic8Aux *)

  endproc (* Logic8 *)
')')

# "Source_Decl" declares a generic logic source

define(Source_Decl,`declare(`$0',`
  process Source [Op] (b : Bit) : noexit :=
    Op ! b;
    stop
  endproc (* Source *)
')')

################################ Basic Logic ################################

define(One_Decl,`Gate_Decl(one)')

define(Sink_Decl,`Gate_Decl(sink)')

define(Zero_Decl,`Gate_Decl(zero)')

################################ Unary Gates ################################

# "Delay1_Decl" defines a one-unit delay

define(Delay1_Decl,`declare(`$0',`Repeater_Decl
  process Delay1 [Ip, Op] : noexit :=
    Repeater [Ip, Op]
  endproc (* Delay1 *)
')')

# "Delay2_Decl" defines a two-unit delay

define(Delay2_Decl,`declare(`$0',`Repeater_Decl
  process Delay2 [Ip, Op] : noexit :=
    hide int in
      Repeater [Ip, Int]
    |[Int]|
      Repeater [Int, Op]
  endproc (* Delay2 *)
')')

define(Inverter_Decl,`Gate_Decl(inverter)')

define(Repeater_Decl,`Gate_Decl(repeater)')

################################ Binary Gates ################################

define(And2_Decl,`Gate_Decl(and,2)')

define(Nand2_Decl,`Gate_Decl(nand,2)')

define(Or2_Decl,`Gate_Decl(or,2)')

define(Nor2_Decl,`Gate_Decl(nor,2)')

define(Xor2_Decl,`Gate_Decl(xor,2)')

define(Xnor2_Decl,`Gate_Decl(xnor,2)')

############################### Ternary Gates ###############################

define(And3_Decl,`Gate_Decl(and,3)')

define(Nand3_Decl,`Gate_Decl(nand,3)')

define(Or3_Decl,`Gate_Decl(or,3)')

define(Nor3_Decl,`Gate_Decl(nor,3)')

define(Xor3_Decl,`Gate_Decl(xor,3)')

define(Xnor3_Decl,`Gate_Decl(xnor,3)')

############################## Quaternary Gates ##############################

define(And4_Decl,`Gate_Decl(and,4)')

define(Nand4_Decl,`Gate_Decl(nand,4)')

define(Or4_Decl,`Gate_Decl(or,4)')

define(Nor4_Decl,`Gate_Decl(nor,4)')

define(Xor4_Decl,`Gate_Decl(xor,4)')

define(Xnor4_Decl,`Gate_Decl(xnor,4)')

############################## Octonary Gates ##############################

define(And8_Decl,`Gate_Decl(and,8)')

define(Nand8_Decl,`Gate_Decl(nand,8)')

define(Or8_Decl,`Gate_Decl(or,8)')

define(Nor8_Decl,`Gate_Decl(nor,8)')

define(Xor8_Decl,`Gate_Decl(xor,8)')

define(Xnor8_Decl,`Gate_Decl(xnor,8)')
