################################### Header ###################################

# "dill_gate_tri.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with the tri-state form of generic gates: 0, 1,
# 2, 3, 4, 8 input logic functions.

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

########################### Generic Tristate Gates ###########################

define(Enable_Decl, `declare(`$1$2$3_Decl', `define(`num', ifelse($3,,0,$3)) dnl
  define(`has_num', eval(index(` and nand or nor xor ', `$1 ') != -1)) dnl
  define(`no_num', eval(index(`inverter repeater ', `$1 ') != -1)) dnl
  ifelse($1, repeater, `Enable1_Decl dnl
  `'ifelse($2, one,
  `process Repeater_$2[Ip, G, Op] :noexit :=
    Enable1[Ip, G, Op](same, 1 of bit)
  endproc (* Repeater_$2 *)', $2, zero,
  `process Repeater_$2[Ip, G, Op] :noexit :=
    Enable1[Ip, G, Op](same, 0 of bit)
  endproc (* Repeater_$2 *)')')
  ifelse($1, inverter, `Enable1_Decl
  `'ifelse( $2, one,
  `process Inverter_$2[Ip, G, Op] :noexit :=
    Enable1[Ip, G, Op](not, 1 of bit)
  endproc (* Inverter_$2 *)', $2, zero,
  `process Inverter_$2[Ip, G, Op] :noexit :=
    Enable1[Ip, G, Op](not, 0 of bit)
  endproc (* Inverter_$2 *)')')
  ifelse(has_num, 1, define(`enable_name', capitalise($1)`'num`'_$3) 
  ifelse(num, 2, ``Enable2_Decl
  `'ifelse($3, one,
  `process enable_name [Ip1, Ip2, G, Op] :noexit :=
    Enable2[Ip1, Ip2, G, Op] ($1, 1 of bit)
  endproc (* enable_name *)', $3, zero,
  `process enable_name [Ip1, Ip2, G, Op] :noexit :=
    Enable2[Ip1, Ip2, G, Op] ($1, 0 of bit)
  endproc (* enable_name *)')'')
  ifelse(num, 3, ``Enable3_Decl
  `'ifelse($3, one,
  `process enable_name [Ip1, Ip2, Ip3, G, Op] :noexit :=
    Enable3[Ip1, Ip2, Ip3, G, Op] ($1, 1 of bit)
  endproc (* enable_name *)', $3, zero,
  `process enable_name [Ip1, Ip2, Ip3, G, Op] :noexit :=
    Enable3[Ip1, Ip2, Ip3, G, Op] ($1, 0 of bit)
  endproc (* enable_name *)')'')
  ifelse(num, 4, ``Enable4_Decl
  `'ifelse($3, one,
  `process enable_name [Ip1, Ip2, Ip3, Ip4, G, Op] :noexit :=
    Enable4[Ip1, Ip2, Ip3, Ip4, G, Op] ($1, 1 of bit)
  endproc (* enalbe_name *)', $3, zero,
  `process enable_name [Ip1, Ip2, Ip3, Ip4, G, Op] :noexit :=
    Enable4[Ip1, Ip2, Ip3, Ip4, G, Op] ($1, 0 of bit)
  endproc (* enalbe_name *)')'')
  ifelse(num, 8, ``Enable8_Decl
  `'ifelse($3, one,
 `process enable_name [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] : noexit :=
    Enable8[Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] ($1, 1 of bit)
  endproc (* enable_name *)', $3, zero,
 `process enable_name [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] : noexit :=
    Enable8[Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] ($1, 0 of bit)
  endproc (* enable_name *)')'')
  ifelse(eval (num <2 | (num >4 & num !=8)), 1, `  dnl
    (*** $1 enable not allowed with num inputs ***)'))')') dnl

define(Enable1_Decl, `declare(`$0', `
  process Enable1[Ip, G, Op] (BOp : BitOp, Enable : Bit) : noexit :=
    Enable1Aux [Ip, G, Op] (BOp, Enable, X of bit, X of bit, X of bit)
  
    where
  
    process Enable1Aux [Ip, G, Op]
     (BOp : BitOp, Enable : Bit, BIn, GIn : Bit, BOut : Bit) : noexit :=
      Ip ? BInNew : Bit;
      Enable1Aux [Ip, G, Op] (BOp, Enable, BInNew, GIn, BOut)
    []
      G ? GInNew : Bit;
      Enable1Aux [Ip, G, Op] (BOp, Enable, BIn, GInNew, BOut)
    []
      [GIn eq Enable] ->
        (
	  let BOutNew : Bit = Apply (BOp, BIn) in
	    (
	      [(BOutNew ne X of bit) and (BOutNew ne BOut)] ->
		Op ! BOutNew;
		Enable1Aux [Ip, G, Op] (BOp, Enable, BIn, GIn, BOutNew)
	    []
	      [(BOutNew eq X of bit) and (BOut eq X of bit)] ->
		Op ? BOutNew : bit [BOutNew ne X of bit];
		Enable1Aux [Ip, G, Op] (BOp, Enable, BIn, GIn, BOutNew)
	   )
       )
    []
      [GIn eq not (Enable)] ->
        Op ? other: Bit;
        Enable1Aux [Ip, G, Op] (BOp, Enable, BIn, GIn, other)
    endproc (* Enable1Aux *)
  endproc (* Enable1 *)
')')

define(Enable2_Decl, `declare(`$0', `
  process Enable2[Ip1, Ip2, G, Op] (BOp:BitOp, Enable:Bit) : noexit :=
    Enable2Aux [Ip1, Ip2, G, Op] 
     (BOp, Enable, X of bit, X of bit, X of bit, X of bit)
  
    where
 
    process Enable2Aux [Ip1, Ip2, G, Op] 
     (BOp : BitOp, Enable : bit, BIn1, BIn2, GIn, BOut : Bit) : noexit :=
      Ip1 ? BIn1New : Bit;
      Enable2Aux [Ip1, Ip2, G, Op] (BOp, Enable, BIn1New, BIn2, GIn, BOut)
    []
      Ip2 ? BIn2New : Bit;
      Enable2Aux [Ip1, Ip2, G, Op] (BOp, Enable, BIn1, BIn2New, GIn, BOut)
    []
      G ? GInNew : Bit;
      Enable2Aux [Ip1, Ip2, G, Op] (BOp, Enable, BIn1, BIn2, GInNew, BOut)
    []
      [GIn eq Enable] ->
        (
	  let BOutNew : Bit = Apply (BOp, BIn1, BIn2) in
	    (
	      [(BOutnew ne BOut) and (BOutNew ne X of bit)] ->
	        Op ! BOutNew;  
	        Enable2Aux [Ip1, Ip2, G, Op] (BOp, Enable, BIn1, Bin2, GIn, BOutNew)
	    []
	      [(BOutNew eq X of bit) and (BOut eq X of bit)] ->
	        Op ? BOutNew :bit [BOutNew ne X of bit];
	        Enable2Aux [Ip1, Ip2, G, Op] (BOp, Enable, BIn1, Bin2, GIn, BOutNew) 
	   )
       )
    []
      [GIn eq not (Enable)] -> 
        Op ? other: Bit;
        Enable2Aux [Ip1, Ip2, G, Op] (BOp, Enable, BIn1, BIn2, GIn, other)
    endproc (* Enable2Aux *)
  endproc (* Enable2 *)
')') 

define(Enable3_Decl, `declare(`$0', `
  process Enable3 [Ip1, Ip2, Ip3, G, Op] (BOp : BitOp, Enable : Bit) : noexit :=
    Enable3Aux [Ip1, Ip2, Ip3, G, Op] 
     (BOp, Enable, X of bit, X of bit, X of bit, X of bit, X of bit)
 
    where

    process Enable3Aux [Ip1, Ip2, Ip3, G, Op] 
     (BOp : BitOp, Enable : Bit, BIn1, BIn2, BIn3, GIn, BOut : Bit) : noexit :=
      Ip1 ? BIn1New : Bit;
      Enable3Aux [Ip1, Ip2, Ip3, G, Op]
       (BOp, Enable, BIn1New, BIn2, BIn3, GIn, BOut)
    []
      Ip2 ? BIn2New : Bit;
      Enable3Aux [Ip1, Ip2, Ip3, G, Op]
       (BOp, Enable, BIn1, BIn2New, BIn3, GIn, BOut)
    []
      Ip3 ? BIn3New : Bit;
      Enable3Aux [Ip1, Ip2, Ip3, G, Op]
       (BOp, Enable, BIn1, BIn2, BIn3New, GIn, BOut)
    []
      G ? GInNew : Bit;
      Enable3Aux [Ip1, Ip2, Ip3, G, Op]
       (BOp, Enable, BIn1, BIn2, BIn3, GInNew, BOut)
    []
      [GIn eq Enable] ->
        (
	  let BOutNew : Bit = Apply (BOp, BIn1, BIn2, BIn3) in
	    (
	      [(BOutNew ne X of bit) and (BOutNew ne BOut)] ->
	        Op ! BOutNew;  
	        Enable3Aux [Ip1, Ip2, Ip3, G, Op]
		 (BOp, Enable, BIn1, Bin2, BIn3, GIn, BOutNew)
	    []
	      [(BOutNew eq X of bit) and (BOut eq X of bit)] ->
	        Op ? BOutNew : Bit [BOutNew ne X of bit];
	        Enable3Aux [Ip1, Ip2, Ip3, G, Op]
		 (BOp, Enable, BIn1, Bin2, BIn3, GIn, BOutNew)
	    ) 
        )
    []
      [GIn eq not (Enable)] -> 
        Op ? other: Bit;
        Enable3Aux [Ip1, Ip2, Ip3, G, Op]
	 (BOp, Enable, BIn1, BIn2, BIn3, GIn, other)
    endproc (* Enable3Aux *)
  endproc (* Enable3 *)
')') 

define(Enable4_Decl, `declare(`$0', `
  process Enable4 [Ip1, Ip2, Ip3, Ip4, G, Op] (BOp : BitOp, Enable : Bit) : noexit :=
    Enable4Aux [Ip1, Ip2, Ip3, Ip4, G, Op] 
     (BOp, Enable, X of bit, X of bit, X of bit, X of bit, X of bit, X of bit)
 
    where
 
    process Enable4Aux [Ip1, Ip2, Ip3, Ip4, G, Op] 
     (BOp : BitOp, Enable : Bit, BIn1, BIn2, BIn3, BIn4, GIn, BOut : Bit) : noexit :=
      Ip1 ? BIn1New : Bit;
      Enable4Aux [Ip1, Ip2, Ip3, Ip4, G, Op]
       (BOp, Enable, BIn1New, BIn2, BIn3, BIn4, GIn, BOut)
    []
      Ip2 ? BIn2New : Bit;
      Enable4Aux [Ip1, Ip2, Ip3, Ip4, G, Op]
       (BOp, Enable, BIn1, BIn2New, BIn3, BIn4, GIn, BOut)
    []
      Ip3 ? BIn3New : Bit;
      Enable4Aux [Ip1, Ip2, Ip3, Ip4, G, Op]
       (BOp, Enable, BIn1, BIn2, BIn3New, BIn4, GIn, BOut)
    []
      Ip4 ? BIn4New : Bit;
      Enable4Aux [Ip1, Ip2, Ip3, Ip4, G, Op]
       (BOp, Enable, BIn1, BIn2, BIn3, BIn4New, GIn, BOut)
    []
      G ? GInNew : Bit;
      Enable4Aux [Ip1, Ip2, Ip3, Ip4, G, Op]
       (BOp, Enable, BIn1, BIn2, BIn3, BIn4, GInNew, BOut)
    []
      [GIn eq Enable] ->
        (
	  let BOutNew : Bit = Apply (BOp, BIn1, BIn2, BIn3, BIn4) in
	    (
	      [(BOutNew ne X of bit) and (BOutNew ne BOut)] ->
	        Op ! BOutNew;  
	        Enable4Aux [Ip1, Ip2, Ip3, Ip4, G, Op] 
	         (BOp, Enable, BIn1, Bin2, BIn3, BIn4, GIn, BOutNew)
	    []
	      [(BOutNew eq X of bit) and (BOut eq X of bit)] ->
	        Op ? BOutNew : Bit [BOutNew ne X of bit];
	        Enable4Aux [Ip1, Ip2, Ip3, Ip4, G, Op] 
	         (BOp, Enable, BIn1, Bin2, BIn3, BIn4, GIn, BOutNew)
	    )
        )
    []
      [GIn eq not (Enable)] -> 
        Op ? other: Bit;
        Enable4Aux [Ip1, Ip2, Ip3, Ip4, G, Op] 
         (BOp, Enable, BIn1, BIn2, BIn3, BIn4, GIn, other)
    endproc (* Enable4Aux *)
  endproc (* Enable4 *)
')')

define(Enable8_Decl, `declare(`$0', `
  process Enable8 [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
   (BOp:BitOp, Enable:Bit) : noexit :=
    Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
     (BOp, Enable, X of bit, X of bit, X of bit, X of bit, X of bit, X of bit,
      X of bit, X of bit, X of bit, X of bit)
  
  where

    process Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
     (BOp : BitOp, Enable : Bit, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7,
      BIn8, GIn, BOut : Bit) : noexit :=
      Ip1 ? BIn1New : Bit;
      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
       (BOp, Enable, BIn1New, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8, GIn, BOut)
    []
      Ip2 ? BIn2New : Bit;
      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
       (BOp, Enable, BIn1, BIn2New, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8, GIn, BOut)
    []
      Ip3 ? BIn3New : Bit;
      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
       (BOp, Enable, BIn1, BIn2, BIn3New, BIn4, BIn5, BIn6, BIn7, BIn8, GIn, BOut)
    []
      Ip4 ? BIn4New : Bit;
      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
       (BOp, Enable, BIn1, BIn2, BIn3, BIn4New, BIn5, BIn6, BIn7, BIn8, GIn, BOut)
    []
      Ip5 ? BIn5New : Bit;
      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
       (BOp, Enable, BIn1, BIn2, BIn3, BIn4, BIn5New, BIn6, BIn7, BIn8, GIn, BOut)
    []
      Ip6 ? BIn6New : Bit;
      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
       (BOp, Enable, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6New, BIn7, BIn8, GIn, BOut)
    []
      Ip7 ? BIn7New : Bit;
      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
       (BOp, Enable, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7New, BIn8, GIn, BOut)
    []
      Ip8 ? BIn8New : Bit;
      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
       (BOp, Enable, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8New, GIn, BOut)
    []
      G ? GInNew : Bit;
      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
       (BOp, Enable, BIn1, BIn2, BIn3, BIn4, BIn5, BIn6, BIn7, BIn8, GInNew, BOut)
    []
      [GIn eq Enable] ->
        (
	  let BOutNew : Bit = Apply (BOp, BIn1, BIn2, BIn3, BIn4, Bin5, BIn6, BIn7, Bin8) in
	  (
	    [(BOutNew ne X of bit) and (BOutNew ne BOut)] ->
	      Op ! BOutNew [BOutNew ne BOut];  
	      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
	       (BOp, Enable, BIn1, Bin2, BIn3, BIn4, Bin5, BIn6, BIn7, Bin8, GIn, BOutNew)
	  []
	    [(BOutNew eq X of bit) and (BOut eq X of bit)] ->
	      Op ? BOutNew : Bit  [BOutNew ne X of bit];
	      Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
	       (BOp, Enable, BIn1, Bin2, BIn3, BIn4, Bin5, BIn6, BIn7, Bin8, GIn, BOutNew)
	  )
        )
    []
      [GIn ne Enable] -> 
	Op ? other: Bit;
	Enable8Aux [Ip1, Ip2, Ip3, Ip4, Ip5, Ip6, Ip7, Ip8, G, Op] 
	 (BOp, Enable, BIn1, BIn2, BIn3, BIn4, Bin5, BIn6, BIn7, Bin8, GIn, other)
    endproc (* Enable8Aux *)
  endproc (* Enable8 *)
')')

################################ Unary Gates ################################

define(Inverter_One_Decl, `Enable_Decl(inverter, one)')

define(Inverter_Zero_Decl, `Enable_Decl(inverter, zero)')

define(Repeater_One_Decl, `Enable_Decl(repeater, one)')
  
define(Repeater_Zero_Decl, `Enable_Decl(repeater, zero)')

define(Inverter_One_4_Decl, `declare(`$0', `Inverter_One_Decl
  process Inverter_One_4 [MWire(4, Inp), En, MWire(4, Oup)] : noexit :=
    MComp(4, En=, `Inverter_One[Inp, En=, Oup]')
  endproc (* Inverter_One_4 *)
')')

define(Inverter_Zero_4_Decl, `declare(`$0', `Inverter_Zero_Decl
  process Inverter_Zero_4 [MWire(4, Inp), En, MWire(4, Oup)] : noexit :=
    MComp(4, En=, `Inverter_Zero[Inp, En=, Oup]')
  endproc (* Inverter_Zero_4 *)
')')

define(Inverter_One_8_Decl, `declare(`$0', `Inverter_One_Decl
  process Inverter_One_8 [MWire(8, Inp), En, MWire(8, Oup)] : noexit :=
    MComp(8, En=, `Inverter_One[Inp, En=, Oup]')
  endproc (* Inverter_One_8 *)
')')

define(Inverter_Zero_8_Decl, `declare(`$0', `Inverter_Zero_Decl
  process Inverter_Zero_8 [MWire(8, Inp), En, MWire(8, Oup)] : noexit :=
    MComp(8, En=, `Inverter_Zero[Inp, En=, Oup]')
  endproc (* Inverter_Zero_8 *)
')')

define(Repeater_One_4_Decl, `declare(`$0', `Repeater_One_Decl
  process Repeater_One_4 [MWire(4, Inp), En, MWire(4, Oup)] : noexit :=
    MComp(4, En=, `Repeater_One[Inp, En=, Oup]')
  endproc (* Repeater_One_4 *)
')')

define(Repeater_Zero_4_Decl, `declare(`$0', `Repeater_Zero_Decl
  process Repeater_Zero_4 [MWire(4, Inp), En, MWire(4, Oup)] : noexit :=
    MComp(4, En=, `Repeater_Zero[Inp, En=, Oup]')
  endproc (* Repeater_Zero_4 *) ')')

define(Repeater_One_8_Decl, `declare(`$0', `Repeater_One_Decl
  process Repeater_One_8 [MWire(8, Inp), En, MWire(8, Oup)] : noexit :=
   MComp(8, En=, `Repeater_One[Inp, En=, Oup]')
  endproc (* Repeater_One_8 *)
')')

define(Repeater_Zero_8_Decl, `declare(`$0', `Repeater_Zero_Decl
  process Repeater_Zero_8 [MWire(8, Inp), En, MWire(8, Oup)] : noexit :=
    MComp(8, En=, `Repeater_Zero[Inp, En=, Oup]')
  endproc (* Repeater_Zero_8 *)
')')

################################ Binary Gates ################################

define(And2_One_Decl, `Enable_Decl(and, one, 2)')

define(And2_Zero_Decl, `Enable_Decl(and, zero, 2)')

define(Nand2_One_Decl, `Enable_Decl(nand, one, 2)')

define(Nand2_Zero_Decl, `Enable_Decl(nand, zero, 2)')

define(Or2_One_Decl, `Enable_Decl(or, one, 2)')

define(Or2_Zero_Decl, `Enable_Decl(or, zero, 2)')

define(Nor2_One_Decl, `Enable_Decl(nor, one, 2)')

define(Nor2_Zero_Decl, `Enable_Decl(nor, zero, 2)')

define(Xor2_One_Decl, `Enable_Decl(xor, one, 2)')

define(Xor2_Zero_Decl, `Enable_Decl(xor, zero, 2)')

define(Xnor2_One_Decl, `Enable_Decl(xnor, one, 2)')

define(Xnor2_Zero_Decl, `Enable_Decl(xnor, zero, 2)')

############################### Ternary Gates ###############################

define(And3_One_Decl, `Enable_Decl(and, one, 3)')

define(And3_Zero_Decl, `Enable_Decl(and, zero, 3)')

define(Nand3_One_Decl, `Enable_Decl(nand, one, 3)')

define(Nand3_Zero_Decl, `Enable_Decl(nand, zero, 3)')

define(Or3_One_Decl, `Enable_Decl(or, one, 3)')

define(Or3_Zero_Decl, `Enable_Decl(or, zero, 3)')

define(Nor3_One_Decl, `Enable_Decl(nor, one, 3)')

define(Nor3_Zero_Decl, `Enable_Decl(nor, zero, 3)')

define(Xor3_One_Decl, `Enable_Decl(xor, one, 3)')

define(Xor3_Zero_Decl, `Enable_Decl(xor, zero, 3)')

define(Xnor3_One_Decl, `Enable_Decl(xnor, one, 3)')

define(Xnor3_Zero_Decl, `Enable_Decl(xnor, zero, 3)')

############################## Quaternary Gates ##############################

define(And4_One_Decl, `Enable_Decl(and, one, 4)')

define(And4_Zero_Decl, `Enable_Decl(and, zero, 4)')

define(Nand4_One_Decl, `Enable_Decl(nand, one, 4)')

define(Nand4_Zero_Decl, `Enable_Decl(nand, zero, 4)')
 
define(Or4_One_Decl, `Enable_Decl(or, one, 4)')

define(Or4_Zero_Decl, `Enable_Decl(or, zero, 4)')

define(Nor4_One_Decl, `Enable_Decl(nor, one, 4)')

define(Nor4_Zero_Decl, `Enable_Decl(nor, zero, 4)')

define(Xor4_One_Decl, `Enable_Decl(xor, one, 4)')

define(Xor4_Zero_Decl, `Enable_Decl(xor, zero, 4)')

define(Xnor4_One_Decl, `Enable_Decl(xnor, one, 4)')

define(Xnor4_Zero_Decl, `Enable_Decl(xnor, zero, 4)')

############################## Octonary Gates ##############################

define(And8_One_Decl, `Enable_Decl(and, one, 8)')

define(And8_Zero_Decl, `Enable_Decl(and, zero, 8)')

define(Nand8_One_Decl, `Enable_Decl(nand, one, 8)')

define(Nand8_Zero_Decl, `Enable_Decl(nand, zero, 8)')

define(Or8_One_Decl, `Enable_Decl(or, one, 8)')

define(Or8_Zero_Decl, `Enable_Decl(or, zero, 8)')

define(Nor8_One_Decl, `Enable_Decl(nor, one, 8)')

define(Nor8_Zero_Decl, `Enable_Decl(nor, zero, 8)')

define(Xor8_One_Decl, `Enable_Decl(xor, one, 8)')

define(Xor8_Zero_Decl, `Enable_Decl(xor, zero, 8)')

define(Xnor8_One_Decl, `Enable_Decl(xnor, one, 8)')

define(Xnor8_Zero_Decl, `Enable_Decl(xnor, zero, 8)')
