################################### Header ###################################

# "dill_latch.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach. Bit states (but not signals) may have an "X" (unknown)
# value - generally for their initial condition.
#
# This particular file deals with latches (RS with optional clock and data
# inputs, D).

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

################################## Latches ###################################

# "RSLatch_Decl" defines a reset-set flip-flop

define(RSLatch_Decl,`declare(`$0',`Nor2_Decl
  process RSLatch [R, S, Q, Qbar] : noexit :=
    Nor2 [R, Qbar, Q]
  |[Q, Qbar]|
    Nor2 [S, Q, Qbar]
  endproc (* RSLatch *)
')')

# "CRSLatch_Decl" defines a clocked reset-set flip-flop

define(CRSLatch_Decl,`declare(`$0',`And2_Decl`'RSLatch_Decl
  process CRSLatch [R, S, C, Q, Qbar] : noexit :=
    hide Rint, Sint in
      (
        And2 [R, C, Rint]
      |[C]|
        And2 [S, C, Sint]
      )
    |[Rint, Sint]|
      RSLatch [Rint, Sint, Q, Qbar]
  endproc (* CRSLatch *)
')')

# "DRSLatch_Decl" defines a reset-set latch with data input

define(DRSLatch_Decl,`declare(`$0',`Nor3_Decl
  process DRSLatch [R, S, D0, D1, Q, Qbar] : noexit :=
    Nor3 [R, D0, Qbar, Q]
  |[Q, Qbar]|
    Nor3 [S, D1, Q, Qbar]
  endproc (* DRSLatch *)
')')

# "CDRSLatch_Decl" defines a clocked reset-set latch with data input

define(CDRSLatch_Decl,`declare(`$0',`And2_Decl`'DRSLatch_Decl
  process CDRSLatch [R, S, D0, D1, C, Q, Qbar] : noexit :=
    hide D0int, D1int in
      (
        And2 [D0, C, D0int]
      |[C]|
        And2 [D1, C, D1int]
      )
    |[D0int, D1int]|
      DRSLatch [R, S, D0int, D1int, Q, Qbar]
  endproc (* CDRSLatch *)
')')

# "DLatch_Decl" defines a delay latch

define(DLatch_Decl,`declare(`$0',`Inverter_Decl`'And2_Decl`'RSLatch_Decl
  process DLatch [D, C, Q, Qbar] : noexit :=
    hide Rint, Sint, Dint in
      (
        And2 [D, C, Sint]
      |[D, C]|
        (
	  Inverter [D, Dint]
	|[Dint]|
	  And2 [Dint, C, Rint]
	)
      )
    |[Rint, Sint]|
      RSLatch [Rint, Sint, Q, Qbar]
  endproc (* DLatch *)
')')

# " Latch_PreClr_Decl" defines a RS_latch with pre_set and pre_clear inputs
#  pre_set and pre_clear are 0 active.

define(Latch_PreClr_Decl, `declare(`$0', `Nand3_Decl
  process Latch_PreClr [R, S, Preset, Clear, Ck, Q, Qbar] :noexit :=
    hide Rint, Sint in
      (Nand3 [S, Clear, Ck, Sint] |[Ck]| Nand3 [R, Preset, Ck, Rint])
   |[Rint, Sint, Preset, Clear]|
      (Nand3 [Sint, Preset, Qbar, Q] |[Q, Qbar]| Nand3 [Rint, Clear, Q, Qbar])
  endproc (* Latch_PreClr *)
')')

# "DLatch4_Decl" defines a 4 bits D Latch.

define(DLatch4_Decl, `declare(`$0', `DLatch_Decl
  process DLatch4 [MWire(4, D), G, MWire(4, Q)] :noexit :=
    hide MWire(4, Qbar) in
      MComp(4, G=, `DLatch [D, G=, Q, Qbar]')
  endproc (*  DLatch4 *)
')')

# "DLatch8_Decl" defines a 8 bits D Latch.

define(DLatch8_Decl, `declare(`$0', `DLatch_Decl
  process DLatch8 [MWire(8, D), G, MWire(8, Q)] :noexit :=
    hide MWire(8, Qbar) in
      MComp(8, G=, `DLatch [D, G=, Q, Qbar]')
  endproc (*  DLatch8 *)
')')
