################################### Header ###################################

# "dill_latch_bb_wb.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with the black-box and white-box forms of latches
# (RS with optional clock and data inputs, D).

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

################################## Latches ###################################

# "RSLatch_WB_Decl" defines a reset-set flip-flop:
# 
#    R=1 S=0 => Q=0 Qbar=1 reset 
#    R=0 S=1 => Q=1 Qbar=0 set
#    R=0 S=0 => no change on outputs
#    R=1 S=1 => Q=0 Qbar=0 unstable state, which means if R and S change to 0 
#    synchronously,the outputs are undecidable,either Q=1 Qbar=0 or Q=0 or
#    Qbar=1

define(RSLatch_WB_Decl, `declare(`$0', `
  process RSLatch_WB [R, S, Q, Qbar] : noexit :=
    RSLatch_WB_Aux [R, S, Q, Qbar] (X of bit, X of bit, X of bit, X of bit) 
  
    where
    
    process RSLatch_WB_Aux [R, S, Q, Qbar] (dtR, dtS, dtQ, dtQbar:Bit) :noexit :=
      R ? newdtR: Bit;
      RSLatch_WB_Aux [R, S, Q, Qbar] (newdtR, dtS, dtQ, dtQbar)
    []
      S ? newdtS: Bit;
      RSLatch_WB_Aux [R, S, Q, Qbar] (dtR, newdtS, dtQ, dtQbar)
    []
      (
        let newdtQ : Bit = dtR nor dtQbar, 
	    newdtQbar: Bit = dtS nor dtQ in
	  (
	    [(dtQ eq X) and (newdtQ eq X)] ->
	      Q ? newdtQ : Bit [newdtQ ne X];
	      RSLatch_WB_Aux [R, S, Q, Qbar] (dtR, dtS, newdtQ, dtQbar)
	  []
	    [(newdtQ ne X) and (newdtQ ne dtQ)] ->
	      Q ! newdtQ;
	      RSLatch_WB_Aux [R, S, Q, Qbar] (dtR, dtS, newdtQ, dtQbar)
	  []
	    [(dtQbar eq X) and (newdtQbar eq X)] ->
	      Qbar ? newdtQbar : Bit [newdtQbar ne X];
	      RSLatch_WB_Aux [R, S, Q, Qbar] (dtR, dtS, dtQ, newdtQbar)
	  []
	    [(newdtQbar ne X) and (newdtQbar ne dtQbar)] ->
	      Qbar ! newdtQbar;
	      RSLatch_WB_Aux [R, S, Q, Qbar] (dtR, dtS, dtQ, newdtQbar)
	  )
      )
    endproc (* RSLatch_WB_Aux *)     
  endproc (* RSLatch_WB *)
')')

# "RSLatch_BB_Decl" is an alternative definition of RSLatch

define(RSLatch_BB_Decl, `declare(`$0', `
  process RSLatch_BB [R, S, Q, Qbar] : noexit :=
  
    RSLatch_BB_Aux [R, S, Q, Qbar] (X of bit, X of bit, X of bit, X of bit) 
    
    where
    
    process RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, dtS, dtQ, dtQbar:Bit) :noexit :=
      R ? newdtR: Bit;
      RSLatch_BB_Aux [R, S, Q, Qbar] (newdtR, dtS, dtQ, dtQbar)
    []
      S ? newdtS: Bit;
      RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, newdtS, dtQ, dtQbar)
    []
      (
	[(dtR eq 1) and (dtS eq 0 of bit) and (dtQ ne 0 of bit)] -> (* reset *)
	  Q ! 0 of bit ;
	  RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, dtS, 0 of bit, dtQbar)
      []
	[(dtR eq 1) and (dtS eq 0 of bit) and (dtQbar ne 1)] ->
	  Qbar! 1 of bit;
	  RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, dtS, dtQ, 1 of bit)
      []				(* set *)
	[(dtR eq 0 of bit) and (dtS eq 1) and (dtQ ne 1)] ->
	  Q ! 1 of bit;
	  RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, dtS, 1 of bit, dtQbar)
      [] 
	[(dtR eq 0 of bit) and (dtS eq 1) and (dtQbar ne 0 of bit)] ->
	  Qbar ! 0 of bit;
	  RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, dtS, dtQ, 0 of bit)
      []				(* no change *)
	(* R, S return to their active level synchronously from the unstable state *)
	[(dtR eq 0 of bit) and (dtS eq 0 of bit) and 
	 (dtQ eq 0 of bit) and (dtQbar eq 0 of bit)] ->
	  (
	    i;
	    Q ! 1 of bit;
	    RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, dtS, 1 of bit, dtQbar)
	  []
	    i;
	    Qbar ! 1 of bit;
	    RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, dtS, dtQ, 1 of bit)
	  )
      []				(* initialize *)
        [(dtR eq 0 of bit) and (dtS eq 0 of bit) and (dtQ eq X)] ->
	  (
	    (
	      Q ? newdtQ : Bit [newdtQ ne X];
	      exit (newdtQ, any bit)
	    |||
	      Qbar ? newdtQbar : Bit [newdtQbar ne X];
	      exit (any bit, newdtQbar)
	    )
	  >>
	    accept newdtQ, newdtQbar : Bit in
	      RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, dtS, newdtQ, newdtQbar)
	  )
      []				(* R=1 S=1 *)
	[(dtR eq 1) and (dtS eq 1) and (dtQ ne 0 of bit)]->
	  Q ! 0 of bit;
	  RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, dtS, 0 of bit, dtQbar)
      []
	[(dtR eq 1) and (dtS eq 1) and (dtQbar ne 0 of bit)]->
	  Qbar ! 0 of bit;
	  RSLatch_BB_Aux [R, S, Q, Qbar] (dtR, dtS, dtQ, 0 of bit)
      )   
    endproc (* RSLatch_BB_Aux *)     
  endproc (* RSLatch_BB *)
')')

# "CRSLatch_WB_Decl" defines a clocked reset-set flip-flop. There could also
# be an alternative definition like "RSLatch_WB". Be careful that 
# there are two situations in which undecidability may occur: from R=S=1
# to R=S=0 or to C=0.

define(CRSLatch_WB_Decl, `declare(`$0', `
  process CRSLatch_WB [R, S, C, Q, Qbar] : noexit :=
    CRSLatch_WB_Aux [R, S, C, Q, Qbar]
     (X of bit, X of bit, X of bit, X of bit, X of bit)

    where
    
    process CRSLatch_WB_Aux [R, S, C, Q, Qbar]
     (dtR, dtS, dtC, dtQ, dtQbar: Bit):noexit:=
      R ? newdtR: Bit;
      CRSLatch_WB_Aux [R, S, C, Q, Qbar] (newdtR, dtS, dtC, dtQ, dtQbar)
    []
      S ? newdtS: Bit;
      CRSLatch_WB_Aux [R, S, C, Q, Qbar] (dtR, newdtS, dtC, dtQ, dtQbar)
    []
      C ? newdtC : Bit;
      CRSLatch_WB_Aux [R, S, C, Q, Qbar] (dtR, dtS, newdtC, dtQ, dtQbar)
    []
      (
        let newdtQ : Bit = (dtC and dtR) nor dtQbar, 
	    newdtQbar: Bit = (dtC and dtS) nor dtQ in
	(
	  [(newdtQ eq X) and (dtQ eq X)] ->
	    Q ? newdtQ : Bit [newdtQ ne X];
	    CRSLatch_WB_Aux [R, S, C, Q, Qbar] (dtR, dtS, dtC, newdtQ, dtQbar)
	[]
	  [(newdtQ ne X) and (newdtQ ne dtQ)] ->
	    Q ! newdtQ;
	    CRSLatch_WB_Aux [R, S, C, Q, Qbar] (dtR, dtS, dtC, newdtQ, dtQbar)
	[]
	  [(newdtQbar eq X) and (dtQbar eq X)] ->
	    Qbar ? newdtQbar : Bit [newdtQbar ne X];
	    CRSLatch_WB_Aux [R, S, C, Q, Qbar] (dtR, dtS, dtC, dtQ, newdtQbar)
	[]
	  [(newdtQbar ne X) and (newdtQbar ne dtQbar)] ->
	    Qbar ! newdtQbar;
	    CRSLatch_WB_Aux [R, S, C, Q, Qbar] (dtR, dtS, dtC, dtQ, newdtQbar)
	)
      ) 
    endproc (* CRSLatch_WB_Aux *)      
  endproc (* CRSLatch_WB *)
')')

# "DRSLatch_WB_Decl" defines a reset-set flip-flop with data input

define(DRSLatch_WB_Decl, `declare(`$0', `
  process DRSLatch_WB [R, S, D0, D1, Q, Qbar] : noexit :=
    DRSLatch_WB_Aux [R, S, D0, D1, Q, Qbar]
     (X of bit, X of bit, X of bit, X of bit, X of bit, X of bit)

    where
    
    process DRSLatch_WB_Aux [R, S, D0, D1, Q, Qbar]
     (dtR, dtS, dtD0, dtD1, dtQ, dtQbar: Bit) : noexit:=
      R ? newdtR: Bit;
      DRSLatch_WB_Aux [R, S, D0, D1, Q, Qbar]
       (newdtR, dtS, dtD0, dtD1, dtQ, dtQbar)
    []
      S ? newdtS: Bit;
      DRSLatch_WB_Aux [R, S, D0, D1, Q, Qbar]
       (dtR, newdtS, dtD0, dtD1, dtQ, dtQbar)
    []
      D0 ? newdtD0 : Bit;
      DRSLatch_WB_Aux [R, S, D0, D1, Q, Qbar]
       (dtR, dtS, newdtD0, dtD1, dtQ, dtQbar)
    []
      D1 ? newdtD1 : Bit;
      DRSLatch_WB_Aux [R, S, D0, D1, Q, Qbar]
       (dtR, dtS, dtD0, newdtD1, dtQ, dtQbar)
    []
      (
        let newdtQ : Bit = not(dtR or dtD0 or dtQbar), 
	    newdtQbar: Bit = not(dtS or dtD1 or dtQ) in
	    
	(
	  [(newdtQ eq X) and (dtQ eq X)] ->
	    Q ? newdtQ : Bit [newdtQ ne X];
	    DRSLatch_WB_Aux [R, S, D0, D1, Q, Qbar]
	     (dtR, dtS, dtD0, dtD1, newdtQ, dtQbar)
	[]
	  [(newdtQ ne X) and (newdtQ ne dtQ)] ->
	    Q ! newdtQ;
	    DRSLatch_WB_Aux [R, S, D0, D1, Q, Qbar]
	    (dtR, dtS, dtD0, dtD1, newdtQ, dtQbar)
	[]
	  [(newdtQbar eq X) and (dtQbar eq X)] ->
	    Qbar ? newdtQbar : Bit [newdtQbar ne X];
	    DRSLatch_WB_Aux [R, S, D0, D1, Q, Qbar]
	     (dtR, dtS, dtD0, dtD1, dtQ, newdtQbar)
	[]
	  [(newdtQbar ne X) and (newdtQbar ne dtQbar)] ->
	    Qbar ! newdtQbar;
	    DRSLatch_WB_Aux [R, S, D0, D1, Q, Qbar]
	     (dtR, dtS, dtD0, dtD1, dtQ, newdtQbar)
	)
      )  
    endproc (* DRSLatch_WB_Aux *)      
  endproc (* DRSLatch_WB *)
')')

# "CDRSLatch_WB_Decl" defines a clocked reset-set flip-flop with data input

define(CDRSLatch_WB_Decl, `
  process CDRSLatch_WB [R, S, D0, D1, C, Q, Qbar] : noexit :=
    CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
     (X of bit, X of bit, X of bit, X of bit, X of bit, X of bit, X of bit)

    where
    
    process CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
     (dtR, dtS, dtD0, dtD1, dtC, dtQ, dtQbar: Bit):noexit:=
      R ? newdtR: Bit;
      CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
       (newdtR, dtS, dtD0, dtD1, dtC, dtQ, dtQbar)
    []
      S ? newdtS: Bit;
      CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
       (dtR, newdtS, dtD0, dtD1, dtC, dtQ, dtQbar)
    []
      D0 ? newdtD0 : Bit;
      CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
       (dtR, dtS, newdtD0, dtD1, dtC, dtQ, dtQbar)
    []
      D1 ? newdtD1 : Bit;
      CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
       (dtR, dtS, dtD0, newdtD1, dtC, dtQ, dtQbar)
    []
      C ? newdtC : Bit;
      CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
       (dtR, dtS, dtD0, dtD1, newdtC, dtQ, dtQbar)
    []
      (
        let newdtQ : Bit = not(dtR or (dtD0 and dtC) or dtQbar), 
	    newdtQbar: Bit = not(dtS or (dtD1 and dtC) or dtQ) in
	    
	(
	  [(newdtQ eq X) and (dtQ eq X)] ->
	    Q ? newdtQ : Bit [newdtQ ne X];
	    CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
	     (dtR, dtS, dtD0, dtD1, dtC, newdtQ, dtQbar)
	[]
	  [(newdtQ ne X) and (newdtQ ne dtQ)] ->
	    Q ! newdtQ;
	    CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
	     (dtR, dtS, dtD0, dtD1, dtC, newdtQ, dtQbar)
	[]
	  [(newdtQbar eq X) and (dtQbar eq X)] ->
	    Qbar ? newdtQbar : Bit [newdtQbar ne X];
	    CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
	     (dtR, dtS, dtD0, dtD1, dtC, dtQ, newdtQbar)
	[]
	  [(newdtQbar ne X) and (newdtQbar ne dtQbar)] ->
	    Qbar ! newdtQbar;
	    CDRSLatch_WB_Aux [R, S, D0, D1, C, Q, Qbar]
	     (dtR, dtS, dtD0, dtD1, dtC, dtQ, newdtQbar)
	)
      )  
    endproc (* CDRSLatch_WB_Aux *)      
  endproc (* CDRSLatch_WB *)
')')

# "DLatch_WB_Decl" defines a delay latch

define(DLatch_WB_Decl, `
  process DLatch_WB [D, C, Q, Qbar] : noexit :=
    DLatch_WB_Aux [D, C, Q, Qbar] (X of bit, X of bit, X of bit, X of bit)
  
    where
    
    process DLatch_WB_Aux [D, C, Q, Qbar]
     (dtD, dtC, dtQ, dtQbar: Bit ) : noexit :=
      D ? newdtD : Bit ;
      DLatch_WB_Aux [D, C, Q, Qbar] (newdtD, dtC, dtQ, dtQbar)
    []
      C ? newdtC : Bit;
      DLatch_WB_Aux [D, C, Q, Qbar] (dtD, newdtC, dtQ, dtQbar)
    []
      (
        let newdtQ : Bit =  not(dtQbar or (not(dtD) and dtC)), 
	    newdtQbar : Bit = not(dtQ or (dtD and dtC)) in
	(
	  [(newdtQ eq X) and (dtQ eq X)] ->
	    Q ? newdtQ : Bit [newdtQ ne X];
	    DLatch_WB_Aux [D, C, Q, Qbar] (dtD, dtC, newdtQ, dtQbar)
	[]
	  [(newdtQ ne X) and (newdtQ ne dtQ)] ->
	    Q ! newdtQ;
	    DLatch_WB_Aux [D, C, Q, Qbar] (dtD, dtC, newdtQ, dtQbar)
	[]
	  [(newdtQbar eq X) and (dtQbar eq X)] ->
	    Qbar ? newdtQbar : Bit [newdtQbar ne X];
	    DLatch_WB_Aux [D, C, Q, Qbar] (dtD, dtC, dtQ, newdtQbar)
	[]
	  [(newdtQbar ne X) and (newdtQbar ne dtQbar)] ->
	    Qbar ! newdtQbar;
	    DLatch_WB_Aux [D, C, Q, Qbar] (dtD, dtC, dtQ, newdtQbar)
	)
      )
    endproc (* DLatch_WB_Aux *)
  endproc (* DLatch_WB *)
')')

# " Latch_WB_PreClr_Decl" defines a RS_latch with asynchronous pre_set and
# pre_clear inputs pre_set and pre_clear are 0 active.

define(Latch_WB_PreClr_Decl, `
  process Latch_WB_PreClr[R, S, Preset, Clear, Ck, Q, Qbar] :noexit :=
    Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar] 
    (X of bit, X of bit, X of bit, X of bit, X of bit, X of bit, X of bit) 
  
    where
    
    process Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar]
	      (dtR, dtS, dtPreset, dtClear, dtCk, dtQ, dtQbar:Bit) : noexit :=
      R ? newdtR : Bit;
      Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar]
       (newdtR, dtS, dtPreset, dtClear, dtCk, dtQ, dtQbar)
    []
      S ? newdtS : Bit;
      Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar]
       (dtR, newdtS, dtPreset, dtClear, dtCk, dtQ, dtQbar)
    []
      Preset ? newdtPreset :  Bit;
      Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar]
       (dtR, dtS, newdtPreset, dtClear, dtCk, dtQ, dtQbar)  
    []
      Clear ? newdtClear : Bit;
      Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar]
       (dtR, dtS, dtPreset, newdtClear, dtCk, dtQ, dtQbar)
    []
      Ck ? newdtCk : Bit;
      Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar]
       (dtR, dtS, dtPreset, dtClear, newdtCk, dtQ, dtQbar)
    []
      (
        let newdtQ : Bit =
	 not (dtQbar and dtPreset and not (dtS and dtClear and dtCk)), 
	  newdtQbar : Bit =
	   not (dtQ and dtClear and not (dtR and dtPreset and dtCk)) in
          (
	    [(newdtQ eq X) and (dtQ eq X)] ->
	      Q ? newdtQ : Bit [newdtQ ne X];
	      Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar]
	       (dtR, dtS, dtPreset, dtClear, dtCk, newdtQ, dtQbar)
	  []
	    [(newdtQ ne X) and (newdtQ ne dtQ)] -> 
	      Q ! newdtQ;
	      Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar]
	       (dtR, dtS, dtPreset, dtClear, dtCk, newdtQ, dtQbar)
	  []
	    [(newdtQ eq X) and (dtQbar eq X)] ->
	      Qbar ? newdtQbar : Bit [newdtQbar ne X];
	      Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar]
	       (dtR, dtS, dtPreset, dtClear, dtCk, dtQ, newdtQbar)
	  []
	    [(newdtQbar ne X) and (newdtQbar ne dtQbar)] -> 
	      Qbar ! newdtQbar;
	      Latch_WB_PreClr_Aux [R, S, Preset, Clear, Ck, Q, Qbar]
	       (dtR, dtS, dtPreset, dtClear, dtCk, dtQ, newdtQbar)
          )
      )
    endproc (* Latch_WB_PreClr_Aux *)
  endproc (* Latch_WB_PreClr *)
')')

# "DLatch4_BB_Decl" defines a 4 bit D Latch

define(DLatch4_BB_Decl, `declare(`$0', `
  process DLatch4_BB[MWire(4, D), G, MWire(4, Q)] :noexit :=
    DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0] (MWire(9, X of bit=))
 
    where
 
    process DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
     (dtD3, dtD2, dtD1, dtD0, dtG, dtQ3, dtQ2, dtQ1, dtQ0:Bit) : noexit :=
      D3 ? newdtD3 : Bit;
      DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
       (newdtD3, dtD2, dtD1, dtD0, dtG, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      D2 ? newdtD2 : Bit;
      DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
       (dtD3, newdtD2, dtD1, dtD0, dtG, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      D1 ? newdtD1: Bit;
      DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
       (dtD3, dtD2, newdtD1, dtD0, dtG, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      D0 ? newdtD0 : Bit;
      DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
       (dtD3, dtD2, dtD1, newdtD0, dtG, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      G ? newdtG : Bit;
      DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
       (dtD3, dtD2, dtD1, dtD0, newdtG, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtQ3 ne dtD3) and (dtD3 ne X)] ->
	Q3 ! dtD3 ;
	DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
	 (dtD3, dtD2, dtD1, dtD0, dtG, dtD3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtQ2 ne dtD2) and (dtD2 ne X)] ->
	Q2 ! dtD2 ;
	DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
	 (dtD3, dtD2, dtD1, dtD0, dtG, dtQ3, dtD2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtQ1 ne dtD1) and (dtD1 ne X)] ->
      Q1 ! dtD1 ;
      DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
       (dtD3, dtD2, dtD1, dtD0, dtG, dtQ3, dtQ2, dtD1, dtQ0)
    []
      [(dtG eq 1) and (dtQ0 ne dtD0) and (dtD0 ne X)] ->
	Q0 ! dtD0 ;
	DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
	 (dtD3, dtD2, dtD1, dtD0, dtG, dtQ3, dtQ2, dtQ1, dtD0)
    []					(* initialize *)
      [(dtQ3 eq X) and ((dtD3 eq X) or (dtD2 eq X) or 
       (dtD1 eq X) or (dtD0 eq X) or (dtG eq X))] ->
	(
	  (
	    Q3 ? newdtQ3 : Bit [newdtQ3 ne X]; 
	    exit (newdtQ3, any bit, any bit, any bit)
	  |||
	    Q2 ? newdtQ2 : Bit [newdtQ2 ne X];
	    exit (any bit, newdtQ2, any bit, any bit)
	  |||
	    Q1 ? newdtQ1 : Bit [newdtQ1 ne X]; 
	    exit (any bit, any bit, newdtQ1, any bit)
	  |||
	    Q0 ? newdtQ0 : Bit [newdtQ0 ne X]; 
	    exit (any bit, any bit, any bit, newdtQ0)
	  )
	>>
	  accept newdtQ3, newdtQ2, newdtQ1, newdtQ0 : Bit in
	    DLatch4_BB_Aux [D3, D2, D1, D0, G, Q3, Q2, Q1, Q0]
	     (MWire(4, dtD), dtG, MWire(4, newdtQ))
	) 
    endproc (* DLatch4_BB_Aux *)   
  endproc (*  DLatch4_BB *)
')')

# "DLatch8_BB_Decl" defines a 8 bits D Latch

define(DLatch8_BB_Decl, `declare(`$0', `DLatch_Decl
  process DLatch8_BB[MWire(8, D), G, MWire(8, Q)] :noexit :=
    DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)] 
     (MWire(8, X of bit=), X of bit, MWire(8, X of bit=))
 
    where
    
    process DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	      (MWire(8, dtD), dtG, MWire(8, dtQ):Bit) : noexit :=
      D7 ? newdtD7 : Bit;
      DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
       (newdtD7, dtD6, dtD5, dtD4, dtD3, dtD2, dtD1, dtD0, dtG, MWire(8, dtQ))
    []
      D6 ? newdtD6 : Bit;
      DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
       (dtD7, newdtD6, dtD5, dtD4, dtD3, dtD2, dtD1, dtD0, dtG, MWire(8, dtQ))
    []
      D5 ? newdtD5: Bit;
      DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
       (dtD7, dtD6, newdtD5, dtD4, dtD3, dtD2, dtD1, dtD0, dtG, MWire(8, dtQ))
    []
      D4 ? newdtD4 : Bit;
      DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
       (dtD7, dtD6, dtD5, newdtD4, dtD3, dtD2, dtD1, dtD0, dtG, MWire(8, dtQ))
    []
      D3 ? newdtD3 : Bit;
      DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
       (dtD7, dtD6, dtD5, dtD4, newdtD3, dtD2, dtD1, dtD0, dtG, MWire(8, dtQ))
    []
      D2 ? newdtD2 : Bit;
      DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
       (dtD7, dtD6, dtD5, dtD4, dtD3, newdtD2, dtD1, dtD0, dtG, MWire(8, dtQ))
    []
      D1 ? newdtD1: Bit;
      DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
       (dtD7, dtD6, dtD5, dtD4, dtD3, dtD2, newdtD1, dtD0, dtG, MWire(8, dtQ))
    []
      D0 ? newdtD0 : Bit;
      DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
       (dtD7, dtD6, dtD5, dtD4, dtD3, dtD2, dtD1, newdtD0, dtG, MWire(8, dtQ))
    []
      G ? newdtG : Bit;
      DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
       (dtD7, dtD6, dtD5, dtD4, dtD3, dtD2, dtD1, dtD0, newdtG, MWire(8, dtQ))   
    []
      [(dtG eq 1) and (dtD7 ne X of bit) and (dtQ7 ne dtD7)] ->
	Q7 ! dtD7 ;
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtD7, dtQ6, dtQ5, dtQ4, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtQ7 eq X of bit) and (dtD7 eq X of bit)] ->
	Q7 ? dtD7 : bit [dtD7 ne X of bit] ;
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtD7, dtQ6, dtQ5, dtQ4, dtQ3, dtQ2, dtQ1, dtQ0)  
    []
      [(dtG eq 1) and (dtD6 ne X of bit) and (dtQ6 ne dtD6)] ->
	Q6 ! dtD6 ;
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtQ7, dtD6, dtQ5, dtQ4, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtD6 eq X of bit) and (dtQ6 eq X of bit)] ->
	Q6 ? dtD6 : bit [dtD6 ne X of bit];
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtQ7, dtD6, dtQ5, dtQ4, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtD5 ne X of bit) and (dtQ5 ne dtD5)] ->
	Q5 ! dtD5 ;
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtQ7, dtQ6, dtD5, dtQ4, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtD5 eq X of bit) and (dtQ5  eq X of bit)] ->
	Q5 ? dtD5 : bit [dtD5 ne X of bit];
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtQ7, dtQ6, dtD5, dtQ4, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtD4 ne X of bit) and (dtQ4 ne dtD4)] ->
	Q4 ! dtD4 ;
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtQ7, dtQ6, dtQ5, dtD4, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtD4 eq X of bit) and (dtQ4 eq X of bit )] ->
	Q4 ? dtD4 : bit[dtD4 ne X of bit];
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtQ7, dtQ6, dtQ5, dtD4, dtQ3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtD3 ne X of bit) and (dtQ3 ne dtD3)] ->
	Q3 ! dtD3 ;
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtD7, dtD6, dtD5, dtD4, dtD3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtD3 eq  X of bit) and (dtQ3 eq  X of bit )] ->
	Q3 ? dtD3 : Bit[dtD3 ne X of bit] ;
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtD7, dtD6, dtD5, dtD4, dtD3, dtQ2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtD2 ne X of bit) and (dtQ2 ne dtD2)] ->
	Q2 ! dtD2 ;
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtD7, dtD6, dtD5, dtD4, dtQ3, dtD2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtD2 eq X of bit) and (dtQ2 eq X of bit  )] ->
	Q2 ? dtD2 : bit[dtD2 ne X of bit];
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtD7, dtD6, dtD5, dtD4, dtQ3, dtD2, dtQ1, dtQ0)
    []
      [(dtG eq 1) and (dtD1 ne X of bit) and (dtQ1 ne dtD1)] ->
	Q1 ! dtD1 ;
	DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtD7, dtD6, dtD5, dtD4, dtQ3, dtQ2, dtD1, dtQ0)
    []
      [(dtG eq 1) and (dtD1 eq X of bit) and (dtQ1 eq X of bit )] ->
      Q1 ? dtD1  : Bit[dtD1 ne X of bit];
      DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	(MWire(8, dtD), dtG, dtD7, dtD6, dtD5, dtD4, dtQ3, dtQ2, dtD1, dtQ0)
    []
      [(dtG eq 1) and (dtD0 ne X of bit) and (dtQ0 ne dtD0)] ->
        Q0 ! dtD0 ;
        DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtD7, dtD6, dtD5, dtD4, dtQ3, dtQ2, dtQ1, dtD0)
    []
      [(dtG eq 1) and (dtD0 eq X of bit) and (dtQ0 eq X of bit )] ->
        Q0 ? dtD0: bit[dtD0 ne X of bit] ;
        DLatch8_BB_Aux [MWire(8, D), G, MWire(8, Q)]
	 (MWire(8, dtD), dtG, dtD7, dtD6, dtD5, dtD4, dtQ3, dtQ2, dtQ1, dtD0)
    endproc (* DLatch8_BB_Aux *)   
  endproc (*  DLatch8_BB *)
')')
