################################### Header ###################################

# "dill_memory.m4"	Ji He, K. J. Turner	24/09/97

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with memory devices.

# Copyright 1997 Ji He, K. J. Turner, University of Stirling

################################### Memory ###################################

# "Reg_4T4_RW_Decl"defines 4bits*4bits memory with read write inputs
#
#   D3--D0:		data inputs
#   Gw/Gr:		write/read enable(0 active)
#   Wb, Wa/Rb, Ra:	write/read address
#   Q3--Q0:		data outputs
#   74Ls170
 
define(Reg_4T4_RW_Decl, `declare(`$0', 
  `DLatch_4_Decl`'Decoder2_Decl`'Multiplexer2_Decl`'Nor2_Decl`'Or2_Decl
  process Reg_4T4_RW
   [MWire(4, D), Gw, Wb, Wa, Gr, Rb, Ra, MWire(4, Q)] : noexit :=
    hide MWire(4, `W, Gwin, Q0, Q1, Q2, Q3, Qin') in  
      (
	(
	  Decoder2[Wb, Wa, MWire(4, W)] 
	|[MWire(4, W)]| 
	  MComp(4, Gw=, `Nor2[Gw=, W, Gwin]')
	)
      |[MWire(4, Gwin)]|
	(
	  DLatch_4 [MWire(4, D), Gwin3, MWire(4, Q3)]
	|[MWire(4, D)]|
	  DLatch_4 [MWire(4, D), Gwin2, MWire(4, Q2)]
	|[MWire(4, D)]|
	  DLatch_4 [MWire(4, D), Gwin1, MWire(4, Q1)]
	|[MWire(4, D)]|
	  DLatch_4 [MWire(4, D), Gwin0, MWire(4, Q0)]
	)
      )
    |[MWire(4, `Q0, Q1, Q2, Q3')]|
      (
	MComp(4, `Rb=, Ra=',  `Multiplexer2 [Q3, Q2, Q1, Q0, Rb=, Ra=, Qin]')
      |[MWire(4, Qin)]|
	MComp(4, Gr=, `Or2 [Qin, Gr=, Q]')
      )
  endproc (* Reg_4T4_RW *)
')')
