################################### Header ###################################

# "dill_memory_bb.m4"	Ji He, K. J. Turner	24/09/97

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach. Bit states (but not signals) may have an "X" (unknown)
# value - generally for their initial condition.
#
# This particular file deals with the black-box form of memory devices.

# Copyright 1997 Ji He, K. J. Turner, University of Stirling

################################### Memory ###################################

# "Reg_4T4_BB_RW_Decl"defines 4Bits*4Bits memory with read write inputs
#
#   D3--D0:      data inputs
#   Gw/Gr:       write/read enable(0 active)
#   Wb,Wa/Rb,Ra: write/read address
#   Q3--Q0:      data outputs
#   74Ls170
 
define(Reg_4T4_BB_RW_Decl,`declare(`$0',`
  process Reg_4T4_BB_RW [D, Gw, Wb, Wa, Gr, Rb, Ra, Q]:noexit :=
    Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
     (Bit(X)#X#X#X, X of Bit, X of Bit, X of Bit, X of Bit, X of Bit, X of Bit, 
      Bit(X)#X#X#X, Bit(X)#X#X#X, Bit(X)#X#X#X, Bit(X)#X#X#X, Bit(X)#X#X#X)

    where
  
    process Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
     (dtD: BitArray, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa: Bit, 
      dtMem3, dtMem2, dtMem1, dtMem0, dtQ : BitArray) : noexit :=
      D ? newdtD: BitArray;
      Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
       (newdtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtQ)
    []
      Gw ? newdtGw: Bit;
      Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
       (dtD, newdtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtQ)
    []
      Wb ? newdtWb: Bit;
      Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
       (dtD, dtGw, newdtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtQ)
    []
      Wa ? newdtWa: Bit;
      Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
       (dtD, dtGw, dtWb, newdtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtQ)
    []
      Gr ? newdtGr: Bit;
      Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
       (dtD, dtGw, dtWb, dtWa, newdtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtQ)
    []
      Rb ? newdtRb: Bit;
      Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
       (dtD, dtGw, dtWb, dtWa, dtGr, newdtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtQ)
    []
      Ra ? newdtRa: Bit;
      Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
       (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, newdtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtQ)
    []
      [dtQ eq Bit (X)] ->
	Q ? newdtQ : BitArray [newdtQ ne Bit (X)];   
	Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
	 (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, newdtQ) 
    []
      [dtGw eq 0 of Bit] ->			(* write enable *)
	(
	  [(dtWb eq 0 of Bit) and (dtWa eq 0 of Bit) and (dtMem0 ne dtD) 
	   and (dtD eq Bit(X))] ->
	    i;
	    Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
	     (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtD, dtQ) 
	[]
	  [(dtWb eq 0 of Bit) and(dtWa eq 1 of Bit) and (dtMem1 ne dtD) 
	   and (dtD eq Bit(X))] ->
	    i;
	    Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
	     (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtD, dtMem0, dtQ) 
	[]
	  [(dtWb eq 1 of Bit) and (dtWa eq 0 of Bit) and (dtMem2 ne dtD) 
	   and (dtD eq Bit(X))] ->
	    i;
	    Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
	     (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtD, dtMem1, dtMem0, dtQ) 
	[]
	  [(dtWb eq 1 of Bit) and (dtWa eq 1 of Bit) and (dtMem3 ne dtD) 
	   and (dtD eq Bit(X))] ->
	    i;
	    Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
	     (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtD, dtMem2, dtMem1, dtMem0, dtQ) 
	)					(* end of write enable *)
    []
      [dtGr eq 0 of Bit] ->			(* read enable *)
	(
	  [(dtRb eq 0 of Bit) and (dtRa eq 0 of Bit) and (dtMem0 ne Bit(X)) 
	   and (dtQ ne dtMem0)]->
	    Q ! dtMem0;
	    Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
	     (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtMem0) 
	[]
	  [(dtRb eq 0 of Bit) and (dtRa eq 1 of Bit) and (dtMem1 ne Bit(X)) 
	   and (dtQ ne dtMem1)]->
	    Q ! dtMem1;
	    Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
	     (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtMem1)
	[]
	  [(dtRb eq 1 of Bit) and (dtRa eq 0 of Bit) and (dtMem2 ne Bit(X)) 
	    and (dtQ ne dtMem2)]->
	    Q ! dtMem2;
	    Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
	     (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtMem2)
	[]
	  [(dtRb eq 1 of Bit) and (dtRa eq 1 of Bit) and (dtMem3 ne Bit(X)) 
	    and (dtQ ne dtMem3)]->
	    Q ! dtMem3;
	    Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
	     (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, dtMem3)
	)					(* end  of read enable *)
    []
      [(dtGr eq 1) and (dtQ ne (Bit(1)#1#1#1))] ->	(* read disable *)
	Q ! Bit(1)#1#1#1;
	Reg_4T4_BB_RW_Aux [D, Gw, Wb, Wa, Gr, Rb, Ra, Q] 
	 (dtD, dtGw, dtWb, dtWa, dtGr, dtRb, dtRa, dtMem3, dtMem2, dtMem1, dtMem0, Bit(1)#1#1#1) 
    endproc (* Reg_4T4_BB_RW_Aux *)
  endproc (* Reg_4T4_BB_RW *)
')')
