################################### Header ###################################

# "dill_multi.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach. Bit states (but not signals) may have an "X" (unknown)
# value - generally for their initial condition.
#
# This particular file deals with multiple instances (components, wires).

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

######################### General-Purpose Macros #########################

# "Comma" defines the replacement for comma characters

define(Comma,`@')

# "Comma_In(string)" reinstates comma characters

define(Comma_In,`translit($1,Comma,`,')')

# "Comma_Out(string)" substitutes for comma characters

define(Comma_Out,`translit(`$1',`,',Comma)')

# "Shrink(string)" deletes the first and last characters (e.g. parentheses)

define(Shrink,
  `define(`strlen',eval(len(`$1')-2))substr(`$1',1,strlen)')

######################### Multi-Component Macros #########################

# "MComp(count,gates,process)" or "MComp(count,process)" produces multiple
# instances of a component process:
# 
#   MComp(2,`And2 [Ip1, Ip2, Out]')
# or
#   MComp(2,`And2 [Ip1, Ip2, Out]')
# 
# expands to:
# 
#   (
#     And2 [Ip11, Ip21, Out1] (0)
#   |||
#     And2 [Ip10, Ip20, Out0] (0)
#   )
# 
# The process is instantiated the required number of times and a count is
# appended to each gate as required. The gates (second) parameter is optional
# and defaults to none. Note that the gate and process parameters must be
# quoted if they contain commas. Commas in either parameter are internally
# substituted before further processing.
# 
# A count may be appended to a gate name by using the following symbols:
# 
#   +		current count + 1
#   -		current count - 1 (avoid decrementing below zero)
#   *		current count * 2
#   /		current count / 2 (rounded down to the nearest integer)
#   =		unchanged
#   else	current count
# 
# This facility is to enable chains of repeated components to be
# interconnected at the correct common gates. If a component is being
# repeated "n" times, the current count is set to n-1, ... 0 for each
# successive component and the operator that connects it to later instances.
# If necessary, the arithmetic operators may be repeated, e.g.:
# 
#   -**		yields 11 (3*2*2-1) for a current count of 3
# 
# As an example of giving a gate list:
# 
#   MComp(2,Ip2-,`And2 [Ip1=, Ip2+, Out]')
# 
# expands to:
# 
#   (
#     And2 [Ip11, Ip22, Out] (0)		(* count 1 *)
#   |[Ip20]|					(* count 1 *)
#     And2 [Ip10, Ip21, Out] (0)		(* count 0 *)
#   )

define(MComp,
  `define(`parop',
    `Shrink(Comma_Out((|[$2]|)))')define(`parproc',
      `Shrink(Comma_Out(($3)))')ifelse(`$3',,
        `define(`parop',
          |||)define(`parproc',
	    `Shrink(Comma_Out(($2)))')')ifelse(eval($1<=0),1,,
              `ifelse($1,1,`Comma_In(parproc)',
                `  (MComp_Aux(decr($1),parop,parproc)
  )')')')

# "MComp_Aux(count,operator,process)" produces multiple instances of a
# component process. Note that the count parameter must be at least 1. It is
# assumed that commas in the parameters have already been internally
# substituted; they are reinstated on output.

define(MComp_Aux,`
    Comma_In(Lab_Gates($1,`$3'))`'ifelse($1,0,,`
  Comma_In(Lab_Gates($1,`$2'))MComp_Aux(eval($1-1),`$2',`$3')')')
  
# "Lab_Gates(count,process)" appends a count to gate names in the process.

define(Lab_Gates,
  `define(`gateind1',
    `index(`$2',[)')define(`gateind2',
      `index(`$2',])')ifelse(gateind1,-1,`$2',
        `ifelse(gateind2,-1,`$2',
	  `define(`gateind1',
	    incr(gateind1))define(`gatelen',
	      eval(gateind2-gateind1))substr(`$2',
	        0,gateind1)Lab_Gates_Aux($1,`'substr(`$2',
	          gateind1,gatelen))`]'Lab_Gates($1,substr(`$2',
		    incr(gateind2)))')')')

# "Lab_Gates_Aux(count,gates)" appends a count to gate names.

define(Lab_Gates_Aux,
  `define(`gatelist',`'$2)define(`gateind3',
    index(gatelist,Comma))ifelse(gateind3,-1,
      `Lab_Gate($1,gatelist)',
	`Lab_Gate($1,
	  `substr(gatelist,0,gateind3)')`'Comma`'Lab_Gates_Aux($1,
	    `substr(gatelist,incr(gateind3))')')')

# "Lab_Gate(count,gate)" appends a count to a single gate name.

define(Lab_Gate,
  `define(`gatename',`'$2)define(`gateind4',
    decr(len(`'gatename)))ifelse(gateind4,-1,,
      `define(`gatechar',
        substr(`'gatename,gateind4,1))define(`gatename',
	  substr(`'gatename,0,gateind4))ifelse(gatechar,` ',
	    `Lab_Gate($1,``'gatename')',
	      gatechar,+,
		`Lab_Gate(incr($1),``'gatename')',
		  gatechar,-,
		    `Lab_Gate(decr($1),``'gatename')',
		      gatechar,*,
			`Lab_Gate(eval($1*2),``'gatename')',
			  gatechar,/,
			    `Lab_Gate(eval($1/2),``'gatename')',
			      gatechar,=,
				``'gatename',
				  `gatename`'gatechar`'$1')')')
  
######################### Multi-Wire Macros #########################

# "MWire(count,gates)" produces multiple instances of wires:
# 
#   MWire(2,`Ip1, Ip2, Out')
# 
# expands to:
# 
#  Ip11, Ip21, Out1, Ip10, Ip20, Out0
# 
# A count is appended to each gate as required.  Note that the gate list must
# be quoted if it contains commas. Commas are internally substituted before
# further processing.
# 
# A count may be appended to a gate name by using the following symbols:
# 
#   +		current count + 1
#   -		current count - 1 (avoid decrementing below zero)
#   *		current count * 2
#   /		current count / 2 (rounded down to the nearest integer)
#   =		unchanged
#   else	current count
# 
# This facility supports chains of repeated components to be
# interconnected at the correct common gates. The arithmetic operators are
# as for "MComp". The "-" operator is unlikely to be useful since it could
# result in a negative gate label. 
# 
#   MWire(2,`Ip1++, Ip2, Out+')
# 
# expands to:
# 
#   Ip13, Ip21, Out2,				(* count 1 *)
#   Ip12, Ip20, Out1				(* count 0 *)

define(MWire,
  `ifelse(eval($1<=0),1,,
      `ifelse($1,1,`$2',
        `MWire_Aux(decr($1),Shrink(Comma_Out(($2))))')')')

# "MWire_Aux(count,gates)" produces multiple instances of a wire. Note that
# the count parameter must be at least 1. It is assumed that commas in the
# parameter have already been internally substituted; they are reinstated on
# output.

define(MWire_Aux,
  `Comma_In(Lab_Gates_Aux($1,`$2'))`'ifelse($1,0,,
    ``,' MWire_Aux(eval($1-1),`$2')')')

# Pars(parlist1,parlist2) changes the parameter names in "parlist1" to the
# form of "newname"; the other parameter name in "parlist2" will not be
# changed. "parlist1" is a sub-list of "parlist2". Here is an example:
#
#   Pars(`dtD,dtC')		-> dtD,dtC
#   Pars(dtC,dtC)		-> newdtC
#   Pars(dtD,`dtC,dtD')		-> dtC,newdtD
#   Pars(`dtC,dtD',`dtC,dtD')	-> newdtC,newdtD

define(Pars,
 `define(`newpar',
   Shrink(Comma_Out(($1))))define(`parlist',
    Shrink(Comma_Out(($2))))ifelse(`$2',,`Comma_In(newpar)',
     `ParsAux(newpar,parlist)')')

define(ParsAux,`define(`mark1',
 index(`$1',Comma))define(`mark2',
  index(`$2',Comma))define(`data',
   ifelse(mark1,-1,`$1',substr(`$1',0,mark1)))define(`olddata',
    ifelse(mark2,-1,`$2',substr(`$2',0,mark2)))define(`newpar1',
     ifelse(data,olddata,ifelse(mark1,-1,
      ` ',substr(`$1',incr(mark1))),`$1'))define(`newdata',
       ifelse(data,olddata,new`'olddata,olddata))ifelse(mark2,-1,
        newdata,newdata`,'`ParsAux(newpar1,substr($2,incr(mark2)))')') 
 
######################### Test Data #########################

# 02: MComp(0,`And2 [Ip1, Ip2, Out] (0)')
# 12: MComp(1,`And2 [Ip1, Ip2, Out] (0)')
# 22: MComp(2,`And2 [Ip1,  Ip2,Out] (0)')
# 03: MComp(0,`|[Ip2, Sig]|',`And2 [Ip1, Ip2, Out] (0)')
# 13: MComp(1,`|[Ip2, Sig]|',`And2 [Ip1, Ip2, Out] (0)')
# 23: MComp(2,`|[Ip2, Sig+]|',`And2 [Ip1+, Ip2++, Out] (0)')

# 0: MWire(0,` Ip1, Ip2, Out')
# 1: MWire(1,` Ip1, Ip2-, Out')
# 2: MWire(3,` Ip1+,  Ip2=,Out++')

