################################### Header ###################################

# "dill_parity.m4"	Ji He, K. J. Turner	27/01/98

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with parity devices (checkers, generators).

# Copyright 1998 Ji He, K. J. Turner, University of Stirling

################################### Parity ###################################

# "Parity8_Decl" defines an 8 bits parity checker/generator

define(Parity8_Decl,  `declare(`$0',`Xor2_Decl
  process Parity8 [MWire(8, D), P] : noexit :=
    hide MWire(4, A), MWire(2, B) in
      MComp(4, `Xor2 [D+*, D*, A]')
    |[MWire(4, A)]|
      MComp(2, `Xor2 [A+*, A*, B]')
    |[MWire(2, B)]|
      Xor2 [MWire(2, B), P]
  endproc (* Parity8 *)
')')
