################################### Header ###################################

# "dill_parity_bb.m4"	Ji He, K. J. Turner	24/09/97

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with the black-box form of parity devices
# (checkers, generators).

# Copyright 1997 Ji He, K. J. Turner, University of Stirling

################################### Parity ###################################

# "Parity8_BB_Decl" defines a 8bits parity checker/generator

define(Parity8_BB_Decl,  `
  process Parity8_BB [MWire(8, D), P] : noexit :=
    Parity8_BBAux [MWire(8, D), P] (MWire(9, X of bit=)) 

    where
    
    process Parity8_BBAux [MWire(8, D), P] (MWire(8, dtD), dtP: Bit ) : noexit :=
      D7 ? newdtD7 : Bit;
      Parity8_BBAux [MWire(8, D), P]
       (newdtD7, dtD6, dtD5, dtD4, dtD3, dtD2, dtD1, dtD0, dtP)
    []
      D6 ? newdtD6 : Bit;
      Parity8_BBAux [MWire(8, D), P]
       (dtD7, newdtD6, dtD5, dtD4, dtD3, dtD2, dtD1, dtD0, dtP)
    []
      D5 ? newdtD5 : Bit;
      Parity8_BBAux [MWire(8, D), P]
       (dtD7, dtD6, newdtD5, dtD4, dtD3, dtD2, dtD1, dtD0, dtP)
    []
      D4 ? newdtD4 : Bit;
      Parity8_BBAux [MWire(8, D), P]
       (dtD7, dtD6, dtD5, newdtD4, dtD3, dtD2, dtD1, dtD0, dtP)
    []
      D3 ? newdtD3 : Bit;
      Parity8_BBAux [MWire(8, D), P]
       (dtD7, dtD6, dtD5, dtD4, newdtD3, dtD2, dtD1, dtD0, dtP)
    []
      D2 ? newdtD2 : Bit;
      Parity8_BBAux [MWire(8, D), P]
       (dtD7, dtD6, dtD5, dtD4, dtD3, newdtD2, dtD1, dtD0, dtP)
    []
      D1 ? newdtD1 : Bit;
      Parity8_BBAux [MWire(8, D), P]
       (dtD7, dtD6, dtD5, dtD4, dtD3, dtD2, newdtD1, dtD0, dtP)
    []
      D0 ? newdtD0 : Bit;
      Parity8_BBAux [MWire(8, D), P]
       (dtD7, dtD6, dtD5, dtD4, dtD3, dtD2, dtD1, newdtD0, dtP)
    []
      (
        let newdtP : Bit =    
	 (((((((dtD7 xor dtD6) xor dtD5) xor dtD4) xor dtD3) xor dtD2) xor dtD1)
	  xor dtD0) in
          [(newdtP eq X) and (dtP eq X)] ->
	    P ? newdtP : Bit [newdtP ne X];
	    Parity8_BBAux [MWire(8, D), P]
	     (dtD7, dtD6, dtD5, dtD4, dtD3, dtD2, dtD1, dtD0, newdtP)
        []
          [(newdtP ne X) and (newdtP ne dtP)] ->
            P ! newdtP;
            Parity8_BBAux [MWire(8, D), P] 
	     (dtD7, dtD6, dtD5, dtD4, dtD3, dtD2, dtD1, dtD0, newdtP)
      )
    endproc (* Parity8_BBAux *)
  endproc (* Parity8_BB *)
')')
