################################### Header ###################################

# "dill_plexer.m4"	Ji He, K. J. Turner	24/09/97

# This "m4" macro file contAIns templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with plexers (multiplexer, demultiplexer).

# Copyright 1997 Ji He, K. J. Turner, University of Stirling

################################## Plexers ###################################

# "Demultiplexer1to2_Decl" define a 2-to-1 demultiplexer

define(Demultiplexer1to2_Decl, `declare(`$0', `Inverter_Decl`'And2_Decl
  process Demultiplexer1to2 [D, S, Q1, Q0] : noexit :=
    hide SInt in
      Inverter [S, SInt]      
    |[S, SInt ]|
      (
        And2 [S, D, Q1]
      |[D]|
        And2 [SInt, D, Q0]
      )    
  endproc (* Demultiplexer1to2 *)
')')

# "Demultiplexer2to4_Decl" defines a 2-to-4 multiplexer

define(Demultiplexer2to4_Decl, `declare(`$0', `Inverter_Decl`'And3_Decl
  process Demultiplexer2to4 [D, S1, S0, Q3, Q2, Q1, Q0] : noexit :=
    hide SInt0, SInt1 in
      (
	Inverter [S0, SInt0]
      |||
	Inverter [S1, SInt1]
      )
    |[S0, S1, SInt0, SInt1]|
      (
        And3 [SInt0, SInt1, D, Q0]
      |[D]|
        And3 [S0, S1, D, Q3]
      )
    |[S0, S1, SInt0, SInt1, D]|
      (
        And3 [S0, SInt1, D, Q1]
      |[D]|
        And3 [SInt0, S1, D, Q2]
      )
  endproc (* Demultiplexer2to4 *)
')')

# "Multiplexer4to1_Decl" defines a 4-to-1 multiplexer

define(Multiplexer4to1_Decl, `declare(`$0', `Inverter_Decl`'And3_Decl`'Or4_Decl
  process Multiplexer4to1 [D3, D2, D1, D0, S1, S0, Q] : noexit :=
    hide SInt0, SInt1, QInt0, QInt1, QInt2, QInt3 in
      (
	(
	  Inverter [S0, SInt0]
	|||
	  Inverter [S1, SInt1]
	)
      |[S0, S1, SInt0, SInt1]|
	(
	  And3 [SInt0, SInt1, D0, QInt0]
	|||
	  And3 [S0, S1, D3, QInt3]
	)
      |[S0, S1, SInt0, SInt1]|
	(
	  And3 [S0, SInt1, D1, QInt1]
	|||
	  And3 [SInt0, S1, D2, QInt2]
	)
      )
    |[QInt0, QInt1, QInt2, QInt3]|
      Or4 [QInt0, QInt1, QInt2, QInt3, Q]
  endproc (* Multiplexer4to1 *)
')')

# "Multiplexer2to1_Decl" defines a 2-to-1 multiplexer.

define(Multiplexer2to1_Decl, `declare(`$0', `And2_Decl`'Or2_Decl`'Inverter_Decl
  process Multiplexer2to1 [A, B, S, C] : noexit :=
    hide AIn, BIn, SIn in
      (Inverter [S, Sin]
    |[S, Sin]|
      (And2 [A, Sin, AIn] ||| And2 [B, S, Bin]))
    |[AIn, BIn]|
      Or2 [AIn, BIn, C]
  endproc (* Multiplexer2to1 *)
')')

# "Demultiplexer2to1_4_Decl" define a 4 bits 2-to-1 demultiplexer

define(Demultiplexer2to1_4_Decl, `declare(`$0', `demultiplexer2to1_Decl
  process Demultiplexer2to1_4 [MWire(4, D), S, MWire(4, `Q1, Q0' ] : noexit :=
    MComp(4, S=, `Demultiplexer2to1 [D, S=, Q1, Q0]' )
  endproc (*  Demultiplexer2to1_4 *)
')')

# "Demultiplexer2to1_8_Decl" define a 4 bits 1_to_2 demultiplexer

define(Demultiplexer2to1_8_Decl, `declare(`$0', `demultiplexer2to1_Decl
  process Demultiplexer2to1_8 [MWire(8, D), S, MWire(8, `Q1, Q0' ] : noexit :=
    MComp(8, S=, `Demultiplexer2to1 [D, S=, Q1, Q0]' )
  endproc (* Demultiplexer2to1_8 *)
')')

# "Multiplexer2to1_4_Decl" defines a 4bits 2to1 multiplexer.

define(Multiplexer2to1_4_Decl, `declare(`$0', `Multiplexer2to1_Decl
  process Multiplexer2to1_4 [MWire(4, `A, B'), S, MWire(4, C)] : noexit :=
    MComp(4, S=, `Multiplexer2to1 [A, B, S=, C]')
  endproc (* Multiplexer2to1_4 *)
')')

# "Multiplexer2to1_8_Decl" defines a 8bits 2to1 multiplexer.

define(Multiplexer2to1_8_Decl, `declare(`$0', `Multiplexer2to1_Decl
  process Multiplexer2to1_8 [MWire(8, `A, B'), S, MWire(8, C)] : noexit :=
    MComp(8, S=, `Multiplexer2to1 [A, B, S=, C]')
  endproc (* Multiplexer2to1_8 *)
')')

# "Multiplexer2to1Reg_8_Decl" defines a 8 bit 2-to-1 multiplexer, with
# register output.

define(Multiplexer2to1Reg_8_Decl, `declare(`$0',
  `Reg_8_Decl`'Multiplexer2to1_8_Decl
  process Multiplexer2to1Reg_8 [MWire(8, `A, B'), S, Ck, MWire(8, Q)] : noexit :=
    hide MWire(8, `C, Qbar') in
      Multiplexer2to1_8 [MWire(8, `A, B'), S, MWire(8, C)]
     |[MWire(8, C)]|
      Reg_8 [MWire(8, C), Ck, MWire(8, `Q, Qbar')]
  endproc (* Multiplexer2to1Reg_8_Decl *)
')')
