################################### Header ###################################

# "dill_plexer_bb_wb.m4"	Ji He, K. J. Turner	24/09/97

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with black-box and white-box forms of plexers
# (multiplexer, demultiplexer).

# Copyright 1997 Ji He, K. J. Turner, University of Stirling

################################## Plexers ###################################

# "Demultiplexer1to2_WB_Decl" defines a 1-to-2 demultiplexer

define(Demultiplexer1to2_WB_Decl, `declare(`$0', `
  process Demultiplexer1to2_WB [D, S, Q1, Q0] : noexit :=
    Demultiplexer1to2_WB_Aux [D, S, Q1, Q0] 
     (X of bit, X of bit, X of bit, X of bit)

    where
    
    process Demultiplexer1to2_WB_Aux [D, S, Q1, Q0] (dtD, dtS, dtQ1, dtQ0 : Bit) : noexit:=
      D ? newdtD : Bit;
      Demultiplexer1to2_WB_Aux [D, S, Q1, Q0] (newdtD, dtS, dtQ1, dtQ0)
    []
      S ? newdtS : Bit;
      Demultiplexer1to2_WB_Aux [D, S, Q1, Q0] (dtD, newdtS, dtQ1, dtQ0)
    []
      (
        let newdtQ1 : Bit = dtD and dtS,
	      newdtQ0 : Bit = dtD and not(dtS) in
	  (
	    [(newdtQ1 ne X) and (newdtQ1 ne dtQ1)] ->
	      Q1 ! newdtQ1;
	      Demultiplexer1to2_WB_Aux [D, S, Q1, Q0] (dtD, dtS, newdtQ1, dtQ0)
	  []
	    [(newdtQ0 ne X) and (newdtQ0 ne dtQ0)] ->
	      Q0 ! newdtQ0;
	      Demultiplexer1to2_WB_Aux [D, S, Q1, Q0] (dtD, dtS, dtQ1, newdtQ0)
	  []
	    [(newdtQ1 eq X) and (dtQ1 eq X of bit)] ->
	      Q1 ? newdtQ1 : Bit [newdtQ1 ne X] ;
	      Demultiplexer1to2_WB_Aux [D, S, Q1, Q0] (dtD, dtS, newdtQ1, dtQ0)
	  []
	    [(newdtQ0 eq X) and (dtQ0 eq X of bit)] ->
	      Q0 ? newdtQ0 : Bit [newdtQ0 ne X] ;
	      Demultiplexer1to2_WB_Aux [D, S, Q1, Q0] (dtD, dtS, dtQ1, newdtQ0)
	  )
      )
    endproc (* Demultiplexer1to2_WB_Aux *)
  endproc (* Demultiplexer1to2_WB *)
')')

# "Demultiplexer1to4_WB_Decl" defines a 1-to-4 demultiplexer

define(Demultiplexer1to4_WB_Decl, `declare(`$0', `
  process Demultiplexer1to4_WB [D, S1, S0, Q3, Q2, Q1, Q0] : noexit :=
    Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
     (X of bit, X of bit, X of bit, X of bit, X of bit, X of bit, X of bit)

    where
    
    process Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
     (dtD, dtS1, dtS0, dtQ3, dtQ2, dtQ1, dtQ0 : Bit) : noexit:=
      D ? newdtD : Bit;
      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0]
       (newdtD, dtS1, dtS0, dtQ3, dtQ2, dtQ1, dtQ0) 
    []
      S1 ? newdtS1 : Bit;
      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
       (dtD, newdtS1, dtS0, dtQ3, dtQ2, dtQ1, dtQ0) 
    []
      S0 ? newdtS0 : Bit;
      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
       (dtD, dtS1, newdtS0, dtQ3, dtQ2, dtQ1, dtQ0) 
    []
      (
        let newdtQ3 : Bit = dtD and dtS1 and dtS0,
	      newdtQ2 : Bit = dtD and dtS1 and not(dtS0),
	      newdtQ1 : Bit = dtD and not(dtS1) and dtS0,
	      newdtQ0 : Bit = dtD and not(dtS1) and not(dtS0) in 
          (
	    [(newdtQ3 eq X) and (dtQ3 eq X)] -> 
	      Q3? newdtQ3 : Bit [newdtQ3 ne X];
	      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
	       (dtD, dtS1, dtS0, newdtQ3, dtQ2, dtQ1, dtQ0) 
	  []
	    [(newdtQ2 eq X) and (dtQ2 eq X)] -> 
	      Q2 ? newdtQ2 : Bit [newdtQ2 ne X];
	      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
	       (dtD, dtS1, dtS0, dtQ3, newdtQ2, dtQ1, dtQ0) 
	  []
	    [(newdtQ1 eq X) and (dtQ1 eq X)] -> 
	      Q1 ? newdtQ1 : Bit [newdtQ1 ne X];
	      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
	       (dtD, dtS1, dtS0, dtQ3, dtQ2, newdtQ1, dtQ0) 
	  []
	    [(newdtQ0 eq X) and (dtQ0 eq X)] -> 
	      Q0 ? newdtQ0 : Bit [newdtQ0 ne X];
	      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
	       (dtD, dtS1, dtS0, dtQ3, dtQ2, dtQ1, newdtQ0) 
	  []
	    [(newdtQ3 ne X) and (newdtQ3 ne dtQ3)] ->
	      Q3 ! newdtQ3;
	      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
	       (dtD, dtS1, dtS0, newdtQ3, dtQ2, dtQ1, dtQ0) 
	  []
	    [(newdtQ2 ne X) and (newdtQ2 ne dtQ2)] ->
	      Q2 ! newdtQ2;
	      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
	       (dtD, dtS1, dtS0, dtQ3, newdtQ2, dtQ1, dtQ0) 
	  []
	    [(newdtQ1 ne X) and (newdtQ1 ne dtQ1)] ->
	      Q1 ! newdtQ1;
	      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
	       (dtD, dtS1, dtS0, dtQ3, dtQ2, newdtQ1, dtQ0) 
	  []
	    [(newdtQ0 ne X) and (newdtQ0 ne dtQ0)] ->
	      Q0 ! newdtQ0;
	      Demultiplexer1to4_WB_Aux [D, S1, S0, Q3, Q2, Q1, Q0] 
	       (dtD, dtS1, dtS0, dtQ3, dtQ2, dtQ1, newdtQ0) 
          )
      )
    endproc (* Demultiplexer1to4_WB_Aux *)
  endproc (* Demultiplexer1to4_WB *)
')')

# "Multiplexer4to1_WB_Decl" defines a 4-to-1 multiplexer

define(Multiplexer4to1_WB_Decl, `declare(`$0', `
  process Multiplexer4to1_WB [D3, D2, D1, D0, S1, S0, Q] : noexit :=
    Multiplexer4to1_WB_Aux [D3, D2, D1, D0, S1, S0, Q] 
     (X of bit, X of bit, X of bit, X of bit, X of bit, X of bit, X of bit)

    where
    
    process Multiplexer4to1_WB_Aux [D3, D2, D1, D0, S1, S0, Q]
     (dtD3, dtD2, dtD1, dtD0, dtS1, dtS0, dtQ:Bit) : noexit :=
      D3 ? newdtD3 : Bit;
      Multiplexer4to1_WB_Aux [D3, D2, D1, D0, S1, S0, Q]
       (newdtD3, dtD2, dtD1, dtD0, dtS1, dtS0, dtQ)
    []
      D2 ? newdtD2 : Bit;
      Multiplexer4to1_WB_Aux [D3, D2, D1, D0, S1, S0, Q]
       (dtD3, newdtD2, dtD1, dtD0, dtS1, dtS0, dtQ)
    []
      D1 ? newdtD1 : Bit;
      Multiplexer4to1_WB_Aux [D3, D2, D1, D0, S1, S0, Q]
       (dtD3, dtD2, newdtD1, dtD0, dtS1, dtS0, dtQ)
    []
      D0 ? newdtD0 : Bit;
      Multiplexer4to1_WB_Aux [D3, D2, D1, D0, S1, S0, Q]
       (dtD3, dtD2, dtD1, newdtD0, dtS1, dtS0, dtQ)
    []
      S1 ? newdtS1 : Bit;
      Multiplexer4to1_WB_Aux [D3, D2, D1, D0, S1, S0, Q]
       (dtD3, dtD2, dtD1, dtD0, newdtS1, dtS0, dtQ)
    []
      S0 ? newdtS0 : Bit;
      Multiplexer4to1_WB_Aux [D3, D2, D1, D0, S1, S0, Q]
       (dtD3, dtD2, dtD1, dtD0, dtS1, newdtS0, dtQ)
    []
      (
        let newdtQ : Bit = (dtD3 and dtS1 and dtS0) or
			(dtD2 and dtS1 and not(dtS0)) or
			(dtD1 and not(dtS1) and dtS0) or
			(dtD0 and not(dtS1) and not(dtS0)) in 
          [(newdtQ eq X) and (dtQ eq X)] ->
            Q ? newdtQ : Bit [newdtQ ne X];
            Multiplexer4to1_WB_Aux [D3, D2, D1, D0, S1, S0, Q]
             (dtD3, dtD2, dtD1, dtD0, dtS1, dtS0, newdtQ)
        []
          [(newdtQ ne X) and (dtQ ne newdtQ)] ->
            Q ! newdtQ ;
            Multiplexer4to1_WB_Aux [D3, D2, D1, D0, S1, S0, Q]
             (dtD3, dtD2, dtD1, dtD0, dtS1, dtS0, newdtQ)
      )
    endproc (* Multiplexer4to1_WB_Aux *)
  endproc (* Multiplexer4to1_WB *)
')')

# "Multiplexer2to1_WB_Decl" defines a 2-to-1 multiplexer.

define(Multiplexer2to1_WB_Decl, `declare(`$0', `
  process Multiplexer2to1_WB [A, B, S, C] :noexit :=
    Multiplexer2to1_WB_Aux [A, B, S, C] (X of bit, X of bit, X of bit, X of bit)

    where
    
    process Multiplexer2to1_WB_Aux [A, B, S, C] (dtA, dtB, dtS, dtC: Bit ) : noexit :=
      A? newdtA: Bit ;
      Multiplexer2to1_WB_Aux [A, B, S, C] (newdtA, dtB, dtS, dtC)
    []
      B  ? newdtB : Bit ;
      Multiplexer2to1_WB_Aux [A, B, S, C] (dtA, newdtB, dtS, dtC)
    []
      S ? newdtS : Bit ;
      Multiplexer2to1_WB_Aux [A, B, S, C] (dtA, dtB, newdtS, dtC)
    []
      (
        let newdtC : Bit = (not(dtS) and dtA) or (dtS and dtB) in
          [(newdtC eq X of bit) and (dtC eq X)] -> 
            C ? newdtC : Bit [newdtC ne X of bit];
            Multiplexer2to1_WB_Aux [A, B, S, C] (dtA, dtB, dtS, newdtC)
        []
          [(newdtC ne X) and (newdtC ne dtC)] ->
            C ! newdtC ;
            Multiplexer2to1_WB_Aux [A, B, S, C] (dtA, dtB, dtS, newdtC)
      )
    endproc (* Multiplexer2to1_WB_Aux  *)
  endproc (* Multiplexer2to1_WB *)
')')


# "Multiplexer2to1_BB_Decl" defines a 2-to-1 multiplexer.

define(Multiplexer2to1_BB_Decl, `declare(`$0', `
  process Multiplexer2to1_BB[A, B, S, C] :noexit :=
    Multiplexer2to1_BB_Aux [A, B, S, C] (X of bit, X of bit, X of bit, X of bit)

    where
    
    process Multiplexer2to1_BB_Aux [A, B, S, C] (dtA, dtB, dtS, dtC: Bit ) : noexit :=
      A? newdtA: Bit ;
      Multiplexer2to1_BB_Aux [A, B, S, C] (newdtA, dtB, dtS, dtC)
    []
      B  ? newdtB : Bit ;
      Multiplexer2to1_BB_Aux [A, B, S, C] (dtA, newdtB, dtS, dtC)
    []
      S ? newdtS : Bit ;
      Multiplexer2to1_BB_Aux [A, B, S, C] (dtA, dtB, newdtS, dtC)
    []
      [dtC eq X] -> 
        C ? newdtC : Bit[newdtC ne X of bit];
        Multiplexer2to1_BB_Aux [A, B, S, C] (dtA, dtB, dtS, newdtC)
    []
      [(dtS eq 0 of bit) and (dtA ne X) and (dtC ne dtA) ] ->
	C ! dtA ;
	Multiplexer2to1_BB_Aux [A, B, S, C] (dtA, dtB, dtS, dtA)
    []
      [(dtS eq 1) and (dtB ne X) and (dtC ne dtB) ] ->
	C ! dtB ;
	Multiplexer2to1_BB_Aux [A, B, S, C] (dtA, dtB, dtS, dtB)
    endproc (* Multiplexer2to1_BB_Aux  *)
  endproc (* Multiplexer2to1_BB *)
')')

# "Multiplexer2to1_8_BB_Decl" defines an 8 bit 2-to-1 multiplexer.

define(Multiplexer2to1_8_BB_Decl, `declare(`$0', `Multiplexer2to1_BB_Decl
   process Multiplexer2to1_8_BB [MWire(8, A), MWire(8, B), S, MWire(8, C)] :noexit :=
     MComp(8, S=, `Multiplexer2to1_BB [A, B, S=, C]')
   endproc (* Multiplexer2to1_8_BB *)
 ')')

# "Multiplexer2to1_RegN_BB_Decl" defines a nbits 2-to-1 multiplexer, with register output.

define(Multiplexer2to1_RegN_BB_Pos_Decl, `declare(`$0',
  `Multiplexer2to1_RegN_BB_Decl
  process Multiplexer2to1_RegN_BB_Pos [A, B, S, Ck, C] : noexit :=
    Multiplexer2to1_RegN_BB [A, B, S, Ck, C] (1 of bit)
  endproc (* Multiplexer2to1_RegN_BB_Pos  *)
')')

define(Multiplexer2to1_RegN_BB_Neg_Decl, `declare(`$0',
  `Multiplexer2to1_RegN_BB_Decl
  process Multiplexer2to1_RegN_BB_Neg [A, B, S, Ck, C] : noexit :=
    Multiplexer2to1_RegN_BB [A, B, S, Ck, C] (0 of bit)
  endproc (* Multiplexer2to1_RegN_BB_Neg  *)
')')

define(Multiplexer2to1_RegN_BB_Decl, `declare(`$0', `
  process Multiplexer2to1_RegN_BB [A, B, S, Ck, C] (edge : Bit) :noexit :=
    Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C] 
     (edge, Bit (X), Bit (X), X of bit, X of bit, Bit (X))

  where
  
    process Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C] 
      (edge : bit, dtA, dtB : BitArray, dtS, dtCK : bit, dtC : BitArray) : noexit :=
      A ? newdtA : BitArray;
      Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
       (edge, newdtA, dtB, dtS, dtCk, dtC)
    []
      B ? newdtB : BitArray;
      Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
       (edge, dtA, newdtB, dtS, dtCk, dtC)
    []
      S ? newdtS : Bit;
      Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
       (edge, dtA, dtB, newdtS, dtCk, dtC)
    []
      Ck ? newdtCk : Bit;
      (
        [(newdtCk eq edge) and (dtCk eq not(edge))] -> (* appropriate clock transition *)
	  (
	    [(dtS eq X of bit) and (dtC ne Bit (X))] ->
	      Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
	       (edge, dtA, dtB, dtS, newdtCk, dtC)
	  []
	    [(dtS eq X) and (dtC eq Bit (X))] ->
	      C ? newdtC : BitArray [newdtC ne Bit (X)];
	      Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
	       (edge, dtA, dtB, dtS, newdtCk, newdtC)
	  []
	    [dtS ne X of bit] ->
	      (
		[(dtS eq 0 of bit) and (dtA ne Bit (X)) and (dtA ne dtC)] ->
		  C ! dtA;
		  Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
		   (edge, dtA, dtB, dtS, newdtCk, dtA)
	      []
		[(dtS eq 0 of bit) and ((dtA eq Bit(X)) and (dtA ne dtC))] ->
		  Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
		   (edge, dtA, dtB, dtS, newdtCk, dtC)
	      []
		[(dtS eq 0 of bit) and (dtA eq Bit (X)) and (dtC eq Bit (X))] ->
		  C ? newdtC : BitArray [newdtC ne Bit (X)];
		  Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
		   (edge, dtA, dtB, dtS, newdtCk, newdtC)
	      []
		[(dtS eq 0 of bit) and (dtA ne Bit (X)) and (dtA eq dtC)] ->
		  Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
		   (edge, dtA, dtB, dtS, newdtCk, dtC)
	      []
		[(dtS eq 1) and (dtB ne Bit (X)) and (dtB ne dtC)] ->
		  C ! dtB;
		  Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
		   (edge, dtA, dtB, dtS, newdtCk, dtB)
	      []
		[(dtS eq 1) and (dtB ne Bit (X)) and (dtB eq dtC)] ->
		  Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
		   (edge, dtA, dtB, dtS, newdtCk, dtC)
	      []
		[(dts eq 1) and (dtB eq Bit (X)) and (dtC ne Bit (X))] ->
		  Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
		   (edge, dtA, dtB, dtS, newdtCk, dtC) 
	      []
		[(dtS eq 1) and (dtB eq Bit(X)) and (dtB eq dtC)] ->
		  C ? newdtC : BitArray [newdtC ne Bit (X)];
		  Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
		   (edge, dtA, dtB, dtS, newdtCk, newdtC)
	      )			(* end of dtS ne X of bit *)
	  )			(* end of appropriate clock transition *)
      []
	[(newdtCk ne edge) or (dtCk ne not(edge))] -> 
	  Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
	   (edge, dtA, dtB, dtS, newdtCk, dtC)   
      )				(* end of Ck ? -- *)
    []
      [dtC eq Bit (X)] ->
        C ? newdtC : BitArray [newdtC ne Bit (X)];
        Multiplexer2to1_RegN_BB_Aux [A, B, S, Ck, C]
	 (edge, dtA, dtB, dtS, dtCk, newdtC)
    endproc (* Multiplexer2to1_RegN_BB_Aux *)    
  endproc (* Multiplexer2to1_RegN_BB *)
')')
