################################### Header ###################################

# "dill_register.m4"	Ji He, K. J. Turner	24/09/97

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach. Bit states (but not signals) may have an "X" (unknown)
# value - generally for their initial condition.
#
# This particular file deals with registers (bucket-brigade, pass-on, shift).

# Copyright 1997 Ji He, K. J. Turner, University of Stirling

################################# Registers ##################################

# "BucketBrigade2_Decl" defines a two-stage bucket brigade

define(BucketBrigade2_Decl,`declare(`$0',JKFlipFlop_Decl
  process BucketBrigade2 [J0, J1, K0, C, Q0, Q1] : noexit :=
    hide QInt, Qbar1 in
      JKFlipFlop [J0, K0, C, Q0, QInt]
    |[C, QInt]|
      JKFlipFlop [J1, QInt0, C, Q1, Qbar1]
  endproc (* BucketBrigade2 *)
')')

# "PassOn2_Decl" defines a two-stage sequential pass-on

define(PassOn2_Decl,`declare(`$0',DFlipFlop_Decl
  process PassOn2 [D, C0, C1, Q] : noexit :=
    hide QInt, Qbar0, Qbar1 in
      DFlipFlop [D, C0, QInt, Qbar0]
    |[QInt]|
      DFlipFlop [QInt, C1, Q, Qbar1]
  endproc (* PassOn2 *)
')')

# "ShiftRegister2_Decl" defines a two-bit shift register

define(ShiftRegister2_Decl,`declare(`$0',DFlipFlop_Decl
  process ShiftRegister2 [D, C, Q1, Q0] : noexit :=
    hide Qbar0, Qbar1 in
      DFlipFlop [D, C, Q1, Qbar1]
    |[Q1]|
      DFlipFlop [Q1, C, Q0, Qbar0]
  endproc (* ShiftRegister2 *)
')')

# "ShiftRegister8_Decl" defines an eight-bit shift register with:

define(ShiftRegister8_Decl, `declare(`$0',`Sink_Decl`' DFlipFlop_Decl
  process ShiftRegister8 [D0, C,D8] : noexit :=
    hide MWire(7, D+), MWire(8, Dbar+) in
      MComp(8, `D, C=', `DFlipFlop[D, C=, D+, Dbar+]')
   |[MWire(8, Dbar+)]|
    MComp(8, `Sink [Dbar+]')
  endproc (* ShiftRegister8 *)
')')

# "Register4_Decl" defines a 4-bit register

define(Register4_Decl, `declare(`$0', `DfilpFlop_Decl
  process Register4 [MWire(4, D), Clk, MWire(4, Q)] : noexit :=
    hide MWire(4, Qbar) in
      MComp(4, Clk= `DfilpFlop [D, Clk, Q, Qbar]')
  endproc (* Register4 *)
')')

# "Register8_Decl" defines an 8-bit register with:
# 
#   D7-D0	data inputs
#   Q7-Q0	data outputs
#   Qbar7-Qbar0	data outputs negated
#   C		common clock input

define(Register8_Decl,
  `declare(`$0',`DFlipFlop_Decl
  process Register8 [MWire(8, D), C,MWire(8,`Q,Qbar')] : noexit :=
    MComp(8, C=, `DFlipFlop [D, C=, Q, Qbar]')
  endproc (* Register8 *)
')')

define(RegisterLoadClr_Decl, `declare(`$0',
  `DFlipFlop_PreClr_Decl`'And2_Decl`'Or2_Decl`'Inverter_Decl`'One_Decl
  process RegisterLoadClr[D, G, Clr, Clk, Q] : noexit :=
    hide GIn, ClkIn, Din1, Din2, Din, Qbar, Pre in
      (
	(Inverter [G, GIn] ||| Inverter [Clk, ClkIn] ||| One [Pre])
      |[G, GIn, ClkIn, Pre]|
	(
	  (
	    (And2 [D, G, Din1] ||| And2 [Q, GIn, Din2]) 
	  |[Din1, Din2]|
	    Or2 [Din1, Din2, Din]
	  )   
	|[Din, Q, ClkIn]|
	  DFlipFlop_PreClr [Din, Pre, Clr, ClkIn, Q, Qbar]
	) 
      )     
  endproc (* RegisterLoadClr *)
')')
   
define(RegisterLoadClr4_Decl, `declare(`$0', `RegisterLoadClr_Decl
  process RegisterLoadClr4 [MWire(4, D), G, Clr, Clk, MWire(4, Q)] : noexit :=
    MComp(4, `G=, Clr=, Clk=', `RegisterLoadClr[D, G=, Clr=, Clk=, Q]')
  endproc (* RegisterLoadClr4 *)
')')

# "RegisterLoadClr4_Tri_Decl" defines a 4 bit D type Register with tristate output.
#
#   D3--D0:	data inputs
#   G1, G2:	data enabla(0 active)
#   Clr:	asynchronous clear
#   Clk:	clock
#   M, N:	output control
#   Q3--Q0:	data outputs
# Ls173

define(RegisterLoadClr4_Tri_Decl, 
  `declare(`$0', `RegisterLoadClr4_Decl`'Nor2_Decl`'Inverter_One_Decl
  process RegisterLoadClr4_Tri [M, N, MWire(4, D), G1, G2, Clr, Clk, MWire(4, Q)]
   : noexit :=
    hide G, MWire(4, QIn) in
      (
        Nor2 [G1, G2, G]  
      |||
        Nor2 [M, N, MN]
      )
    |[MN, G]|
      (
	RegisterLoadClr4 [MWire(4, D), G, Clr, Clk, MWire(4, QIn)]
      |[MWir(4, QIn)]|
	Inverter_One [MWire(4, QIn), MN, MWire(4, Q)]
      )
  endproc (* RegisterLoadClr4_Tri *)
')')
