################################### Header ###################################

# "dill_register_bb.m4"	Ji He, K. J. Turner	24/09/97

# This "m4" macro file contains templates for specification of digital logic
# components and circuits in LOTOS according to the DILL (Digital Logic in
# LOTOS) approach.
#
# This particular file deals with the black-box forms of registers
# (bucket-brigade, pass-on, shift).

# Copyright 1997 Ji He, K. J. Turner, University of Stirling

################################# Registers ##################################

# "RegisterLoadClr_Decl" defines a 1 bit register with asynchronized clear input
# and a Load enable input
 
define(RegisterLoadClr_BB_Pos_Decl, `declare(`$0', `RegisterLoadClr_BB_Decl
  process RegisterLoadClr_BB_Pos [D, G, Clr, Clk, Q] : noexit :=
    RegisterLoadClr_BB [D, G, Clr, Clk, Q] (1 of Bit)
  endproc (*  RegisterLoadClr_BB_Pos *)
')')

define(RegisterLoadClr_BB_Neg_Decl, `declare(`$0', ` RegisterLoadClr_BB_Decl 
  process RegisterLoadClr_BB_Neg[D, G, Clr, Clk, Q] : noexit :=
    RegisterLoadClr_BB [D, G, Clr, Clk, Q] (0 of Bit)
  endproc (* RegisterLoadClr_BB_Neg *)
')')

define(RegisterLoadClr_BB_Decl, `declare(`$0', `
  process RegisterLoadClr_BB [D, G, Clr, Clk, Q](edge: Bit) : noexit :=
    RegisterLoadClr_BB_Aux [D, G, Clr, Clk, Q] 
     (edge, X of Bit, X of Bit, X of Bit, X of Bit, X of Bit)

    where 
    
    process  RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
     (edge, dtD, dtG, dtClr, dtClk, dtQ : Bit) : noexit :=
      D ? newdtD: Bit;
      RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
       (edge, newdtD, dtG, dtClr, dtClk, dtQ)  
    []
      G ? newdtG: Bit;
      RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
       (edge, dtD, newdtG, dtClr, dtClk, dtQ)
    []
      Clr ? newdtClr: Bit;
      RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
       (edge, dtD, dtG, newdtClr, dtClk, dtQ)
    []
      Clk ? newdtClk: Bit;
      (
        [(dtClk eq not (edge)) and (newdtClk eq edge)] ->  
	  (
	    [(dtClr eq 1) and (dtG eq 1)] ->   
	      (
		[(dtD eq X) and (dtQ eq X)] ->  
		  Q ? newdtQ : Bit [newdtQ ne X];
		  RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
		   (edge, dtD, dtG, dtClr, newdtClk, newdtQ)
	      []
		[(dtD eq X) and (dtQ ne X)] ->
		  RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
		   (edge, dtD, dtG, dtClr, newdtClk, dtQ)
	      [] 
		[(dtD eq 0 of Bit) and (dtQ ne 0 of Bit)] ->     
		  Q ! 0 of Bit ;
		  RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
		   (edge, dtD, dtG, dtClr, newdtClk, 0 of Bit) 
	      []      
		[(dtD eq 0 of Bit) and (dtQ eq 0 of Bit)] -> 
		  RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
		   (edge, dtD, dtG, dtClr, newdtClk, 0 of Bit)        
	      []
		[(dtD eq 1) and (dtQ ne 1)] ->     
		  Q ! 1 of Bit;  
		  RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
		   (edge, dtD, dtG, dtClr, newdtClk, 1 of Bit)    
	      []
		[(dtD eq 1) and (dtQ eq 1) ] ->
		  RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
		   (edge, dtD, dtG, dtClr, newdtClk, 1 of Bit)       
	      )
	  []
	    [(dtClr ne 1) or (dtG ne 1)] ->
	      RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
	       (edge, dtD, dtG, dtClr, newdtClk, dtQ)
	  )			(* end of appropriate clock transition *)
      []
        [(dtClk ne not (edge)) or (newdtClk ne edge)] ->  
	  RegisterLoadClr_BB_Aux[D, G, Clr, Clk, Q]
	    (edge, dtD, dtG, dtClr, newdtClk, dtQ)
      )				(* end of clock transition *)       
    []				(* clear *)
      [(dtClr eq 0 of Bit) and (dtQ ne 0 of Bit)] ->      
        Q ! 0 of Bit; 
        RegisterLoadClr_BB_Aux [D, G, Clr, Clk, Q]
	 (edge, dtD, dtG, dtClr, dtClk, 0 of Bit)  
    endproc (* RegisterLoadClr_BB_Aux  *)
  endproc (* RegisterLoadClr_BB  *)
')')

# "RegisterLoadClr4_BB_Decl" defines a 1 Bit register with asynchronized clear
# input and a load enable input
 
define(RegisterLoadClr4_BB_Pos_Decl, `declare(`$0', `RegisterLoadClr_BB_Pos_Decl
  process RegisterLoadClr4_BB_Pos [MWire(4, D), G, Clr, Clk, MWire(4, Q)] : noexit :=
     MComp(4, `G=, Clr=, Clk=', `RegisterLoadClr_BB_Pos [D, G=, Clr=, Clk=, Q]')
  endproc (* RegisterLoadClr4_BB_Pos *)
')')

define(RegisterLoadClr4_BB_Neg_Decl, `declare(`$0', `RegisterLoadClr_BB_Neg_Decl 
  process RegisterLoadClr4_BB_Neg [MWire(4, D), G, Clr, Clk, MWire(4, Q)] : noexit :=
    MComp(4, `G=, Clr=, Clk=', `RegisterLoadClr_BB_Neg [D, G=, Clr=, Clk=, Q]')
  endproc (* RegisterLoadClr4_BB_Neg  *)
')')

# "ShiftRegister2_BB_Decl" defines a two-stage shift register

define(ShiftRegister2_BB_Pos_Decl, `declare(`$0', `ShiftRegister2_BB_Decl
  process ShiftRegister2_BB_Pos [D, C, Q1, Q0] : noexit :=
    ShiftRegister2_BB [D, C, Q1, Q0] (1)
  endproc (* ShiftRegister2_BB_Pos *)
')')

define(ShiftRegister2_BB_Neg_Decl, `declare(`$0', `ShiftRegister2_BB_Decl
  process ShiftRegister2_BB_Neg [D, C, Q1, Q0] : noexit :=
    ShiftRegister2_BB [D, C, Q1, Q0] (0 of Bit)
  endproc (* ShiftRegister2_BB_Neg *)
')')
 
define(ShiftRegister2_BB_Decl, `declare(`$0', `
  process ShiftRegister2_BB [D, C, Q1, Q0] (edge: Bit) : noexit :=
    ShiftRegister2_BB_Aux [D, C, Q1, Q0] 
     (edge, X of Bit, X of Bit, X of Bit, X of Bit)
 
    where
    
    process ShiftRegister2_BB_Aux [D, C, Q1, Q0] 
      (edge, dtD, dtC, dtQ1, dtQ0 : Bit) : noexit :=
      D ? newdtD : Bit;
      ShiftRegister2_BB_Aux [D, C, Q1, Q0] (edge, newdtD, dtC, dtQ1, dtQ0)
    []
      C ? newdtC : Bit;
      (
	[(dtC eq not (edge)) and (newdtC eq edge)] ->
	  (
	    let newdtQ1 : Bit = dtQ0,
		newdtQ0 : Bit = dtD in
	    (
	      (
		(
		  [(newdtQ1 eq X) or (newdtQ1 eq dtQ1)] ->
		    exit (dtQ1, any Bit)
		[]
		  [(newdtQ1 ne X) and (newdtQ1 ne dtQ1)] ->
		    Q1 ! newdtQ1; exit (newdtQ1, any Bit)
		)
	      |||
		(
		  [(newdtQ0 eq X) or (newdtQ0 eq dtQ0)] ->
		    exit (any Bit, dtQ0)
		[]
		  [(newdtQ0 ne X) and (newdtQ0 ne dtQ0)] ->
		    Q0 ! newdtQ0; exit (any Bit, newdtQ0)
		)
	      )			(* end of interleaving *)
	    >>
	      accept nowdtQ1 : Bit, nowdtQ0 : Bit  in
		ShiftRegister2_BB_Aux [D, C, Q1, Q0]
		  (edge, dtD, newdtC, nowdtQ1, nowdtQ0)
	    )			(* end of let *)
	  )			(* end of appropriate clock transition *)
      []
	[(dtC eq edge) or (dtC eq X) or (newdtC eq not (edge))] ->
	  ShiftRegister2_BB_Aux [D, C, Q1, Q0] (edge, dtD, newdtC, dtQ1, dtQ0)
      )				(* end of C ? --- *)
    []
      [dtQ1 eq X] ->
        Q1 ? newdtQ1 : Bit [newdtQ1 ne X];
        ShiftRegister2_BB_Aux [D, C, Q1, Q0] (edge, dtD, dtC, newdtQ1, dtQ0)
    []
      [dtQ0 eq X] ->
	Q0 ? newdtQ0 : Bit [newdtQ0 ne X];
	ShiftRegister2_BB_Aux [D, C, Q1, Q0] (edge, dtD, dtC, dtQ1, newdtQ0)
    endproc (* ShiftRegister2_BB_Aux *)
  endproc (* ShiftRegister2_BB *)
')')

# "Register4_BB_Decl" defines a 4 Bit register with:
# 
#   D3-D0	data inputs
#   Q3-Q0	data outputs
#   C		common clock input

# Error: Syntax error in input specification

define(Register4_BB_Pos_Decl, `declare(`$0', `Register4_BB_Decl
  process Register4_BB_Pos [MWire(4, D), C, MWire(4, Q)] : noexit :=
    Register4_BB [MWire(4, D), C, MWire(4, Q)] (1 of Bit)
  endproc (* Register4_BB_Pos *)
')')

define(Register4_BB_Neg_Decl, `declare(`$0', `Register4_BB_Decl
  process Register4_BB_Neg [MWire(4, D), C, MWire(4, Q)] : noexit :=
    Register4_BB [MWire(4, D), C, MWire(4, Q)] (0 of Bit)
  endproc (* Register4_BB_Neg *)
')')

define(Register4_BB_Decl, `declare(`$0', `
  process Register4_BB [MWire(4, D), C, MWire(4, Q)] (edge: Bit) : noexit :=
   Register4_BB_Aux [MWire(4, D), C, MWire(4, Q)] 
    (edge, MWire(4, X of Bit=), X of Bit, MWire(4, X of Bit=))

    where
    
    process Register4_BB_Aux [MWire(4, D), C, MWire(4, Q)] 
     (edge, MWire(4, dtD), dtC, MWire(4, dtQ): Bit) : noexit :=
      
      D3 ? newdtD3 : Bit;
      Register4_BB_Aux [MWire(4, D), C, MWire(4, Q)] 
       (edge, newdtD3, dtD2, dtD1, dtD0, dtC, MWire(4, dtQ))
    []
      D2 ? newdtD2 : Bit;
      Register4_BB_Aux [MWire(4, D), C, MWire(4, Q)] 
       (edge, dtD3, newdtD2, dtD1, dtD0, dtC, MWire(4, dtQ))
    []
      D1 ? newdtD1 : Bit;
      Register4_BB_Aux [MWire(4, D), C, MWire(4, Q)] 
       (edge, dtD3, dtD2, newdtD1, dtD0, dtC, MWire(4, dtQ))
    []
      D0 ? newdtD0 : Bit;
      Register4_BB_Aux [MWire(4, D), C, MWire(4, Q)] 
      (edge, dtD3, dtD2, dtD1, newdtD0, dtC, MWire(4, dtQ))
    []
      C ? newdtC : Bit;
      (
        [(newdtC eq edge) and (dtC eq not (edge))] -> (* appropriate clock transition *)
          (
	    let newdtQ3 : Bit = dtD3, newdtQ2 : Bit = dtD2,
	        newdtQ1 : Bit = dtD1, newdtQ0 : Bit = dtD0 in 
	    (
	      (
		(
		  [((newdtQ3 eq X of Bit) and (dtQ3 ne X of Bit)) or  
		   ((newdtQ3 eq dtQ3) and (newdtQ3 ne X of Bit))] -> 
		    exit (dtQ3, any Bit, any Bit, any Bit) 
	        []
		  [(newdtQ3 eq X of Bit) and (dtQ3 eq X of Bit)] ->
		    Q3 ? newdtQ3 : Bit [newdtQ3 ne X of Bit];
		    exit (newdtQ3, any Bit, any Bit, any Bit)
	        []
		  [(newdtQ3 ne X of Bit) and (newdtQ3 ne dtQ3)] ->
		    Q3 ! newdtQ3;
		    exit (newdtQ3, any Bit, any Bit, any Bit)
		)
	      |||
		(
		  [((newdtQ2 eq X of Bit) and (dtQ2 ne X of Bit)) or
		   ((newdtQ2 eq dtQ2) and (newdtQ2 ne X of Bit))] -> 
		    exit (any Bit, dtQ2, any Bit, any Bit) 
		[]
		  [(newdtQ2 eq X of Bit) and (dtQ2 eq X of Bit)] ->
		    Q2 ? newdtQ2 : Bit [newdtQ2 ne X of Bit];
		    exit (any Bit, newdtQ2, any Bit, any Bit)
		[]
		  [(newdtQ2 ne X of Bit) and (newdtQ2 ne dtQ2)] ->
		    Q2 ! newdtQ2;
		    exit (any Bit, newdtQ2, any Bit, any Bit)
		)
	      |||
		(
		  [((newdtQ1 eq X of Bit) and (dtQ1 ne X of Bit)) or
		   ((newdtQ1 eq dtQ1) and (newdtQ1 ne X of Bit))] -> 
		    exit (any Bit, any Bit, dtQ1, any Bit) 
		[]
		  [(newdtQ1 eq X of Bit) and (dtQ1 eq X of Bit)] ->
		    Q1 ? newdtQ1 : Bit [newdtQ1 ne X of Bit];
		    exit (any Bit, any Bit, newdtQ1, any Bit)
		[]
		  [(newdtQ1 ne X of Bit) and (newdtQ1 ne dtQ1)] ->
		    Q1 ! newdtQ1;
		    exit (any Bit, any Bit, newdtQ1, any Bit)
		)
	      |||
	        (
		  [((newdtQ0 eq X of Bit) and (dtQ0 ne X of Bit)) or
		   ((newdtQ0 eq dtQ0) and (newdtQ0 ne X of Bit))] -> 
		    exit (any Bit, any Bit , any Bit, dtQ0) 
	        []
		  [(newdtQ0 eq X of Bit) and (dtQ0 eq X of Bit)] ->
		    Q0 ? newdtQ0 : Bit [newdtQ0 ne X of Bit];
		    exit (any Bit, any Bit, any Bit, newdtQ0)
	        []
		  [(newdtQ0 ne X of Bit) and (newdtQ0 ne dtQ1)] ->
		    Q0 ! newdtQ0;
		    exit (any Bit, any Bit, any Bit, newdtQ0)
	        )     
	      )			(* end of interleaving *)
	    >>
	      accept MWire(4, nowdtQ) : Bit in 
	        Register4_BB_Aux [MWire(4, D), C, MWire(4, Q)] 
	         (edge, MWire(4, dtD), newdtC, MWire(4, nowdtQ))
	    )			(* end of let *) 
          )			(* end of appropriat clock transition  *)
      []
	[(newdtC eq not (edge)) or (dtC ne edge)] ->       
	  Register4_BB_Aux [MWire(4, D), C, MWire(4, Q)] 
	   (edge, MWire(4, dtD), newdtC, MWire(4, dtQ))
      )				(* end of C ? --- *)
    endproc (* Register4_BB_Aux *)
  endproc (* Register4_BB *)
')')

# "ShiftRegister8_BB_Pos_Decl" defines an eight-Bit shift register with:
# 
#   Q7--Q0:     data output
#   D		data input
#   C		common clock input

define(ShiftRegister8_BB_Pos_Decl, `declare(`$0', `Shift8_BB_Decl
  process ShiftRegister8_BB_Pos [D, C, MWire(8, Q)] : noexit :=
    Shift8_BB [D, C, MWire(8, Q)] (1)
  endproc (*ShiftRegister8_BB_Pos*)
')')

define(ShiftRegister8_BB_Neg_Decl, `declare(`$0', `Shift8_BB_Decl
  process ShiftRegister8_BB_Neg [D, C, MWire(8, Q)] : noexit :=
    Shift8_BB [D, C, MWire(8, Q)] (0 of Bit)
  endproc (*ShiftRegister8_BB_Neg*)
')')

define(ShiftRegister8_BB_Decl, `declare(`$0', `
  process ShiftRegister8_BB [D, C, MWire(8, Q)] (edge : Bit) : noexit :=
    ShiftRegister8_BB Aux [D, C, MWire(8, Q)]
     (edge, X of Bit, X of Bit, MWire(8, X of Bit=))

    where
    
    process ShiftRegister8_BB_Aux [D, C, MWire(8, Q)] 
      (edge, dtD, dtC, MWire(8, dtQ) : Bit) : noexit :=
      D ? newdtD : Bit;
      ShiftRegister8_BB_Aux [D, C, MWire(8, Q)]
       (edge, newdtD, dtC, MWire(8, dtQ))
    []
      C ? newdtC : Bit;
      (
        [(newdtC eq edge) and (dtC eq not (edge))] ->
	  (
	    let newdtQ7 : Bit = dtQ6, newdtQ6 : Bit = dtQ5, newdtQ5 : Bit = dtQ4,
		newdtQ4 : Bit = dtQ3, newdtQ3 : Bit = dtQ2, newdtQ2: Bit = dtQ1,
		newdtQ1 : Bit = dtQ0, newdtQ0 : Bit = dtD in
	    (
	      (
		(
		  [(newdtQ7 eq X) or (newdtQ7 eq dtQ7)] ->
		    exit (dtQ7, MWire(7, any Bit=))
		[]
		  [(newdtQ7 ne X) and (newdtQ7 ne dtQ7)] ->
		    Q7 ! newdtQ7;
		    exit (newdtQ7, MWire(7, any Bit=))
		)
	      |||
		(
		  [(newdtQ6 eq X) or (newdtQ6 eq dtQ6)] ->
		    exit (any Bit, dtQ6, MWire(6, any Bit=))
		[]
		  [(newdtQ6 ne X) and (newdtQ6 ne dtQ6)] ->
		    Q6 ! newdtQ6;
		    exit (any Bit, newdtQ6, MWire(6, any Bit=))
		)
	      |||
		(
		  [(newdtQ5 eq X) or (newdtQ5 eq dtQ5)] ->
		    exit (any Bit, any Bit, dtQ5, MWire(5, any Bit=))
		[]
		  [(newdtQ5 ne X) and (newdtQ5 ne dtQ5)] ->
		   Q5 ! newdtQ5;
		    exit (any Bit, any Bit, newdtQ5, MWire(5, any Bit=))
		)
	      |||
		(
		  [(newdtQ4 eq X) or (newdtQ4 eq dtQ4)] ->
		    exit (MWire(3, any Bit=), dtQ4, MWire(4, any Bit=))
		[]
		  [(newdtQ4 ne X) and (newdtQ4 ne dtQ4)] ->
		    Q4 ! newdtQ4;
		    exit (MWire(3, any Bit=), newdtQ4, MWire(4, any Bit=))
		)
	      |||
		(
		  [(newdtQ3 eq X) or (newdtQ3 eq dtQ3)] ->
		    exit (MWire(4, any Bit=), dtQ3, MWire(3, any Bit=))
		[]
		  [(newdtQ3 ne X) and (newdtQ3 ne dtQ3)] ->
		    Q3 ! newdtQ3;
		    exit (MWire(4, any Bit=), newdtQ3, MWire(3, any Bit=))
		)
	      |||
		(
		  [(newdtQ2 eq X) or (newdtQ2 eq dtQ2)] ->
		    exit (MWire(5, any Bit=), dtQ2, MWire(2, any Bit=))
		[]
		  [(newdtQ2 ne X) and (newdtQ2 ne dtQ2)] ->
		    Q2 ! newdtQ2;
		    exit (MWire(5, any Bit=), newdtQ2, MWire(2, any Bit=))
		)
	      |||
		(
		  [(newdtQ1 eq X) or (newdtQ1 eq dtQ1)] ->
		    exit (MWire(6, any Bit=), dtQ1, any Bit)
		[]
		  [(newdtQ1 ne X) and (newdtQ1 ne dtQ1)] ->
		    Q1 ! newdtQ1;
		    exit (MWire(6, any Bit=), newdtQ1, any Bit)
		)
	      |||
		(
		  [(newdtQ0 eq X) or (newdtQ0 eq dtQ0)] ->
		    exit (MWire(7, any Bit=), dtQ0)
		[]
		  [(newdtQ0 ne X) and (newdtQ0 ne dtQ0)] ->
		    Q0 ! newdtQ0;
		    exit (MWire(7, any Bit=), newdtQ0)
		)
	      ) (* end of interleaving *)
	    >>
	      accept MWire(8, nowdtQ) : Bit in 
		ShiftRegister8_BB_Aux [D, C, MWire(8, Q)]
		 (edge, dtD, newdtC, MWire(8, nowdtQ))
	    )			(* end of let *)
	  )			(* end of appropriate clock transitioin *)
      []
	[(newdtC ne edge) or (dtC ne not (edge))] ->
	  ShiftRegister8_BB_Aux [D, C, MWire(8, Q)]
	   (edge, dtD, newdtC, MWire(8, dtQ))
      )				(* end of C ? -- *)
    []
      [dtQ7 eq X] ->
	Q7  ? newdtQ7: Bit [newdtQ7 ne X];
	ShiftRegister8_BB_Aux [D, C, MWire(8, Q)]
	 (edge, dtD, dtC, newdtQ7, MWire(7, dtQ))
    []
      [dtQ6 eq X] ->
	Q6 ? newdtQ6 : Bit [newdtQ6 ne X];
	ShiftRegister8_BB_Aux [D, C, MWire(8, Q)]
	 (edge, dtD, dtC, dtQ7, newdtQ6, MWire(6, dtQ))
    []
      [dtQ5 eq X] ->
	Q5  ? newdtQ5 : Bit [newdtQ5 ne X];
	ShiftRegister8_BB_Aux [D, C, MWire(8, Q)] 
	 (edge, dtD, dtC, dtQ7, dtQ6, newdtQ5, MWire(5, dtQ))
    []
      [dtQ4 eq X] ->
	Q4  ? newdtQ4 : Bit [newdtQ4 ne X];
	ShiftRegister8_BB_Aux [D, C, MWire(8, Q)] 
	 (edge, dtD, dtC, MWire(3, dtQ+++++), newdtQ4, MWire(4, dtQ))
    []
      [dtQ3 eq X] ->
	Q3  ? newdtQ3 : Bit [newdtQ3 ne X];
	ShiftRegister8_BB_Aux [D, C, MWire(8, Q)] 
	 (edge, dtD, dtC, MWire(4, dtQ++++), newdtQ3, MWire(3, dtQ))
    []
      [dtQ2 eq X] ->
	Q2  ? newdtQ2 : Bit [newdtQ2 ne X];
	ShiftRegister8_BB_Aux [D, C, MWire(8, Q)] 
	 (edge, dtD, dtC, MWire(5, dtQ+++), newdtQ2, MWire(2, dtQ))
    []
      [dtQ1 eq X] -> 
	Q1  ? newdtQ1 : Bit [newdtQ1 ne X];
	ShiftRegister8_BB_Aux [D, C, MWire(8, Q)] 
	 (edge, dtD, dtC, MWire(6, dtQ++), newdtQ1, dtQ0)
    []
      [dtQ0 eq X] ->
	Q0 ? newdtQ0 : Bit [newdtQ0 ne X];
	ShiftRegister8_BB_Aux [D, C, MWire(8, Q)]
	 (edge, dtD, dtC, MWire(7, dtQ+), newdtQ0)
    endproc (* ShiftRegister8_BB_Aux *)
  endproc (* ShiftRegister8_BB *)
')')

define(RegisterN_BB_Pos_Decl, `declare(`$0', `RegisterN_BB_Decl
  process RegisterN_BB_Pos [D, C, Q, Qbar] : noexit :=
    RegisterN_BB [D, C, Q, Qbar] (1 of Bit)
  endproc (* RegisterN_BB_Pos *)
')')

define(RegisterN_BB_Neg_Decl, `declare(`$0', `RegisterN_BB_Decl
  process RegisterN_BB_Neg [D, C, Q, Qbar] : noexit :=
    RegisterN_BB [D, C, Q, Qbar] (0 of Bit)
  endproc (* RegisterN_BB_Neg *)
')')

define(RegisterN_BB_Decl, `declare(`$0', `
  process RegisterN_BB [D, C, Q, Qbar] (edge: Bit) : noexit :=
    RegisterN_BB_Aux [D, C, Q, Qbar] 
     (edge, Bit (X of Bit), X of Bit, Bit (X of Bit), Bit (X of Bit))

    where
    
    process RegisterN_BB_Aux [D, C, Q, Qbar] 
     (edge: Bit, dtD : Bitarray, dtC: Bit, dtQ, dtQbar : BitArray) : noexit :=
      D ? newdtD : BitArray;
      RegisterN_BB_Aux [D, C, Q, Qbar] (edge, newdtD, dtC, dtQ, dtQbar)
    []
      C ? newdtC : Bit;
      (
        [(newdtC eq edge) and (dtC eq not (edge))] -> 
	  (
	    let newdtQ : Bitarray = dtD,
	        newdtQbar : Bitarray = not (dtD) in
	    (
	      [(newdtQ ne Bit (X)) and (newdtQ ne dtQ)] ->
	        (
		  (
		    Q ! newdtQ;
		    exit
		  )
		|||
		  (
		    Qbar ! newdtQbar;
		    exit
		  ) 
		>>
		  RegisterN_BB_Aux [D, C, Q, Qbar]
		   (edge, dtD, newdtC, newdtQ, newdtQbar)
	        )
	    []
	      [(newdtQ eq Bit (x)) or (newdtQ eq dtQ)] ->
		RegisterN_BB_Aux [D, C, Q, Qbar] (edge, dtD, newdtC, dtQ, dtQbar)
	    )  (* end of let *)
	  )			(* end of appropriate transition *)
      []
	[ (newdtC ne edge) or (dtC ne not (edge))] ->
	RegisterN_BB_Aux [D, C, Q, Qbar] (edge, dtD, newdtC, dtQ, dtQbar)
      )				(* end of C? -- *)
    []
      [dtQ eq Bit (X)] ->
        Q ? newdtQ : Bitarray [newdtQ ne Bit (X)];
        RegisterN_BB_Aux [D, C, Q, Qbar] (edge, dtD, dtC, newdtQ, dtQbar)
    []
      [dtQbar eq Bit (X)] ->
        Qbar ? newdtQbar : Bitarray [newdtQbar ne Bit (X)];
        RegisterN_BB_Aux [D, C, Q, Qbar] (edge, dtD, dtC, dtQ, newdtQbar)
    endproc (* RegisterN_BB_Aux *)
  endproc (* RegisterN_BB *)
')')
