/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class Easter
extends MIDlet
implements CommandListener {
    private static final int itemCentred = 16899;
    private static final int yearMinimum = 1600;
    private static final int yearMaximum = 9999;
    private static final Command commandAbout = new Command("About", 1, 1);
    private static final Command commandEaster = new Command("Easter", 1, 0);
    private static final Command commandExit = new Command("Exit", 7, 1);
    private static final Command commandOK = new Command("OK", 4, 1);
    private Display display;
    private static final Alert easterAbout = new Alert("About Easter", "Author: (C) Kenneth J. Turner\n\nURL: www.cs.stir.ac.uk/~kjt/software/pda/easter.html\n\nVersion: 1.0 (2006-12-31)\n\nLicence: GPL (no fee, no warranty)\n\nYear: 1600 to 9999 (Red if selected, Left or Clear key to delete digits)\n\nAlgorithm: 'Puzzles and Paradoxes', T. H. O'Beirne, 1965 (p. 180)", null, AlertType.INFO);
    private StringItem easterDate = new StringItem("Date: ", "");
    private Form easterForm;
    private final Spacer easterSpacer = new Spacer(0, 0);
    private static ImageItem imageEaster = null;
    private static final Alert yearError;
    private NumberField yearField;
    private final Spacer yearSpacer = new Spacer(0, 0);

    public Easter() {
        this.display = Display.getDisplay((MIDlet)this);
        this.easterForm = new Form("Easter Sunday");
        this.yearField = new NumberField(this.display, "Enter Date:", 4);
        easterAbout.setTimeout(-2);
        this.easterDate.setLayout(16899);
        this.easterSpacer.setLayout(16899);
        yearError.addCommand(commandOK);
        yearError.setTimeout(5000);
        this.yearField.setLayout(16899);
        this.yearSpacer.setLayout(16899);
        this.easterForm.append((Item)this.yearSpacer);
        this.easterForm.append((Item)this.yearField);
        this.easterForm.append((Item)imageEaster);
        this.easterForm.append((Item)this.easterSpacer);
        this.easterForm.append((Item)this.easterDate);
        this.easterForm.addCommand(commandAbout);
        this.easterForm.addCommand(commandExit);
        this.easterForm.addCommand(commandEaster);
        this.easterForm.setCommandListener((CommandListener)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == commandAbout) {
            this.display.setCurrent((Displayable)easterAbout);
        } else if (command == commandEaster) {
            String string = this.yearField.getString();
            int n = string != null && string.length() > 0 ? Integer.parseInt(string) : 0;
            this.yearField.resetNumber();
            if (1600 <= n && n <= 9999) {
                this.setDate(n);
            } else {
                this.display.setCurrent((Displayable)yearError);
            }
            this.display.setCurrentItem((Item)this.yearField);
        } else if (command == commandExit) {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
    }

    private String dayOf(int n) {
        String string = n == 1 || n == 21 || n == 31 ? "st" : (n == 2 || n == 22 ? "nd" : (n == 3 || n == 23 ? "rd" : "th"));
        return n + string;
    }

    public void destroyApp(boolean bl) {
    }

    private String monthOf(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "January";
                break;
            }
            case 2: {
                string = "February";
                break;
            }
            case 3: {
                string = "March";
                break;
            }
            case 4: {
                string = "April";
                break;
            }
            case 5: {
                string = "May";
                break;
            }
            case 6: {
                string = "June";
                break;
            }
            case 7: {
                string = "July";
                break;
            }
            case 8: {
                string = "August";
                break;
            }
            case 9: {
                string = "September";
                break;
            }
            case 10: {
                string = "October";
                break;
            }
            case 11: {
                string = "November";
                break;
            }
            case 12: {
                string = "December";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public void pauseApp() {
    }

    public void setDate(int n) {
        int n2 = n / 100;
        int n3 = n % 100;
        int n4 = (5 * n2 + n3) % 19;
        int n5 = 3 * (n2 + 25) / 4;
        int n6 = 3 * (n2 + 25) % 4;
        int n7 = 8 * (n2 + 11) / 25;
        int n8 = (19 * n4 + n5 - n7) % 30;
        int n9 = (n4 + 11 * n8) / 319;
        int n10 = (60 * (5 - n6) + n3) / 4;
        int n11 = (60 * (5 - n6) + n3) % 4;
        int n12 = (2 * n10 - n11 - n8 + n9) % 7;
        int n13 = (n8 - n9 + n12 + 110) / 30;
        int n14 = (n8 - n9 + n12 + 110) % 30;
        int n15 = n14 + 5 - n13;
        this.easterDate.setText(this.dayOf(n15) + " " + this.monthOf(n13) + " " + n);
    }

    public void startApp() {
        this.display.setCurrentItem((Item)this.yearField);
    }

    static {
        try {
            imageEaster = new ImageItem("", Image.createImage((String)"/EasterLarge.png"), 16899, "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        yearError = new Alert("Year Error", "Year must be 1600 to 9999", null, AlertType.ERROR);
    }
}

