/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class NumberField
extends CustomItem {
    private static final int colourActive = 0xFF0000;
    private static final int colourInactive = 255;
    private Display numberDisplay;
    private static final int minHeight = Font.getDefaultFont().getHeight();
    private static final int minWidth = 4 * minHeight;
    private static final int SE_CLEAR = -8;
    private int numberColour;
    private int numberSize;
    private String numberValue;

    public NumberField(Display display, String string, int n) {
        super(string);
        this.numberDisplay = display;
        this.numberSize = n;
        this.resetNumber();
    }

    public int getMinContentHeight() {
        return minHeight;
    }

    public int getMinContentWidth() {
        return minWidth;
    }

    public int getPrefContentHeight(int n) {
        return minHeight;
    }

    public int getPrefContentWidth(int n) {
        return minWidth;
    }

    public void keyReleased(int n) {
        int n2 = this.numberValue.length();
        if (n2 < this.numberSize && 48 <= n && n <= 57) {
            this.numberValue = this.numberValue + (char)n;
        } else if (n2 > 0 && (n == -3 || n == -8)) {
            this.numberValue = this.numberValue.substring(0, n2 - 1);
        }
        this.numberColour = 0xFF0000;
        this.repaint();
    }

    public void paint(Graphics graphics, int n, int n2) {
        graphics.setColor(this.numberColour);
        graphics.drawString(this.numberValue, 0, 0, 20);
    }

    public String getString() {
        return this.numberValue;
    }

    public void resetNumber() {
        this.numberValue = "";
        this.numberColour = 0xFF0000;
        this.repaint();
    }

    public void setString(String string) {
        this.numberValue = string;
        this.repaint();
    }

    public boolean traverse(int n, int n2, int n3, int[] nArray) {
        this.numberColour = 0xFF0000;
        this.repaint();
        return false;
    }

    public void traverseOut() {
        this.numberColour = 255;
        this.repaint();
    }
}

