/****************************************************************************

Easter.java	(c) Kenneth J. Turner <kjt@cs.stir.ac.uk>	20/08/02 v1.1

  Display date of Easter from 1600 to 9999, using an algorithm from
  "Puzzles and Paradoxes", T. H. O'Beirne, 1965 (p. 180)

  KJT 20/08/02:

    o Modified for consistency with Superwaba 3.0

****************************************************************************/

import waba.fx.*;				// sound effects
import waba.sys.*;				// system support
import waba.ui.*;				// user interface

public class Easter extends MainWindow {	// Easter class
  private Label yearLabel;			// label for year
  private Edit yearText;			// text field for year
  private Button calculateButton;		// calculate button
  private Label easterLabel;			// label for Easter
  private Label dateLabel;			// label for Easter date
  private final int yearMin = 1600;		// set lowest year
  private final int yearMax = 9999;		// set highest year
  private MessageBox aboutMessage =		// set about message
    new MessageBox (
      "About Easter",
      "DATE OF EASTER SUNDAY||" +
      "Kenneth J. Turner| <kjt@cs.stir.ac.uk>|" +
      "www.cs.stir.ac.uk/~kjt/software/|  pda/easter.html||" +
      "Version 1.1 (c) 20th August 2002|" +
      "GPL Licence: no fee, no warranty!||" +
      "Enter year in range " + yearMin + " to " + yearMax + "|" +
      "Algorithm from|'Puzzles and Paradoxes',|" +
      "T. H. O'Beirne, 1965 (p. 180)||" +
      "Created with SuperWaba||http://www.superwaba.org/||" +
      "See the software license at|this URL, or email|" +
      "<guich@superwaba.org>",
      new String[] {"OK"});
  private static String menu[] = {		// set up menu
    "Easter", "About..."};
  private MenuBar menuBar =			// set up menu bar
    new MenuBar (new String[][]{menu});
  public static final Color backgroundColour =	// background colour
    new Color (255, 255, 176);
  private static final Color buttonColour =	// border colour
    new Color (224, 224, 128);
  public static final Color textColour =	// input text colour
    Color.BLACK;

  public Easter () {				// Easter constructor
    super ("Easter", TAB_ONLY_BORDER);		// add window title
    setMenuBar (menuBar);			// set up menu bar
    this.setBackColor (backgroundColour);	// colour background for start
    aboutMessage.setRect (0, 0, 160, 160);	// set message box size
    menuBar.setBackForeColors			// set menu colours
      (buttonColour, textColour);
    aboutMessage.setBackForeColors		// set box colours
      (buttonColour, textColour);
    yearLabel = new Label ("Enter Year (yyyy):"); // set year label
    yearLabel.setRect (5, 40, 85, 12);		// set label size
    add (yearLabel);				// add label to layout
    yearText = new Edit ();			// set year text field
    yearText.setText ("");			// set empty text
    yearText.setRect (95, 40, 30, 14);		// set text size
    yearText.setValidChars ("0123456789");	// text numeric
    yearText.setBackForeColors			// set text colours
      (backgroundColour.brighter (), textColour);
    add (yearText);				// add label to layout
    calculateButton = new Button ("Calculate");	// set calculate button
    calculateButton.setBackForeColors		// set button colours
      (buttonColour, textColour);
    calculateButton.setRect (50, 70, 50, 12);	// set button size
    add (calculateButton);			// add button to layout
    easterLabel = new Label ("Easter Sunday is:"); // set Easter label
    easterLabel.setRect (5, 100, 75, 12);	// set label size
    add (easterLabel);				// add label to layout
    dateLabel = new Label ("");			// set Easter date label
    dateLabel.setRect (95, 100, 50, 12);	// set label size
    add (dateLabel);				// add label to layout
  }

  private String dayOf (int d) {		// get day ordinal
    String day;					// day string

    day = Convert.toString (d);			// set day cardinal
    if (d == 1 || d == 21 || d == 31) {		// 1st?
      day += "st";
    }
    else if (d == 2 || d == 22) {		// 2nd?
      day += "nd";
    }
    else if (d == 3 || d == 23) {		// 3rd?
      day += "rd";
    }
    else					// all other cases
      day += "th";
    return (day);				// return day as string
  }

  private void error (String message) {		// report error in date field
    Sound.tone (1000, 80);			// sound alternating tones
    Sound.tone (900, 80);
    Sound.tone (1000, 80);
    dateLabel.setText (message);		// set message in date field
  }

  private String monthOf (int m) {		// get month name
    String month;				// month name

    switch (m) {				// check month number
      case  1: month = "January"; break;
      case  2: month = "February"; break;
      case  3: month = "March"; break;
      case  4: month = "April"; break;
      case  5: month = "May"; break;
      case  6: month = "June"; break;
      case  7: month = "July"; break;
      case  8: month = "August"; break;
      case  9: month = "September"; break;
      case 10: month = "October"; break;
      case 11: month = "November"; break;
      case 12: month = "December"; break;
      default: month = "Unknown";
    }
    return (month);				// return month name
  }

  public void onEvent(Event event) {		// react to event
    int year;					// current year
    int a, b, c, d, e, g, h, j, k, l, m, n, p, q; // intermediate values
    String date;				// Easter date

    if (event.type == ControlEvent.WINDOW_CLOSED) { // window closed?
      if (event.target == menuBar) {		// menu bar?
	switch (menuBar.getSelectedMenuItem ()) { // check menu item
	  case 001:				// about?
	    popupModal (aboutMessage); break;	// show about message
	}
      }
    }
    else if (event.type == ControlEvent.PRESSED) { // button pressed?
      if (event.target == calculateButton) {	// calculate button?
        year =					// get year text as int
          Convert.toInt (yearText.getText ());
        if (yearMin <= year && year <= yearMax) { // year in range?
          b = year / 100;			// compute intermediate values
          c = year % 100;
          a = (5 * b + c) % 19;
          d = (3 * (b + 25)) / 4;
          e = (3 * (b + 25)) % 4;
          g = (8 * (b + 11)) / 25;
          h = (19 * a + d - g) % 30;
          m = (a + 11 * h) / 319;
          j = (60 * (5 - e) + c) / 4;
          k = (60 * (5 - e) + c) % 4;
          l = (2 * j - k - h + m) % 7;
          n = (h - m + l + 110) / 30;		// n = month number
          q = (h - m + l + 110) % 30;
          p = q + 5 - n;			// p = day number
          dateLabel.setText (			// display date
	    dayOf (p) + " " + monthOf (n));
        }
        else					// year out of range
          error ("Year Invalid!");		// report error
      }
    }
  }
}
