/* lexer.h */

/*
 * Copyright (c) 1991-1993  R. Nigel Horspool.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#define MAXLEN		255	/* max command name length */

#ifndef BOOL
#define TRUE		1
#define FALSE		0
#define BOOL		char
#endif


#define SKIPWSPACE()	while( isspace(ch) )		\
			    readch();


extern char tokenbuffer[MAXLEN+1];
extern int ch;			/* current input character */
extern int linenum;
extern char *filename;
extern FILE *f;
extern BOOL german;

extern ENVPTR curr_env, verbatim_env, tabular_env,
	description_env, enumerate_env, itemize_env; 

extern void readch(void);
extern ACTIONPTR get_token(void);
extern ENVPTR lookup_env(char *);
extern void initialize_lexer(void);
