/* main.c */

/*
 * Copyright (c) 1991-1993  R. Nigel Horspool.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
    AUTHOR:	R. Nigel Horspool

    ADDRESS:	Dept. of Computer Science
		University of Victoria
		P.O. Box 3055
		BC, Canada  V8W 3P6

    E-MAIL:	nigelh@csr.uvic.ca

    TELEPHONE:	(604) 721 7227

    FAX:	(604) 721 7292

*/

#ifdef THINK_C
#include <MacHeaders>
#else
#include <unistd.h>
#include <limits.h>
#endif

#ifdef NeXT
#define _NEXT_SOURCE
#define MMLEXT ".framemml"
#else
#define MMLEXT ".mml"
#endif

#define TEXEXT ".tex"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef NeXT
#include "/usr/include/bsd/sys/fcntl.h"
#else
#include <fcntl.h>
#endif

#include "tables.h"
#include "lexer.h"
#include "output.h"
#include "mml-defs.h"
#include "la_mml.h"
#include "main.h"

static char *pgmname;

char *docstyle = "";

#ifndef THINK_C

#ifndef TEXINPUTSDFLT
#define TEXINPUTSDFLT	".:/usr/lib/tex/inputs"
#endif

#ifndef _POSIX_PATH_MAX
#define _POSIX_PATH_MAX	255
#endif

#ifdef NeXT
#define SEP		'/'	/* Unix filename separator */
#else
#define SEP		'\\'	/* Windows filename separator */
#endif

FILE *locateTexFile( char *fname ) {
    char *tp, *dir, *fp;
    char tempFileName[_POSIX_PATH_MAX+1];
    int  flen = strlen(fname);
    int len;
    FILE *result;

    if (fname[0] == '/') {	/* an absolute path name! */
	result = fopen(fname, "r");
	if (result == NULL) perror(fname);
	return result;
    }

    tp = getenv("TEXINPUTS");
    if (tp == NULL)
	tp = TEXINPUTSDFLT;

    for( ; ; ) {
	while(*tp == ':')
	    tp++;
	len = 0;
	while(*tp != ':' && *tp != '\0') {
	    if (len < _POSIX_PATH_MAX)
		tempFileName[len++] = *tp++;
	}
	if (len == 0) break;
	if ((len+flen) > _POSIX_PATH_MAX) continue;
	tempFileName[len++] = '/';
	for( fp=fname;  *fp != '\0';  fp++ )
	    tempFileName[len++] = *fp;
	tempFileName[len] = '\0';
	if (access(tempFileName, R_OK) != 0) continue;
	result = fopen(tempFileName, "r");
	if (result == NULL) perror(tempFileName);
	return result;
    }
    return NULL;
}
#else

#include "macRoutines.h"
#define SEP		':'		/* filename separator */


FILE *locateTexFile( char *fname ) {
    char buffer[256];
    char *intro = "Please locate file: ";
    char *fn;
    int len;
    FILE *result;

    len = strlen(intro) + strlen(fname);
    if (len <= 255)
	sprintf(buffer+1, "%s%s", intro, fname);
    else {
	len = strlen(fname);
	if (len > 255) {
	    FPR(stderr, "File name too long: %s\n", fname);
	    return NULL;
	}
	strcpy(buffer+1, fname);
    }
    buffer[0] = len;	/* convert to a Pascal string */
    fname = getInFileName((void*)buffer);
    result = fopen(fname, "r");
    if (result == NULL) perror(fn);
    return result;
}
#endif


static char *setsuffix( char *inname, char *newsuffix ) {
    register char *cp;
    char *outp, *result;
    char *dotpos = NULL;

    result = outp =
	malloc(strlen(inname) + strlen(newsuffix) + 1);

    for( cp = inname;  *cp != '\0';  cp++ ) {
	/* ignored to place output file in same directory
	if (*cp == SEP) {
	    outp = result;
	    dotpos = NULL;
	    continue;
	}
	*/
	if (*cp == '.') dotpos = outp;
	*outp++ = *cp;
    }
    if (dotpos != NULL) outp = dotpos;
    for( cp = newsuffix;  *outp++ = *cp++; )
	;
    return result;
}

/***************************************************************/
/* Check if "str1" ends with "str2".                           */
/***************************************************************/

int strend(str1, str2)
char *str1, *str2;
{
  char *strptr;

  if ((strptr = strstr (str1, str2)) != NULL)
    return *(strptr + strlen (str2)) == '\0';
  else
    return 0;
}

#ifndef THINK_C

/*  The following code is intended for Unix systems  */

#define TEMP1 "/tmp/la_mmlXXXXXX"

void usage() {
    FPR(stderr, "usage: %s [-a|-b|-r] [-A] [-U] [filename]\n", pgmname);
    FPR(stderr, "    -a\tprocess as article\n");
    FPR(stderr, "    -b\tprocess as book\n");
    FPR(stderr, "    -r\tprocess as report\n");
    FPR(stderr, "    -U\tlist unconverted LaTeX commands on stderr\n");
    FPR(stderr, "*or*\n        %s -v\n", pgmname);
    FPR(stderr, "    Display version number and exit\n");
    exit(1);
}

int main( int argc, char *argv[] ) {
    register int i;
    register char *cp;
    char *fn = NULL;
    char fname[80];
    BOOL alldefs = FALSE;
    FILE *TF;

    pgmname = argv[0];

    initialize_lexer();

    for( i = 1;  i < argc;  i++ ) {
	cp = argv[i];
	if (cp[0] == '-') {
	    if (cp[1] == 'a') {	/* process as article */
		docstyle = "article";
		continue;
	    }
	    if (cp[1] == 'b') {	/* process as book */
		docstyle = "book";
		continue;
	    }
	    if (cp[1] == 'r') {	/* process as report */
		docstyle = "report";
		continue;
	    }
	    if (cp[1] == 'A') {	/* force out all paragraph formats */
		alldefs = TRUE;
		continue;
	    }
	    if (cp[1] == 'U') {	/* output unprocessed command names */
		unknowns = TRUE;
		continue;
	    }
	    if (cp[1] == 'v') { /* output version number and quit */
		FPR(stderr, "la_mml Version %s\n", VERSION);
		exit(0);
	    }
	    usage();
	}
	if (fn != NULL)
	    usage();
	else
	    fn = cp;
    }

    /* create a temporary file for results */

    /* KJT 29/03/08: called "open_tempfile" instead of "tmpfile" */
    OF = open_tempfile();
    if (OF == NULL) OOPS("cannot create temp file");

    curr_matching_mode = PARA;
    (void)GProc("%<B2Text>");
    curr_env->name = ""; curr_env->nlmode = 'N'; curr_env->slmode = 'H';
    if (fn == NULL) {
      f = stdin;
      checkFile("<stdin>");
    }
    else {
      strcpy (fname, fn);
      if (!strend (fname, TEXEXT))		/* add TeX extension? */
	strcat(fname, TEXEXT);
      f = fopen(fname, "r");
      if (f == NULL) {
	  perror(fname);  exit(1);
      }
      checkFile(fname);
      fclose(f);
    }

    close_tempfile();
    rewind(OF);
    TF = OF;

    if (fn == NULL) {
	OF = stdout;
	outputfilename = "<<stdout>>";
    } else {
	outputfilename = setsuffix(fn, MMLEXT);
	OF = fopen(outputfilename, "w");
	if (OF == NULL)
	    OOPS(outputfilename);
    }

    /* write para & char format definitions to output file */
    write_header(OF);
    write_defs(OF, alldefs);

    /* transfer translated material to output file */
    for( ; ; ) {
	register int ch;
	ch = getc(TF);
	if (ch == EOF) break;
	putc(ch, OF);
    }
    fclose(OF);
    fclose(TF);

    return 0;
}

#else

/*  The following code is intended for the Macintosh  */

int main() {
    register int i;
    register char *cp;
    char *fn = NULL;
    char *fnCopy, *outFnGuess;
    BOOL alldefs = FALSE;
    FILE *TF;
    char welcomeStr[48];
    extern long _fcreator, _ftype;

    pgmname = "la_mml";

    initialize_lexer();

    sprintf(welcomeStr, "LaTeX -> MML Translator - version %s", VERSION);
    macGetArgs(welcomeStr, 2,
		&alldefs,  "force out all para definitions",
		&unknowns, "create log file of error messages");

    fn = getInFileName("\pSelect the LaTeX Input File");
    f = fopen(fn, "r");
    if (f == NULL) {
	perror(fn);  exit(1);
    }

    fnCopy = malloc(strlen(fn)+1);
    strcpy(fnCopy, fn);

    if (unknowns) {
	char *logfn, *logFnGuess;
	logFnGuess = setsuffix(fnCopy, ".log");
	logfn = getOutFileName(logFnGuess, "\pSpecify the Logfile");
	(void)freopen(logfn, "w", stderr);
	free(logFnGuess);
    }

    /* open a temporary file for results */

    /* KJT 29/03/08: called "open_tempfile" instead of "tmpfile" */
    OF = open_tempfile();
    if (OF == NULL) OOPS("cannot create temp file");

    curr_matching_mode = PARA;
    (void)GProc("%<B2Text>");
    checkFile(fnCopy);

    close_tempfile();
    rewind(OF);
    TF = OF;

    outFnGuess = setsuffix(fnCopy, MMLEXT);
    outputfilename =
      getOutFileName(outFnGuess, "\pSpecify the MML Output File");

    _fcreator = 'Fram';		/* this causes the output file to */
    _ftype = 'TEXT';		/* get the FrameMaker icon on a Mac */

    OF = fopen(outputfilename, "w");
    if (OF == NULL)
	OOPS(outputfilename);

    /* write para & char format definitions to output file */
    write_header(OF);
    write_defs(OF, alldefs);

    /* transfer translated material to output file */
    for( ; ; ) {
	register int ch;
	ch = getc(TF);
	if (ch == EOF) break;
	putc(ch, OF);
    }
    fclose(OF);
    fclose(TF);

    if (unknowns) {
	fprintf(stderr, "\n%d lines translated\n", linenum);
	fclose(stderr);
    } else
	waitForClick();

    return 0;
}
#endif
